"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an AutoScaling StepScalingAction as an Alarm Action
 */
class AutoScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_autoscaling_StepScalingAction(stepScalingAction);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AutoScalingAction);
            }
            throw error;
        }
    }
    /**
     * Returns an alarm action configuration to use an AutoScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
_a = JSII_RTTI_SYMBOL_1;
AutoScalingAction[_a] = { fqn: "aws-cdk-lib.aws_cloudwatch_actions.AutoScalingAction", version: "2.74.0" };
exports.AutoScalingAction = AutoScalingAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0b3NjYWxpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhdXRvc2NhbGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFJQTs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQzVCLFlBQTZCLGlCQUFnRDtRQUFoRCxzQkFBaUIsR0FBakIsaUJBQWlCLENBQStCOzs7Ozs7K0NBRGxFLGlCQUFpQjs7OztLQUUzQjtJQUVEOzs7T0FHRztJQUNJLElBQUksQ0FBQyxNQUFpQixFQUFFLE1BQXlCOzs7Ozs7Ozs7O1FBQ3RELE9BQU8sRUFBRSxjQUFjLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLENBQUM7S0FDcEU7Ozs7QUFWVSw4Q0FBaUIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhdXRvc2NhbGluZyBmcm9tICcuLi8uLi9hd3MtYXV0b3NjYWxpbmcnO1xuaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tICcuLi8uLi9hd3MtY2xvdWR3YXRjaCc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBVc2UgYW4gQXV0b1NjYWxpbmcgU3RlcFNjYWxpbmdBY3Rpb24gYXMgYW4gQWxhcm0gQWN0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBBdXRvU2NhbGluZ0FjdGlvbiBpbXBsZW1lbnRzIGNsb3Vkd2F0Y2guSUFsYXJtQWN0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBzdGVwU2NhbGluZ0FjdGlvbjogYXV0b3NjYWxpbmcuU3RlcFNjYWxpbmdBY3Rpb24pIHtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGFuIGFsYXJtIGFjdGlvbiBjb25maWd1cmF0aW9uIHRvIHVzZSBhbiBBdXRvU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvblxuICAgKiBhcyBhbiBhbGFybSBhY3Rpb25cbiAgICovXG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBfYWxhcm06IGNsb3Vkd2F0Y2guSUFsYXJtKTogY2xvdWR3YXRjaC5BbGFybUFjdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHsgYWxhcm1BY3Rpb25Bcm46IHRoaXMuc3RlcFNjYWxpbmdBY3Rpb24uc2NhbGluZ1BvbGljeUFybiB9O1xuICB9XG59XG4iXX0=