"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2Action = exports.Ec2InstanceAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Types of EC2 actions available
 */
var Ec2InstanceAction;
(function (Ec2InstanceAction) {
    /**
     * Stop the instance
     */
    Ec2InstanceAction["STOP"] = "stop";
    /**
     * Terminatethe instance
     */
    Ec2InstanceAction["TERMINATE"] = "terminate";
    /**
     * Recover the instance
     */
    Ec2InstanceAction["RECOVER"] = "recover";
    /**
     * Reboot the instance
     */
    Ec2InstanceAction["REBOOT"] = "reboot";
})(Ec2InstanceAction = exports.Ec2InstanceAction || (exports.Ec2InstanceAction = {}));
/**
 * Use an EC2 action as an Alarm action
 */
class Ec2Action {
    constructor(instanceAction) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_actions_Ec2InstanceAction(instanceAction);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Ec2Action);
            }
            throw error;
        }
        this.ec2Action = instanceAction;
    }
    /**
     * Returns an alarm action configuration to use an EC2 action as an alarm action
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return { alarmActionArn: `arn:${core_1.Stack.of(_scope).partition}:automate:${core_1.Stack.of(_scope).region}:ec2:${this.ec2Action}` };
    }
}
_a = JSII_RTTI_SYMBOL_1;
Ec2Action[_a] = { fqn: "aws-cdk-lib.aws_cloudwatch_actions.Ec2Action", version: "2.74.0" };
exports.Ec2Action = Ec2Action;
//# sourceMappingURL=data:application/json;base64,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