"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmIncidentAction = exports.SsmAction = exports.OpsItemCategory = exports.OpsItemSeverity = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Types of OpsItem severity available
 */
var OpsItemSeverity;
(function (OpsItemSeverity) {
    /**
     * Set the severity to critical
     */
    OpsItemSeverity["CRITICAL"] = "1";
    /**
     * Set the severity to high
     */
    OpsItemSeverity["HIGH"] = "2";
    /**
     * Set the severity to medium
     */
    OpsItemSeverity["MEDIUM"] = "3";
    /**
     * Set the severity to low
     */
    OpsItemSeverity["LOW"] = "4";
})(OpsItemSeverity = exports.OpsItemSeverity || (exports.OpsItemSeverity = {}));
/**
 * Types of OpsItem category available
 */
var OpsItemCategory;
(function (OpsItemCategory) {
    /**
     * Set the category to availability
     */
    OpsItemCategory["AVAILABILITY"] = "Availability";
    /**
     * Set the category to cost
     */
    OpsItemCategory["COST"] = "Cost";
    /**
     * Set the category to performance
     */
    OpsItemCategory["PERFORMANCE"] = "Performance";
    /**
     * Set the category to recovery
     */
    OpsItemCategory["RECOVERY"] = "Recovery";
    /**
     * Set the category to security
     */
    OpsItemCategory["SECURITY"] = "Security";
})(OpsItemCategory = exports.OpsItemCategory || (exports.OpsItemCategory = {}));
/**
 * Use an SSM OpsItem action as an Alarm action
 */
class SsmAction {
    constructor(severity, category) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_actions_OpsItemSeverity(severity);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_actions_OpsItemCategory(category);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SsmAction);
            }
            throw error;
        }
        this.severity = severity;
        this.category = category;
    }
    /**
     * Returns an alarm action configuration to use an SSM OpsItem action as an alarm action
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.category === undefined) {
            return { alarmActionArn: `arn:${core_1.Stack.of(_scope).partition}:ssm:${core_1.Stack.of(_scope).region}:${core_1.Stack.of(_scope).account}:opsitem:${this.severity}` };
        }
        else {
            return { alarmActionArn: `arn:${core_1.Stack.of(_scope).partition}:ssm:${core_1.Stack.of(_scope).region}:${core_1.Stack.of(_scope).account}:opsitem:${this.severity}#CATEGORY=${this.category}` };
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
SsmAction[_a] = { fqn: "aws-cdk-lib.aws_cloudwatch_actions.SsmAction", version: "2.74.0" };
exports.SsmAction = SsmAction;
/**
 * Use an SSM Incident Response Plan as an Alarm action
 */
class SsmIncidentAction {
    constructor(responsePlanName) {
        this.responsePlanName = responsePlanName;
    }
    /**
     * Returns an alarm action configuration to use an SSM Incident as an alarm action
     * based on an Incident Manager Response Plan
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            alarmActionArn: `arn:${core_1.Stack.of(_scope).partition}:ssm-incidents::${core_1.Stack.of(_scope).account}:response-plan/${this.responsePlanName}`,
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
SsmIncidentAction[_b] = { fqn: "aws-cdk-lib.aws_cloudwatch_actions.SsmIncidentAction", version: "2.74.0" };
exports.SsmIncidentAction = SsmIncidentAction;
//# sourceMappingURL=data:application/json;base64,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