"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Unit = exports.Statistic = void 0;
/**
 * Statistic to use over the aggregation period
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html
 * @deprecated Use one of the factory methods on `Stats` to produce statistics strings
 */
var Statistic;
(function (Statistic) {
    /**
     * The count (number) of data points used for the statistical calculation.
     */
    Statistic["SAMPLE_COUNT"] = "SampleCount";
    /**
     * The value of Sum / SampleCount during the specified period.
     */
    Statistic["AVERAGE"] = "Average";
    /**
     * All values submitted for the matching metric added together.
     * This statistic can be useful for determining the total volume of a metric.
     */
    Statistic["SUM"] = "Sum";
    /**
     * The lowest value observed during the specified period.
     * You can use this value to determine low volumes of activity for your application.
     */
    Statistic["MINIMUM"] = "Minimum";
    /**
     * The highest value observed during the specified period.
     * You can use this value to determine high volumes of activity for your application.
     */
    Statistic["MAXIMUM"] = "Maximum";
})(Statistic = exports.Statistic || (exports.Statistic = {}));
/**
 * Unit for metric
 */
var Unit;
(function (Unit) {
    /**
     * Seconds
     */
    Unit["SECONDS"] = "Seconds";
    /**
     * Microseconds
     */
    Unit["MICROSECONDS"] = "Microseconds";
    /**
     * Milliseconds
     */
    Unit["MILLISECONDS"] = "Milliseconds";
    /**
     * Bytes
     */
    Unit["BYTES"] = "Bytes";
    /**
     * Kilobytes
     */
    Unit["KILOBYTES"] = "Kilobytes";
    /**
     * Megabytes
     */
    Unit["MEGABYTES"] = "Megabytes";
    /**
     * Gigabytes
     */
    Unit["GIGABYTES"] = "Gigabytes";
    /**
     * Terabytes
     */
    Unit["TERABYTES"] = "Terabytes";
    /**
     * Bits
     */
    Unit["BITS"] = "Bits";
    /**
     * Kilobits
     */
    Unit["KILOBITS"] = "Kilobits";
    /**
     * Megabits
     */
    Unit["MEGABITS"] = "Megabits";
    /**
     * Gigabits
     */
    Unit["GIGABITS"] = "Gigabits";
    /**
     * Terabits
     */
    Unit["TERABITS"] = "Terabits";
    /**
     * Percent
     */
    Unit["PERCENT"] = "Percent";
    /**
     * Count
     */
    Unit["COUNT"] = "Count";
    /**
     * Bytes/second (B/s)
     */
    Unit["BYTES_PER_SECOND"] = "Bytes/Second";
    /**
     * Kilobytes/second (kB/s)
     */
    Unit["KILOBYTES_PER_SECOND"] = "Kilobytes/Second";
    /**
     * Megabytes/second (MB/s)
     */
    Unit["MEGABYTES_PER_SECOND"] = "Megabytes/Second";
    /**
     * Gigabytes/second (GB/s)
     */
    Unit["GIGABYTES_PER_SECOND"] = "Gigabytes/Second";
    /**
     * Terabytes/second (TB/s)
     */
    Unit["TERABYTES_PER_SECOND"] = "Terabytes/Second";
    /**
     * Bits/second (b/s)
     */
    Unit["BITS_PER_SECOND"] = "Bits/Second";
    /**
     * Kilobits/second (kb/s)
     */
    Unit["KILOBITS_PER_SECOND"] = "Kilobits/Second";
    /**
     * Megabits/second (Mb/s)
     */
    Unit["MEGABITS_PER_SECOND"] = "Megabits/Second";
    /**
     * Gigabits/second (Gb/s)
     */
    Unit["GIGABITS_PER_SECOND"] = "Gigabits/Second";
    /**
     * Terabits/second (Tb/s)
     */
    Unit["TERABITS_PER_SECOND"] = "Terabits/Second";
    /**
     * Count/second
     */
    Unit["COUNT_PER_SECOND"] = "Count/Second";
    /**
     * None
     */
    Unit["NONE"] = "None";
})(Unit = exports.Unit || (exports.Unit = {}));
//# sourceMappingURL=data:application/json;base64,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