"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Artifacts = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Artifacts definition for a CodeBuild Project.
 */
class Artifacts {
    static s3(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_S3ArtifactsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.s3);
            }
            throw error;
        }
        return new S3Artifacts(props);
    }
    constructor(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_ArtifactsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Artifacts);
            }
            throw error;
        }
        this.identifier = props.identifier;
    }
    bind(_scope, _project) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_IProject(_project);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            artifactsProperty: {
                artifactIdentifier: this.identifier,
                type: this.type,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
Artifacts[_a] = { fqn: "aws-cdk-lib.aws_codebuild.Artifacts", version: "2.74.0" };
exports.Artifacts = Artifacts;
/**
 * S3 Artifact definition for a CodeBuild Project.
 */
class S3Artifacts extends Artifacts {
    constructor(props) {
        super(props);
        this.props = props;
        this.type = 'S3';
    }
    bind(_scope, project) {
        this.props.bucket.grantReadWrite(project);
        const superConfig = super.bind(_scope, project);
        return {
            artifactsProperty: {
                ...superConfig.artifactsProperty,
                location: this.props.bucket.bucketName,
                path: this.props.path,
                namespaceType: this.props.includeBuildId === false ? 'NONE' : 'BUILD_ID',
                name: this.props.name == null ? undefined : this.props.name,
                packaging: this.props.packageZip === false ? 'NONE' : 'ZIP',
                encryptionDisabled: this.props.encryption === false ? true : undefined,
                overrideArtifactName: this.props.name == null ? true : undefined,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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