"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystemLocation = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * FileSystemLocation provider definition for a CodeBuild Project.
 */
class FileSystemLocation {
    /**
     * EFS file system provider.
     * @param props the EFS File System location property.
     */
    static efs(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_EfsFileSystemLocationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.efs);
            }
            throw error;
        }
        return new EfsFileSystemLocation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
FileSystemLocation[_a] = { fqn: "aws-cdk-lib.aws_codebuild.FileSystemLocation", version: "2.74.0" };
exports.FileSystemLocation = FileSystemLocation;
/**
 * EfsFileSystemLocation definition for a CodeBuild project.
 */
class EfsFileSystemLocation {
    constructor(props) {
        this.props = props;
    }
    bind(_scope, _project) {
        return {
            location: {
                identifier: this.props.identifier,
                location: this.props.location,
                mountOptions: this.props.mountOptions,
                mountPoint: this.props.mountPoint,
                type: 'EFS',
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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