"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineProject = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline_artifacts_1 = require("./codepipeline-artifacts");
const codepipeline_source_1 = require("./codepipeline-source");
const project_1 = require("./project");
/**
 * A convenience class for CodeBuild Projects that are used in CodePipeline.
 */
class PipelineProject extends project_1.Project {
    constructor(scope, id, props) {
        super(scope, id, {
            source: new codepipeline_source_1.CodePipelineSource(),
            artifacts: new codepipeline_artifacts_1.CodePipelineArtifacts(),
            ...props,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_PipelineProjectProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PipelineProject);
            }
            throw error;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
PipelineProject[_a] = { fqn: "aws-cdk-lib.aws_codebuild.PipelineProject", version: "2.74.0" };
exports.PipelineProject = PipelineProject;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZWxpbmUtcHJvamVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBpcGVsaW5lLXByb2plY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EscUVBQWlFO0FBQ2pFLCtEQUEyRDtBQUMzRCx1Q0FBd0Q7QUFLeEQ7O0dBRUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsaUJBQU87SUFDMUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLE1BQU0sRUFBRSxJQUFJLHdDQUFrQixFQUFFO1lBQ2hDLFNBQVMsRUFBRSxJQUFJLDhDQUFxQixFQUFFO1lBQ3RDLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQzs7Ozs7OytDQU5NLGVBQWU7Ozs7S0FPekI7Ozs7QUFQVSwwQ0FBZSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ29kZVBpcGVsaW5lQXJ0aWZhY3RzIH0gZnJvbSAnLi9jb2RlcGlwZWxpbmUtYXJ0aWZhY3RzJztcbmltcG9ydCB7IENvZGVQaXBlbGluZVNvdXJjZSB9IGZyb20gJy4vY29kZXBpcGVsaW5lLXNvdXJjZSc7XG5pbXBvcnQgeyBDb21tb25Qcm9qZWN0UHJvcHMsIFByb2plY3QgfSBmcm9tICcuL3Byb2plY3QnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFBpcGVsaW5lUHJvamVjdFByb3BzIGV4dGVuZHMgQ29tbW9uUHJvamVjdFByb3BzIHtcbn1cblxuLyoqXG4gKiBBIGNvbnZlbmllbmNlIGNsYXNzIGZvciBDb2RlQnVpbGQgUHJvamVjdHMgdGhhdCBhcmUgdXNlZCBpbiBDb2RlUGlwZWxpbmUuXG4gKi9cbmV4cG9ydCBjbGFzcyBQaXBlbGluZVByb2plY3QgZXh0ZW5kcyBQcm9qZWN0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM/OiBQaXBlbGluZVByb2plY3RQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgc291cmNlOiBuZXcgQ29kZVBpcGVsaW5lU291cmNlKCksXG4gICAgICBhcnRpZmFjdHM6IG5ldyBDb2RlUGlwZWxpbmVBcnRpZmFjdHMoKSxcbiAgICAgIC4uLnByb3BzLFxuICAgIH0pO1xuICB9XG59XG4iXX0=