"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferenceEvent = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events");
/**
 * Fields of CloudWatch Events that change references
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 */
class ReferenceEvent {
    /**
     * The type of reference event
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     */
    static get eventType() {
        return events.EventField.fromPath('$.detail.event');
    }
    /**
     * Name of the CodeCommit repository
     */
    static get repositoryName() {
        return events.EventField.fromPath('$.detail.repositoryName');
    }
    /**
     * Id of the CodeCommit repository
     */
    static get repositoryId() {
        return events.EventField.fromPath('$.detail.repositoryId');
    }
    /**
     * Type of reference changed
     *
     * 'branch' or 'tag'
     */
    static get referenceType() {
        return events.EventField.fromPath('$.detail.referenceType');
    }
    /**
     * Name of reference changed (branch or tag name)
     */
    static get referenceName() {
        return events.EventField.fromPath('$.detail.referenceName');
    }
    /**
     * Full reference name
     *
     * For example, 'refs/tags/myTag'
     */
    static get referenceFullName() {
        return events.EventField.fromPath('$.detail.referenceFullName');
    }
    /**
     * Commit id this reference now points to
     */
    static get commitId() {
        return events.EventField.fromPath('$.detail.commitId');
    }
    constructor() {
    }
}
_a = JSII_RTTI_SYMBOL_1;
ReferenceEvent[_a] = { fqn: "aws-cdk-lib.aws_codecommit.ReferenceEvent", version: "2.74.0" };
exports.ReferenceEvent = ReferenceEvent;
//# sourceMappingURL=data:application/json;base64,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