"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseDeploymentConfig = exports.ComputePlatform = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const codedeploy_generated_1 = require("./codedeploy.generated");
const utils_1 = require("./private/utils");
/**
 * The compute platform of a deployment configuration
 */
var ComputePlatform;
(function (ComputePlatform) {
    /**
     * The deployment will target EC2 instances or on-premise servers
     */
    ComputePlatform["SERVER"] = "Server";
    /**
     * The deployment will target a Lambda function
     */
    ComputePlatform["LAMBDA"] = "Lambda";
    /**
     * The deployment will target an ECS server
     */
    ComputePlatform["ECS"] = "ECS";
})(ComputePlatform = exports.ComputePlatform || (exports.ComputePlatform = {}));
/**
 * The base class for ServerDeploymentConfig, EcsDeploymentConfig,
 * and LambdaDeploymentConfig deployment configurations.
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class BaseDeploymentConfig extends core_1.Resource {
    /**
     * Import a custom Deployment Configuration for a Deployment Group defined outside the CDK.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param deploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromDeploymentConfigName(scope, id, deploymentConfigName) {
        ignore(id);
        const arn = core_1.Stack.of(scope).formatArn({
            service: 'codedeploy',
            resource: 'deploymentconfig',
            resourceName: deploymentConfigName,
            arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
        });
        return {
            deploymentConfigName: deploymentConfigName,
            deploymentConfigArn: arn,
        };
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props?.deploymentConfigName,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_BaseDeploymentConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BaseDeploymentConfig);
            }
            throw error;
        }
        // Traffic routing is not applicable to Server-based deployment configs
        if (props?.trafficRouting && (props?.computePlatform === undefined || props?.computePlatform === ComputePlatform.SERVER)) {
            throw new Error('Traffic routing config must not be specified for a Server-base deployment configuration');
        }
        // Minimum healthy hosts is only applicable to Server-based deployment configs
        if (props?.minimumHealthyHosts && props?.computePlatform && props?.computePlatform !== ComputePlatform.SERVER) {
            throw new Error('Minimum healthy hosts config must only be specified for a Server-base deployment configuration');
        }
        const resource = new codedeploy_generated_1.CfnDeploymentConfig(this, 'Resource', {
            deploymentConfigName: this.physicalName,
            computePlatform: props?.computePlatform,
            trafficRoutingConfig: props?.trafficRouting?.bind(this),
            minimumHealthyHosts: props?.minimumHealthyHosts?._json,
        });
        this.deploymentConfigName = this.getResourceNameAttribute(resource.ref);
        this.deploymentConfigArn = this.getResourceArnAttribute((0, utils_1.arnForDeploymentConfig)(resource.ref), {
            service: 'codedeploy',
            resource: 'deploymentconfig',
            resourceName: this.physicalName,
            arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
        });
        this.node.addValidation({ validate: () => (0, utils_1.validateName)('Deployment config', this.physicalName) });
    }
}
_a = JSII_RTTI_SYMBOL_1;
BaseDeploymentConfig[_a] = { fqn: "aws-cdk-lib.aws_codedeploy.BaseDeploymentConfig", version: "2.74.0" };
exports.BaseDeploymentConfig = BaseDeploymentConfig;
function ignore(_x) { return; }
//# sourceMappingURL=data:application/json;base64,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