"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base_deployment_config_1 = require("../base-deployment-config");
const utils_1 = require("../private/utils");
const traffic_routing_config_1 = require("../traffic-routing-config");
/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig extends base_deployment_config_1.BaseDeploymentConfig {
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(scope, id, ecsDeploymentConfigName) {
        return this.fromDeploymentConfigName(scope, id, ecsDeploymentConfigName);
    }
    static deploymentConfig(name) {
        return (0, utils_1.deploymentConfig)(name);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            computePlatform: base_deployment_config_1.ComputePlatform.ECS,
            trafficRouting: props?.trafficRouting ?? traffic_routing_config_1.TrafficRouting.allAtOnce(),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_EcsDeploymentConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcsDeploymentConfig);
            }
            throw error;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentConfig[_a] = { fqn: "aws-cdk-lib.aws_codedeploy.EcsDeploymentConfig", version: "2.74.0" };
/** CodeDeploy predefined deployment configuration that shifts all traffic to the updated ECS task set at once. */
EcsDeploymentConfig.ALL_AT_ONCE = EcsDeploymentConfig.deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every minute until all traffic is shifted. */
EcsDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTES = EcsDeploymentConfig.deploymentConfig('CodeDeployDefault.ECSLinear10PercentEvery1Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every three minutes until all traffic is shifted. */
EcsDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = EcsDeploymentConfig.deploymentConfig('CodeDeployDefault.ECSLinear10PercentEvery3Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment. The remaining 90 percent is deployed five minutes later. */
EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES = EcsDeploymentConfig.deploymentConfig('CodeDeployDefault.ECSCanary10Percent5Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment. The remaining 90 percent is deployed 15 minutes later. */
EcsDeploymentConfig.CANARY_10PERCENT_15MINUTES = EcsDeploymentConfig.deploymentConfig('CodeDeployDefault.ECSCanary10Percent15Minutes');
exports.EcsDeploymentConfig = EcsDeploymentConfig;
//# sourceMappingURL=data:application/json;base64,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