"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDeploymentConfig = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base_deployment_config_1 = require("../base-deployment-config");
const utils_1 = require("../private/utils");
const traffic_routing_config_1 = require("../traffic-routing-config");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig extends base_deployment_config_1.BaseDeploymentConfig {
    /**
     * Import a Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param lambdaDeploymentConfigName the name of the Lambda Deployment Configuration to import
     * @returns a Construct representing a reference to an existing Lambda Deployment Configuration
     */
    static fromLambdaDeploymentConfigName(scope, id, lambdaDeploymentConfigName) {
        return this.fromDeploymentConfigName(scope, id, lambdaDeploymentConfigName);
    }
    /**
     * Import a Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     * @deprecated use `fromLambdaDeploymentConfigName`
     */
    static import(_scope, _id, props) {
        try {
            jsiiDeprecationWarnings.print("aws-cdk-lib.aws_codedeploy.LambdaDeploymentConfig#import", "use `fromLambdaDeploymentConfigName`");
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_LambdaDeploymentConfigImportProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.import);
            }
            throw error;
        }
        return this.fromLambdaDeploymentConfigName(_scope, _id, props.deploymentConfigName);
    }
    static deploymentConfig(name) {
        return (0, utils_1.deploymentConfig)(name);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            computePlatform: base_deployment_config_1.ComputePlatform.LAMBDA,
            trafficRouting: props?.trafficRouting ?? traffic_routing_config_1.TrafficRouting.allAtOnce(),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_LambdaDeploymentConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDeploymentConfig);
            }
            throw error;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
LambdaDeploymentConfig[_a] = { fqn: "aws-cdk-lib.aws_codedeploy.LambdaDeploymentConfig", version: "2.74.0" };
/** CodeDeploy predefined deployment configuration that shifts all traffic to the updated Lambda function at once. */
LambdaDeploymentConfig.ALL_AT_ONCE = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment. The remaining 90 percent is deployed 30 minutes later. */
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment. The remaining 90 percent is deployed five minutes later. */
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment. The remaining 90 percent is deployed 10 minutes later. */
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment. The remaining 90 percent is deployed 15 minutes later. */
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every 10 minutes until all traffic is shifted. */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every minute until all traffic is shifted. */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every two minutes until all traffic is shifted. */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
/** CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every three minutes until all traffic is shifted. */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = LambdaDeploymentConfig.deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
//# sourceMappingURL=data:application/json;base64,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