"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerDeploymentConfig = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base_deployment_config_1 = require("../base-deployment-config");
const utils_1 = require("../private/utils");
/**
 * A custom Deployment Configuration for an EC2/on-premise Deployment Group.
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class ServerDeploymentConfig extends base_deployment_config_1.BaseDeploymentConfig {
    /**
     * Import a custom Deployment Configuration for an EC2/on-premise Deployment Group defined either outside the CDK app,
     * or in a different region.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param serverDeploymentConfigName the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromServerDeploymentConfigName(scope, id, serverDeploymentConfigName) {
        return this.fromDeploymentConfigName(scope, id, serverDeploymentConfigName);
    }
    static deploymentConfig(name) {
        return (0, utils_1.deploymentConfig)(name);
    }
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_ServerDeploymentConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ServerDeploymentConfig);
            }
            throw error;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
ServerDeploymentConfig[_a] = { fqn: "aws-cdk-lib.aws_codedeploy.ServerDeploymentConfig", version: "2.74.0" };
/**
 * The CodeDeployDefault.OneAtATime predefined deployment configuration for EC2/on-premises compute platform
 *
 * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server
 */
ServerDeploymentConfig.ONE_AT_A_TIME = ServerDeploymentConfig.deploymentConfig('CodeDeployDefault.OneAtATime');
/**
 * The CodeDeployDefault.HalfAtATime predefined deployment configuration for EC2/on-premises compute platform
 *
 * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server
 */
ServerDeploymentConfig.HALF_AT_A_TIME = ServerDeploymentConfig.deploymentConfig('CodeDeployDefault.HalfAtATime');
/**
 * The CodeDeployDefault.AllAtOnce predefined deployment configuration for EC2/on-premises compute platform
 *
 * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server
 */
ServerDeploymentConfig.ALL_AT_ONCE = ServerDeploymentConfig.deploymentConfig('CodeDeployDefault.AllAtOnce');
exports.ServerDeploymentConfig = ServerDeploymentConfig;
//# sourceMappingURL=data:application/json;base64,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