"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerGeneration = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The generations of AWS load balancing solutions.
 */
var LoadBalancerGeneration;
(function (LoadBalancerGeneration) {
    /**
     * The first generation (ELB Classic).
     */
    LoadBalancerGeneration[LoadBalancerGeneration["FIRST"] = 0] = "FIRST";
    /**
     * The second generation (ALB and NLB).
     */
    LoadBalancerGeneration[LoadBalancerGeneration["SECOND"] = 1] = "SECOND";
})(LoadBalancerGeneration = exports.LoadBalancerGeneration || (exports.LoadBalancerGeneration = {}));
/**
 * An interface of an abstract load balancer, as needed by CodeDeploy.
 * Create instances using the static factory methods:
 * `#classic`, `#application` and `#network`.
 */
class LoadBalancer {
    /**
     * Creates a new CodeDeploy load balancer from a Classic ELB Load Balancer.
     *
     * @param loadBalancer a classic ELB Load Balancer
     */
    static classic(loadBalancer) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancing_LoadBalancer(loadBalancer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.classic);
            }
            throw error;
        }
        class ClassicLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.FIRST;
                this.name = loadBalancer.loadBalancerName;
            }
        }
        return new ClassicLoadBalancer();
    }
    /**
     * Creates a new CodeDeploy load balancer from an Application Load Balancer Target Group.
     *
     * @param albTargetGroup an ALB Target Group
     */
    static application(albTargetGroup) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_IApplicationTargetGroup(albTargetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.application);
            }
            throw error;
        }
        class AlbLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.SECOND;
                this.name = albTargetGroup.targetGroupName;
            }
        }
        return new AlbLoadBalancer();
    }
    /**
     * Creates a new CodeDeploy load balancer from a Network Load Balancer Target Group.
     *
     * @param nlbTargetGroup an NLB Target Group
     */
    static network(nlbTargetGroup) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_INetworkTargetGroup(nlbTargetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.network);
            }
            throw error;
        }
        class NlbLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.SECOND;
                this.name = nlbTargetGroup.targetGroupName;
            }
        }
        return new NlbLoadBalancer();
    }
}
_a = JSII_RTTI_SYMBOL_1;
LoadBalancer[_a] = { fqn: "aws-cdk-lib.aws_codedeploy.LoadBalancer", version: "2.74.0" };
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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