"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeBasedLinearTrafficRouting = exports.TimeBasedCanaryTrafficRouting = exports.AllAtOnceTrafficRouting = exports.TrafficRouting = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents how traffic is shifted during a CodeDeploy deployment.
 */
class TrafficRouting {
    /**
     * Shifts 100% of traffic in a single shift.
     */
    static allAtOnce() {
        return new AllAtOnceTrafficRouting();
    }
    /**
     * Shifts a specified percentage of traffic, waits for a specified amount of time, then shifts the rest of traffic.
     */
    static timeBasedCanary(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_TimeBasedCanaryTrafficRoutingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.timeBasedCanary);
            }
            throw error;
        }
        return new TimeBasedCanaryTrafficRouting(props);
    }
    /**
     * Keeps shifting a specified percentage of traffic until reaching 100%, waiting for a specified amount of time in between each traffic shift.
     */
    static timeBasedLinear(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_TimeBasedLinearTrafficRoutingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.timeBasedLinear);
            }
            throw error;
        }
        return new TimeBasedLinearTrafficRouting(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
TrafficRouting[_a] = { fqn: "aws-cdk-lib.aws_codedeploy.TrafficRouting", version: "2.74.0" };
exports.TrafficRouting = TrafficRouting;
/**
 * Define a traffic routing config of type 'AllAtOnce'.
 */
class AllAtOnceTrafficRouting extends TrafficRouting {
    constructor() {
        super();
    }
    /**
     * Return a TrafficRoutingConfig of type `AllAtOnce`.
     */
    bind(_scope) {
        return {
            type: 'AllAtOnce',
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
AllAtOnceTrafficRouting[_b] = { fqn: "aws-cdk-lib.aws_codedeploy.AllAtOnceTrafficRouting", version: "2.74.0" };
exports.AllAtOnceTrafficRouting = AllAtOnceTrafficRouting;
/**
 * Define a traffic routing config of type 'TimeBasedCanary'.
 */
class TimeBasedCanaryTrafficRouting extends TrafficRouting {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_TimeBasedCanaryTrafficRoutingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TimeBasedCanaryTrafficRouting);
            }
            throw error;
        }
        this.interval = props.interval;
        this.percentage = props.percentage;
    }
    /**
     * Return a TrafficRoutingConfig of type `TimeBasedCanary`.
     */
    bind(_scope) {
        return {
            type: 'TimeBasedCanary',
            timeBasedCanary: {
                canaryInterval: this.interval.toMinutes(),
                canaryPercentage: this.percentage,
            },
        };
    }
}
_c = JSII_RTTI_SYMBOL_1;
TimeBasedCanaryTrafficRouting[_c] = { fqn: "aws-cdk-lib.aws_codedeploy.TimeBasedCanaryTrafficRouting", version: "2.74.0" };
exports.TimeBasedCanaryTrafficRouting = TimeBasedCanaryTrafficRouting;
/**
 * Define a traffic routing config of type 'TimeBasedLinear'.
 */
class TimeBasedLinearTrafficRouting extends TrafficRouting {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_TimeBasedLinearTrafficRoutingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TimeBasedLinearTrafficRouting);
            }
            throw error;
        }
        this.interval = props.interval;
        this.percentage = props.percentage;
    }
    /**
     * Return a TrafficRoutingConfig of type `TimeBasedLinear`.
     */
    bind(_scope) {
        return {
            type: 'TimeBasedLinear',
            timeBasedLinear: {
                linearInterval: this.interval.toMinutes(),
                linearPercentage: this.percentage,
            },
        };
    }
}
_d = JSII_RTTI_SYMBOL_1;
TimeBasedLinearTrafficRouting[_d] = { fqn: "aws-cdk-lib.aws_codedeploy.TimeBasedLinearTrafficRouting", version: "2.74.0" };
exports.TimeBasedLinearTrafficRouting = TimeBasedLinearTrafficRouting;
//# sourceMappingURL=data:application/json;base64,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