"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationDeployStackInstancesAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const singleton_policy_1 = require("./private/singleton-policy");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * CodePipeline action to create/update Stack Instances of a StackSet
 *
 * After the initial creation of a stack set, you can add new stack instances by
 * using CloudFormationStackInstances. Template parameter values can be
 * overridden at the stack instance level during create or update stack set
 * instance operations.
 *
 * Each stack set has one template and set of template parameters. When you
 * update the template or template parameters, you update them for the entire
 * set. Then all instance statuses are set to OUTDATED until the changes are
 * deployed to that instance.
 */
class CloudFormationDeployStackInstancesAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            region: props.stackSetRegion,
            provider: 'CloudFormationStackInstances',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 0,
                maxInputs: 3,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [
                ...props.parameterOverrides?._artifactsReferenced ?? [],
                ...props.stackInstances?._artifactsReferenced ?? [],
            ],
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_CloudFormationDeployStackInstancesActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationDeployStackInstancesAction);
            }
            throw error;
        }
        this.props = props;
        (0, common_1.validatePercentage)('failureTolerancePercentage', props.failureTolerancePercentage);
        (0, common_1.validatePercentage)('maxAccountConcurrencyPercentage', props.maxAccountConcurrencyPercentage);
    }
    bound(scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        const singletonPolicy = singleton_policy_1.SingletonPolicy.forRole(options.role);
        singletonPolicy.grantCreateUpdateStackSet(this.props);
        const instancesResult = this.props.stackInstances?._bind(scope);
        if ((this.actionProperties.inputs || []).length > 0) {
            options.bucket.grantRead(singletonPolicy);
        }
        return {
            configuration: {
                StackSetName: this.props.stackSetName,
                ParameterOverrides: this.props.parameterOverrides?._render(),
                FailureTolerancePercentage: this.props.failureTolerancePercentage,
                MaxConcurrentPercentage: this.props.maxAccountConcurrencyPercentage,
                ...instancesResult?.stackSetConfiguration,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CloudFormationDeployStackInstancesAction[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.CloudFormationDeployStackInstancesAction", version: "2.74.0" };
exports.CloudFormationDeployStackInstancesAction = CloudFormationDeployStackInstancesAction;
//# sourceMappingURL=data:application/json;base64,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