"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeDeployEcsDeployAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const iam = require("../../../aws-iam");
const core_1 = require("../../../core");
const action_1 = require("../action");
const stack_dependency_1 = require("../private/stack-dependency");
class CodeDeployEcsDeployAction extends action_1.Action {
    constructor(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_CodeDeployEcsDeployActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeDeployEcsDeployAction);
            }
            throw error;
        }
        const inputs = [];
        inputs.push(determineTaskDefinitionArtifact(props));
        inputs.push(determineAppSpecArtifact(props));
        if (props.containerImageInputs) {
            if (props.containerImageInputs.length > 4) {
                throw new Error(`Action cannot have more than 4 container image inputs, got: ${props.containerImageInputs.length}`);
            }
            for (const imageInput of props.containerImageInputs) {
                inputs.push(imageInput.input);
            }
        }
        super({
            ...props,
            resource: props.deploymentGroup,
            category: codepipeline.ActionCategory.DEPLOY,
            provider: 'CodeDeployToECS',
            artifactBounds: { minInputs: 1, maxInputs: 5, minOutputs: 0, maxOutputs: 0 },
            inputs,
        });
        this.actionProps = props;
    }
    bound(_scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        // permissions, based on:
        // https://docs.aws.amazon.com/codedeploy/latest/userguide/auth-and-access-control-permissions-reference.html
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: [this.actionProps.deploymentGroup.application.applicationArn],
            actions: ['codedeploy:GetApplication', 'codedeploy:GetApplicationRevision', 'codedeploy:RegisterApplicationRevision'],
        }));
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: [this.actionProps.deploymentGroup.deploymentGroupArn],
            actions: ['codedeploy:CreateDeployment', 'codedeploy:GetDeployment'],
        }));
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: [this.actionProps.deploymentGroup.deploymentConfig.deploymentConfigArn],
            actions: ['codedeploy:GetDeploymentConfig'],
        }));
        // Allow action to register the task definition template file with ECS
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: ['*'],
            actions: ['ecs:RegisterTaskDefinition'],
        }));
        // Allow passing any roles specified in the task definition template file to ECS
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: ['iam:PassRole'],
            resources: ['*'],
            conditions: {
                StringEqualsIfExists: {
                    'iam:PassedToService': [
                        'ecs-tasks.amazonaws.com',
                    ],
                },
            },
        }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        (0, stack_dependency_1.forceSupportStackDependency)(options.bucket, options.role);
        const taskDefinitionTemplateArtifact = determineTaskDefinitionArtifact(this.actionProps);
        const appSpecTemplateArtifact = determineAppSpecArtifact(this.actionProps);
        const actionConfig = {
            configuration: {
                ApplicationName: this.actionProps.deploymentGroup.application.applicationName,
                DeploymentGroupName: this.actionProps.deploymentGroup.deploymentGroupName,
                TaskDefinitionTemplateArtifact: core_1.Lazy.string({ produce: () => taskDefinitionTemplateArtifact.artifactName }),
                TaskDefinitionTemplatePath: this.actionProps.taskDefinitionTemplateFile
                    ? this.actionProps.taskDefinitionTemplateFile.fileName
                    : 'taskdef.json',
                AppSpecTemplateArtifact: core_1.Lazy.string({ produce: () => appSpecTemplateArtifact.artifactName }),
                AppSpecTemplatePath: this.actionProps.appSpecTemplateFile
                    ? this.actionProps.appSpecTemplateFile.fileName
                    : 'appspec.yaml',
            },
        };
        if (this.actionProps.containerImageInputs) {
            for (let i = 1; i <= this.actionProps.containerImageInputs.length; i++) {
                const imageInput = this.actionProps.containerImageInputs[i - 1];
                actionConfig.configuration[`Image${i}ArtifactName`] = core_1.Lazy.string({ produce: () => imageInput.input.artifactName });
                actionConfig.configuration[`Image${i}ContainerName`] = imageInput.taskDefinitionPlaceholder
                    ? imageInput.taskDefinitionPlaceholder
                    : 'IMAGE';
            }
        }
        return actionConfig;
    }
}
_a = JSII_RTTI_SYMBOL_1;
CodeDeployEcsDeployAction[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.CodeDeployEcsDeployAction", version: "2.74.0" };
exports.CodeDeployEcsDeployAction = CodeDeployEcsDeployAction;
function determineTaskDefinitionArtifact(props) {
    if (props.taskDefinitionTemplateFile && props.taskDefinitionTemplateInput) {
        throw new Error("Exactly one of 'taskDefinitionTemplateInput' or 'taskDefinitionTemplateFile' can be provided in the ECS CodeDeploy Action");
    }
    if (props.taskDefinitionTemplateFile) {
        return props.taskDefinitionTemplateFile.artifact;
    }
    if (props.taskDefinitionTemplateInput) {
        return props.taskDefinitionTemplateInput;
    }
    throw new Error("Specifying one of 'taskDefinitionTemplateInput' or 'taskDefinitionTemplateFile' is required for the ECS CodeDeploy Action");
}
function determineAppSpecArtifact(props) {
    if (props.appSpecTemplateFile && props.appSpecTemplateInput) {
        throw new Error("Exactly one of 'appSpecTemplateInput' or 'appSpecTemplateFile' can be provided in the ECS CodeDeploy Action");
    }
    if (props.appSpecTemplateFile) {
        return props.appSpecTemplateFile.artifact;
    }
    if (props.appSpecTemplateInput) {
        return props.appSpecTemplateInput;
    }
    throw new Error("Specifying one of 'appSpecTemplateInput' or 'appSpecTemplateFile' is required for the ECS CodeDeploy Action");
}
//# sourceMappingURL=data:application/json;base64,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