"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeStarConnectionsSourceAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const iam = require("../../../aws-iam");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * A CodePipeline source action for the CodeStar Connections source,
 * which allows connecting to GitHub and BitBucket.
 */
class CodeStarConnectionsSourceAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.SOURCE,
            owner: 'AWS',
            provider: 'CodeStarSourceConnection',
            artifactBounds: (0, common_1.sourceArtifactBounds)(),
            outputs: [props.output],
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_CodeStarConnectionsSourceActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeStarConnectionsSourceAction);
            }
            throw error;
        }
        this.props = props;
    }
    /** The variables emitted by this action. */
    get variables() {
        return {
            fullRepositoryName: this.variableExpression('FullRepositoryName'),
            branchName: this.variableExpression('BranchName'),
            authorDate: this.variableExpression('AuthorDate'),
            commitId: this.variableExpression('CommitId'),
            commitMessage: this.variableExpression('CommitMessage'),
            connectionArn: this.variableExpression('ConnectionArn'),
        };
    }
    bound(_scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        // https://docs.aws.amazon.com/codepipeline/latest/userguide/security-iam.html#how-to-update-role-new-services
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: [
                'codestar-connections:UseConnection',
            ],
            resources: [
                this.props.connectionArn,
            ],
        }));
        // the action needs to write the output to the pipeline bucket
        options.bucket.grantReadWrite(options.role);
        options.bucket.grantPutAcl(options.role);
        // if codeBuildCloneOutput is true,
        // save the connectionArn in the Artifact instance
        // to be read by the CodeBuildAction later
        if (this.props.codeBuildCloneOutput === true) {
            this.props.output.setMetadata(CodeStarConnectionsSourceAction._CONNECTION_ARN_PROPERTY, this.props.connectionArn);
        }
        return {
            configuration: {
                ConnectionArn: this.props.connectionArn,
                FullRepositoryId: `${this.props.owner}/${this.props.repo}`,
                BranchName: this.props.branch ?? 'master',
                OutputArtifactFormat: this.props.codeBuildCloneOutput === true
                    ? 'CODEBUILD_CLONE_REF'
                    : undefined,
                DetectChanges: this.props.triggerOnPush,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CodeStarConnectionsSourceAction[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.CodeStarConnectionsSourceAction", version: "2.74.0" };
/**
 * The name of the property that holds the ARN of the CodeStar Connection
 * inside of the CodePipeline Artifact's metadata.
 *
 * @internal
 */
CodeStarConnectionsSourceAction._CONNECTION_ARN_PROPERTY = 'CodeStarConnectionArnProperty';
exports.CodeStarConnectionsSourceAction = CodeStarConnectionsSourceAction;
//# sourceMappingURL=data:application/json;base64,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