"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrSourceAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const aws_events_1 = require("../../../aws-events");
const targets = require("../../../aws-events-targets");
const iam = require("../../../aws-iam");
const core_1 = require("../../../core");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * The ECR Repository source CodePipeline Action.
 *
 * Will trigger the pipeline as soon as the target tag in the repository
 * changes, but only if there is a CloudTrail Trail in the account that
 * captures the ECR event.
 */
class EcrSourceAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            resource: props.repository,
            category: codepipeline.ActionCategory.SOURCE,
            provider: 'ECR',
            artifactBounds: (0, common_1.sourceArtifactBounds)(),
            outputs: [props.output],
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_EcrSourceActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSourceAction);
            }
            throw error;
        }
        this.props = props;
    }
    /** The variables emitted by this action. */
    get variables() {
        return {
            registryId: this.variableExpression('RegistryId'),
            repositoryName: this.variableExpression('RepositoryName'),
            imageDigest: this.variableExpression('ImageDigest'),
            imageTag: this.variableExpression('ImageTag'),
            imageUri: this.variableExpression('ImageURI'),
        };
    }
    bound(scope, stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: ['ecr:DescribeImages'],
            resources: [this.props.repository.repositoryArn],
        }));
        new aws_events_1.Rule(scope, core_1.Names.nodeUniqueId(stage.pipeline.node) + 'SourceEventRule', {
            targets: [
                new targets.CodePipeline(stage.pipeline),
            ],
            eventPattern: {
                detailType: ['ECR Image Action'],
                source: ['aws.ecr'],
                detail: {
                    'result': ['SUCCESS'],
                    'repository-name': [this.props.repository.repositoryName],
                    'image-tag': [this.props.imageTag === '' ? undefined : (this.props.imageTag ?? 'latest')],
                    'action-type': ['PUSH'],
                },
            },
        });
        // the Action Role also needs to write to the Pipeline's bucket
        options.bucket.grantWrite(options.role);
        return {
            configuration: {
                RepositoryName: this.props.repository.repositoryName,
                ImageTag: this.props.imageTag ? this.props.imageTag : undefined, // `''` is falsy in JS/TS
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
EcrSourceAction[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.EcrSourceAction", version: "2.74.0" };
exports.EcrSourceAction = EcrSourceAction;
//# sourceMappingURL=data:application/json;base64,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