"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeployAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const iam = require("../../../aws-iam");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * CodePipeline Action to deploy an ECS Service.
 */
class EcsDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.DEPLOY,
            provider: 'ECS',
            artifactBounds: (0, common_1.deployArtifactBounds)(),
            inputs: [determineInputArtifact(props)],
            resource: props.service,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_EcsDeployActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcsDeployAction);
            }
            throw error;
        }
        const deploymentTimeout = props.deploymentTimeout?.toMinutes({ integral: true });
        if (deploymentTimeout !== undefined && (deploymentTimeout < 1 || deploymentTimeout > 60)) {
            throw new Error(`Deployment timeout must be between 1 and 60 minutes, got: ${deploymentTimeout}`);
        }
        this.props = props;
        this.deploymentTimeout = deploymentTimeout;
    }
    bound(_scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        // permissions based on CodePipeline documentation:
        // https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-custom-role.html#how-to-update-role-new-services
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: [
                'ecs:DescribeServices',
                'ecs:DescribeTaskDefinition',
                'ecs:DescribeTasks',
                'ecs:ListTasks',
                'ecs:RegisterTaskDefinition',
                'ecs:UpdateService',
            ],
            resources: ['*'],
        }));
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: ['iam:PassRole'],
            resources: ['*'],
            conditions: {
                StringEqualsIfExists: {
                    'iam:PassedToService': [
                        'ec2.amazonaws.com',
                        'ecs-tasks.amazonaws.com',
                    ],
                },
            },
        }));
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                ClusterName: this.props.service.cluster.clusterName,
                ServiceName: this.props.service.serviceName,
                FileName: this.props.imageFile?.fileName,
                DeploymentTimeout: this.deploymentTimeout,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
EcsDeployAction[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.EcsDeployAction", version: "2.74.0" };
exports.EcsDeployAction = EcsDeployAction;
function determineInputArtifact(props) {
    if (props.imageFile && props.input) {
        throw new Error("Exactly one of 'input' or 'imageFile' can be provided in the ECS deploy Action");
    }
    if (props.imageFile) {
        return props.imageFile.artifact;
    }
    if (props.input) {
        return props.input;
    }
    throw new Error("Specifying one of 'input' or 'imageFile' is required for the ECS deploy Action");
}
//# sourceMappingURL=data:application/json;base64,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