"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticBeanstalkDeployAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * CodePipeline action to deploy an AWS ElasticBeanstalk Application.
 */
class ElasticBeanstalkDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.DEPLOY,
            provider: 'ElasticBeanstalk',
            artifactBounds: (0, common_1.deployArtifactBounds)(),
            inputs: [props.input],
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_ElasticBeanstalkDeployActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ElasticBeanstalkDeployAction);
            }
            throw error;
        }
        this.applicationName = props.applicationName;
        this.environmentName = props.environmentName;
    }
    bound(_scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        // Per https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html
        // it doesn't seem we can scope this down further for the codepipeline action.
        options.role.addManagedPolicy({ managedPolicyArn: 'arn:aws:iam::aws:policy/AdministratorAccess-AWSElasticBeanstalk' });
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                ApplicationName: this.applicationName,
                EnvironmentName: this.environmentName,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ElasticBeanstalkDeployAction[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.ElasticBeanstalkDeployAction", version: "2.74.0" };
exports.ElasticBeanstalkDeployAction = ElasticBeanstalkDeployAction;
//# sourceMappingURL=data:application/json;base64,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