"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JenkinsAction = exports.JenkinsActionType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const jenkins_provider_1 = require("./jenkins-provider");
const action_1 = require("../action");
/**
 * The type of the Jenkins Action that determines its CodePipeline Category -
 * Build, or Test.
 * Note that a Jenkins provider, even if it has the same name,
 * must be separately registered for each type.
 */
var JenkinsActionType;
(function (JenkinsActionType) {
    /**
     * The Action will have the Build Category.
     */
    JenkinsActionType[JenkinsActionType["BUILD"] = 0] = "BUILD";
    /**
     * The Action will have the Test Category.
     */
    JenkinsActionType[JenkinsActionType["TEST"] = 1] = "TEST";
})(JenkinsActionType = exports.JenkinsActionType || (exports.JenkinsActionType = {}));
/**
 * Jenkins build CodePipeline Action.
 *
 * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-four-stage-pipeline.html
 */
class JenkinsAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: props.type === JenkinsActionType.BUILD
                ? codepipeline.ActionCategory.BUILD
                : codepipeline.ActionCategory.TEST,
            provider: props.jenkinsProvider.providerName,
            owner: 'Custom',
            artifactBounds: jenkins_provider_1.jenkinsArtifactsBounds,
            version: props.jenkinsProvider.version,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_JenkinsActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, JenkinsAction);
            }
            throw error;
        }
        this.props = props;
    }
    bound(_scope, _stage, _options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        if (this.actionProperties.category === codepipeline.ActionCategory.BUILD) {
            this.props.jenkinsProvider._registerBuildProvider();
        }
        else {
            this.props.jenkinsProvider._registerTestProvider();
        }
        return {
            configuration: {
                ProjectName: this.props.projectName,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
JenkinsAction[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.JenkinsAction", version: "2.74.0" };
exports.JenkinsAction = JenkinsAction;
//# sourceMappingURL=data:application/json;base64,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