"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.jenkinsArtifactsBounds = exports.JenkinsProvider = exports.BaseJenkinsProvider = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const constructs_1 = require("constructs");
class BaseJenkinsProvider extends constructs_1.Construct {
    constructor(scope, id, version) {
        super(scope, id);
        this.version = version || '1';
    }
}
_a = JSII_RTTI_SYMBOL_1;
BaseJenkinsProvider[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.BaseJenkinsProvider", version: "2.74.0" };
exports.BaseJenkinsProvider = BaseJenkinsProvider;
/**
 * A class representing Jenkins providers.
 *
 * @see #import
 */
class JenkinsProvider extends BaseJenkinsProvider {
    /**
     * Import a Jenkins provider registered either outside the CDK,
     * or in a different CDK Stack.
     *
     * @param scope the parent Construct for the new provider
     * @param id the identifier of the new provider Construct
     * @param attrs the properties used to identify the existing provider
     * @returns a new Construct representing a reference to an existing Jenkins provider
     */
    static fromJenkinsProviderAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_JenkinsProviderAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromJenkinsProviderAttributes);
            }
            throw error;
        }
        return new ImportedJenkinsProvider(scope, id, attrs);
    }
    constructor(scope, id, props) {
        super(scope, id, props.version);
        this.buildIncluded = false;
        this.testIncluded = false;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_JenkinsProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, JenkinsProvider);
            }
            throw error;
        }
        this.providerName = props.providerName;
        this.serverUrl = props.serverUrl;
        if (props.forBuild === true) {
            this._registerBuildProvider();
        }
        if (props.forTest === true) {
            this._registerTestProvider();
        }
    }
    /**
     * @internal
     */
    _registerBuildProvider() {
        if (this.buildIncluded) {
            return;
        }
        this.buildIncluded = true;
        this.registerJenkinsCustomAction('JenkinsBuildProviderResource', codepipeline.ActionCategory.BUILD);
    }
    /**
     * @internal
     */
    _registerTestProvider() {
        if (this.testIncluded) {
            return;
        }
        this.testIncluded = true;
        this.registerJenkinsCustomAction('JenkinsTestProviderResource', codepipeline.ActionCategory.TEST);
    }
    registerJenkinsCustomAction(id, category) {
        new codepipeline.CustomActionRegistration(this, id, {
            category,
            artifactBounds: exports.jenkinsArtifactsBounds,
            provider: this.providerName,
            version: this.version,
            entityUrl: appendToUrl(this.serverUrl, 'job/{Config:ProjectName}'),
            executionUrl: appendToUrl(this.serverUrl, 'job/{Config:ProjectName}/{ExternalExecutionId}'),
            actionProperties: [
                {
                    name: 'ProjectName',
                    required: true,
                    key: true,
                    queryable: true,
                },
            ],
        });
    }
}
_b = JSII_RTTI_SYMBOL_1;
JenkinsProvider[_b] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.JenkinsProvider", version: "2.74.0" };
exports.JenkinsProvider = JenkinsProvider;
class ImportedJenkinsProvider extends BaseJenkinsProvider {
    constructor(scope, id, props) {
        super(scope, id, props.version);
        this.providerName = props.providerName;
        this.serverUrl = props.serverUrl;
    }
    _registerBuildProvider() {
    }
    _registerTestProvider() {
    }
}
function appendToUrl(baseUrl, path) {
    return baseUrl.endsWith('/') ? baseUrl + path : `${baseUrl}/${path}`;
}
exports.jenkinsArtifactsBounds = {
    minInputs: 0,
    maxInputs: 5,
    minOutputs: 0,
    maxOutputs: 5,
};
//# sourceMappingURL=data:application/json;base64,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