"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.forceSupportStackDependency = void 0;
const core_1 = require("../../../core");
/**
 * Create a dependency between the stack of the replication bucket and the stack of the action role
 *
 * If the deployment action happens in across-account/cross-region fashion, we
 * create two support stacks (stack R for the cross-account role, and stack B for the
 * cross-region replication bucket), but these stacks are not related to each
 * other by default.
 *
 * To make it more interesting, if these are roles with autogenerated names, the
 * stacks have bidirectional policies: the bucket and key (B) refer to the role
 * (R), and the role (R) refers to the bucket and key (B). This is an
 * unfortunate way of setting up the policies, and it should really be
 * completely replaced with a tag-based mechanism.
 *
 * Until then, we've determined that deployment accidentally works fine if we deploy
 * the account stack R first, followed by the region stack B. So explicitly establish
 * this dependency in CodePipeline Actions.
 */
function forceSupportStackDependency(bucket, role) {
    if (core_1.Resource.isOwnedResource(bucket) && core_1.Resource.isOwnedResource(role)) {
        core_1.Stack.of(bucket).addDependency(core_1.Stack.of(role), `replication bucket {${bucket.node.path}} to action role {${role}}`);
    }
}
exports.forceSupportStackDependency = forceSupportStackDependency;
//# sourceMappingURL=data:application/json;base64,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