"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionInvokeAction = exports.StateMachineInput = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const iam = require("../../../aws-iam");
const cdk = require("../../../core");
const action_1 = require("../action");
/**
 * Represents the input for the StateMachine.
 */
class StateMachineInput {
    /**
     * When the input type is FilePath, input artifact and
     * filepath must be specified.
     */
    static filePath(inputFile) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ArtifactPath(inputFile);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.filePath);
            }
            throw error;
        }
        return new StateMachineInput(inputFile.location, inputFile.artifact, 'FilePath');
    }
    /**
     * When the input type is Literal, input value is passed
     * directly to the state machine input.
     */
    static literal(object) {
        return new StateMachineInput(JSON.stringify(object), undefined, 'Literal');
    }
    constructor(input, inputArtifact, inputType) {
        this.input = input;
        this.inputArtifact = inputArtifact;
        this.inputType = inputType;
    }
}
_a = JSII_RTTI_SYMBOL_1;
StateMachineInput[_a] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.StateMachineInput", version: "2.74.0" };
exports.StateMachineInput = StateMachineInput;
/**
 * StepFunctionInvokeAction that is provided by an AWS CodePipeline.
 */
class StepFunctionInvokeAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            resource: props.stateMachine,
            category: codepipeline.ActionCategory.INVOKE,
            provider: 'StepFunctions',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 1,
            },
            inputs: (props.stateMachineInput && props.stateMachineInput.inputArtifact) ? [props.stateMachineInput.inputArtifact] : [],
            outputs: (props.output) ? [props.output] : [],
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_StepFunctionsInvokeActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionInvokeAction);
            }
            throw error;
        }
        this.props = props;
    }
    bound(_scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        // allow pipeline to invoke this step function
        options.role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:StartExecution', 'states:DescribeStateMachine'],
            resources: [this.props.stateMachine.stateMachineArn],
        }));
        // allow state machine executions to be inspected
        options.role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:DescribeExecution'],
            resources: [cdk.Stack.of(this.props.stateMachine).formatArn({
                    service: 'states',
                    resource: 'execution',
                    resourceName: `${cdk.Stack.of(this.props.stateMachine).splitArn(this.props.stateMachine.stateMachineArn, cdk.ArnFormat.COLON_RESOURCE_NAME).resourceName}:${this.props.executionNamePrefix ?? ''}*`,
                    arnFormat: cdk.ArnFormat.COLON_RESOURCE_NAME,
                })],
        }));
        // allow the Role access to the Bucket, if there are any inputs/outputs
        if ((this.actionProperties.inputs ?? []).length > 0) {
            options.bucket.grantRead(options.role);
        }
        if ((this.actionProperties.outputs ?? []).length > 0) {
            options.bucket.grantWrite(options.role);
        }
        return {
            configuration: {
                StateMachineArn: this.props.stateMachine.stateMachineArn,
                Input: this.props.stateMachineInput?.input,
                InputType: this.props.stateMachineInput?.inputType,
                ExecutionNamePrefix: this.props.executionNamePrefix,
            },
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
StepFunctionInvokeAction[_b] = { fqn: "aws-cdk-lib.aws_codepipeline_actions.StepFunctionInvokeAction", version: "2.74.0" };
exports.StepFunctionInvokeAction = StepFunctionInvokeAction;
//# sourceMappingURL=data:application/json;base64,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