"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const codepipeline_generated_1 = require("./codepipeline.generated");
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_CustomActionRegistrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomActionRegistration);
            }
            throw error;
        }
        new codepipeline_generated_1.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties?.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
CustomActionRegistration[_a] = { fqn: "aws-cdk-lib.aws_codepipeline.CustomActionRegistration", version: "2.74.0" };
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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