"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationRule = exports.DetailType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const codestarnotifications_generated_1 = require("./codestarnotifications.generated");
/**
 * The level of detail to include in the notifications for this resource.
 */
var DetailType;
(function (DetailType) {
    /**
     * BASIC will include only the contents of the event as it would appear in AWS CloudWatch
     */
    DetailType["BASIC"] = "BASIC";
    /**
     * FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
     */
    DetailType["FULL"] = "FULL";
})(DetailType = exports.DetailType || (exports.DetailType = {}));
/**
 * A new notification rule
 *
 * @resource AWS::CodeStarNotifications::NotificationRule
 */
class NotificationRule extends core_1.Resource {
    /**
     * Import an existing notification rule provided an ARN
     * @param scope The parent creating construct
     * @param id The construct's name
     * @param notificationRuleArn Notification rule ARN (i.e. arn:aws:codestar-notifications:::notificationrule/01234abcde)
     */
    static fromNotificationRuleArn(scope, id, notificationRuleArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.notificationRuleArn = notificationRuleArn;
            }
            addTarget(_target) {
                return false;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: notificationRuleArn,
        });
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.targets = [];
        this.events = [];
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codestarnotifications_NotificationRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NotificationRule);
            }
            throw error;
        }
        const source = props.source.bindAsNotificationRuleSource(this);
        this.addEvents(props.events);
        const resource = new codestarnotifications_generated_1.CfnNotificationRule(this, 'Resource', {
            // It has a 64 characters limit for the name
            name: props.notificationRuleName || core_1.Names.uniqueId(this).slice(-64),
            detailType: props.detailType || DetailType.FULL,
            targets: this.targets,
            eventTypeIds: this.events,
            resource: source.sourceArn,
            status: props.enabled !== undefined
                ? (props.enabled ? 'ENABLED' : 'DISABLED')
                : undefined,
        });
        this.notificationRuleArn = resource.ref;
        props.targets?.forEach((target) => {
            this.addTarget(target);
        });
    }
    /**
     * Adds target to notification rule
     * @param target The SNS topic or AWS Chatbot Slack target
     */
    addTarget(target) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codestarnotifications_INotificationRuleTarget(target);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addTarget);
            }
            throw error;
        }
        this.targets.push(target.bindAsNotificationRuleTarget(this));
        return true;
    }
    /**
     * Adds events to notification rule
     *
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-buildproject
     * @param events The list of event types for AWS Codebuild and AWS CodePipeline
     */
    addEvents(events) {
        events.forEach((event) => {
            if (this.events.includes(event)) {
                return;
            }
            this.events.push(event);
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
NotificationRule[_a] = { fqn: "aws-cdk-lib.aws_codestarnotifications.NotificationRule", version: "2.74.0" };
exports.NotificationRule = NotificationRule;
//# sourceMappingURL=data:application/json;base64,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