"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientAttributes = exports.DateTimeAttribute = exports.BooleanAttribute = exports.NumberAttribute = exports.StringAttribute = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const attr_names_1 = require("./private/attr-names");
/**
 * The String custom attribute type.
 */
class StringAttribute {
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_StringAttributeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StringAttribute);
            }
            throw error;
        }
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props?.minLen;
        this.maxLen = props?.maxLen;
        this.mutable = props?.mutable;
    }
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
StringAttribute[_a] = { fqn: "aws-cdk-lib.aws_cognito.StringAttribute", version: "2.74.0" };
exports.StringAttribute = StringAttribute;
/**
 * The Number custom attribute type.
 */
class NumberAttribute {
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_NumberAttributeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NumberAttribute);
            }
            throw error;
        }
        this.min = props?.min;
        this.max = props?.max;
        this.mutable = props?.mutable;
    }
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
NumberAttribute[_b] = { fqn: "aws-cdk-lib.aws_cognito.NumberAttribute", version: "2.74.0" };
exports.NumberAttribute = NumberAttribute;
/**
 * The Boolean custom attribute type.
 */
class BooleanAttribute {
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_CustomAttributeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BooleanAttribute);
            }
            throw error;
        }
        this.mutable = props?.mutable;
    }
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
_c = JSII_RTTI_SYMBOL_1;
BooleanAttribute[_c] = { fqn: "aws-cdk-lib.aws_cognito.BooleanAttribute", version: "2.74.0" };
exports.BooleanAttribute = BooleanAttribute;
/**
 * The DateTime custom attribute type.
 */
class DateTimeAttribute {
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_CustomAttributeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DateTimeAttribute);
            }
            throw error;
        }
        this.mutable = props?.mutable;
    }
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
_d = JSII_RTTI_SYMBOL_1;
DateTimeAttribute[_d] = { fqn: "aws-cdk-lib.aws_cognito.DateTimeAttribute", version: "2.74.0" };
exports.DateTimeAttribute = DateTimeAttribute;
/**
 * A set of attributes, useful to set Read and Write attributes
 */
class ClientAttributes {
    /**
     * Creates a ClientAttributes with the specified attributes
     *
     * @default - a ClientAttributes object without any attributes
     */
    constructor() {
        this.attributesSet = new Set();
    }
    /**
     * Creates a custom ClientAttributes with the specified attributes
     * @param attributes a list of standard attributes to add to the set
     */
    withStandardAttributes(attributes) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_StandardAttributesMask(attributes);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.withStandardAttributes);
            }
            throw error;
        }
        let attributesSet = new Set(this.attributesSet);
        // iterate through key-values in the `StandardAttributeNames` constant
        // to get the value for all attributes
        for (const attributeKey in attr_names_1.StandardAttributeNames) {
            if (attributes[attributeKey] === true) {
                const attributeName = attr_names_1.StandardAttributeNames[attributeKey];
                attributesSet.add(attributeName);
            }
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * Creates a custom ClientAttributes with the specified attributes
     * @param attributes a list of custom attributes to add to the set
     */
    withCustomAttributes(...attributes) {
        let attributesSet = new Set(this.attributesSet);
        for (let attribute of attributes) {
            // custom attributes MUST begin with `custom:`, so add the string if not present
            if (!attribute.startsWith('custom:')) {
                attribute = 'custom:' + attribute;
            }
            attributesSet.add(attribute);
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * The list of attributes represented by this ClientAttributes
     */
    attributes() {
        // sorting is unnecessary but it simplify testing
        return Array.from(this.attributesSet).sort();
    }
}
_e = JSII_RTTI_SYMBOL_1;
ClientAttributes[_e] = { fqn: "aws-cdk-lib.aws_cognito.ClientAttributes", version: "2.74.0" };
exports.ClientAttributes = ClientAttributes;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1wb29sLWF0dHIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1c2VyLXBvb2wtYXR0ci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxxQ0FBbUM7QUFDbkMscURBQThEO0FBeU85RDs7R0FFRztBQUNILE1BQWEsZUFBZTtJQUsxQixZQUFZLFFBQThCLEVBQUU7Ozs7OzsrQ0FMakMsZUFBZTs7OztRQU14QixJQUFJLEtBQUssQ0FBQyxNQUFNLElBQUksQ0FBQyxZQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtZQUN6RSxNQUFNLElBQUksS0FBSyxDQUFDLHdDQUF3QyxLQUFLLENBQUMsTUFBTSxJQUFJLENBQUMsQ0FBQztTQUMzRTtRQUNELElBQUksS0FBSyxDQUFDLE1BQU0sSUFBSSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxNQUFNLEdBQUcsSUFBSSxFQUFFO1lBQzVFLE1BQU0sSUFBSSxLQUFLLENBQUMsOENBQThDLEtBQUssQ0FBQyxNQUFNLElBQUksQ0FBQyxDQUFDO1NBQ2pGO1FBQ0QsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLEVBQUUsTUFBTSxDQUFDO1FBQzVCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxFQUFFLE1BQU0sQ0FBQztRQUM1QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssRUFBRSxPQUFPLENBQUM7S0FDL0I7SUFFTSxJQUFJO1FBQ1QsSUFBSSxpQkFBeUQsQ0FBQztRQUM5RCxJQUFJLElBQUksQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRTtZQUM5QixpQkFBaUIsR0FBRztnQkFDbEIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2dCQUNuQixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07YUFDcEIsQ0FBQztTQUNIO1FBRUQsT0FBTztZQUNMLFFBQVEsRUFBRSxRQUFRO1lBQ2xCLGlCQUFpQjtZQUNqQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87U0FDdEIsQ0FBQztLQUNIOzs7O0FBL0JVLDBDQUFlO0FBeUQ1Qjs7R0FFRztBQUNILE1BQWEsZUFBZTtJQUsxQixZQUFZLFFBQThCLEVBQUU7Ozs7OzsrQ0FMakMsZUFBZTs7OztRQU14QixJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssRUFBRSxHQUFHLENBQUM7UUFDdEIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLEVBQUUsR0FBRyxDQUFDO1FBQ3RCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxFQUFFLE9BQU8sQ0FBQztLQUMvQjtJQUVNLElBQUk7UUFDVCxJQUFJLGlCQUF5RCxDQUFDO1FBQzlELElBQUksSUFBSSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsR0FBRyxFQUFFO1lBQ3hCLGlCQUFpQixHQUFHO2dCQUNsQixHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7Z0JBQ2IsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO2FBQ2QsQ0FBQztTQUNIO1FBRUQsT0FBTztZQUNMLFFBQVEsRUFBRSxRQUFRO1lBQ2xCLGlCQUFpQjtZQUNqQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87U0FDdEIsQ0FBQztLQUNIOzs7O0FBekJVLDBDQUFlO0FBNEI1Qjs7R0FFRztBQUNILE1BQWEsZ0JBQWdCO0lBRzNCLFlBQVksUUFBOEIsRUFBRTs7Ozs7OytDQUhqQyxnQkFBZ0I7Ozs7UUFJekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLEVBQUUsT0FBTyxDQUFDO0tBQy9CO0lBRU0sSUFBSTtRQUNULE9BQU87WUFDTCxRQUFRLEVBQUUsU0FBUztZQUNuQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87U0FDdEIsQ0FBQztLQUNIOzs7O0FBWlUsNENBQWdCO0FBZTdCOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUFHNUIsWUFBWSxRQUE4QixFQUFFOzs7Ozs7K0NBSGpDLGlCQUFpQjs7OztRQUkxQixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssRUFBRSxPQUFPLENBQUM7S0FDL0I7SUFFTSxJQUFJO1FBQ1QsT0FBTztZQUNMLFFBQVEsRUFBRSxVQUFVO1lBQ3BCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztTQUN0QixDQUFDO0tBQ0g7Ozs7QUFaVSw4Q0FBaUI7QUF5STlCOztHQUVHO0FBQ0gsTUFBYSxnQkFBZ0I7SUFPM0I7Ozs7T0FJRztJQUNIO1FBQ0UsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLEdBQUcsRUFBVSxDQUFDO0tBQ3hDO0lBRUQ7OztPQUdHO0lBQ0ksc0JBQXNCLENBQUMsVUFBa0M7Ozs7Ozs7Ozs7UUFDOUQsSUFBSSxhQUFhLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ2hELHNFQUFzRTtRQUN0RSxzQ0FBc0M7UUFDdEMsS0FBSyxNQUFNLFlBQVksSUFBSSxtQ0FBc0IsRUFBRTtZQUNqRCxJQUFLLFVBQWtCLENBQUMsWUFBWSxDQUFDLEtBQUssSUFBSSxFQUFFO2dCQUM5QyxNQUFNLGFBQWEsR0FBSSxtQ0FBOEIsQ0FBQyxZQUFZLENBQUMsQ0FBQztnQkFDcEUsYUFBYSxDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQzthQUNsQztTQUNGO1FBQ0QsSUFBSSxHQUFHLEdBQUcsSUFBSSxnQkFBZ0IsRUFBRSxDQUFDO1FBQ2pDLEdBQUcsQ0FBQyxhQUFhLEdBQUcsYUFBYSxDQUFDO1FBQ2xDLE9BQU8sR0FBRyxDQUFDO0tBQ1o7SUFFRDs7O09BR0c7SUFDSSxvQkFBb0IsQ0FBQyxHQUFHLFVBQW9CO1FBQ2pELElBQUksYUFBYSxHQUFnQixJQUFJLEdBQUcsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDN0QsS0FBSyxJQUFJLFNBQVMsSUFBSSxVQUFVLEVBQUU7WUFDaEMsZ0ZBQWdGO1lBQ2hGLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxFQUFFO2dCQUNwQyxTQUFTLEdBQUcsU0FBUyxHQUFHLFNBQVMsQ0FBQzthQUNuQztZQUNELGFBQWEsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUM7U0FDOUI7UUFDRCxJQUFJLEdBQUcsR0FBRyxJQUFJLGdCQUFnQixFQUFFLENBQUM7UUFDakMsR0FBRyxDQUFDLGFBQWEsR0FBRyxhQUFhLENBQUM7UUFDbEMsT0FBTyxHQUFHLENBQUM7S0FDWjtJQUVEOztPQUVHO0lBQ0ksVUFBVTtRQUNmLGlEQUFpRDtRQUNqRCxPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDO0tBQzlDOzs7O0FBM0RVLDRDQUFnQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRva2VuIH0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBTdGFuZGFyZEF0dHJpYnV0ZU5hbWVzIH0gZnJvbSAnLi9wcml2YXRlL2F0dHItbmFtZXMnO1xuXG4vKipcbiAqIFRoZSBzZXQgb2Ygc3RhbmRhcmQgYXR0cmlidXRlcyB0aGF0IGNhbiBiZSBtYXJrZWQgYXMgcmVxdWlyZWQgb3IgbXV0YWJsZS5cbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb2duaXRvL2xhdGVzdC9kZXZlbG9wZXJndWlkZS91c2VyLXBvb2wtc2V0dGluZ3MtYXR0cmlidXRlcy5odG1sI2NvZ25pdG8tdXNlci1wb29scy1zdGFuZGFyZC1hdHRyaWJ1dGVzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3RhbmRhcmRBdHRyaWJ1dGVzIHtcbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgcG9zdGFsIGFkZHJlc3MuXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBhZGRyZXNzPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgYmlydGhkYXksIHJlcHJlc2VudGVkIGFzIGFuIElTTyA4NjAxOjIwMDQgZm9ybWF0LlxuICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgKi9cbiAgcmVhZG9ubHkgYmlydGhkYXRlPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgZS1tYWlsIGFkZHJlc3MsIHJlcHJlc2VudGVkIGFzIGFuIFJGQyA1MzIyIFtSRkM1MzIyXSBhZGRyLXNwZWMuXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBlbWFpbD86IFN0YW5kYXJkQXR0cmlidXRlO1xuXG4gIC8qKlxuICAgKiBUaGUgc3VybmFtZSBvciBsYXN0IG5hbWUgb2YgdGhlIHVzZXIuXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBmYW1pbHlOYW1lPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgZ2VuZGVyLlxuICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgKi9cbiAgcmVhZG9ubHkgZ2VuZGVyPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgZmlyc3QgbmFtZSBvciBnaXZlIG5hbWUuXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBnaXZlbk5hbWU/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcblxuICAvKipcbiAgICogVGhlIHVzZXIncyBsb2NhbGUsIHJlcHJlc2VudGVkIGFzIGEgQkNQNDcgW1JGQzU2NDZdIGxhbmd1YWdlIHRhZy5cbiAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICovXG4gIHJlYWRvbmx5IGxvY2FsZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIG1pZGRsZSBuYW1lLlxuICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgKi9cbiAgcmVhZG9ubHkgbWlkZGxlTmFtZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIGZ1bGwgbmFtZSBpbiBkaXNwbGF5YWJsZSBmb3JtLCBpbmNsdWRpbmcgYWxsIG5hbWUgcGFydHMsIHRpdGxlcyBhbmQgc3VmZml4ZXMuXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBmdWxsbmFtZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIG5pY2tuYW1lIG9yIGNhc3VhbCBuYW1lLlxuICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgKi9cbiAgcmVhZG9ubHkgbmlja25hbWU/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcblxuICAvKipcbiAgICogVGhlIHVzZXIncyB0ZWxlcGhvbmUgbnVtYmVyLlxuICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgKi9cbiAgcmVhZG9ubHkgcGhvbmVOdW1iZXI/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcblxuICAvKipcbiAgICogVGhlIFVSTCB0byB0aGUgdXNlcidzIHByb2ZpbGUgcGljdHVyZS5cbiAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICovXG4gIHJlYWRvbmx5IHByb2ZpbGVQaWN0dXJlPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgcHJlZmZlcmVkIHVzZXJuYW1lLCBkaWZmZXJlbnQgZnJvbSB0aGUgaW1tdXRhYmxlIHVzZXIgbmFtZS5cbiAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICovXG4gIHJlYWRvbmx5IHByZWZlcnJlZFVzZXJuYW1lPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG5cbiAgLyoqXG4gICAqIFRoZSBVUkwgdG8gdGhlIHVzZXIncyBwcm9maWxlIHBhZ2UuXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBwcm9maWxlUGFnZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIHRpbWUgem9uZS5cbiAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICovXG4gIHJlYWRvbmx5IHRpbWV6b25lPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG5cbiAgLyoqXG4gICAqIFRoZSB0aW1lLCB0aGUgdXNlcidzIGluZm9ybWF0aW9uIHdhcyBsYXN0IHVwZGF0ZWQuXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBsYXN0VXBkYXRlVGltZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuXG4gIC8qKlxuICAgKiBUaGUgVVJMIHRvIHRoZSB1c2VyJ3Mgd2ViIHBhZ2Ugb3IgYmxvZy5cbiAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICovXG4gIHJlYWRvbmx5IHdlYnNpdGU/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcblxuICAvKipcbiAgICogREVQUkVDQVRFRFxuICAgKiBAZGVwcmVjYXRlZCB0aGlzIGlzIG5vdCBhIHN0YW5kYXJkIGF0dHJpYnV0ZSBhbmQgd2FzIGluY29ycmVjdGx5IGFkZGVkIHRvIHRoZSBDREsuXG4gICAqIEl0IGlzIGEgQ29nbml0byBidWlsdC1pbiBhdHRyaWJ1dGUgYW5kIGNhbm5vdCBiZSBjb250cm9sbGVkIGFzIHBhcnQgb2YgdXNlciBwb29sIGNyZWF0aW9uLlxuICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgKi9cbiAgcmVhZG9ubHkgZW1haWxWZXJpZmllZD86IFN0YW5kYXJkQXR0cmlidXRlO1xuXG4gIC8qKlxuICAgKiBERVBSRUNBVEVEXG4gICAqIEBkZXByZWNhdGVkIHRoaXMgaXMgbm90IGEgc3RhbmRhcmQgYXR0cmlidXRlIGFuZCB3YXMgaW5jb3JyZWN0bHkgYWRkZWQgdG8gdGhlIENESy5cbiAgICogSXQgaXMgYSBDb2duaXRvIGJ1aWx0LWluIGF0dHJpYnV0ZSBhbmQgY2Fubm90IGJlIGNvbnRyb2xsZWQgYXMgcGFydCBvZiB1c2VyIHBvb2wgY3JlYXRpb24uXG4gICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAqL1xuICByZWFkb25seSBwaG9uZU51bWJlclZlcmlmaWVkPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG59XG5cbi8qKlxuICogU3RhbmRhcmQgYXR0cmlidXRlIHRoYXQgY2FuIGJlIG1hcmtlZCBhcyByZXF1aXJlZCBvciBtdXRhYmxlLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvZ25pdG8vbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3VzZXItcG9vbC1zZXR0aW5ncy1hdHRyaWJ1dGVzLmh0bWwjY29nbml0by11c2VyLXBvb2xzLXN0YW5kYXJkLWF0dHJpYnV0ZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdGFuZGFyZEF0dHJpYnV0ZSB7XG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgdmFsdWUgb2YgdGhlIGF0dHJpYnV0ZSBjYW4gYmUgY2hhbmdlZC5cbiAgICogRm9yIGFueSB1c2VyIHBvb2wgYXR0cmlidXRlIHRoYXQncyBtYXBwZWQgdG8gYW4gaWRlbnRpdHkgcHJvdmlkZXIgYXR0cmlidXRlLCB0aGlzIG11c3QgYmUgc2V0IHRvIGB0cnVlYC5cbiAgICogQW1hem9uIENvZ25pdG8gdXBkYXRlcyBtYXBwZWQgYXR0cmlidXRlcyB3aGVuIHVzZXJzIHNpZ24gaW4gdG8geW91ciBhcHBsaWNhdGlvbiB0aHJvdWdoIGFuIGlkZW50aXR5IHByb3ZpZGVyLlxuICAgKiBJZiBhbiBhdHRyaWJ1dGUgaXMgaW1tdXRhYmxlLCBBbWF6b24gQ29nbml0byB0aHJvd3MgYW4gZXJyb3Igd2hlbiBpdCBhdHRlbXB0cyB0byB1cGRhdGUgdGhlIGF0dHJpYnV0ZS5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgbXV0YWJsZT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgYXR0cmlidXRlIGlzIHJlcXVpcmVkIHVwb24gdXNlciByZWdpc3RyYXRpb24uXG4gICAqIElmIHRoZSBhdHRyaWJ1dGUgaXMgcmVxdWlyZWQgYW5kIHRoZSB1c2VyIGRvZXMgbm90IHByb3ZpZGUgYSB2YWx1ZSwgcmVnaXN0cmF0aW9uIG9yIHNpZ24taW4gd2lsbCBmYWlsLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVxdWlyZWQ/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYSBjdXN0b20gYXR0cmlidXRlIHR5cGUuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUN1c3RvbUF0dHJpYnV0ZSB7XG4gIC8qKlxuICAgKiBCaW5kIHRoaXMgY3VzdG9tIGF0dHJpYnV0ZSB0eXBlIHRvIHRoZSB2YWx1ZXMgYXMgZXhwZWN0ZWQgYnkgQ2xvdWRGb3JtYXRpb25cbiAgICovXG4gIGJpbmQoKTogQ3VzdG9tQXR0cmlidXRlQ29uZmlnO1xufVxuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gdGhhdCB3aWxsIGJlIGZlZCBpbnRvIENsb3VkRm9ybWF0aW9uIGZvciBhbnkgY3VzdG9tIGF0dHJpYnV0ZSB0eXBlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEN1c3RvbUF0dHJpYnV0ZUNvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgZGF0YSB0eXBlIG9mIHRoZSBjdXN0b20gYXR0cmlidXRlLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb2duaXRvLXVzZXItaWRlbnRpdHktcG9vbHMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU2NoZW1hQXR0cmlidXRlVHlwZS5odG1sI0NvZ25pdG9Vc2VyUG9vbHMtVHlwZS1TY2hlbWFBdHRyaWJ1dGVUeXBlLUF0dHJpYnV0ZURhdGFUeXBlXG4gICAqL1xuICByZWFkb25seSBkYXRhVHlwZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgY29uc3RyYWludHMgZm9yIGEgY3VzdG9tIGF0dHJpYnV0ZSBvZiAnU3RyaW5nJyBkYXRhIHR5cGUuXG4gICAqIEBkZWZhdWx0IC0gTm9uZS5cbiAgICovXG4gIHJlYWRvbmx5IHN0cmluZ0NvbnN0cmFpbnRzPzogU3RyaW5nQXR0cmlidXRlQ29uc3RyYWludHM7XG5cbiAgLyoqXG4gICAqIFRoZSBjb25zdHJhaW50cyBmb3IgYSBjdXN0b20gYXR0cmlidXRlIG9mIHRoZSAnTnVtYmVyJyBkYXRhIHR5cGUuXG4gICAqIEBkZWZhdWx0IC0gTm9uZS5cbiAgICovXG4gIHJlYWRvbmx5IG51bWJlckNvbnN0cmFpbnRzPzogTnVtYmVyQXR0cmlidXRlQ29uc3RyYWludHM7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyB3aGV0aGVyIHRoZSB2YWx1ZSBvZiB0aGUgYXR0cmlidXRlIGNhbiBiZSBjaGFuZ2VkLlxuICAgKiBGb3IgYW55IHVzZXIgcG9vbCBhdHRyaWJ1dGUgdGhhdCdzIG1hcHBlZCB0byBhbiBpZGVudGl0eSBwcm92aWRlciBhdHRyaWJ1dGUsIHlvdSBtdXN0IHNldCB0aGlzIHBhcmFtZXRlciB0byB0cnVlLlxuICAgKiBBbWF6b24gQ29nbml0byB1cGRhdGVzIG1hcHBlZCBhdHRyaWJ1dGVzIHdoZW4gdXNlcnMgc2lnbiBpbiB0byB5b3VyIGFwcGxpY2F0aW9uIHRocm91Z2ggYW4gaWRlbnRpdHkgcHJvdmlkZXIuXG4gICAqIElmIGFuIGF0dHJpYnV0ZSBpcyBpbW11dGFibGUsIEFtYXpvbiBDb2duaXRvIHRocm93cyBhbiBlcnJvciB3aGVuIGl0IGF0dGVtcHRzIHRvIHVwZGF0ZSB0aGUgYXR0cmlidXRlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgbXV0YWJsZT86IGJvb2xlYW47XG59XG5cbi8qKlxuICogQ29uc3RyYWludHMgdGhhdCBjYW4gYmUgYXBwbGllZCB0byBhIGN1c3RvbSBhdHRyaWJ1dGUgb2YgYW55IHR5cGUuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ3VzdG9tQXR0cmlidXRlUHJvcHMge1xuICAvKipcbiAgICogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIHZhbHVlIG9mIHRoZSBhdHRyaWJ1dGUgY2FuIGJlIGNoYW5nZWQuXG4gICAqIEZvciBhbnkgdXNlciBwb29sIGF0dHJpYnV0ZSB0aGF0J3MgbWFwcGVkIHRvIGFuIGlkZW50aXR5IHByb3ZpZGVyIGF0dHJpYnV0ZSwgeW91IG11c3Qgc2V0IHRoaXMgcGFyYW1ldGVyIHRvIHRydWUuXG4gICAqIEFtYXpvbiBDb2duaXRvIHVwZGF0ZXMgbWFwcGVkIGF0dHJpYnV0ZXMgd2hlbiB1c2VycyBzaWduIGluIHRvIHlvdXIgYXBwbGljYXRpb24gdGhyb3VnaCBhbiBpZGVudGl0eSBwcm92aWRlci5cbiAgICogSWYgYW4gYXR0cmlidXRlIGlzIGltbXV0YWJsZSwgQW1hem9uIENvZ25pdG8gdGhyb3dzIGFuIGVycm9yIHdoZW4gaXQgYXR0ZW1wdHMgdG8gdXBkYXRlIHRoZSBhdHRyaWJ1dGUuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBtdXRhYmxlPzogYm9vbGVhblxufVxuXG4vKipcbiAqIENvbnN0cmFpbnRzIHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gYSBjdXN0b20gYXR0cmlidXRlIG9mIHN0cmluZyB0eXBlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0cmluZ0F0dHJpYnV0ZUNvbnN0cmFpbnRzIHtcbiAgLyoqXG4gICAqIE1pbmltdW0gbGVuZ3RoIG9mIHRoaXMgYXR0cmlidXRlLlxuICAgKiBAZGVmYXVsdCAwXG4gICAqL1xuICByZWFkb25seSBtaW5MZW4/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIE1heGltdW0gbGVuZ3RoIG9mIHRoaXMgYXR0cmlidXRlLlxuICAgKiBAZGVmYXVsdCAyMDQ4XG4gICAqL1xuICByZWFkb25seSBtYXhMZW4/OiBudW1iZXI7XG59XG5cbi8qKlxuICogUHJvcHMgZm9yIGNvbnN0cnVjdGluZyBhIFN0cmluZ0F0dHJcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdHJpbmdBdHRyaWJ1dGVQcm9wcyBleHRlbmRzIFN0cmluZ0F0dHJpYnV0ZUNvbnN0cmFpbnRzLCBDdXN0b21BdHRyaWJ1dGVQcm9wcyB7XG59XG5cbi8qKlxuICogVGhlIFN0cmluZyBjdXN0b20gYXR0cmlidXRlIHR5cGUuXG4gKi9cbmV4cG9ydCBjbGFzcyBTdHJpbmdBdHRyaWJ1dGUgaW1wbGVtZW50cyBJQ3VzdG9tQXR0cmlidXRlIHtcbiAgcHJpdmF0ZSByZWFkb25seSBtaW5MZW4/OiBudW1iZXI7XG4gIHByaXZhdGUgcmVhZG9ubHkgbWF4TGVuPzogbnVtYmVyO1xuICBwcml2YXRlIHJlYWRvbmx5IG11dGFibGU/OiBib29sZWFuO1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBTdHJpbmdBdHRyaWJ1dGVQcm9wcyA9IHt9KSB7XG4gICAgaWYgKHByb3BzLm1pbkxlbiAmJiAhVG9rZW4uaXNVbnJlc29sdmVkKHByb3BzLm1pbkxlbikgJiYgcHJvcHMubWluTGVuIDwgMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBtaW5MZW4gY2Fubm90IGJlIGxlc3MgdGhhbiAwICh2YWx1ZTogJHtwcm9wcy5taW5MZW59KS5gKTtcbiAgICB9XG4gICAgaWYgKHByb3BzLm1heExlbiAmJiAhVG9rZW4uaXNVbnJlc29sdmVkKHByb3BzLm1heExlbikgJiYgcHJvcHMubWF4TGVuID4gMjA0OCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBtYXhMZW4gY2Fubm90IGJlIGdyZWF0ZXIgdGhhbiAyMDQ4ICh2YWx1ZTogJHtwcm9wcy5tYXhMZW59KS5gKTtcbiAgICB9XG4gICAgdGhpcy5taW5MZW4gPSBwcm9wcz8ubWluTGVuO1xuICAgIHRoaXMubWF4TGVuID0gcHJvcHM/Lm1heExlbjtcbiAgICB0aGlzLm11dGFibGUgPSBwcm9wcz8ubXV0YWJsZTtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKCk6IEN1c3RvbUF0dHJpYnV0ZUNvbmZpZyB7XG4gICAgbGV0IHN0cmluZ0NvbnN0cmFpbnRzOiBTdHJpbmdBdHRyaWJ1dGVDb25zdHJhaW50cyB8IHVuZGVmaW5lZDtcbiAgICBpZiAodGhpcy5taW5MZW4gfHwgdGhpcy5tYXhMZW4pIHtcbiAgICAgIHN0cmluZ0NvbnN0cmFpbnRzID0ge1xuICAgICAgICBtaW5MZW46IHRoaXMubWluTGVuLFxuICAgICAgICBtYXhMZW46IHRoaXMubWF4TGVuLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGF0YVR5cGU6ICdTdHJpbmcnLFxuICAgICAgc3RyaW5nQ29uc3RyYWludHMsXG4gICAgICBtdXRhYmxlOiB0aGlzLm11dGFibGUsXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIENvbnN0cmFpbnRzIHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gYSBjdXN0b20gYXR0cmlidXRlIG9mIG51bWJlciB0eXBlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIE51bWJlckF0dHJpYnV0ZUNvbnN0cmFpbnRzIHtcbiAgLyoqXG4gICAqIE1pbmltdW0gdmFsdWUgb2YgdGhpcyBhdHRyaWJ1dGUuXG4gICAqIEBkZWZhdWx0IC0gbm8gbWluaW11bSB2YWx1ZVxuICAgKi9cbiAgcmVhZG9ubHkgbWluPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBNYXhpbXVtIHZhbHVlIG9mIHRoaXMgYXR0cmlidXRlLlxuICAgKiBAZGVmYXVsdCAtIG5vIG1heGltdW0gdmFsdWVcbiAgICovXG4gIHJlYWRvbmx5IG1heD86IG51bWJlcjtcbn1cblxuLyoqXG4gKiBQcm9wcyBmb3IgTnVtYmVyQXR0clxuICovXG5leHBvcnQgaW50ZXJmYWNlIE51bWJlckF0dHJpYnV0ZVByb3BzIGV4dGVuZHMgTnVtYmVyQXR0cmlidXRlQ29uc3RyYWludHMsIEN1c3RvbUF0dHJpYnV0ZVByb3BzIHtcbn1cblxuLyoqXG4gKiBUaGUgTnVtYmVyIGN1c3RvbSBhdHRyaWJ1dGUgdHlwZS5cbiAqL1xuZXhwb3J0IGNsYXNzIE51bWJlckF0dHJpYnV0ZSBpbXBsZW1lbnRzIElDdXN0b21BdHRyaWJ1dGUge1xuICBwcml2YXRlIHJlYWRvbmx5IG1pbj86IG51bWJlcjtcbiAgcHJpdmF0ZSByZWFkb25seSBtYXg/OiBudW1iZXI7XG4gIHByaXZhdGUgcmVhZG9ubHkgbXV0YWJsZT86IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IocHJvcHM6IE51bWJlckF0dHJpYnV0ZVByb3BzID0ge30pIHtcbiAgICB0aGlzLm1pbiA9IHByb3BzPy5taW47XG4gICAgdGhpcy5tYXggPSBwcm9wcz8ubWF4O1xuICAgIHRoaXMubXV0YWJsZSA9IHByb3BzPy5tdXRhYmxlO1xuICB9XG5cbiAgcHVibGljIGJpbmQoKTogQ3VzdG9tQXR0cmlidXRlQ29uZmlnIHtcbiAgICBsZXQgbnVtYmVyQ29uc3RyYWludHM6IE51bWJlckF0dHJpYnV0ZUNvbnN0cmFpbnRzIHwgdW5kZWZpbmVkO1xuICAgIGlmICh0aGlzLm1pbiB8fCB0aGlzLm1heCkge1xuICAgICAgbnVtYmVyQ29uc3RyYWludHMgPSB7XG4gICAgICAgIG1pbjogdGhpcy5taW4sXG4gICAgICAgIG1heDogdGhpcy5tYXgsXG4gICAgICB9O1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBkYXRhVHlwZTogJ051bWJlcicsXG4gICAgICBudW1iZXJDb25zdHJhaW50cyxcbiAgICAgIG11dGFibGU6IHRoaXMubXV0YWJsZSxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuICogVGhlIEJvb2xlYW4gY3VzdG9tIGF0dHJpYnV0ZSB0eXBlLlxuICovXG5leHBvcnQgY2xhc3MgQm9vbGVhbkF0dHJpYnV0ZSBpbXBsZW1lbnRzIElDdXN0b21BdHRyaWJ1dGUge1xuICBwcml2YXRlIHJlYWRvbmx5IG11dGFibGU/OiBib29sZWFuO1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBDdXN0b21BdHRyaWJ1dGVQcm9wcyA9IHt9KSB7XG4gICAgdGhpcy5tdXRhYmxlID0gcHJvcHM/Lm11dGFibGU7XG4gIH1cblxuICBwdWJsaWMgYmluZCgpOiBDdXN0b21BdHRyaWJ1dGVDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBkYXRhVHlwZTogJ0Jvb2xlYW4nLFxuICAgICAgbXV0YWJsZTogdGhpcy5tdXRhYmxlLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBUaGUgRGF0ZVRpbWUgY3VzdG9tIGF0dHJpYnV0ZSB0eXBlLlxuICovXG5leHBvcnQgY2xhc3MgRGF0ZVRpbWVBdHRyaWJ1dGUgaW1wbGVtZW50cyBJQ3VzdG9tQXR0cmlidXRlIHtcbiAgcHJpdmF0ZSByZWFkb25seSBtdXRhYmxlPzogYm9vbGVhbjtcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogQ3VzdG9tQXR0cmlidXRlUHJvcHMgPSB7fSkge1xuICAgIHRoaXMubXV0YWJsZSA9IHByb3BzPy5tdXRhYmxlO1xuICB9XG5cbiAgcHVibGljIGJpbmQoKTogQ3VzdG9tQXR0cmlidXRlQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgZGF0YVR5cGU6ICdEYXRlVGltZScsXG4gICAgICBtdXRhYmxlOiB0aGlzLm11dGFibGUsXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIFRoaXMgaW50ZXJmYWNlIGNvbnRhaW5zIHN0YW5kYXJkIGF0dHJpYnV0ZXMgcmVjb2duaXplZCBieSBDb2duaXRvXG4gKiBmcm9tIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb2duaXRvL2xhdGVzdC9kZXZlbG9wZXJndWlkZS91c2VyLXBvb2wtc2V0dGluZ3MtYXR0cmlidXRlcy5odG1sXG4gKiBpbmNsdWRpbmcgYnVpbHQtaW4gYXR0cmlidXRlcyBgZW1haWxfdmVyaWZpZWRgIGFuZCBgcGhvbmVfbnVtYmVyX3ZlcmlmaWVkYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0YW5kYXJkQXR0cmlidXRlc01hc2sge1xuICAvKipcbiAgICogVGhlIHVzZXIncyBwb3N0YWwgYWRkcmVzcy5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGFkZHJlc3M/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIGJpcnRoZGF5LCByZXByZXNlbnRlZCBhcyBhbiBJU08gODYwMToyMDA0IGZvcm1hdC5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGJpcnRoZGF0ZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgZS1tYWlsIGFkZHJlc3MsIHJlcHJlc2VudGVkIGFzIGFuIFJGQyA1MzIyIFtSRkM1MzIyXSBhZGRyLXNwZWMuXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBlbWFpbD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSBzdXJuYW1lIG9yIGxhc3QgbmFtZSBvZiB0aGUgdXNlci5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGZhbWlseU5hbWU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIGdlbmRlci5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGdlbmRlcj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgZmlyc3QgbmFtZSBvciBnaXZlIG5hbWUuXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBnaXZlbk5hbWU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIGxvY2FsZSwgcmVwcmVzZW50ZWQgYXMgYSBCQ1A0NyBbUkZDNTY0Nl0gbGFuZ3VhZ2UgdGFnLlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgbG9jYWxlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIHVzZXIncyBtaWRkbGUgbmFtZS5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IG1pZGRsZU5hbWU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIGZ1bGwgbmFtZSBpbiBkaXNwbGF5YWJsZSBmb3JtLCBpbmNsdWRpbmcgYWxsIG5hbWUgcGFydHMsIHRpdGxlcyBhbmQgc3VmZml4ZXMuXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBmdWxsbmFtZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3Mgbmlja25hbWUgb3IgY2FzdWFsIG5hbWUuXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBuaWNrbmFtZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VyJ3MgdGVsZXBob25lIG51bWJlci5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHBob25lTnVtYmVyPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIFVSTCB0byB0aGUgdXNlcidzIHByb2ZpbGUgcGljdHVyZS5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHByb2ZpbGVQaWN0dXJlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIHVzZXIncyBwcmVmZmVyZWQgdXNlcm5hbWUsIGRpZmZlcmVudCBmcm9tIHRoZSBpbW11dGFibGUgdXNlciBuYW1lLlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgcHJlZmVycmVkVXNlcm5hbWU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgVVJMIHRvIHRoZSB1c2VyJ3MgcHJvZmlsZSBwYWdlLlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgcHJvZmlsZVBhZ2U/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgdXNlcidzIHRpbWUgem9uZS5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHRpbWV6b25lPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIHRpbWUsIHRoZSB1c2VyJ3MgaW5mb3JtYXRpb24gd2FzIGxhc3QgdXBkYXRlZC5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGxhc3RVcGRhdGVUaW1lPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIFVSTCB0byB0aGUgdXNlcidzIHdlYiBwYWdlIG9yIGJsb2cuXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSB3ZWJzaXRlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogV2hldGhlciB0aGUgZW1haWwgYWRkcmVzcyBoYXMgYmVlbiB2ZXJpZmllZC5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGVtYWlsVmVyaWZpZWQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRoZSBwaG9uZSBudW1iZXIgaGFzIGJlZW4gdmVyaWZpZWQuXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBwaG9uZU51bWJlclZlcmlmaWVkPzogYm9vbGVhbjtcbn1cblxuXG4vKipcbiAqIEEgc2V0IG9mIGF0dHJpYnV0ZXMsIHVzZWZ1bCB0byBzZXQgUmVhZCBhbmQgV3JpdGUgYXR0cmlidXRlc1xuICovXG5leHBvcnQgY2xhc3MgQ2xpZW50QXR0cmlidXRlcyB7XG5cbiAgLyoqXG4gICAqIFRoZSBzZXQgb2YgYXR0cmlidXRlc1xuICAgKi9cbiAgcHJpdmF0ZSBhdHRyaWJ1dGVzU2V0OiBTZXQ8c3RyaW5nPjtcblxuICAvKipcbiAgICogQ3JlYXRlcyBhIENsaWVudEF0dHJpYnV0ZXMgd2l0aCB0aGUgc3BlY2lmaWVkIGF0dHJpYnV0ZXNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBhIENsaWVudEF0dHJpYnV0ZXMgb2JqZWN0IHdpdGhvdXQgYW55IGF0dHJpYnV0ZXNcbiAgICovXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHRoaXMuYXR0cmlidXRlc1NldCA9IG5ldyBTZXQ8c3RyaW5nPigpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBjdXN0b20gQ2xpZW50QXR0cmlidXRlcyB3aXRoIHRoZSBzcGVjaWZpZWQgYXR0cmlidXRlc1xuICAgKiBAcGFyYW0gYXR0cmlidXRlcyBhIGxpc3Qgb2Ygc3RhbmRhcmQgYXR0cmlidXRlcyB0byBhZGQgdG8gdGhlIHNldFxuICAgKi9cbiAgcHVibGljIHdpdGhTdGFuZGFyZEF0dHJpYnV0ZXMoYXR0cmlidXRlczogU3RhbmRhcmRBdHRyaWJ1dGVzTWFzayk6IENsaWVudEF0dHJpYnV0ZXMge1xuICAgIGxldCBhdHRyaWJ1dGVzU2V0ID0gbmV3IFNldCh0aGlzLmF0dHJpYnV0ZXNTZXQpO1xuICAgIC8vIGl0ZXJhdGUgdGhyb3VnaCBrZXktdmFsdWVzIGluIHRoZSBgU3RhbmRhcmRBdHRyaWJ1dGVOYW1lc2AgY29uc3RhbnRcbiAgICAvLyB0byBnZXQgdGhlIHZhbHVlIGZvciBhbGwgYXR0cmlidXRlc1xuICAgIGZvciAoY29uc3QgYXR0cmlidXRlS2V5IGluIFN0YW5kYXJkQXR0cmlidXRlTmFtZXMpIHtcbiAgICAgIGlmICgoYXR0cmlidXRlcyBhcyBhbnkpW2F0dHJpYnV0ZUtleV0gPT09IHRydWUpIHtcbiAgICAgICAgY29uc3QgYXR0cmlidXRlTmFtZSA9IChTdGFuZGFyZEF0dHJpYnV0ZU5hbWVzIGFzIGFueSlbYXR0cmlidXRlS2V5XTtcbiAgICAgICAgYXR0cmlidXRlc1NldC5hZGQoYXR0cmlidXRlTmFtZSk7XG4gICAgICB9XG4gICAgfVxuICAgIGxldCBhdXggPSBuZXcgQ2xpZW50QXR0cmlidXRlcygpO1xuICAgIGF1eC5hdHRyaWJ1dGVzU2V0ID0gYXR0cmlidXRlc1NldDtcbiAgICByZXR1cm4gYXV4O1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBjdXN0b20gQ2xpZW50QXR0cmlidXRlcyB3aXRoIHRoZSBzcGVjaWZpZWQgYXR0cmlidXRlc1xuICAgKiBAcGFyYW0gYXR0cmlidXRlcyBhIGxpc3Qgb2YgY3VzdG9tIGF0dHJpYnV0ZXMgdG8gYWRkIHRvIHRoZSBzZXRcbiAgICovXG4gIHB1YmxpYyB3aXRoQ3VzdG9tQXR0cmlidXRlcyguLi5hdHRyaWJ1dGVzOiBzdHJpbmdbXSk6IENsaWVudEF0dHJpYnV0ZXMge1xuICAgIGxldCBhdHRyaWJ1dGVzU2V0OiBTZXQ8c3RyaW5nPiA9IG5ldyBTZXQodGhpcy5hdHRyaWJ1dGVzU2V0KTtcbiAgICBmb3IgKGxldCBhdHRyaWJ1dGUgb2YgYXR0cmlidXRlcykge1xuICAgICAgLy8gY3VzdG9tIGF0dHJpYnV0ZXMgTVVTVCBiZWdpbiB3aXRoIGBjdXN0b206YCwgc28gYWRkIHRoZSBzdHJpbmcgaWYgbm90IHByZXNlbnRcbiAgICAgIGlmICghYXR0cmlidXRlLnN0YXJ0c1dpdGgoJ2N1c3RvbTonKSkge1xuICAgICAgICBhdHRyaWJ1dGUgPSAnY3VzdG9tOicgKyBhdHRyaWJ1dGU7XG4gICAgICB9XG4gICAgICBhdHRyaWJ1dGVzU2V0LmFkZChhdHRyaWJ1dGUpO1xuICAgIH1cbiAgICBsZXQgYXV4ID0gbmV3IENsaWVudEF0dHJpYnV0ZXMoKTtcbiAgICBhdXguYXR0cmlidXRlc1NldCA9IGF0dHJpYnV0ZXNTZXQ7XG4gICAgcmV0dXJuIGF1eDtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgbGlzdCBvZiBhdHRyaWJ1dGVzIHJlcHJlc2VudGVkIGJ5IHRoaXMgQ2xpZW50QXR0cmlidXRlc1xuICAgKi9cbiAgcHVibGljIGF0dHJpYnV0ZXMoKTogc3RyaW5nW10ge1xuICAgIC8vIHNvcnRpbmcgaXMgdW5uZWNlc3NhcnkgYnV0IGl0IHNpbXBsaWZ5IHRlc3RpbmdcbiAgICByZXR1cm4gQXJyYXkuZnJvbSh0aGlzLmF0dHJpYnV0ZXNTZXQpLnNvcnQoKTtcbiAgfVxufVxuIl19