"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderAttribute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An attribute available from a third party identity provider.
 */
class ProviderAttribute {
    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     * @param attributeName the attribute value string as recognized by the provider
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ProviderAttribute[_a] = { fqn: "aws-cdk-lib.aws_cognito.ProviderAttribute", version: "2.74.0" };
/** The email attribute provided by Apple */
ProviderAttribute.APPLE_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Apple */
ProviderAttribute.APPLE_NAME = new ProviderAttribute('name');
/** The first name attribute provided by Apple */
ProviderAttribute.APPLE_FIRST_NAME = new ProviderAttribute('firstName');
/** The last name attribute provided by Apple */
ProviderAttribute.APPLE_LAST_NAME = new ProviderAttribute('lastName');
/** The user id attribute provided by Amazon */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/** The email attribute provided by Amazon */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Amazon */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/** The postal code attribute provided by Amazon */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/** The user id attribute provided by Facebook */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/** The birthday attribute provided by Facebook */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/** The email attribute provided by Facebook */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/** The first name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/** The last name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/** The middle name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/** The gender attribute provided by Facebook */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/** The locale attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/** The name attribute provided by Google */
ProviderAttribute.GOOGLE_NAMES = new ProviderAttribute('names');
/** The gender attribute provided by Google */
ProviderAttribute.GOOGLE_GENDER = new ProviderAttribute('gender');
/** The birthday attribute provided by Google */
ProviderAttribute.GOOGLE_BIRTHDAYS = new ProviderAttribute('birthdays');
/** The phone number attribute provided by Google */
ProviderAttribute.GOOGLE_PHONE_NUMBERS = new ProviderAttribute('phoneNumbers');
/** The email attribute provided by Google */
ProviderAttribute.GOOGLE_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Google */
ProviderAttribute.GOOGLE_NAME = new ProviderAttribute('name');
/** The picture attribute provided by Google */
ProviderAttribute.GOOGLE_PICTURE = new ProviderAttribute('picture');
/** The given name attribute provided by Google */
ProviderAttribute.GOOGLE_GIVEN_NAME = new ProviderAttribute('given_name');
/** The family name attribute provided by Google */
ProviderAttribute.GOOGLE_FAMILY_NAME = new ProviderAttribute('family_name');
exports.ProviderAttribute = ProviderAttribute;
//# sourceMappingURL=data:application/json;base64,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