"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderOidc = exports.OidcAttributeRequestMethod = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const user_pool_idp_base_1 = require("./private/user-pool-idp-base");
const cognito_generated_1 = require("../cognito.generated");
/**
 * The method to use to request attributes
 */
var OidcAttributeRequestMethod;
(function (OidcAttributeRequestMethod) {
    /** GET */
    OidcAttributeRequestMethod["GET"] = "GET";
    /** POST */
    OidcAttributeRequestMethod["POST"] = "POST";
})(OidcAttributeRequestMethod = exports.OidcAttributeRequestMethod || (exports.OidcAttributeRequestMethod = {}));
/**
 * Represents a identity provider that integrates with OpenID Connect
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderOidc extends user_pool_idp_base_1.UserPoolIdentityProviderBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_UserPoolIdentityProviderOidcProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, UserPoolIdentityProviderOidc);
            }
            throw error;
        }
        if (props.name && !core_1.Token.isUnresolved(props.name) && (props.name.length < 3 || props.name.length > 32)) {
            throw new Error(`Expected provider name to be between 3 and 32 characters, received ${props.name} (${props.name.length} characters)`);
        }
        const scopes = props.scopes ?? ['openid'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: this.getProviderName(props.name),
            providerType: 'OIDC',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
                attributes_request_method: props.attributeRequestMethod ?? OidcAttributeRequestMethod.GET,
                oidc_issuer: props.issuerUrl,
                authorize_url: props.endpoints?.authorization,
                token_url: props.endpoints?.token,
                attributes_url: props.endpoints?.userInfo,
                jwks_uri: props.endpoints?.jwksUri,
            },
            idpIdentifiers: props.identifiers,
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
    getProviderName(name) {
        if (name) {
            if (!core_1.Token.isUnresolved(name) && (name.length < 3 || name.length > 32)) {
                throw new Error(`Expected provider name to be between 3 and 32 characters, received ${name} (${name.length} characters)`);
            }
            return name;
        }
        const uniqueId = core_1.Names.uniqueId(this);
        if (uniqueId.length < 3) {
            return `${uniqueId}oidc`;
        }
        if (uniqueId.length > 32) {
            return uniqueId.substring(0, 16) + uniqueId.substring(uniqueId.length - 16);
        }
        return uniqueId;
    }
}
_a = JSII_RTTI_SYMBOL_1;
UserPoolIdentityProviderOidc[_a] = { fqn: "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderOidc", version: "2.74.0" };
exports.UserPoolIdentityProviderOidc = UserPoolIdentityProviderOidc;
//# sourceMappingURL=data:application/json;base64,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