"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolResourceServer = exports.ResourceServerScope = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const cognito_generated_1 = require("./cognito.generated");
/**
 * A scope for ResourceServer
 */
class ResourceServerScope {
    constructor(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_ResourceServerScopeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ResourceServerScope);
            }
            throw error;
        }
        this.scopeName = props.scopeName;
        this.scopeDescription = props.scopeDescription;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ResourceServerScope[_a] = { fqn: "aws-cdk-lib.aws_cognito.ResourceServerScope", version: "2.74.0" };
exports.ResourceServerScope = ResourceServerScope;
/**
 * Defines a User Pool OAuth2.0 Resource Server
 */
class UserPoolResourceServer extends core_1.Resource {
    /**
     * Import a user pool resource client given its id.
     */
    static fromUserPoolResourceServerId(scope, id, userPoolResourceServerId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.userPoolResourceServerId = userPoolResourceServerId;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.identifier,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_UserPoolResourceServerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, UserPoolResourceServer);
            }
            throw error;
        }
        const resource = new cognito_generated_1.CfnUserPoolResourceServer(this, 'Resource', {
            identifier: this.physicalName,
            name: props.userPoolResourceServerName ?? this.physicalName,
            scopes: props.scopes,
            userPoolId: props.userPool.userPoolId,
        });
        this.userPoolResourceServerId = resource.ref;
    }
}
_b = JSII_RTTI_SYMBOL_1;
UserPoolResourceServer[_b] = { fqn: "aws-cdk-lib.aws_cognito.UserPoolResourceServer", version: "2.74.0" };
exports.UserPoolResourceServer = UserPoolResourceServer;
//# sourceMappingURL=data:application/json;base64,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