"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTask = exports.CfnLocationSMB = exports.CfnLocationS3 = exports.CfnLocationObjectStorage = exports.CfnLocationNFS = exports.CfnLocationHDFS = exports.CfnLocationFSxWindows = exports.CfnLocationFSxOpenZFS = exports.CfnLocationFSxONTAP = exports.CfnLocationFSxLustre = exports.CfnLocationEFS = exports.CfnAgent = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAgentProps`
 *
 * @param properties - the TypeScript properties of a `CfnAgentProps`
 *
 * @returns the result of the validation.
 */
function CfnAgentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('activationKey', cdk.validateString)(properties.activationKey));
    errors.collect(cdk.propertyValidator('agentName', cdk.validateString)(properties.agentName));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subnetArns', cdk.listValidator(cdk.validateString))(properties.subnetArns));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcEndpointId', cdk.validateString)(properties.vpcEndpointId));
    return errors.wrap('supplied properties not correct for "CfnAgentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Agent` resource
 *
 * @param properties - the TypeScript properties of a `CfnAgentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Agent` resource.
 */
// @ts-ignore TS6133
function cfnAgentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAgentPropsValidator(properties).assertSuccess();
    return {
        ActivationKey: cdk.stringToCloudFormation(properties.activationKey),
        AgentName: cdk.stringToCloudFormation(properties.agentName),
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        SubnetArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetArns),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VpcEndpointId: cdk.stringToCloudFormation(properties.vpcEndpointId),
    };
}
// @ts-ignore TS6133
function CfnAgentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('activationKey', 'ActivationKey', properties.ActivationKey != null ? cfn_parse.FromCloudFormation.getString(properties.ActivationKey) : undefined);
    ret.addPropertyResult('agentName', 'AgentName', properties.AgentName != null ? cfn_parse.FromCloudFormation.getString(properties.AgentName) : undefined);
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', properties.SecurityGroupArns != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns) : undefined);
    ret.addPropertyResult('subnetArns', 'SubnetArns', properties.SubnetArns != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SubnetArns) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcEndpointId', 'VpcEndpointId', properties.VpcEndpointId != null ? cfn_parse.FromCloudFormation.getString(properties.VpcEndpointId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::Agent`
 *
 * The `AWS::DataSync::Agent` resource specifies an AWS DataSync agent to be deployed and activated on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the AWS Region that you want to activate the agent in. You activate the agent in the AWS Region where your target locations (in Amazon S3, Amazon EFS, or Amazon FSx for Windows File Server) reside. Your tasks are created in this AWS Region .
 *
 * You can activate the agent in a virtual private cloud (VPC) or provide the agent access to a VPC endpoint so that you can run tasks without sending them over the public internet.
 *
 * You can specify an agent to be used for more than one location. If a task uses multiple agents, all of them must have a status of AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
 *
 * For more information, see [Activating an Agent](https://docs.aws.amazon.com/datasync/latest/userguide/activating-agent.html) in the *AWS DataSync User Guide* .
 *
 * Agents are automatically updated by AWS on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
 *
 * @cloudformationResource AWS::DataSync::Agent
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html
 */
class CfnAgent extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAgentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAgent(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::Agent`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnAgent.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnAgentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAgent);
            }
            throw error;
        }
        this.attrAgentArn = cdk.Token.asString(this.getAtt('AgentArn', cdk.ResolutionTypeHint.STRING));
        this.attrEndpointType = cdk.Token.asString(this.getAtt('EndpointType', cdk.ResolutionTypeHint.STRING));
        this.activationKey = props.activationKey;
        this.agentName = props.agentName;
        this.securityGroupArns = props.securityGroupArns;
        this.subnetArns = props.subnetArns;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::Agent", props.tags, { tagPropertyName: 'tags' });
        this.vpcEndpointId = props.vpcEndpointId;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAgent.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            activationKey: this.activationKey,
            agentName: this.agentName,
            securityGroupArns: this.securityGroupArns,
            subnetArns: this.subnetArns,
            tags: this.tags.renderTags(),
            vpcEndpointId: this.vpcEndpointId,
        };
    }
    renderProperties(props) {
        return cfnAgentPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnAgent[_a] = { fqn: "aws-cdk-lib.aws_datasync.CfnAgent", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAgent.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::Agent";
exports.CfnAgent = CfnAgent;
/**
 * Determine whether the given properties match those of a `CfnLocationEFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationEFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationEFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessPointArn', cdk.validateString)(properties.accessPointArn));
    errors.collect(cdk.propertyValidator('ec2Config', cdk.requiredValidator)(properties.ec2Config));
    errors.collect(cdk.propertyValidator('ec2Config', CfnLocationEFS_Ec2ConfigPropertyValidator)(properties.ec2Config));
    errors.collect(cdk.propertyValidator('efsFilesystemArn', cdk.validateString)(properties.efsFilesystemArn));
    errors.collect(cdk.propertyValidator('fileSystemAccessRoleArn', cdk.validateString)(properties.fileSystemAccessRoleArn));
    errors.collect(cdk.propertyValidator('inTransitEncryption', cdk.validateString)(properties.inTransitEncryption));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationEFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationEFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationEFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationEFSPropsValidator(properties).assertSuccess();
    return {
        Ec2Config: cfnLocationEFSEc2ConfigPropertyToCloudFormation(properties.ec2Config),
        AccessPointArn: cdk.stringToCloudFormation(properties.accessPointArn),
        EfsFilesystemArn: cdk.stringToCloudFormation(properties.efsFilesystemArn),
        FileSystemAccessRoleArn: cdk.stringToCloudFormation(properties.fileSystemAccessRoleArn),
        InTransitEncryption: cdk.stringToCloudFormation(properties.inTransitEncryption),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationEFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('ec2Config', 'Ec2Config', CfnLocationEFSEc2ConfigPropertyFromCloudFormation(properties.Ec2Config));
    ret.addPropertyResult('accessPointArn', 'AccessPointArn', properties.AccessPointArn != null ? cfn_parse.FromCloudFormation.getString(properties.AccessPointArn) : undefined);
    ret.addPropertyResult('efsFilesystemArn', 'EfsFilesystemArn', properties.EfsFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.EfsFilesystemArn) : undefined);
    ret.addPropertyResult('fileSystemAccessRoleArn', 'FileSystemAccessRoleArn', properties.FileSystemAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.FileSystemAccessRoleArn) : undefined);
    ret.addPropertyResult('inTransitEncryption', 'InTransitEncryption', properties.InTransitEncryption != null ? cfn_parse.FromCloudFormation.getString(properties.InTransitEncryption) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationEFS`
 *
 * The `AWS::DataSync::LocationEFS` resource creates an endpoint for an Amazon EFS file system. AWS DataSync can access this endpoint as a source or destination location.
 *
 * @cloudformationResource AWS::DataSync::LocationEFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html
 */
class CfnLocationEFS extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationEFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationEFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationEFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationEFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationEFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationEFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'ec2Config', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.ec2Config = props.ec2Config;
        this.accessPointArn = props.accessPointArn;
        this.efsFilesystemArn = props.efsFilesystemArn;
        this.fileSystemAccessRoleArn = props.fileSystemAccessRoleArn;
        this.inTransitEncryption = props.inTransitEncryption;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationEFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationEFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            ec2Config: this.ec2Config,
            accessPointArn: this.accessPointArn,
            efsFilesystemArn: this.efsFilesystemArn,
            fileSystemAccessRoleArn: this.fileSystemAccessRoleArn,
            inTransitEncryption: this.inTransitEncryption,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationEFSPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnLocationEFS[_b] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationEFS", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationEFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationEFS";
exports.CfnLocationEFS = CfnLocationEFS;
/**
 * Determine whether the given properties match those of a `Ec2ConfigProperty`
 *
 * @param properties - the TypeScript properties of a `Ec2ConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationEFS_Ec2ConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subnetArn', cdk.requiredValidator)(properties.subnetArn));
    errors.collect(cdk.propertyValidator('subnetArn', cdk.validateString)(properties.subnetArn));
    return errors.wrap('supplied properties not correct for "Ec2ConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS.Ec2Config` resource
 *
 * @param properties - the TypeScript properties of a `Ec2ConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS.Ec2Config` resource.
 */
// @ts-ignore TS6133
function cfnLocationEFSEc2ConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationEFS_Ec2ConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        SubnetArn: cdk.stringToCloudFormation(properties.subnetArn),
    };
}
// @ts-ignore TS6133
function CfnLocationEFSEc2ConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('subnetArn', 'SubnetArn', cfn_parse.FromCloudFormation.getString(properties.SubnetArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationFSxLustreProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxLustreProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxLustrePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fsxFilesystemArn', cdk.validateString)(properties.fsxFilesystemArn));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxLustreProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxLustre` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxLustreProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxLustre` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxLustrePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxLustrePropsValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        FsxFilesystemArn: cdk.stringToCloudFormation(properties.fsxFilesystemArn),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxLustrePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('fsxFilesystemArn', 'FsxFilesystemArn', properties.FsxFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.FsxFilesystemArn) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxLustre`
 *
 * The `AWS::DataSync::LocationFSxLustre` resource specifies an endpoint for an Amazon FSx for Lustre file system.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxLustre
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxlustre.html
 */
class CfnLocationFSxLustre extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxLustrePropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxLustre(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationFSxLustre`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxLustre.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationFSxLustreProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxLustre);
            }
            throw error;
        }
        cdk.requireProperty(props, 'securityGroupArns', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.securityGroupArns = props.securityGroupArns;
        this.fsxFilesystemArn = props.fsxFilesystemArn;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxLustre", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxLustre.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            securityGroupArns: this.securityGroupArns,
            fsxFilesystemArn: this.fsxFilesystemArn,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxLustrePropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnLocationFSxLustre[_c] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationFSxLustre", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxLustre.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxLustre";
exports.CfnLocationFSxLustre = CfnLocationFSxLustre;
/**
 * Determine whether the given properties match those of a `CfnLocationFSxONTAPProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxONTAPProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAPPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('protocol', CfnLocationFSxONTAP_ProtocolPropertyValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('storageVirtualMachineArn', cdk.requiredValidator)(properties.storageVirtualMachineArn));
    errors.collect(cdk.propertyValidator('storageVirtualMachineArn', cdk.validateString)(properties.storageVirtualMachineArn));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxONTAPProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxONTAPProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAPPropsValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        StorageVirtualMachineArn: cdk.stringToCloudFormation(properties.storageVirtualMachineArn),
        Protocol: cfnLocationFSxONTAPProtocolPropertyToCloudFormation(properties.protocol),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('storageVirtualMachineArn', 'StorageVirtualMachineArn', cfn_parse.FromCloudFormation.getString(properties.StorageVirtualMachineArn));
    ret.addPropertyResult('protocol', 'Protocol', properties.Protocol != null ? CfnLocationFSxONTAPProtocolPropertyFromCloudFormation(properties.Protocol) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxONTAP`
 *
 * The `AWS::DataSync::LocationFSxONTAP` resource creates an endpoint for an Amazon FSx for NetApp ONTAP file system. AWS DataSync can access this endpoint as a source or destination location.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxONTAP
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxontap.html
 */
class CfnLocationFSxONTAP extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxONTAPPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxONTAP(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationFSxONTAP`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxONTAP.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationFSxONTAPProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxONTAP);
            }
            throw error;
        }
        cdk.requireProperty(props, 'securityGroupArns', this);
        cdk.requireProperty(props, 'storageVirtualMachineArn', this);
        this.attrFsxFilesystemArn = cdk.Token.asString(this.getAtt('FsxFilesystemArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.securityGroupArns = props.securityGroupArns;
        this.storageVirtualMachineArn = props.storageVirtualMachineArn;
        this.protocol = props.protocol;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxONTAP", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxONTAP.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            securityGroupArns: this.securityGroupArns,
            storageVirtualMachineArn: this.storageVirtualMachineArn,
            protocol: this.protocol,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxONTAPPropsToCloudFormation(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
CfnLocationFSxONTAP[_d] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxONTAP.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxONTAP";
exports.CfnLocationFSxONTAP = CfnLocationFSxONTAP;
/**
 * Determine whether the given properties match those of a `NFSProperty`
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_NFSPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mountOptions', cdk.requiredValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationFSxONTAP_NfsMountOptionsPropertyValidator)(properties.mountOptions));
    return errors.wrap('supplied properties not correct for "NFSProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NFS` resource
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPNFSPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_NFSPropertyValidator(properties).assertSuccess();
    return {
        MountOptions: cfnLocationFSxONTAPNfsMountOptionsPropertyToCloudFormation(properties.mountOptions),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPNFSPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mountOptions', 'MountOptions', CfnLocationFSxONTAPNfsMountOptionsPropertyFromCloudFormation(properties.MountOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NfsMountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `NfsMountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_NfsMountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "NfsMountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NfsMountOptions` resource
 *
 * @param properties - the TypeScript properties of a `NfsMountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NfsMountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPNfsMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_NfsMountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPNfsMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProtocolProperty`
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_ProtocolPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('nfs', CfnLocationFSxONTAP_NFSPropertyValidator)(properties.nfs));
    errors.collect(cdk.propertyValidator('smb', CfnLocationFSxONTAP_SMBPropertyValidator)(properties.smb));
    return errors.wrap('supplied properties not correct for "ProtocolProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.Protocol` resource
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.Protocol` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPProtocolPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_ProtocolPropertyValidator(properties).assertSuccess();
    return {
        NFS: cfnLocationFSxONTAPNFSPropertyToCloudFormation(properties.nfs),
        SMB: cfnLocationFSxONTAPSMBPropertyToCloudFormation(properties.smb),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPProtocolPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('nfs', 'NFS', properties.NFS != null ? CfnLocationFSxONTAPNFSPropertyFromCloudFormation(properties.NFS) : undefined);
    ret.addPropertyResult('smb', 'SMB', properties.SMB != null ? CfnLocationFSxONTAPSMBPropertyFromCloudFormation(properties.SMB) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SMBProperty`
 *
 * @param properties - the TypeScript properties of a `SMBProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_SMBPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('mountOptions', cdk.requiredValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationFSxONTAP_SmbMountOptionsPropertyValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('password', cdk.requiredValidator)(properties.password));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('user', cdk.requiredValidator)(properties.user));
    errors.collect(cdk.propertyValidator('user', cdk.validateString)(properties.user));
    return errors.wrap('supplied properties not correct for "SMBProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SMB` resource
 *
 * @param properties - the TypeScript properties of a `SMBProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SMB` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPSMBPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_SMBPropertyValidator(properties).assertSuccess();
    return {
        Domain: cdk.stringToCloudFormation(properties.domain),
        MountOptions: cfnLocationFSxONTAPSmbMountOptionsPropertyToCloudFormation(properties.mountOptions),
        Password: cdk.stringToCloudFormation(properties.password),
        User: cdk.stringToCloudFormation(properties.user),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPSMBPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('mountOptions', 'MountOptions', CfnLocationFSxONTAPSmbMountOptionsPropertyFromCloudFormation(properties.MountOptions));
    ret.addPropertyResult('password', 'Password', cfn_parse.FromCloudFormation.getString(properties.Password));
    ret.addPropertyResult('user', 'User', cfn_parse.FromCloudFormation.getString(properties.User));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SmbMountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `SmbMountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_SmbMountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "SmbMountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SmbMountOptions` resource
 *
 * @param properties - the TypeScript properties of a `SmbMountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SmbMountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPSmbMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_SmbMountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPSmbMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationFSxOpenZFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxOpenZFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fsxFilesystemArn', cdk.validateString)(properties.fsxFilesystemArn));
    errors.collect(cdk.propertyValidator('protocol', cdk.requiredValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('protocol', CfnLocationFSxOpenZFS_ProtocolPropertyValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxOpenZFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxOpenZFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFSPropsValidator(properties).assertSuccess();
    return {
        Protocol: cfnLocationFSxOpenZFSProtocolPropertyToCloudFormation(properties.protocol),
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        FsxFilesystemArn: cdk.stringToCloudFormation(properties.fsxFilesystemArn),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('protocol', 'Protocol', CfnLocationFSxOpenZFSProtocolPropertyFromCloudFormation(properties.Protocol));
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('fsxFilesystemArn', 'FsxFilesystemArn', properties.FsxFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.FsxFilesystemArn) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxOpenZFS`
 *
 * The `AWS::DataSync::LocationFSxOpenZFS` resource specifies an endpoint for an Amazon FSx for OpenZFS file system.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxOpenZFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxopenzfs.html
 */
class CfnLocationFSxOpenZFS extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxOpenZFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxOpenZFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationFSxOpenZFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxOpenZFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationFSxOpenZFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxOpenZFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'protocol', this);
        cdk.requireProperty(props, 'securityGroupArns', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.protocol = props.protocol;
        this.securityGroupArns = props.securityGroupArns;
        this.fsxFilesystemArn = props.fsxFilesystemArn;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxOpenZFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxOpenZFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            protocol: this.protocol,
            securityGroupArns: this.securityGroupArns,
            fsxFilesystemArn: this.fsxFilesystemArn,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxOpenZFSPropsToCloudFormation(props);
    }
}
_e = JSII_RTTI_SYMBOL_1;
CfnLocationFSxOpenZFS[_e] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationFSxOpenZFS", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxOpenZFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxOpenZFS";
exports.CfnLocationFSxOpenZFS = CfnLocationFSxOpenZFS;
/**
 * Determine whether the given properties match those of a `MountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFS_MountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "MountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.MountOptions` resource
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.MountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFS_MountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NFSProperty`
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFS_NFSPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mountOptions', cdk.requiredValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationFSxOpenZFS_MountOptionsPropertyValidator)(properties.mountOptions));
    return errors.wrap('supplied properties not correct for "NFSProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.NFS` resource
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.NFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSNFSPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFS_NFSPropertyValidator(properties).assertSuccess();
    return {
        MountOptions: cfnLocationFSxOpenZFSMountOptionsPropertyToCloudFormation(properties.mountOptions),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSNFSPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mountOptions', 'MountOptions', CfnLocationFSxOpenZFSMountOptionsPropertyFromCloudFormation(properties.MountOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProtocolProperty`
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFS_ProtocolPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('nfs', CfnLocationFSxOpenZFS_NFSPropertyValidator)(properties.nfs));
    return errors.wrap('supplied properties not correct for "ProtocolProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.Protocol` resource
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.Protocol` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSProtocolPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFS_ProtocolPropertyValidator(properties).assertSuccess();
    return {
        NFS: cfnLocationFSxOpenZFSNFSPropertyToCloudFormation(properties.nfs),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSProtocolPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('nfs', 'NFS', properties.NFS != null ? CfnLocationFSxOpenZFSNFSPropertyFromCloudFormation(properties.NFS) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationFSxWindowsProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxWindowsProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxWindowsPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('fsxFilesystemArn', cdk.validateString)(properties.fsxFilesystemArn));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('user', cdk.requiredValidator)(properties.user));
    errors.collect(cdk.propertyValidator('user', cdk.validateString)(properties.user));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxWindowsProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxWindows` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxWindowsProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxWindows` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxWindowsPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxWindowsPropsValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        User: cdk.stringToCloudFormation(properties.user),
        Domain: cdk.stringToCloudFormation(properties.domain),
        FsxFilesystemArn: cdk.stringToCloudFormation(properties.fsxFilesystemArn),
        Password: cdk.stringToCloudFormation(properties.password),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxWindowsPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('user', 'User', cfn_parse.FromCloudFormation.getString(properties.User));
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('fsxFilesystemArn', 'FsxFilesystemArn', properties.FsxFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.FsxFilesystemArn) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxWindows`
 *
 * The `AWS::DataSync::LocationFSxWindows` resource specifies an endpoint for an Amazon FSx for Windows Server file system.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxWindows
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html
 */
class CfnLocationFSxWindows extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxWindowsPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxWindows(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationFSxWindows`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxWindows.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationFSxWindowsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxWindows);
            }
            throw error;
        }
        cdk.requireProperty(props, 'securityGroupArns', this);
        cdk.requireProperty(props, 'user', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.securityGroupArns = props.securityGroupArns;
        this.user = props.user;
        this.domain = props.domain;
        this.fsxFilesystemArn = props.fsxFilesystemArn;
        this.password = props.password;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxWindows", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxWindows.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            securityGroupArns: this.securityGroupArns,
            user: this.user,
            domain: this.domain,
            fsxFilesystemArn: this.fsxFilesystemArn,
            password: this.password,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxWindowsPropsToCloudFormation(props);
    }
}
_f = JSII_RTTI_SYMBOL_1;
CfnLocationFSxWindows[_f] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationFSxWindows", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxWindows.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxWindows";
exports.CfnLocationFSxWindows = CfnLocationFSxWindows;
/**
 * Determine whether the given properties match those of a `CfnLocationHDFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationHDFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationHDFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    errors.collect(cdk.propertyValidator('authenticationType', cdk.requiredValidator)(properties.authenticationType));
    errors.collect(cdk.propertyValidator('authenticationType', cdk.validateString)(properties.authenticationType));
    errors.collect(cdk.propertyValidator('blockSize', cdk.validateNumber)(properties.blockSize));
    errors.collect(cdk.propertyValidator('kerberosKeytab', cdk.validateString)(properties.kerberosKeytab));
    errors.collect(cdk.propertyValidator('kerberosKrb5Conf', cdk.validateString)(properties.kerberosKrb5Conf));
    errors.collect(cdk.propertyValidator('kerberosPrincipal', cdk.validateString)(properties.kerberosPrincipal));
    errors.collect(cdk.propertyValidator('kmsKeyProviderUri', cdk.validateString)(properties.kmsKeyProviderUri));
    errors.collect(cdk.propertyValidator('nameNodes', cdk.requiredValidator)(properties.nameNodes));
    errors.collect(cdk.propertyValidator('nameNodes', cdk.listValidator(CfnLocationHDFS_NameNodePropertyValidator))(properties.nameNodes));
    errors.collect(cdk.propertyValidator('qopConfiguration', CfnLocationHDFS_QopConfigurationPropertyValidator)(properties.qopConfiguration));
    errors.collect(cdk.propertyValidator('replicationFactor', cdk.validateNumber)(properties.replicationFactor));
    errors.collect(cdk.propertyValidator('simpleUser', cdk.validateString)(properties.simpleUser));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationHDFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationHDFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationHDFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationHDFSPropsValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
        AuthenticationType: cdk.stringToCloudFormation(properties.authenticationType),
        NameNodes: cdk.listMapper(cfnLocationHDFSNameNodePropertyToCloudFormation)(properties.nameNodes),
        BlockSize: cdk.numberToCloudFormation(properties.blockSize),
        KerberosKeytab: cdk.stringToCloudFormation(properties.kerberosKeytab),
        KerberosKrb5Conf: cdk.stringToCloudFormation(properties.kerberosKrb5Conf),
        KerberosPrincipal: cdk.stringToCloudFormation(properties.kerberosPrincipal),
        KmsKeyProviderUri: cdk.stringToCloudFormation(properties.kmsKeyProviderUri),
        QopConfiguration: cfnLocationHDFSQopConfigurationPropertyToCloudFormation(properties.qopConfiguration),
        ReplicationFactor: cdk.numberToCloudFormation(properties.replicationFactor),
        SimpleUser: cdk.stringToCloudFormation(properties.simpleUser),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationHDFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addPropertyResult('authenticationType', 'AuthenticationType', cfn_parse.FromCloudFormation.getString(properties.AuthenticationType));
    ret.addPropertyResult('nameNodes', 'NameNodes', cfn_parse.FromCloudFormation.getArray(CfnLocationHDFSNameNodePropertyFromCloudFormation)(properties.NameNodes));
    ret.addPropertyResult('blockSize', 'BlockSize', properties.BlockSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.BlockSize) : undefined);
    ret.addPropertyResult('kerberosKeytab', 'KerberosKeytab', properties.KerberosKeytab != null ? cfn_parse.FromCloudFormation.getString(properties.KerberosKeytab) : undefined);
    ret.addPropertyResult('kerberosKrb5Conf', 'KerberosKrb5Conf', properties.KerberosKrb5Conf != null ? cfn_parse.FromCloudFormation.getString(properties.KerberosKrb5Conf) : undefined);
    ret.addPropertyResult('kerberosPrincipal', 'KerberosPrincipal', properties.KerberosPrincipal != null ? cfn_parse.FromCloudFormation.getString(properties.KerberosPrincipal) : undefined);
    ret.addPropertyResult('kmsKeyProviderUri', 'KmsKeyProviderUri', properties.KmsKeyProviderUri != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyProviderUri) : undefined);
    ret.addPropertyResult('qopConfiguration', 'QopConfiguration', properties.QopConfiguration != null ? CfnLocationHDFSQopConfigurationPropertyFromCloudFormation(properties.QopConfiguration) : undefined);
    ret.addPropertyResult('replicationFactor', 'ReplicationFactor', properties.ReplicationFactor != null ? cfn_parse.FromCloudFormation.getNumber(properties.ReplicationFactor) : undefined);
    ret.addPropertyResult('simpleUser', 'SimpleUser', properties.SimpleUser != null ? cfn_parse.FromCloudFormation.getString(properties.SimpleUser) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationHDFS`
 *
 * The `AWS::DataSync::LocationHDFS` resource specifies an endpoint for a Hadoop Distributed File System (HDFS).
 *
 * @cloudformationResource AWS::DataSync::LocationHDFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationhdfs.html
 */
class CfnLocationHDFS extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationHDFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationHDFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationHDFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationHDFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationHDFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationHDFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'agentArns', this);
        cdk.requireProperty(props, 'authenticationType', this);
        cdk.requireProperty(props, 'nameNodes', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.agentArns = props.agentArns;
        this.authenticationType = props.authenticationType;
        this.nameNodes = props.nameNodes;
        this.blockSize = props.blockSize;
        this.kerberosKeytab = props.kerberosKeytab;
        this.kerberosKrb5Conf = props.kerberosKrb5Conf;
        this.kerberosPrincipal = props.kerberosPrincipal;
        this.kmsKeyProviderUri = props.kmsKeyProviderUri;
        this.qopConfiguration = props.qopConfiguration;
        this.replicationFactor = props.replicationFactor;
        this.simpleUser = props.simpleUser;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationHDFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationHDFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            agentArns: this.agentArns,
            authenticationType: this.authenticationType,
            nameNodes: this.nameNodes,
            blockSize: this.blockSize,
            kerberosKeytab: this.kerberosKeytab,
            kerberosKrb5Conf: this.kerberosKrb5Conf,
            kerberosPrincipal: this.kerberosPrincipal,
            kmsKeyProviderUri: this.kmsKeyProviderUri,
            qopConfiguration: this.qopConfiguration,
            replicationFactor: this.replicationFactor,
            simpleUser: this.simpleUser,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationHDFSPropsToCloudFormation(props);
    }
}
_g = JSII_RTTI_SYMBOL_1;
CfnLocationHDFS[_g] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationHDFS", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationHDFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationHDFS";
exports.CfnLocationHDFS = CfnLocationHDFS;
/**
 * Determine whether the given properties match those of a `NameNodeProperty`
 *
 * @param properties - the TypeScript properties of a `NameNodeProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationHDFS_NameNodePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostname', cdk.requiredValidator)(properties.hostname));
    errors.collect(cdk.propertyValidator('hostname', cdk.validateString)(properties.hostname));
    errors.collect(cdk.propertyValidator('port', cdk.requiredValidator)(properties.port));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    return errors.wrap('supplied properties not correct for "NameNodeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.NameNode` resource
 *
 * @param properties - the TypeScript properties of a `NameNodeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.NameNode` resource.
 */
// @ts-ignore TS6133
function cfnLocationHDFSNameNodePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationHDFS_NameNodePropertyValidator(properties).assertSuccess();
    return {
        Hostname: cdk.stringToCloudFormation(properties.hostname),
        Port: cdk.numberToCloudFormation(properties.port),
    };
}
// @ts-ignore TS6133
function CfnLocationHDFSNameNodePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostname', 'Hostname', cfn_parse.FromCloudFormation.getString(properties.Hostname));
    ret.addPropertyResult('port', 'Port', cfn_parse.FromCloudFormation.getNumber(properties.Port));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `QopConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `QopConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationHDFS_QopConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataTransferProtection', cdk.validateString)(properties.dataTransferProtection));
    errors.collect(cdk.propertyValidator('rpcProtection', cdk.validateString)(properties.rpcProtection));
    return errors.wrap('supplied properties not correct for "QopConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.QopConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `QopConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.QopConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnLocationHDFSQopConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationHDFS_QopConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DataTransferProtection: cdk.stringToCloudFormation(properties.dataTransferProtection),
        RpcProtection: cdk.stringToCloudFormation(properties.rpcProtection),
    };
}
// @ts-ignore TS6133
function CfnLocationHDFSQopConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataTransferProtection', 'DataTransferProtection', properties.DataTransferProtection != null ? cfn_parse.FromCloudFormation.getString(properties.DataTransferProtection) : undefined);
    ret.addPropertyResult('rpcProtection', 'RpcProtection', properties.RpcProtection != null ? cfn_parse.FromCloudFormation.getString(properties.RpcProtection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationNFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationNFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationNFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationNFS_MountOptionsPropertyValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('onPremConfig', cdk.requiredValidator)(properties.onPremConfig));
    errors.collect(cdk.propertyValidator('onPremConfig', CfnLocationNFS_OnPremConfigPropertyValidator)(properties.onPremConfig));
    errors.collect(cdk.propertyValidator('serverHostname', cdk.validateString)(properties.serverHostname));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationNFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationNFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationNFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationNFSPropsValidator(properties).assertSuccess();
    return {
        OnPremConfig: cfnLocationNFSOnPremConfigPropertyToCloudFormation(properties.onPremConfig),
        MountOptions: cfnLocationNFSMountOptionsPropertyToCloudFormation(properties.mountOptions),
        ServerHostname: cdk.stringToCloudFormation(properties.serverHostname),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationNFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('onPremConfig', 'OnPremConfig', CfnLocationNFSOnPremConfigPropertyFromCloudFormation(properties.OnPremConfig));
    ret.addPropertyResult('mountOptions', 'MountOptions', properties.MountOptions != null ? CfnLocationNFSMountOptionsPropertyFromCloudFormation(properties.MountOptions) : undefined);
    ret.addPropertyResult('serverHostname', 'ServerHostname', properties.ServerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ServerHostname) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationNFS`
 *
 * The `AWS::DataSync::LocationNFS` resource specifies a file system on a Network File System (NFS) server that can be read from or written to.
 *
 * @cloudformationResource AWS::DataSync::LocationNFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html
 */
class CfnLocationNFS extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationNFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationNFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationNFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationNFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationNFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationNFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'onPremConfig', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.onPremConfig = props.onPremConfig;
        this.mountOptions = props.mountOptions;
        this.serverHostname = props.serverHostname;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationNFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationNFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            onPremConfig: this.onPremConfig,
            mountOptions: this.mountOptions,
            serverHostname: this.serverHostname,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationNFSPropsToCloudFormation(props);
    }
}
_h = JSII_RTTI_SYMBOL_1;
CfnLocationNFS[_h] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationNFS", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationNFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationNFS";
exports.CfnLocationNFS = CfnLocationNFS;
/**
 * Determine whether the given properties match those of a `MountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationNFS_MountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "MountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.MountOptions` resource
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.MountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationNFSMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationNFS_MountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationNFSMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OnPremConfigProperty`
 *
 * @param properties - the TypeScript properties of a `OnPremConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationNFS_OnPremConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    return errors.wrap('supplied properties not correct for "OnPremConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.OnPremConfig` resource
 *
 * @param properties - the TypeScript properties of a `OnPremConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.OnPremConfig` resource.
 */
// @ts-ignore TS6133
function cfnLocationNFSOnPremConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationNFS_OnPremConfigPropertyValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
    };
}
// @ts-ignore TS6133
function CfnLocationNFSOnPremConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationObjectStorageProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationObjectStorageProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationObjectStoragePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessKey', cdk.validateString)(properties.accessKey));
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('secretKey', cdk.validateString)(properties.secretKey));
    errors.collect(cdk.propertyValidator('serverCertificate', cdk.validateString)(properties.serverCertificate));
    errors.collect(cdk.propertyValidator('serverHostname', cdk.validateString)(properties.serverHostname));
    errors.collect(cdk.propertyValidator('serverPort', cdk.validateNumber)(properties.serverPort));
    errors.collect(cdk.propertyValidator('serverProtocol', cdk.validateString)(properties.serverProtocol));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationObjectStorageProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationObjectStorage` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationObjectStorageProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationObjectStorage` resource.
 */
// @ts-ignore TS6133
function cfnLocationObjectStoragePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationObjectStoragePropsValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
        AccessKey: cdk.stringToCloudFormation(properties.accessKey),
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        SecretKey: cdk.stringToCloudFormation(properties.secretKey),
        ServerCertificate: cdk.stringToCloudFormation(properties.serverCertificate),
        ServerHostname: cdk.stringToCloudFormation(properties.serverHostname),
        ServerPort: cdk.numberToCloudFormation(properties.serverPort),
        ServerProtocol: cdk.stringToCloudFormation(properties.serverProtocol),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationObjectStoragePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addPropertyResult('accessKey', 'AccessKey', properties.AccessKey != null ? cfn_parse.FromCloudFormation.getString(properties.AccessKey) : undefined);
    ret.addPropertyResult('bucketName', 'BucketName', properties.BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.BucketName) : undefined);
    ret.addPropertyResult('secretKey', 'SecretKey', properties.SecretKey != null ? cfn_parse.FromCloudFormation.getString(properties.SecretKey) : undefined);
    ret.addPropertyResult('serverCertificate', 'ServerCertificate', properties.ServerCertificate != null ? cfn_parse.FromCloudFormation.getString(properties.ServerCertificate) : undefined);
    ret.addPropertyResult('serverHostname', 'ServerHostname', properties.ServerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ServerHostname) : undefined);
    ret.addPropertyResult('serverPort', 'ServerPort', properties.ServerPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ServerPort) : undefined);
    ret.addPropertyResult('serverProtocol', 'ServerProtocol', properties.ServerProtocol != null ? cfn_parse.FromCloudFormation.getString(properties.ServerProtocol) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationObjectStorage`
 *
 * The `AWS::DataSync::LocationObjectStorage` resource specifies an endpoint for a self-managed object storage bucket. For more information about self-managed object storage locations, see [Creating a Location for Object Storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html) .
 *
 * @cloudformationResource AWS::DataSync::LocationObjectStorage
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html
 */
class CfnLocationObjectStorage extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationObjectStoragePropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationObjectStorage(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationObjectStorage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationObjectStorage.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationObjectStorageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationObjectStorage);
            }
            throw error;
        }
        cdk.requireProperty(props, 'agentArns', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.agentArns = props.agentArns;
        this.accessKey = props.accessKey;
        this.bucketName = props.bucketName;
        this.secretKey = props.secretKey;
        this.serverCertificate = props.serverCertificate;
        this.serverHostname = props.serverHostname;
        this.serverPort = props.serverPort;
        this.serverProtocol = props.serverProtocol;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationObjectStorage", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationObjectStorage.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            agentArns: this.agentArns,
            accessKey: this.accessKey,
            bucketName: this.bucketName,
            secretKey: this.secretKey,
            serverCertificate: this.serverCertificate,
            serverHostname: this.serverHostname,
            serverPort: this.serverPort,
            serverProtocol: this.serverProtocol,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationObjectStoragePropsToCloudFormation(props);
    }
}
_j = JSII_RTTI_SYMBOL_1;
CfnLocationObjectStorage[_j] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationObjectStorage", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationObjectStorage.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationObjectStorage";
exports.CfnLocationObjectStorage = CfnLocationObjectStorage;
/**
 * Determine whether the given properties match those of a `CfnLocationS3Props`
 *
 * @param properties - the TypeScript properties of a `CfnLocationS3Props`
 *
 * @returns the result of the validation.
 */
function CfnLocationS3PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3BucketArn', cdk.validateString)(properties.s3BucketArn));
    errors.collect(cdk.propertyValidator('s3Config', cdk.requiredValidator)(properties.s3Config));
    errors.collect(cdk.propertyValidator('s3Config', CfnLocationS3_S3ConfigPropertyValidator)(properties.s3Config));
    errors.collect(cdk.propertyValidator('s3StorageClass', cdk.validateString)(properties.s3StorageClass));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationS3Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationS3` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationS3Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationS3` resource.
 */
// @ts-ignore TS6133
function cfnLocationS3PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationS3PropsValidator(properties).assertSuccess();
    return {
        S3Config: cfnLocationS3S3ConfigPropertyToCloudFormation(properties.s3Config),
        S3BucketArn: cdk.stringToCloudFormation(properties.s3BucketArn),
        S3StorageClass: cdk.stringToCloudFormation(properties.s3StorageClass),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationS3PropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Config', 'S3Config', CfnLocationS3S3ConfigPropertyFromCloudFormation(properties.S3Config));
    ret.addPropertyResult('s3BucketArn', 'S3BucketArn', properties.S3BucketArn != null ? cfn_parse.FromCloudFormation.getString(properties.S3BucketArn) : undefined);
    ret.addPropertyResult('s3StorageClass', 'S3StorageClass', properties.S3StorageClass != null ? cfn_parse.FromCloudFormation.getString(properties.S3StorageClass) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationS3`
 *
 * The `AWS::DataSync::LocationS3` resource specifies an endpoint for an Amazon S3 bucket.
 *
 * For more information, see [Create an Amazon S3 location](https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli) in the *AWS DataSync User Guide* .
 *
 * @cloudformationResource AWS::DataSync::LocationS3
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html
 */
class CfnLocationS3 extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationS3PropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationS3(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationS3`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationS3.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationS3Props(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationS3);
            }
            throw error;
        }
        cdk.requireProperty(props, 's3Config', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.s3Config = props.s3Config;
        this.s3BucketArn = props.s3BucketArn;
        this.s3StorageClass = props.s3StorageClass;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationS3", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationS3.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            s3Config: this.s3Config,
            s3BucketArn: this.s3BucketArn,
            s3StorageClass: this.s3StorageClass,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationS3PropsToCloudFormation(props);
    }
}
_k = JSII_RTTI_SYMBOL_1;
CfnLocationS3[_k] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationS3", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationS3.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationS3";
exports.CfnLocationS3 = CfnLocationS3;
/**
 * Determine whether the given properties match those of a `S3ConfigProperty`
 *
 * @param properties - the TypeScript properties of a `S3ConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationS3_S3ConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucketAccessRoleArn', cdk.requiredValidator)(properties.bucketAccessRoleArn));
    errors.collect(cdk.propertyValidator('bucketAccessRoleArn', cdk.validateString)(properties.bucketAccessRoleArn));
    return errors.wrap('supplied properties not correct for "S3ConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationS3.S3Config` resource
 *
 * @param properties - the TypeScript properties of a `S3ConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationS3.S3Config` resource.
 */
// @ts-ignore TS6133
function cfnLocationS3S3ConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationS3_S3ConfigPropertyValidator(properties).assertSuccess();
    return {
        BucketAccessRoleArn: cdk.stringToCloudFormation(properties.bucketAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnLocationS3S3ConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucketAccessRoleArn', 'BucketAccessRoleArn', cfn_parse.FromCloudFormation.getString(properties.BucketAccessRoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationSMBProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationSMBProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationSMBPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationSMB_MountOptionsPropertyValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('serverHostname', cdk.validateString)(properties.serverHostname));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('user', cdk.requiredValidator)(properties.user));
    errors.collect(cdk.propertyValidator('user', cdk.validateString)(properties.user));
    return errors.wrap('supplied properties not correct for "CfnLocationSMBProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationSMBProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB` resource.
 */
// @ts-ignore TS6133
function cfnLocationSMBPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationSMBPropsValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
        User: cdk.stringToCloudFormation(properties.user),
        Domain: cdk.stringToCloudFormation(properties.domain),
        MountOptions: cfnLocationSMBMountOptionsPropertyToCloudFormation(properties.mountOptions),
        Password: cdk.stringToCloudFormation(properties.password),
        ServerHostname: cdk.stringToCloudFormation(properties.serverHostname),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationSMBPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addPropertyResult('user', 'User', cfn_parse.FromCloudFormation.getString(properties.User));
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('mountOptions', 'MountOptions', properties.MountOptions != null ? CfnLocationSMBMountOptionsPropertyFromCloudFormation(properties.MountOptions) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('serverHostname', 'ServerHostname', properties.ServerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ServerHostname) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationSMB`
 *
 * The `AWS::DataSync::LocationSMB` resource specifies a Server Message Block (SMB) location.
 *
 * @cloudformationResource AWS::DataSync::LocationSMB
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html
 */
class CfnLocationSMB extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationSMBPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationSMB(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::LocationSMB`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationSMB.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnLocationSMBProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationSMB);
            }
            throw error;
        }
        cdk.requireProperty(props, 'agentArns', this);
        cdk.requireProperty(props, 'user', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn', cdk.ResolutionTypeHint.STRING));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri', cdk.ResolutionTypeHint.STRING));
        this.agentArns = props.agentArns;
        this.user = props.user;
        this.domain = props.domain;
        this.mountOptions = props.mountOptions;
        this.password = props.password;
        this.serverHostname = props.serverHostname;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationSMB", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationSMB.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            agentArns: this.agentArns,
            user: this.user,
            domain: this.domain,
            mountOptions: this.mountOptions,
            password: this.password,
            serverHostname: this.serverHostname,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationSMBPropsToCloudFormation(props);
    }
}
_l = JSII_RTTI_SYMBOL_1;
CfnLocationSMB[_l] = { fqn: "aws-cdk-lib.aws_datasync.CfnLocationSMB", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationSMB.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationSMB";
exports.CfnLocationSMB = CfnLocationSMB;
/**
 * Determine whether the given properties match those of a `MountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationSMB_MountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "MountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB.MountOptions` resource
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB.MountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationSMBMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationSMB_MountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationSMBMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnTaskProps`
 *
 * @param properties - the TypeScript properties of a `CfnTaskProps`
 *
 * @returns the result of the validation.
 */
function CfnTaskPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogGroupArn', cdk.validateString)(properties.cloudWatchLogGroupArn));
    errors.collect(cdk.propertyValidator('destinationLocationArn', cdk.requiredValidator)(properties.destinationLocationArn));
    errors.collect(cdk.propertyValidator('destinationLocationArn', cdk.validateString)(properties.destinationLocationArn));
    errors.collect(cdk.propertyValidator('excludes', cdk.listValidator(CfnTask_FilterRulePropertyValidator))(properties.excludes));
    errors.collect(cdk.propertyValidator('includes', cdk.listValidator(CfnTask_FilterRulePropertyValidator))(properties.includes));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('options', CfnTask_OptionsPropertyValidator)(properties.options));
    errors.collect(cdk.propertyValidator('schedule', CfnTask_TaskSchedulePropertyValidator)(properties.schedule));
    errors.collect(cdk.propertyValidator('sourceLocationArn', cdk.requiredValidator)(properties.sourceLocationArn));
    errors.collect(cdk.propertyValidator('sourceLocationArn', cdk.validateString)(properties.sourceLocationArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnTaskProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task` resource
 *
 * @param properties - the TypeScript properties of a `CfnTaskProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task` resource.
 */
// @ts-ignore TS6133
function cfnTaskPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskPropsValidator(properties).assertSuccess();
    return {
        DestinationLocationArn: cdk.stringToCloudFormation(properties.destinationLocationArn),
        SourceLocationArn: cdk.stringToCloudFormation(properties.sourceLocationArn),
        CloudWatchLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogGroupArn),
        Excludes: cdk.listMapper(cfnTaskFilterRulePropertyToCloudFormation)(properties.excludes),
        Includes: cdk.listMapper(cfnTaskFilterRulePropertyToCloudFormation)(properties.includes),
        Name: cdk.stringToCloudFormation(properties.name),
        Options: cfnTaskOptionsPropertyToCloudFormation(properties.options),
        Schedule: cfnTaskTaskSchedulePropertyToCloudFormation(properties.schedule),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnTaskPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('destinationLocationArn', 'DestinationLocationArn', cfn_parse.FromCloudFormation.getString(properties.DestinationLocationArn));
    ret.addPropertyResult('sourceLocationArn', 'SourceLocationArn', cfn_parse.FromCloudFormation.getString(properties.SourceLocationArn));
    ret.addPropertyResult('cloudWatchLogGroupArn', 'CloudWatchLogGroupArn', properties.CloudWatchLogGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogGroupArn) : undefined);
    ret.addPropertyResult('excludes', 'Excludes', properties.Excludes != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskFilterRulePropertyFromCloudFormation)(properties.Excludes) : undefined);
    ret.addPropertyResult('includes', 'Includes', properties.Includes != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskFilterRulePropertyFromCloudFormation)(properties.Includes) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('options', 'Options', properties.Options != null ? CfnTaskOptionsPropertyFromCloudFormation(properties.Options) : undefined);
    ret.addPropertyResult('schedule', 'Schedule', properties.Schedule != null ? CfnTaskTaskSchedulePropertyFromCloudFormation(properties.Schedule) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::Task`
 *
 * The `AWS::DataSync::Task` resource specifies a task. A task is a set of two locations (source and destination) and a set of `Options` that you use to control the behavior of a task. If you don't specify `Options` when you create a task, AWS DataSync populates them with service defaults.
 *
 * @cloudformationResource AWS::DataSync::Task
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html
 */
class CfnTask extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTaskPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTask(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::DataSync::Task`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTask.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_datasync_CfnTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnTask);
            }
            throw error;
        }
        cdk.requireProperty(props, 'destinationLocationArn', this);
        cdk.requireProperty(props, 'sourceLocationArn', this);
        this.attrDestinationNetworkInterfaceArns = cdk.Token.asList(this.getAtt('DestinationNetworkInterfaceArns', cdk.ResolutionTypeHint.STRING_LIST));
        this.attrSourceNetworkInterfaceArns = cdk.Token.asList(this.getAtt('SourceNetworkInterfaceArns', cdk.ResolutionTypeHint.STRING_LIST));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status', cdk.ResolutionTypeHint.STRING));
        this.attrTaskArn = cdk.Token.asString(this.getAtt('TaskArn', cdk.ResolutionTypeHint.STRING));
        this.destinationLocationArn = props.destinationLocationArn;
        this.sourceLocationArn = props.sourceLocationArn;
        this.cloudWatchLogGroupArn = props.cloudWatchLogGroupArn;
        this.excludes = props.excludes;
        this.includes = props.includes;
        this.name = props.name;
        this.options = props.options;
        this.schedule = props.schedule;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::Task", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTask.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            destinationLocationArn: this.destinationLocationArn,
            sourceLocationArn: this.sourceLocationArn,
            cloudWatchLogGroupArn: this.cloudWatchLogGroupArn,
            excludes: this.excludes,
            includes: this.includes,
            name: this.name,
            options: this.options,
            schedule: this.schedule,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnTaskPropsToCloudFormation(props);
    }
}
_m = JSII_RTTI_SYMBOL_1;
CfnTask[_m] = { fqn: "aws-cdk-lib.aws_datasync.CfnTask", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTask.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::Task";
exports.CfnTask = CfnTask;
/**
 * Determine whether the given properties match those of a `FilterRuleProperty`
 *
 * @param properties - the TypeScript properties of a `FilterRuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnTask_FilterRulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('filterType', cdk.validateString)(properties.filterType));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "FilterRuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task.FilterRule` resource
 *
 * @param properties - the TypeScript properties of a `FilterRuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task.FilterRule` resource.
 */
// @ts-ignore TS6133
function cfnTaskFilterRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTask_FilterRulePropertyValidator(properties).assertSuccess();
    return {
        FilterType: cdk.stringToCloudFormation(properties.filterType),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnTaskFilterRulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('filterType', 'FilterType', properties.FilterType != null ? cfn_parse.FromCloudFormation.getString(properties.FilterType) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OptionsProperty`
 *
 * @param properties - the TypeScript properties of a `OptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnTask_OptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('atime', cdk.validateString)(properties.atime));
    errors.collect(cdk.propertyValidator('bytesPerSecond', cdk.validateNumber)(properties.bytesPerSecond));
    errors.collect(cdk.propertyValidator('gid', cdk.validateString)(properties.gid));
    errors.collect(cdk.propertyValidator('logLevel', cdk.validateString)(properties.logLevel));
    errors.collect(cdk.propertyValidator('mtime', cdk.validateString)(properties.mtime));
    errors.collect(cdk.propertyValidator('objectTags', cdk.validateString)(properties.objectTags));
    errors.collect(cdk.propertyValidator('overwriteMode', cdk.validateString)(properties.overwriteMode));
    errors.collect(cdk.propertyValidator('posixPermissions', cdk.validateString)(properties.posixPermissions));
    errors.collect(cdk.propertyValidator('preserveDeletedFiles', cdk.validateString)(properties.preserveDeletedFiles));
    errors.collect(cdk.propertyValidator('preserveDevices', cdk.validateString)(properties.preserveDevices));
    errors.collect(cdk.propertyValidator('securityDescriptorCopyFlags', cdk.validateString)(properties.securityDescriptorCopyFlags));
    errors.collect(cdk.propertyValidator('taskQueueing', cdk.validateString)(properties.taskQueueing));
    errors.collect(cdk.propertyValidator('transferMode', cdk.validateString)(properties.transferMode));
    errors.collect(cdk.propertyValidator('uid', cdk.validateString)(properties.uid));
    errors.collect(cdk.propertyValidator('verifyMode', cdk.validateString)(properties.verifyMode));
    return errors.wrap('supplied properties not correct for "OptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task.Options` resource
 *
 * @param properties - the TypeScript properties of a `OptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task.Options` resource.
 */
// @ts-ignore TS6133
function cfnTaskOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTask_OptionsPropertyValidator(properties).assertSuccess();
    return {
        Atime: cdk.stringToCloudFormation(properties.atime),
        BytesPerSecond: cdk.numberToCloudFormation(properties.bytesPerSecond),
        Gid: cdk.stringToCloudFormation(properties.gid),
        LogLevel: cdk.stringToCloudFormation(properties.logLevel),
        Mtime: cdk.stringToCloudFormation(properties.mtime),
        ObjectTags: cdk.stringToCloudFormation(properties.objectTags),
        OverwriteMode: cdk.stringToCloudFormation(properties.overwriteMode),
        PosixPermissions: cdk.stringToCloudFormation(properties.posixPermissions),
        PreserveDeletedFiles: cdk.stringToCloudFormation(properties.preserveDeletedFiles),
        PreserveDevices: cdk.stringToCloudFormation(properties.preserveDevices),
        SecurityDescriptorCopyFlags: cdk.stringToCloudFormation(properties.securityDescriptorCopyFlags),
        TaskQueueing: cdk.stringToCloudFormation(properties.taskQueueing),
        TransferMode: cdk.stringToCloudFormation(properties.transferMode),
        Uid: cdk.stringToCloudFormation(properties.uid),
        VerifyMode: cdk.stringToCloudFormation(properties.verifyMode),
    };
}
// @ts-ignore TS6133
function CfnTaskOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('atime', 'Atime', properties.Atime != null ? cfn_parse.FromCloudFormation.getString(properties.Atime) : undefined);
    ret.addPropertyResult('bytesPerSecond', 'BytesPerSecond', properties.BytesPerSecond != null ? cfn_parse.FromCloudFormation.getNumber(properties.BytesPerSecond) : undefined);
    ret.addPropertyResult('gid', 'Gid', properties.Gid != null ? cfn_parse.FromCloudFormation.getString(properties.Gid) : undefined);
    ret.addPropertyResult('logLevel', 'LogLevel', properties.LogLevel != null ? cfn_parse.FromCloudFormation.getString(properties.LogLevel) : undefined);
    ret.addPropertyResult('mtime', 'Mtime', properties.Mtime != null ? cfn_parse.FromCloudFormation.getString(properties.Mtime) : undefined);
    ret.addPropertyResult('objectTags', 'ObjectTags', properties.ObjectTags != null ? cfn_parse.FromCloudFormation.getString(properties.ObjectTags) : undefined);
    ret.addPropertyResult('overwriteMode', 'OverwriteMode', properties.OverwriteMode != null ? cfn_parse.FromCloudFormation.getString(properties.OverwriteMode) : undefined);
    ret.addPropertyResult('posixPermissions', 'PosixPermissions', properties.PosixPermissions != null ? cfn_parse.FromCloudFormation.getString(properties.PosixPermissions) : undefined);
    ret.addPropertyResult('preserveDeletedFiles', 'PreserveDeletedFiles', properties.PreserveDeletedFiles != null ? cfn_parse.FromCloudFormation.getString(properties.PreserveDeletedFiles) : undefined);
    ret.addPropertyResult('preserveDevices', 'PreserveDevices', properties.PreserveDevices != null ? cfn_parse.FromCloudFormation.getString(properties.PreserveDevices) : undefined);
    ret.addPropertyResult('securityDescriptorCopyFlags', 'SecurityDescriptorCopyFlags', properties.SecurityDescriptorCopyFlags != null ? cfn_parse.FromCloudFormation.getString(properties.SecurityDescriptorCopyFlags) : undefined);
    ret.addPropertyResult('taskQueueing', 'TaskQueueing', properties.TaskQueueing != null ? cfn_parse.FromCloudFormation.getString(properties.TaskQueueing) : undefined);
    ret.addPropertyResult('transferMode', 'TransferMode', properties.TransferMode != null ? cfn_parse.FromCloudFormation.getString(properties.TransferMode) : undefined);
    ret.addPropertyResult('uid', 'Uid', properties.Uid != null ? cfn_parse.FromCloudFormation.getString(properties.Uid) : undefined);
    ret.addPropertyResult('verifyMode', 'VerifyMode', properties.VerifyMode != null ? cfn_parse.FromCloudFormation.getString(properties.VerifyMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TaskScheduleProperty`
 *
 * @param properties - the TypeScript properties of a `TaskScheduleProperty`
 *
 * @returns the result of the validation.
 */
function CfnTask_TaskSchedulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.requiredValidator)(properties.scheduleExpression));
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.validateString)(properties.scheduleExpression));
    return errors.wrap('supplied properties not correct for "TaskScheduleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task.TaskSchedule` resource
 *
 * @param properties - the TypeScript properties of a `TaskScheduleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task.TaskSchedule` resource.
 */
// @ts-ignore TS6133
function cfnTaskTaskSchedulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTask_TaskSchedulePropertyValidator(properties).assertSuccess();
    return {
        ScheduleExpression: cdk.stringToCloudFormation(properties.scheduleExpression),
    };
}
// @ts-ignore TS6133
function CfnTaskTaskSchedulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('scheduleExpression', 'ScheduleExpression', cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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