"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secretsmanager_1 = require("../../aws-secretsmanager");
const core_1 = require("../../core");
/**
 *
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends aws_secretsmanager_1.Secret {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_docdb_DatabaseSecretProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DatabaseSecret);
            }
            throw error;
        }
        const excludedCharacters = props.excludeCharacters ?? '"@/';
        super(scope, id, {
            secretName: props.secretName,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            encryptionKey: props.encryptionKey,
            // The CloudFormation resource provider for AWS::DocDB::DBCluster currently limits the DocDB master password to
            // 41 characters when pulling the password from secrets manager using a CloudFormation reference. This does not
            // line up with the CloudFormation resource specification which states a maximum of 100 characters:
            //
            // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masteruserpassword
            //
            // When attempting to exceed 41 characters, a deployment fails with the message:
            // Length of value for property {/MasterUserPassword} is greater than maximum allowed length {41}
            generateSecretString: {
                passwordLength: 41,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: props.masterSecret?.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters: excludedCharacters,
            },
        });
        this._excludedCharacters = excludedCharacters;
    }
}
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "aws-cdk-lib.aws_docdb.DatabaseSecret", version: "2.74.0" };
exports.DatabaseSecret = DatabaseSecret;
//# sourceMappingURL=data:application/json;base64,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