export declare class DynamoDBMetrics {
    static conditionalCheckFailedRequestsSum(dimensions: {
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            TableName: string;
        };
        statistic: string;
    };
    static consumedReadCapacityUnitsSum(dimensions: {
        TableName: string;
    }): MetricWithDims<{
        TableName: string;
    }>;
    static consumedReadCapacityUnitsSum(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): MetricWithDims<{
        GlobalSecondaryIndexName: string;
        TableName: string;
    }>;
    static consumedWriteCapacityUnitsSum(dimensions: {
        TableName: string;
    }): MetricWithDims<{
        TableName: string;
    }>;
    static consumedWriteCapacityUnitsSum(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): MetricWithDims<{
        GlobalSecondaryIndexName: string;
        TableName: string;
    }>;
    static provisionedReadCapacityUnitsAverage(dimensions: {
        TableName: string;
    }): MetricWithDims<{
        TableName: string;
    }>;
    static provisionedReadCapacityUnitsAverage(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): MetricWithDims<{
        GlobalSecondaryIndexName: string;
        TableName: string;
    }>;
    static provisionedWriteCapacityUnitsAverage(dimensions: {
        TableName: string;
    }): MetricWithDims<{
        TableName: string;
    }>;
    static provisionedWriteCapacityUnitsAverage(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): MetricWithDims<{
        GlobalSecondaryIndexName: string;
        TableName: string;
    }>;
    static readThrottleEventsSum(dimensions: {
        TableName: string;
    }): MetricWithDims<{
        TableName: string;
    }>;
    static readThrottleEventsSum(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): MetricWithDims<{
        GlobalSecondaryIndexName: string;
        TableName: string;
    }>;
    static timeToLiveDeletedItemCountSum(dimensions: {
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            TableName: string;
        };
        statistic: string;
    };
    static transactionConflictAverage(dimensions: {
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            TableName: string;
        };
        statistic: string;
    };
    static writeThrottleEventsSum(dimensions: {
        TableName: string;
    }): MetricWithDims<{
        TableName: string;
    }>;
    static writeThrottleEventsSum(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): MetricWithDims<{
        GlobalSecondaryIndexName: string;
        TableName: string;
    }>;
    static successfulRequestLatencyAverage(dimensions: {
        Operation: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            Operation: string;
            TableName: string;
        };
        statistic: string;
    };
    static systemErrorsSum(dimensions: {
        Operation: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            Operation: string;
            TableName: string;
        };
        statistic: string;
    };
    static throttledRequestsSum(dimensions: {
        Operation: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            Operation: string;
            TableName: string;
        };
        statistic: string;
    };
    static returnedItemCountSum(dimensions: {
        Operation: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            Operation: string;
            TableName: string;
        };
        statistic: string;
    };
    static onlineIndexConsumedWriteCapacitySum(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            GlobalSecondaryIndexName: string;
            TableName: string;
        };
        statistic: string;
    };
    static onlineIndexPercentageProgressAverage(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            GlobalSecondaryIndexName: string;
            TableName: string;
        };
        statistic: string;
    };
    static onlineIndexThrottleEventsSum(dimensions: {
        GlobalSecondaryIndexName: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            GlobalSecondaryIndexName: string;
            TableName: string;
        };
        statistic: string;
    };
    static ageOfOldestUnreplicatedRecordAverage(dimensions: {
        DelegatedOperation: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            DelegatedOperation: string;
            TableName: string;
        };
        statistic: string;
    };
    static consumedChangeDataCaptureUnitsAverage(dimensions: {
        DelegatedOperation: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            DelegatedOperation: string;
            TableName: string;
        };
        statistic: string;
    };
    static throttledPutRecordCountAverage(dimensions: {
        DelegatedOperation: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            DelegatedOperation: string;
            TableName: string;
        };
        statistic: string;
    };
    static pendingReplicationCountAverage(dimensions: {
        ReceivingRegion: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ReceivingRegion: string;
            TableName: string;
        };
        statistic: string;
    };
    static replicationLatencyAverage(dimensions: {
        ReceivingRegion: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ReceivingRegion: string;
            TableName: string;
        };
        statistic: string;
    };
    static returnedBytesAverage(dimensions: {
        Operation: string;
        StreamLabel: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            Operation: string;
            StreamLabel: string;
            TableName: string;
        };
        statistic: string;
    };
    static returnedRecordsCountAverage(dimensions: {
        Operation: string;
        StreamLabel: string;
        TableName: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            Operation: string;
            StreamLabel: string;
            TableName: string;
        };
        statistic: string;
    };
    static accountMaxReadsMaximum(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static accountMaxTableLevelReadsMaximum(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static accountMaxTableLevelWritesMaximum(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static accountMaxWritesMaximum(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static accountProvisionedReadCapacityUtilizationAverage(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static accountProvisionedWriteCapacityUtilizationAverage(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static maxProvisionedTableReadCapacityUtilizationAverage(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static maxProvisionedTableWriteCapacityUtilizationAverage(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
    static userErrorsSum(dimensions: {}): {
        namespace: string;
        metricName: string;
        dimensionsMap: {};
        statistic: string;
    };
}
type MetricWithDims<D> = {
    namespace: string;
    metricName: string;
    statistic: string;
    dimensionsMap: D;
};
export {};
