"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceManager = exports.InitSource = exports.InitService = exports.InitPackage = exports.InitUser = exports.InitGroup = exports.InitFile = exports.InitCommand = exports.InitCommandWaitDuration = exports.InitElement = exports.InitServiceRestartHandle = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const s3_assets = require("../../aws-s3-assets");
const core_1 = require("../../core");
const cfn_init_internal_1 = require("./private/cfn-init-internal");
/**
 * An object that represents reasons to restart an InitService
 *
 * Pass an instance of this object to the `InitFile`, `InitCommand`,
 * `InitSource` and `InitPackage` objects, and finally to an `InitService`
 * itself to cause the actions (files, commands, sources, and packages)
 * to trigger a restart of the service.
 *
 * For example, the following will run a custom command to install Nginx,
 * and trigger the nginx service to be restarted after the command has run.
 *
 * ```ts
 * const handle = new ec2.InitServiceRestartHandle();
 * ec2.CloudFormationInit.fromElements(
 *   ec2.InitCommand.shellCommand('/usr/bin/custom-nginx-install.sh', { serviceRestartHandles: [handle] }),
 *   ec2.InitService.enable('nginx', { serviceRestartHandle: handle }),
 * );
 * ```
 */
class InitServiceRestartHandle {
    constructor() {
        this.commands = new Array();
        this.files = new Array();
        this.sources = new Array();
        this.packages = {};
    }
    /**
     * Add a command key to the restart set
     * @internal
     */
    _addCommand(key) {
        return this.commands.push(key);
    }
    /**
     * Add a file key to the restart set
     * @internal
     */
    _addFile(key) {
        return this.files.push(key);
    }
    /**
     * Add a source key to the restart set
     * @internal
     */
    _addSource(key) {
        return this.sources.push(key);
    }
    /**
     * Add a package key to the restart set
     * @internal
     */
    _addPackage(packageType, key) {
        if (!this.packages[packageType]) {
            this.packages[packageType] = [];
        }
        this.packages[packageType].push(key);
    }
    /**
     * Render the restart handles for use in an InitService declaration
     * @internal
     */
    _renderRestartHandles() {
        const nonEmpty = (x) => x.length > 0 ? x : undefined;
        return {
            commands: nonEmpty(this.commands),
            files: nonEmpty(this.files),
            packages: Object.keys(this.packages).length > 0 ? this.packages : undefined,
            sources: nonEmpty(this.sources),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
InitServiceRestartHandle[_a] = { fqn: "aws-cdk-lib.aws_ec2.InitServiceRestartHandle", version: "2.74.0" };
exports.InitServiceRestartHandle = InitServiceRestartHandle;
/**
 * Base class for all CloudFormation Init elements
 */
class InitElement {
}
_b = JSII_RTTI_SYMBOL_1;
InitElement[_b] = { fqn: "aws-cdk-lib.aws_ec2.InitElement", version: "2.74.0" };
exports.InitElement = InitElement;
/**
 * Represents a duration to wait after a command has finished, in case of a reboot (Windows only).
 */
class InitCommandWaitDuration {
    /** Wait for a specified duration after a command. */
    static of(duration) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_Duration(duration);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.of);
            }
            throw error;
        }
        return new class extends InitCommandWaitDuration {
            /** @internal */
            _render() { return duration.toSeconds(); }
        }();
    }
    /** Do not wait for this command. */
    static none() {
        return InitCommandWaitDuration.of(core_1.Duration.seconds(0));
    }
    /** cfn-init will exit and resume only after a reboot. */
    static forever() {
        return new class extends InitCommandWaitDuration {
            /** @internal */
            _render() { return 'forever'; }
        }();
    }
}
_c = JSII_RTTI_SYMBOL_1;
InitCommandWaitDuration[_c] = { fqn: "aws-cdk-lib.aws_ec2.InitCommandWaitDuration", version: "2.74.0" };
exports.InitCommandWaitDuration = InitCommandWaitDuration;
/**
 * Command to execute on the instance
 */
class InitCommand extends InitElement {
    /**
     * Run a shell command
     *
     * Remember that some characters like `&`, `|`, `;`, `>` etc. have special meaning in a shell and
     * need to be preceded by a `\` if you want to treat them as part of a filename.
     */
    static shellCommand(shellCommand, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitCommandOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.shellCommand);
            }
            throw error;
        }
        return new InitCommand(shellCommand, options);
    }
    /**
     * Run a command from an argv array
     *
     * You do not need to escape space characters or enclose command parameters in quotes.
     */
    static argvCommand(argv, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitCommandOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.argvCommand);
            }
            throw error;
        }
        if (argv.length === 0) {
            throw new Error('Cannot define argvCommand with an empty arguments');
        }
        return new InitCommand(argv, options);
    }
    constructor(command, options) {
        super();
        this.command = command;
        this.options = options;
        this.elementType = cfn_init_internal_1.InitElementType.COMMAND.toString();
    }
    /** @internal */
    _bind(options) {
        const commandKey = this.options.key || `${options.index}`.padStart(3, '0'); // 001, 005, etc.
        if (options.platform !== cfn_init_internal_1.InitPlatform.WINDOWS && this.options.waitAfterCompletion !== undefined) {
            throw new Error(`Command '${this.command}': 'waitAfterCompletion' is only valid for Windows systems.`);
        }
        for (const handle of this.options.serviceRestartHandles ?? []) {
            handle._addCommand(commandKey);
        }
        return {
            config: {
                [commandKey]: {
                    command: this.command,
                    env: this.options.env,
                    cwd: this.options.cwd,
                    test: this.options.testCmd,
                    ignoreErrors: this.options.ignoreErrors,
                    waitAfterCompletion: this.options.waitAfterCompletion?._render(),
                },
            },
        };
    }
}
_d = JSII_RTTI_SYMBOL_1;
InitCommand[_d] = { fqn: "aws-cdk-lib.aws_ec2.InitCommand", version: "2.74.0" };
exports.InitCommand = InitCommand;
/**
 * Create files on the EC2 instance.
 */
class InitFile extends InitElement {
    /**
     * Use a literal string as the file content
     */
    static fromString(fileName, content, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromString);
            }
            throw error;
        }
        if (!content) {
            throw new Error(`InitFile ${fileName}: cannot create empty file. Please supply at least one character of content.`);
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        content,
                        encoding: this.options.base64Encoded ? 'base64' : 'plain',
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Write a symlink with the given symlink target
     */
    static symlink(fileName, target, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.symlink);
            }
            throw error;
        }
        const { mode, ...otherOptions } = options;
        if (mode && mode.slice(0, 3) !== '120') {
            throw new Error('File mode for symlinks must begin with 120XXX');
        }
        return InitFile.fromString(fileName, target, { mode: (mode || '120644'), ...otherOptions });
    }
    /**
     * Use a JSON-compatible object as the file content, write it to a JSON file.
     *
     * May contain tokens.
     */
    static fromObject(fileName, obj, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromObject);
            }
            throw error;
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        content: obj,
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Read a file from disk and use its contents
     *
     * The file will be embedded in the template, so care should be taken to not
     * exceed the template size.
     *
     * If options.base64encoded is set to true, this will base64-encode the file's contents.
     */
    static fromFileInline(targetFileName, sourceFileName, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromFileInline);
            }
            throw error;
        }
        const encoding = options.base64Encoded ? 'base64' : 'utf8';
        const fileContents = fs.readFileSync(sourceFileName).toString(encoding);
        return InitFile.fromString(targetFileName, fileContents, options);
    }
    /**
     * Download from a URL at instance startup time
     */
    static fromUrl(fileName, url, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUrl);
            }
            throw error;
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: url,
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Download a file from an S3 bucket at instance startup time
     */
    static fromS3Object(fileName, bucket, key, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromS3Object);
            }
            throw error;
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                bucket.grantRead(bindOptions.instanceRole, key);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: bucket.urlForObject(key),
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, bucket.bucketName),
                };
            }
        }(fileName, options);
    }
    /**
     * Create an asset from the given file
     *
     * This is appropriate for files that are too large to embed into the template.
     */
    static fromAsset(targetFileName, path, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileAssetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                const asset = new s3_assets.Asset(bindOptions.scope, `${targetFileName}Asset`, {
                    path,
                    ...options,
                });
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: asset.httpUrl,
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetFileName, options);
    }
    /**
     * Use a file from an asset at instance startup time
     */
    static fromExistingAsset(targetFileName, asset, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_assets_Asset(asset);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromExistingAsset);
            }
            throw error;
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: asset.httpUrl,
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetFileName, options);
    }
    constructor(fileName, options) {
        super();
        this.fileName = fileName;
        this.options = options;
        this.elementType = cfn_init_internal_1.InitElementType.FILE.toString();
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InitFile);
            }
            throw error;
        }
    }
    /** @internal */
    _bind(bindOptions) {
        for (const handle of this.options.serviceRestartHandles ?? []) {
            handle._addFile(this.fileName);
        }
        return this._doBind(bindOptions);
    }
    /**
     * Render the standard config block, given content vars
     * @internal
     */
    _standardConfig(fileOptions, platform, contentVars) {
        if (platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            if (fileOptions.group || fileOptions.owner || fileOptions.mode) {
                throw new Error('Owner, group, and mode options not supported for Windows.');
            }
            return {
                [this.fileName]: { ...contentVars },
            };
        }
        return {
            [this.fileName]: {
                ...contentVars,
                mode: fileOptions.mode || '000644',
                owner: fileOptions.owner || 'root',
                group: fileOptions.group || 'root',
            },
        };
    }
}
_e = JSII_RTTI_SYMBOL_1;
InitFile[_e] = { fqn: "aws-cdk-lib.aws_ec2.InitFile", version: "2.74.0" };
exports.InitFile = InitFile;
/**
 * Create Linux/UNIX groups and assign group IDs.
 *
 * Not supported for Windows systems.
 */
class InitGroup extends InitElement {
    /**
     * Create a group from its name, and optionally, group id
     */
    static fromName(groupName, groupId) {
        return new InitGroup(groupName, groupId);
    }
    constructor(groupName, groupId) {
        super();
        this.groupName = groupName;
        this.groupId = groupId;
        this.elementType = cfn_init_internal_1.InitElementType.GROUP.toString();
    }
    /** @internal */
    _bind(options) {
        if (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            throw new Error('Init groups are not supported on Windows');
        }
        return {
            config: {
                [this.groupName]: this.groupId !== undefined ? { gid: this.groupId } : {},
            },
        };
    }
}
_f = JSII_RTTI_SYMBOL_1;
InitGroup[_f] = { fqn: "aws-cdk-lib.aws_ec2.InitGroup", version: "2.74.0" };
exports.InitGroup = InitGroup;
/**
 * Create Linux/UNIX users and to assign user IDs.
 *
 * Users are created as non-interactive system users with a shell of
 * /sbin/nologin. This is by design and cannot be modified.
 *
 * Not supported for Windows systems.
 */
class InitUser extends InitElement {
    /**
     * Create a user from user name.
     */
    static fromName(userName, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitUserOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromName);
            }
            throw error;
        }
        return new InitUser(userName, options);
    }
    constructor(userName, userOptions) {
        super();
        this.userName = userName;
        this.userOptions = userOptions;
        this.elementType = cfn_init_internal_1.InitElementType.USER.toString();
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitUserOptions(userOptions);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InitUser);
            }
            throw error;
        }
    }
    /** @internal */
    _bind(options) {
        if (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            throw new Error('Init users are not supported on Windows');
        }
        return {
            config: {
                [this.userName]: {
                    uid: this.userOptions.userId,
                    groups: this.userOptions.groups,
                    homeDir: this.userOptions.homeDir,
                },
            },
        };
    }
}
_g = JSII_RTTI_SYMBOL_1;
InitUser[_g] = { fqn: "aws-cdk-lib.aws_ec2.InitUser", version: "2.74.0" };
exports.InitUser = InitUser;
/**
 * A package to be installed during cfn-init time
 */
class InitPackage extends InitElement {
    /**
     * Install an RPM from an HTTP URL or a location on disk
     */
    static rpm(location, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_LocationPackageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.rpm);
            }
            throw error;
        }
        return new InitPackage('rpm', [location], options.key, options.serviceRestartHandles);
    }
    /**
     * Install a package using Yum
     */
    static yum(packageName, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_NamedPackageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.yum);
            }
            throw error;
        }
        return new InitPackage('yum', options.version ?? [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install a package from RubyGems
     */
    static rubyGem(gemName, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_NamedPackageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.rubyGem);
            }
            throw error;
        }
        return new InitPackage('rubygems', options.version ?? [], gemName, options.serviceRestartHandles);
    }
    /**
     * Install a package from PyPI
     */
    static python(packageName, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_NamedPackageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.python);
            }
            throw error;
        }
        return new InitPackage('python', options.version ?? [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install a package using APT
     */
    static apt(packageName, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_NamedPackageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.apt);
            }
            throw error;
        }
        return new InitPackage('apt', options.version ?? [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install an MSI package from an HTTP URL or a location on disk
     */
    static msi(location, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_LocationPackageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.msi);
            }
            throw error;
        }
        // The MSI package version must be a string, not an array.
        return new class extends InitPackage {
            renderPackageVersions() { return location; }
        }('msi', [location], options.key, options.serviceRestartHandles);
    }
    constructor(type, versions, packageName, serviceHandles) {
        super();
        this.type = type;
        this.versions = versions;
        this.packageName = packageName;
        this.serviceHandles = serviceHandles;
        this.elementType = cfn_init_internal_1.InitElementType.PACKAGE.toString();
    }
    /** @internal */
    _bind(options) {
        if ((this.type === 'msi') !== (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS)) {
            if (this.type === 'msi') {
                throw new Error('MSI installers are only supported on Windows systems.');
            }
            else {
                throw new Error('Windows only supports the MSI package type');
            }
        }
        if (!this.packageName && !['rpm', 'msi'].includes(this.type)) {
            throw new Error('Package name must be specified for all package types besides RPM and MSI.');
        }
        const packageName = this.packageName || `${options.index}`.padStart(3, '0');
        for (const handle of this.serviceHandles ?? []) {
            handle._addPackage(this.type, packageName);
        }
        return {
            config: {
                [this.type]: {
                    [packageName]: this.renderPackageVersions(),
                },
            },
        };
    }
    renderPackageVersions() {
        return this.versions;
    }
}
_h = JSII_RTTI_SYMBOL_1;
InitPackage[_h] = { fqn: "aws-cdk-lib.aws_ec2.InitPackage", version: "2.74.0" };
exports.InitPackage = InitPackage;
/**
 * A services that be enabled, disabled or restarted when the instance is launched.
 */
class InitService extends InitElement {
    /**
     * Enable and start the given service, optionally restarting it
     */
    static enable(serviceName, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitServiceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.enable);
            }
            throw error;
        }
        const { enabled, ensureRunning, ...otherOptions } = options;
        return new InitService(serviceName, {
            enabled: enabled ?? true,
            ensureRunning: ensureRunning ?? enabled ?? true,
            ...otherOptions,
        });
    }
    /**
     * Disable and stop the given service
     */
    static disable(serviceName) {
        return new InitService(serviceName, { enabled: false, ensureRunning: false });
    }
    /**
     * Install a systemd-compatible config file for the given service
     *
     * This is a helper function to create a simple systemd configuration
     * file that will allow running a service on the machine using `InitService.enable()`.
     *
     * Systemd allows many configuration options; this function does not pretend
     * to expose all of them. If you need advanced configuration options, you
     * can use `InitFile` to create exactly the configuration file you need
     * at `/etc/systemd/system/${serviceName}.service`.
     */
    static systemdConfigFile(serviceName, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_SystemdConfigFileOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.systemdConfigFile);
            }
            throw error;
        }
        if (!options.command.startsWith('/')) {
            throw new Error(`SystemD executables must use an absolute path, got '${options.command}'`);
        }
        const lines = [
            '[Unit]',
            ...(options.description ? [`Description=${options.description}`] : []),
            ...(options.afterNetwork ?? true ? ['After=network.target'] : []),
            '[Service]',
            `ExecStart=${options.command}`,
            ...(options.cwd ? [`WorkingDirectory=${options.cwd}`] : []),
            ...(options.user ? [`User=${options.user}`] : []),
            ...(options.group ? [`Group=${options.user}`] : []),
            ...(options.keepRunning ?? true ? ['Restart=always'] : []),
            '[Install]',
            'WantedBy=multi-user.target',
        ];
        return InitFile.fromString(`/etc/systemd/system/${serviceName}.service`, lines.join('\n'));
    }
    constructor(serviceName, serviceOptions) {
        super();
        this.serviceName = serviceName;
        this.serviceOptions = serviceOptions;
        this.elementType = cfn_init_internal_1.InitElementType.SERVICE.toString();
    }
    /** @internal */
    _bind(options) {
        const serviceManager = this.serviceOptions.serviceManager
            ?? (options.platform === cfn_init_internal_1.InitPlatform.LINUX ? ServiceManager.SYSVINIT : ServiceManager.WINDOWS);
        return {
            config: {
                [serviceManagerToString(serviceManager)]: {
                    [this.serviceName]: {
                        enabled: this.serviceOptions.enabled,
                        ensureRunning: this.serviceOptions.ensureRunning,
                        ...this.serviceOptions.serviceRestartHandle?._renderRestartHandles(),
                    },
                },
            },
        };
    }
}
_j = JSII_RTTI_SYMBOL_1;
InitService[_j] = { fqn: "aws-cdk-lib.aws_ec2.InitService", version: "2.74.0" };
exports.InitService = InitService;
/**
 * Extract an archive into a directory
 */
class InitSource extends InitElement {
    /**
     * Retrieve a URL and extract it into the given directory
     */
    static fromUrl(targetDirectory, url, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitSourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUrl);
            }
            throw error;
        }
        return new class extends InitSource {
            _doBind() {
                return {
                    config: { [this.targetDirectory]: url },
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Extract a GitHub branch into a given directory
     */
    static fromGitHub(targetDirectory, owner, repo, refSpec, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitSourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return InitSource.fromUrl(targetDirectory, `https://github.com/${owner}/${repo}/tarball/${refSpec ?? 'master'}`, options);
    }
    /**
     * Extract an archive stored in an S3 bucket into the given directory
     */
    static fromS3Object(targetDirectory, bucket, key, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitSourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromS3Object);
            }
            throw error;
        }
        return new class extends InitSource {
            _doBind(bindOptions) {
                bucket.grantRead(bindOptions.instanceRole, key);
                return {
                    config: { [this.targetDirectory]: bucket.urlForObject(key) },
                    authentication: standardS3Auth(bindOptions.instanceRole, bucket.bucketName),
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Create an InitSource from an asset created from the given path.
     */
    static fromAsset(targetDirectory, path, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitSourceAssetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new class extends InitSource {
            _doBind(bindOptions) {
                const asset = new s3_assets.Asset(bindOptions.scope, `${targetDirectory}Asset`, {
                    path,
                    ...bindOptions,
                });
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: { [this.targetDirectory]: asset.httpUrl },
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Extract a directory from an existing directory asset.
     */
    static fromExistingAsset(targetDirectory, asset, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_assets_Asset(asset);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InitSourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromExistingAsset);
            }
            throw error;
        }
        return new class extends InitSource {
            _doBind(bindOptions) {
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: { [this.targetDirectory]: asset.httpUrl },
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    constructor(targetDirectory, serviceHandles) {
        super();
        this.targetDirectory = targetDirectory;
        this.serviceHandles = serviceHandles;
        this.elementType = cfn_init_internal_1.InitElementType.SOURCE.toString();
    }
    /** @internal */
    _bind(options) {
        for (const handle of this.serviceHandles ?? []) {
            handle._addSource(this.targetDirectory);
        }
        // Delegate actual bind to subclasses
        return this._doBind(options);
    }
}
_k = JSII_RTTI_SYMBOL_1;
InitSource[_k] = { fqn: "aws-cdk-lib.aws_ec2.InitSource", version: "2.74.0" };
exports.InitSource = InitSource;
/**
 * Render a standard S3 auth block for use in AWS::CloudFormation::Authentication
 *
 * This block is the same every time (modulo bucket name), so it has the same
 * key every time so the blocks are merged into one in the final render.
 */
function standardS3Auth(role, bucketName) {
    return {
        S3AccessCreds: {
            type: 'S3',
            roleName: role.roleName,
            buckets: [bucketName],
        },
    };
}
/**
 * The service manager that will be used by InitServices
 *
 * The value needs to match the service manager used by your operating
 * system.
 */
var ServiceManager;
(function (ServiceManager) {
    /**
     * Use SysVinit
     *
     * This is the default for Linux systems.
     */
    ServiceManager[ServiceManager["SYSVINIT"] = 0] = "SYSVINIT";
    /**
     * Use Windows
     *
     * This is the default for Windows systems.
     */
    ServiceManager[ServiceManager["WINDOWS"] = 1] = "WINDOWS";
    /**
     * Use systemd
     */
    ServiceManager[ServiceManager["SYSTEMD"] = 2] = "SYSTEMD";
})(ServiceManager = exports.ServiceManager || (exports.ServiceManager = {}));
function serviceManagerToString(x) {
    switch (x) {
        case ServiceManager.SYSTEMD: return 'systemd';
        case ServiceManager.SYSVINIT: return 'sysvinit';
        case ServiceManager.WINDOWS: return 'windows';
    }
}
//# sourceMappingURL=data:application/json;base64,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