"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cloudwatch = require("../../aws-cloudwatch");
const vpn_1 = require("./vpn");
vpn_1.VpnConnectionBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/VPN',
        metricName,
        dimensionsMap: { VpnId: this.vpnId },
        ...props
    }).attachTo(this);
};
vpn_1.VpnConnectionBase.prototype.metricTunnelState = function (props) {
    return this.metric('TunnelState', { statistic: 'Average', ...props });
};
vpn_1.VpnConnectionBase.prototype.metricTunnelDataIn = function (props) {
    return this.metric('TunnelDataIn', { statistic: 'Sum', ...props });
};
vpn_1.VpnConnectionBase.prototype.metricTunnelDataOut = function (props) {
    return this.metric('TunnelDataOut', { statistic: 'Sum', ...props });
};
//# sourceMappingURL=data:application/json;base64,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