"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const region_info_1 = require("../../region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 *
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VpcEndpointServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcEndpointService);
            }
            throw error;
        }
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = props.acceptanceRequired ?? true;
        if (props.allowedPrincipals && props.whitelistedPrincipals) {
            throw new Error('`whitelistedPrincipals` is deprecated; please use `allowedPrincipals` instead');
        }
        this.allowedPrincipals = props.allowedPrincipals ?? props.whitelistedPrincipals ?? [];
        this.whitelistedPrincipals = this.allowedPrincipals;
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ?
            (region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix ?? region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX) :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.allowedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.allowedPrincipals.map(x => x.arn),
            });
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
VpcEndpointService[_a] = { fqn: "aws-cdk-lib.aws_ec2.VpcEndpointService", version: "2.74.0" };
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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