"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfaceVpcEndpoint = exports.InterfaceVpcEndpointAwsService = exports.InterfaceVpcEndpointService = exports.GatewayVpcEndpoint = exports.GatewayVpcEndpointAwsService = exports.VpcEndpointType = exports.VpcEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const cxschema = require("../../cloud-assembly-schema");
const core_1 = require("../../core");
const connections_1 = require("./connections");
const ec2_generated_1 = require("./ec2.generated");
const peer_1 = require("./peer");
const port_1 = require("./port");
const security_group_1 = require("./security-group");
const util_1 = require("./util");
class VpcEndpoint extends core_1.Resource {
    /**
     * Adds a statement to the policy document of the VPC endpoint. The statement
     * must have a Principal.
     *
     * Not all interface VPC endpoints support policy. For more information
     * see https://docs.aws.amazon.com/vpc/latest/userguide/vpce-interface.html
     *
     * @param statement the IAM statement to add
     */
    addToPolicy(statement) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToPolicy);
            }
            throw error;
        }
        if (!statement.hasPrincipal) {
            throw new Error('Statement must have a `Principal`.');
        }
        if (!this.policyDocument) {
            this.policyDocument = new iam.PolicyDocument();
        }
        this.policyDocument.addStatements(statement);
    }
}
_a = JSII_RTTI_SYMBOL_1;
VpcEndpoint[_a] = { fqn: "aws-cdk-lib.aws_ec2.VpcEndpoint", version: "2.74.0" };
exports.VpcEndpoint = VpcEndpoint;
/**
 * The type of VPC endpoint.
 */
var VpcEndpointType;
(function (VpcEndpointType) {
    /**
     * Interface
     *
     * An interface endpoint is an elastic network interface with a private IP
     * address that serves as an entry point for traffic destined to a supported
     * service.
     */
    VpcEndpointType["INTERFACE"] = "Interface";
    /**
     * Gateway
     *
     * A gateway endpoint is a gateway that is a target for a specified route in
     * your route table, used for traffic destined to a supported AWS service.
     */
    VpcEndpointType["GATEWAY"] = "Gateway";
})(VpcEndpointType = exports.VpcEndpointType || (exports.VpcEndpointType = {}));
/**
 * An AWS service for a gateway VPC endpoint.
 */
class GatewayVpcEndpointAwsService {
    constructor(name, prefix) {
        this.name = `${prefix || 'com.amazonaws'}.${core_1.Aws.REGION}.${name}`;
    }
}
_b = JSII_RTTI_SYMBOL_1;
GatewayVpcEndpointAwsService[_b] = { fqn: "aws-cdk-lib.aws_ec2.GatewayVpcEndpointAwsService", version: "2.74.0" };
GatewayVpcEndpointAwsService.DYNAMODB = new GatewayVpcEndpointAwsService('dynamodb');
GatewayVpcEndpointAwsService.S3 = new GatewayVpcEndpointAwsService('s3');
exports.GatewayVpcEndpointAwsService = GatewayVpcEndpointAwsService;
/**
 * A gateway VPC endpoint.
 * @resource AWS::EC2::VPCEndpoint
 */
class GatewayVpcEndpoint extends VpcEndpoint {
    static fromGatewayVpcEndpointId(scope, id, gatewayVpcEndpointId) {
        class Import extends VpcEndpoint {
            constructor() {
                super(...arguments);
                this.vpcEndpointId = gatewayVpcEndpointId;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_GatewayVpcEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GatewayVpcEndpoint);
            }
            throw error;
        }
        const subnets = props.subnets
            ? (0, util_1.flatten)(props.subnets.map(s => props.vpc.selectSubnets(s).subnets))
            : [...props.vpc.privateSubnets, ...props.vpc.publicSubnets, ...props.vpc.isolatedSubnets];
        const routeTableIds = (0, util_1.allRouteTableIds)(subnets);
        if (routeTableIds.length === 0) {
            throw new Error('Can\'t add a gateway endpoint to VPC; route table IDs are not available');
        }
        const endpoint = new ec2_generated_1.CfnVPCEndpoint(this, 'Resource', {
            policyDocument: core_1.Lazy.any({ produce: () => this.policyDocument }),
            routeTableIds,
            serviceName: props.service.name,
            vpcEndpointType: VpcEndpointType.GATEWAY,
            vpcId: props.vpc.vpcId,
        });
        this.vpcEndpointId = endpoint.ref;
        this.vpcEndpointCreationTimestamp = endpoint.attrCreationTimestamp;
        this.vpcEndpointDnsEntries = endpoint.attrDnsEntries;
        this.vpcEndpointNetworkInterfaceIds = endpoint.attrNetworkInterfaceIds;
    }
}
_c = JSII_RTTI_SYMBOL_1;
GatewayVpcEndpoint[_c] = { fqn: "aws-cdk-lib.aws_ec2.GatewayVpcEndpoint", version: "2.74.0" };
exports.GatewayVpcEndpoint = GatewayVpcEndpoint;
/**
 * A custom-hosted service for an interface VPC endpoint.
 */
class InterfaceVpcEndpointService {
    constructor(name, port) {
        /**
         * Whether Private DNS is supported by default.
         */
        this.privateDnsDefault = false;
        this.name = name;
        this.port = port || 443;
    }
}
_d = JSII_RTTI_SYMBOL_1;
InterfaceVpcEndpointService[_d] = { fqn: "aws-cdk-lib.aws_ec2.InterfaceVpcEndpointService", version: "2.74.0" };
exports.InterfaceVpcEndpointService = InterfaceVpcEndpointService;
/**
 * An AWS service for an interface VPC endpoint.
 */
class InterfaceVpcEndpointAwsService {
    constructor(name, prefix, port) {
        /**
         * Whether Private DNS is supported by default.
         */
        this.privateDnsDefault = true;
        const region = core_1.Lazy.uncachedString({
            produce: (context) => core_1.Stack.of(context.scope).region,
        });
        const defaultEndpointPrefix = core_1.Lazy.uncachedString({
            produce: (context) => {
                const regionName = core_1.Stack.of(context.scope).region;
                return this.getDefaultEndpointPrefix(name, regionName);
            },
        });
        const defaultEndpointSuffix = core_1.Lazy.uncachedString({
            produce: (context) => {
                const regionName = core_1.Stack.of(context.scope).region;
                return this.getDefaultEndpointSuffix(name, regionName);
            },
        });
        this.name = `${prefix || defaultEndpointPrefix}.${region}.${name}${defaultEndpointSuffix}`;
        this.shortName = name;
        this.port = port || 443;
    }
    /**
     * Get the endpoint prefix for the service in the specified region
     * because the prefix for some of the services in cn-north-1 and cn-northwest-1 are different
     *
     * For future maintenance， the vpc endpoint services could be fetched using AWS CLI Commmand:
     * aws ec2 describe-vpc-endpoint-services
     */
    getDefaultEndpointPrefix(name, region) {
        const VPC_ENDPOINT_SERVICE_EXCEPTIONS = {
            'cn-north-1': ['application-autoscaling', 'athena', 'autoscaling', 'awsconnector', 'cassandra',
                'cloudformation', 'codedeploy-commands-secure', 'databrew', 'dms', 'ebs', 'ec2', 'ecr.api', 'ecr.dkr',
                'elasticbeanstalk', 'elasticfilesystem', 'elasticfilesystem-fips', 'execute-api', 'imagebuilder',
                'iotsitewise.api', 'iotsitewise.data', 'kinesis-streams', 'lambda', 'license-manager', 'monitoring',
                'rds', 'redshift', 'redshift-data', 's3', 'sagemaker.api', 'sagemaker.featurestore-runtime',
                'sagemaker.runtime', 'servicecatalog', 'sms', 'sqs', 'states', 'sts', 'synthetics', 'transcribe',
                'transcribestreaming', 'transfer', 'xray'],
            'cn-northwest-1': ['application-autoscaling', 'athena', 'autoscaling', 'awsconnector', 'cassandra',
                'cloudformation', 'codedeploy-commands-secure', 'databrew', 'dms', 'ebs', 'ec2', 'ecr.api', 'ecr.dkr',
                'elasticbeanstalk', 'elasticfilesystem', 'elasticfilesystem-fips', 'execute-api', 'imagebuilder',
                'kinesis-streams', 'lambda', 'license-manager', 'monitoring', 'rds', 'redshift', 'redshift-data', 's3',
                'sagemaker.api', 'sagemaker.featurestore-runtime', 'sagemaker.runtime', 'servicecatalog', 'sms', 'sqs',
                'states', 'sts', 'synthetics', 'transcribe', 'transcribestreaming', 'transfer', 'workspaces', 'xray'],
        };
        if (VPC_ENDPOINT_SERVICE_EXCEPTIONS[region]?.includes(name)) {
            return 'cn.com.amazonaws';
        }
        else {
            return 'com.amazonaws';
        }
    }
    /**
     * Get the endpoint suffix for the service in the specified region.
     * In cn-north-1 and cn-northwest-1, the vpc endpoint of transcribe is:
     *   cn.com.amazonaws.cn-north-1.transcribe.cn
     *   cn.com.amazonaws.cn-northwest-1.transcribe.cn
     * so suffix '.cn' should be return in these scenarios.
     *
     * For future maintenance， the vpc endpoint services could be fetched using AWS CLI Commmand:
     * aws ec2 describe-vpc-endpoint-services
     */
    getDefaultEndpointSuffix(name, region) {
        const VPC_ENDPOINT_SERVICE_EXCEPTIONS = {
            'cn-north-1': ['transcribe'],
            'cn-northwest-1': ['transcribe'],
        };
        return VPC_ENDPOINT_SERVICE_EXCEPTIONS[region]?.includes(name) ? '.cn' : '';
    }
}
_e = JSII_RTTI_SYMBOL_1;
InterfaceVpcEndpointAwsService[_e] = { fqn: "aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService", version: "2.74.0" };
InterfaceVpcEndpointAwsService.SAGEMAKER_STUDIO = new InterfaceVpcEndpointAwsService('studio', 'aws.sagemaker');
InterfaceVpcEndpointAwsService.SAGEMAKER_NOTEBOOK = new InterfaceVpcEndpointAwsService('notebook', 'aws.sagemaker');
InterfaceVpcEndpointAwsService.KENDRA_RANKING = new InterfaceVpcEndpointAwsService('kendra-ranking', 'aws.api');
InterfaceVpcEndpointAwsService.ACCESS_ANALYZER = new InterfaceVpcEndpointAwsService('access-analyzer');
InterfaceVpcEndpointAwsService.ACCOUNT_MANAGEMENT = new InterfaceVpcEndpointAwsService('account');
InterfaceVpcEndpointAwsService.APP_MESH = new InterfaceVpcEndpointAwsService('appmesh-envoy-management');
InterfaceVpcEndpointAwsService.APP_RUNNER = new InterfaceVpcEndpointAwsService('apprunner');
InterfaceVpcEndpointAwsService.APP_RUNNER_REQUESTS = new InterfaceVpcEndpointAwsService('apprunner.requests');
InterfaceVpcEndpointAwsService.APPLICATION_MIGRATION_SERVICE = new InterfaceVpcEndpointAwsService('mgn');
InterfaceVpcEndpointAwsService.APPSTREAM_API = new InterfaceVpcEndpointAwsService('appstream.api');
InterfaceVpcEndpointAwsService.APPSTREAM_STREAMING = new InterfaceVpcEndpointAwsService('appstream.streaming');
InterfaceVpcEndpointAwsService.ATHENA = new InterfaceVpcEndpointAwsService('athena');
InterfaceVpcEndpointAwsService.AUDIT_MANAGER = new InterfaceVpcEndpointAwsService('auditmanager');
InterfaceVpcEndpointAwsService.APPLICATION_AUTOSCALING = new InterfaceVpcEndpointAwsService('application-autoscaling');
InterfaceVpcEndpointAwsService.AUTOSCALING = new InterfaceVpcEndpointAwsService('autoscaling');
InterfaceVpcEndpointAwsService.AUTOSCALING_PLANS = new InterfaceVpcEndpointAwsService('autoscaling-plans');
InterfaceVpcEndpointAwsService.BACKUP = new InterfaceVpcEndpointAwsService('backup');
InterfaceVpcEndpointAwsService.BACKUP_GATEWAY = new InterfaceVpcEndpointAwsService('backup-gateway');
InterfaceVpcEndpointAwsService.BATCH = new InterfaceVpcEndpointAwsService('batch');
InterfaceVpcEndpointAwsService.BILLING_CONDUCTOR = new InterfaceVpcEndpointAwsService('billingconductor');
InterfaceVpcEndpointAwsService.BRAKET = new InterfaceVpcEndpointAwsService('braket');
InterfaceVpcEndpointAwsService.PRIVATE_CERTIFICATE_AUTHORITY = new InterfaceVpcEndpointAwsService('acm-pca');
InterfaceVpcEndpointAwsService.CLOUD_CONTROL_API = new InterfaceVpcEndpointAwsService('cloudcontrolapi');
InterfaceVpcEndpointAwsService.CLOUD_CONTROL_API_FIPS = new InterfaceVpcEndpointAwsService('cloudcontrolapi-fips');
InterfaceVpcEndpointAwsService.CLOUD_DIRECTORY = new InterfaceVpcEndpointAwsService('clouddirectory');
InterfaceVpcEndpointAwsService.CLOUDFORMATION = new InterfaceVpcEndpointAwsService('cloudformation');
InterfaceVpcEndpointAwsService.CLOUDHSM = new InterfaceVpcEndpointAwsService('cloudhsmv2');
InterfaceVpcEndpointAwsService.CLOUDTRAIL = new InterfaceVpcEndpointAwsService('cloudtrail');
InterfaceVpcEndpointAwsService.CLOUDWATCH_EVIDENTLY = new InterfaceVpcEndpointAwsService('evidently');
InterfaceVpcEndpointAwsService.CLOUDWATCH_EVIDENTLY_DATAPLANE = new InterfaceVpcEndpointAwsService('evidently-dataplane');
InterfaceVpcEndpointAwsService.CLOUDWATCH_MONITORING = new InterfaceVpcEndpointAwsService('monitoring');
InterfaceVpcEndpointAwsService.CLOUDWATCH_RUM = new InterfaceVpcEndpointAwsService('rum');
InterfaceVpcEndpointAwsService.CLOUDWATCH_RUM_DATAPLANE = new InterfaceVpcEndpointAwsService('rum-dataplane');
InterfaceVpcEndpointAwsService.CLOUDWATCH_SYNTHETICS = new InterfaceVpcEndpointAwsService('synthetics');
InterfaceVpcEndpointAwsService.CODEARTIFACT_API = new InterfaceVpcEndpointAwsService('codeartifact.api');
InterfaceVpcEndpointAwsService.CODEARTIFACT_REPOSITORIES = new InterfaceVpcEndpointAwsService('codeartifact.repositories');
InterfaceVpcEndpointAwsService.CODEBUILD = new InterfaceVpcEndpointAwsService('codebuild');
InterfaceVpcEndpointAwsService.CODEBUILD_FIPS = new InterfaceVpcEndpointAwsService('codebuild-fips');
InterfaceVpcEndpointAwsService.CODECOMMIT = new InterfaceVpcEndpointAwsService('codecommit');
InterfaceVpcEndpointAwsService.CODECOMMIT_FIPS = new InterfaceVpcEndpointAwsService('codecommit-fips');
InterfaceVpcEndpointAwsService.CODEDEPLOY = new InterfaceVpcEndpointAwsService('codedeploy');
InterfaceVpcEndpointAwsService.CODEDEPLOY_COMMANDS_SECURE = new InterfaceVpcEndpointAwsService('codedeploy-commands-secure');
InterfaceVpcEndpointAwsService.CODEGURU_PROFILER = new InterfaceVpcEndpointAwsService('codeguru-profiler');
InterfaceVpcEndpointAwsService.CODEGURU_REVIEWER = new InterfaceVpcEndpointAwsService('codeguru-reviewer');
InterfaceVpcEndpointAwsService.CODEPIPELINE = new InterfaceVpcEndpointAwsService('codepipeline');
InterfaceVpcEndpointAwsService.CODESTAR_CONNECTIONS = new InterfaceVpcEndpointAwsService('codestar-connections.api');
InterfaceVpcEndpointAwsService.COMPREHEND = new InterfaceVpcEndpointAwsService('comprehend');
InterfaceVpcEndpointAwsService.COMPREHEND_MEDICAL = new InterfaceVpcEndpointAwsService('comprehendmedical');
InterfaceVpcEndpointAwsService.CONFIG = new InterfaceVpcEndpointAwsService('config');
InterfaceVpcEndpointAwsService.CONNECT_APP_INTEGRATIONS = new InterfaceVpcEndpointAwsService('app-integrations');
InterfaceVpcEndpointAwsService.CONNECT_CASES = new InterfaceVpcEndpointAwsService('cases');
InterfaceVpcEndpointAwsService.CONNECT_CONNECT_CAMPAIGNS = new InterfaceVpcEndpointAwsService('connect-campaigns');
InterfaceVpcEndpointAwsService.CONNECT_PROFILE = new InterfaceVpcEndpointAwsService('profile');
InterfaceVpcEndpointAwsService.CONNECT_VOICEID = new InterfaceVpcEndpointAwsService('voiceid');
InterfaceVpcEndpointAwsService.CONNECT_WISDOM = new InterfaceVpcEndpointAwsService('wisdom');
InterfaceVpcEndpointAwsService.DATA_EXCHANGE = new InterfaceVpcEndpointAwsService('dataexchange');
InterfaceVpcEndpointAwsService.DATABASE_MIGRATION_SERVICE = new InterfaceVpcEndpointAwsService('dms');
InterfaceVpcEndpointAwsService.DATABASE_MIGRATION_SERVICE_FIPS = new InterfaceVpcEndpointAwsService('dms-fips');
InterfaceVpcEndpointAwsService.DATASYNC = new InterfaceVpcEndpointAwsService('datasync');
InterfaceVpcEndpointAwsService.DEVOPS_GURU = new InterfaceVpcEndpointAwsService('devops-guru');
InterfaceVpcEndpointAwsService.EBS_DIRECT = new InterfaceVpcEndpointAwsService('ebs');
InterfaceVpcEndpointAwsService.EC2 = new InterfaceVpcEndpointAwsService('ec2');
InterfaceVpcEndpointAwsService.EC2_MESSAGES = new InterfaceVpcEndpointAwsService('ec2messages');
InterfaceVpcEndpointAwsService.IMAGE_BUILDER = new InterfaceVpcEndpointAwsService('imagebuilder');
InterfaceVpcEndpointAwsService.ECR = new InterfaceVpcEndpointAwsService('ecr.api');
InterfaceVpcEndpointAwsService.ECR_DOCKER = new InterfaceVpcEndpointAwsService('ecr.dkr');
InterfaceVpcEndpointAwsService.ECS = new InterfaceVpcEndpointAwsService('ecs');
InterfaceVpcEndpointAwsService.ECS_AGENT = new InterfaceVpcEndpointAwsService('ecs-agent');
InterfaceVpcEndpointAwsService.ECS_TELEMETRY = new InterfaceVpcEndpointAwsService('ecs-telemetry');
InterfaceVpcEndpointAwsService.EKS = new InterfaceVpcEndpointAwsService('eks');
InterfaceVpcEndpointAwsService.ELASTIC_BEANSTALK = new InterfaceVpcEndpointAwsService('elasticbeanstalk');
InterfaceVpcEndpointAwsService.ELASTIC_BEANSTALK_HEALTH = new InterfaceVpcEndpointAwsService('elasticbeanstalk-health');
InterfaceVpcEndpointAwsService.ELASTIC_DISASTER_RECOVERY = new InterfaceVpcEndpointAwsService('drs');
InterfaceVpcEndpointAwsService.ELASTIC_FILESYSTEM = new InterfaceVpcEndpointAwsService('elasticfilesystem');
InterfaceVpcEndpointAwsService.ELASTIC_FILESYSTEM_FIPS = new InterfaceVpcEndpointAwsService('elasticfilesystem-fips');
InterfaceVpcEndpointAwsService.ELASTIC_INFERENCE_RUNTIME = new InterfaceVpcEndpointAwsService('elastic-inference.runtime');
InterfaceVpcEndpointAwsService.ELASTIC_LOAD_BALANCING = new InterfaceVpcEndpointAwsService('elasticloadbalancing');
InterfaceVpcEndpointAwsService.ELASTICACHE = new InterfaceVpcEndpointAwsService('elasticache');
InterfaceVpcEndpointAwsService.ELASTICACHE_FIPS = new InterfaceVpcEndpointAwsService('elasticache-fips');
InterfaceVpcEndpointAwsService.EMR = new InterfaceVpcEndpointAwsService('elasticmapreduce');
InterfaceVpcEndpointAwsService.EMR_EKS = new InterfaceVpcEndpointAwsService('emr-containers');
InterfaceVpcEndpointAwsService.EMR_SERVERLESS = new InterfaceVpcEndpointAwsService('emr-serverless');
InterfaceVpcEndpointAwsService.CLOUDWATCH_EVENTS = new InterfaceVpcEndpointAwsService('events');
InterfaceVpcEndpointAwsService.EVENTBRIDGE = new InterfaceVpcEndpointAwsService('events');
InterfaceVpcEndpointAwsService.APIGATEWAY = new InterfaceVpcEndpointAwsService('execute-api');
InterfaceVpcEndpointAwsService.FAULT_INJECTION_SIMULATOR = new InterfaceVpcEndpointAwsService('fis');
InterfaceVpcEndpointAwsService.FINSPACE = new InterfaceVpcEndpointAwsService('finspace');
InterfaceVpcEndpointAwsService.FINSPACE_API = new InterfaceVpcEndpointAwsService('finspace-api');
InterfaceVpcEndpointAwsService.FORECAST = new InterfaceVpcEndpointAwsService('forecast');
InterfaceVpcEndpointAwsService.FORECAST_QUERY = new InterfaceVpcEndpointAwsService('forecastquery');
InterfaceVpcEndpointAwsService.FORECAST_FIPS = new InterfaceVpcEndpointAwsService('forecast-fips');
InterfaceVpcEndpointAwsService.FORECAST_QUERY_FIPS = new InterfaceVpcEndpointAwsService('forecastquery-fips');
InterfaceVpcEndpointAwsService.FRAUD_DETECTOR = new InterfaceVpcEndpointAwsService('frauddetector');
InterfaceVpcEndpointAwsService.FSX = new InterfaceVpcEndpointAwsService('fsx');
InterfaceVpcEndpointAwsService.FSX_FIPS = new InterfaceVpcEndpointAwsService('fsx-fips');
InterfaceVpcEndpointAwsService.CODECOMMIT_GIT = new InterfaceVpcEndpointAwsService('git-codecommit');
InterfaceVpcEndpointAwsService.CODECOMMIT_GIT_FIPS = new InterfaceVpcEndpointAwsService('git-codecommit-fips');
InterfaceVpcEndpointAwsService.GLUE = new InterfaceVpcEndpointAwsService('glue');
InterfaceVpcEndpointAwsService.GLUE_DATABREW = new InterfaceVpcEndpointAwsService('databrew');
InterfaceVpcEndpointAwsService.GRAFANA = new InterfaceVpcEndpointAwsService('grafana');
InterfaceVpcEndpointAwsService.GRAFANA_WORKSPACE = new InterfaceVpcEndpointAwsService('grafana-workspace');
InterfaceVpcEndpointAwsService.GROUNDSTATION = new InterfaceVpcEndpointAwsService('groundstation');
InterfaceVpcEndpointAwsService.HEALTHLAKE = new InterfaceVpcEndpointAwsService('healthlake');
InterfaceVpcEndpointAwsService.IAM_IDENTITY_CENTER = new InterfaceVpcEndpointAwsService('identitystore');
InterfaceVpcEndpointAwsService.IAM_ROLES_ANYWHERE = new InterfaceVpcEndpointAwsService('rolesanywhere');
InterfaceVpcEndpointAwsService.INSPECTOR = new InterfaceVpcEndpointAwsService('inspector2');
InterfaceVpcEndpointAwsService.IOT_CORE = new InterfaceVpcEndpointAwsService('iot.data');
InterfaceVpcEndpointAwsService.IOT_CORE_DEVICE_ADVISOR = new InterfaceVpcEndpointAwsService('deviceadvisor.iot');
InterfaceVpcEndpointAwsService.IOT_CORE_FOR_LORAWAN = new InterfaceVpcEndpointAwsService('iotwireless.api');
InterfaceVpcEndpointAwsService.IOT_LORAWAN_CUPS = new InterfaceVpcEndpointAwsService('lorawan.cups');
InterfaceVpcEndpointAwsService.IOT_LORAWAN_LNS = new InterfaceVpcEndpointAwsService('lorawan.lns');
InterfaceVpcEndpointAwsService.IOT_GREENGRASS = new InterfaceVpcEndpointAwsService('greengrass');
InterfaceVpcEndpointAwsService.IOT_ROBORUNNER = new InterfaceVpcEndpointAwsService('iotroborunner');
InterfaceVpcEndpointAwsService.IOT_SITEWISE_API = new InterfaceVpcEndpointAwsService('iotsitewise.api');
InterfaceVpcEndpointAwsService.IOT_SITEWISE_DATA = new InterfaceVpcEndpointAwsService('iotsitewise.data');
InterfaceVpcEndpointAwsService.IOT_TWINMAKER_API = new InterfaceVpcEndpointAwsService('iottwinmaker.api');
InterfaceVpcEndpointAwsService.IOT_TWINMAKER_DATA = new InterfaceVpcEndpointAwsService('iottwinmaker.data');
InterfaceVpcEndpointAwsService.KENDRA = new InterfaceVpcEndpointAwsService('kendra');
InterfaceVpcEndpointAwsService.KEYSPACES = new InterfaceVpcEndpointAwsService('cassandra', '', 9142);
InterfaceVpcEndpointAwsService.KEYSPACES_FIPS = new InterfaceVpcEndpointAwsService('cassandra-fips', '', 9142);
InterfaceVpcEndpointAwsService.KINESIS_STREAMS = new InterfaceVpcEndpointAwsService('kinesis-streams');
InterfaceVpcEndpointAwsService.KINESIS_FIREHOSE = new InterfaceVpcEndpointAwsService('kinesis-firehose');
InterfaceVpcEndpointAwsService.KMS = new InterfaceVpcEndpointAwsService('kms');
InterfaceVpcEndpointAwsService.KMS_FIPS = new InterfaceVpcEndpointAwsService('kms-fips');
InterfaceVpcEndpointAwsService.LAKE_FORMATION = new InterfaceVpcEndpointAwsService('lakeformation');
InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS = new InterfaceVpcEndpointAwsService('logs');
InterfaceVpcEndpointAwsService.CLOUDWATCH = new InterfaceVpcEndpointAwsService('monitoring');
InterfaceVpcEndpointAwsService.LAMBDA = new InterfaceVpcEndpointAwsService('lambda');
InterfaceVpcEndpointAwsService.LEX_MODELS = new InterfaceVpcEndpointAwsService('models-v2-lex');
InterfaceVpcEndpointAwsService.LEX_RUNTIME = new InterfaceVpcEndpointAwsService('runtime-v2-lex');
InterfaceVpcEndpointAwsService.LICENSE_MANAGER = new InterfaceVpcEndpointAwsService('license-manager');
InterfaceVpcEndpointAwsService.LICENSE_MANAGER_FIPS = new InterfaceVpcEndpointAwsService('license-manager-fips');
InterfaceVpcEndpointAwsService.LOOKOUT_EQUIPMENT = new InterfaceVpcEndpointAwsService('lookoutequipment');
InterfaceVpcEndpointAwsService.LOOKOUT_METRICS = new InterfaceVpcEndpointAwsService('lookoutmetrics');
InterfaceVpcEndpointAwsService.LOOKOUT_VISION = new InterfaceVpcEndpointAwsService('lookoutvision');
InterfaceVpcEndpointAwsService.MACIE = new InterfaceVpcEndpointAwsService('macie2');
InterfaceVpcEndpointAwsService.MAINFRAME_MODERNIZATION = new InterfaceVpcEndpointAwsService('m2');
InterfaceVpcEndpointAwsService.PROMETHEUS = new InterfaceVpcEndpointAwsService('aps');
InterfaceVpcEndpointAwsService.PROMETHEUS_WORKSPACES = new InterfaceVpcEndpointAwsService('aps-workspaces');
InterfaceVpcEndpointAwsService.AIRFLOW_API = new InterfaceVpcEndpointAwsService('airflow.api');
InterfaceVpcEndpointAwsService.AIRFLOW_ENV = new InterfaceVpcEndpointAwsService('airflow.env');
InterfaceVpcEndpointAwsService.AIRFLOW_OPS = new InterfaceVpcEndpointAwsService('airflow.ops');
InterfaceVpcEndpointAwsService.MEMORY_DB = new InterfaceVpcEndpointAwsService('memory-db');
InterfaceVpcEndpointAwsService.MEMORY_DB_FIPS = new InterfaceVpcEndpointAwsService('memorydb-fips');
InterfaceVpcEndpointAwsService.MIGRATIONHUB_ORCHESTRATOR = new InterfaceVpcEndpointAwsService('migrationhub-orchestrator');
InterfaceVpcEndpointAwsService.MIGRATIONHUB_REFACTOR_SPACES = new InterfaceVpcEndpointAwsService('refactor-spaces');
InterfaceVpcEndpointAwsService.MIGRATIONHUB_STRATEGY = new InterfaceVpcEndpointAwsService('migrationhub-strategy');
InterfaceVpcEndpointAwsService.NIMBLE_STUDIO = new InterfaceVpcEndpointAwsService('nimble');
InterfaceVpcEndpointAwsService.OMICS_ANALYTICS = new InterfaceVpcEndpointAwsService('analytics-omics');
InterfaceVpcEndpointAwsService.OMICS_CONTROL_STORAGE = new InterfaceVpcEndpointAwsService('control-storage-omics');
InterfaceVpcEndpointAwsService.OMICS_STORAGE = new InterfaceVpcEndpointAwsService('storage-omics');
InterfaceVpcEndpointAwsService.OMICS_TAGS = new InterfaceVpcEndpointAwsService('tags-omics');
InterfaceVpcEndpointAwsService.OMICS_WORKFLOWS = new InterfaceVpcEndpointAwsService('workflows-omics');
InterfaceVpcEndpointAwsService.PANORAMA = new InterfaceVpcEndpointAwsService('panorama');
InterfaceVpcEndpointAwsService.PINPOINT = new InterfaceVpcEndpointAwsService('pinpoint-sms-voice-v2');
InterfaceVpcEndpointAwsService.POLLY = new InterfaceVpcEndpointAwsService('polly');
InterfaceVpcEndpointAwsService.PRIVATE_5G = new InterfaceVpcEndpointAwsService('private-networks');
InterfaceVpcEndpointAwsService.PROTON = new InterfaceVpcEndpointAwsService('proton');
InterfaceVpcEndpointAwsService.QLDB = new InterfaceVpcEndpointAwsService('qldb.session');
InterfaceVpcEndpointAwsService.RDS = new InterfaceVpcEndpointAwsService('rds');
InterfaceVpcEndpointAwsService.RDS_DATA = new InterfaceVpcEndpointAwsService('rds-data');
InterfaceVpcEndpointAwsService.ROBOMAKER = new InterfaceVpcEndpointAwsService('robomaker');
InterfaceVpcEndpointAwsService.REDSHIFT = new InterfaceVpcEndpointAwsService('redshift');
InterfaceVpcEndpointAwsService.REDSHIFT_FIPS = new InterfaceVpcEndpointAwsService('redshift-fips');
InterfaceVpcEndpointAwsService.REDSHIFT_DATA = new InterfaceVpcEndpointAwsService('redshift-data');
InterfaceVpcEndpointAwsService.S3 = new InterfaceVpcEndpointAwsService('s3');
InterfaceVpcEndpointAwsService.S3_MULTI_REGION_ACCESS_POINTS = new InterfaceVpcEndpointAwsService('s3-global.accesspoint', 'com.amazonaws');
InterfaceVpcEndpointAwsService.S3_OUTPOSTS = new InterfaceVpcEndpointAwsService('s3-outposts');
InterfaceVpcEndpointAwsService.SAGEMAKER_API = new InterfaceVpcEndpointAwsService('sagemaker.api');
InterfaceVpcEndpointAwsService.SAGEMAKER_FEATURESTORE_RUNTIME = new InterfaceVpcEndpointAwsService('sagemaker.featurestore-runtime');
InterfaceVpcEndpointAwsService.SAGEMAKER_METRICS = new InterfaceVpcEndpointAwsService('sagemaker.metrics');
InterfaceVpcEndpointAwsService.SAGEMAKER_RUNTIME = new InterfaceVpcEndpointAwsService('sagemaker.runtime');
InterfaceVpcEndpointAwsService.SAGEMAKER_RUNTIME_FIPS = new InterfaceVpcEndpointAwsService('sagemaker.runtime-fips');
InterfaceVpcEndpointAwsService.SECRETS_MANAGER = new InterfaceVpcEndpointAwsService('secretsmanager');
InterfaceVpcEndpointAwsService.SERVICE_CATALOG = new InterfaceVpcEndpointAwsService('servicecatalog');
InterfaceVpcEndpointAwsService.SERVICE_CATALOG_APPREGISTRY = new InterfaceVpcEndpointAwsService('servicecatalog-appregistry');
InterfaceVpcEndpointAwsService.SERVER_MIGRATION_SERVICE = new InterfaceVpcEndpointAwsService('sms');
InterfaceVpcEndpointAwsService.SERVER_MIGRATION_SERVICE_FIPS = new InterfaceVpcEndpointAwsService('sms-fips');
InterfaceVpcEndpointAwsService.SERVER_MIGRATION_SERVICE_AWSCONNECTOR = new InterfaceVpcEndpointAwsService('awsconnector');
InterfaceVpcEndpointAwsService.SES = new InterfaceVpcEndpointAwsService('email-smtp');
InterfaceVpcEndpointAwsService.SNS = new InterfaceVpcEndpointAwsService('sns');
InterfaceVpcEndpointAwsService.SQS = new InterfaceVpcEndpointAwsService('sqs');
InterfaceVpcEndpointAwsService.SSM = new InterfaceVpcEndpointAwsService('ssm');
InterfaceVpcEndpointAwsService.SSM_MESSAGES = new InterfaceVpcEndpointAwsService('ssmmessages');
InterfaceVpcEndpointAwsService.SSM_CONTACTS = new InterfaceVpcEndpointAwsService('ssm-contacts');
InterfaceVpcEndpointAwsService.SSM_INCIDENTS = new InterfaceVpcEndpointAwsService('ssm-incidents');
InterfaceVpcEndpointAwsService.STS = new InterfaceVpcEndpointAwsService('sts');
InterfaceVpcEndpointAwsService.SNOW_DEVICE_MANAGEMENT = new InterfaceVpcEndpointAwsService('snow-device-management');
InterfaceVpcEndpointAwsService.TEXTRACT = new InterfaceVpcEndpointAwsService('textract');
InterfaceVpcEndpointAwsService.TEXTRACT_FIPS = new InterfaceVpcEndpointAwsService('textract-fips');
InterfaceVpcEndpointAwsService.TRANSFER = new InterfaceVpcEndpointAwsService('transfer');
InterfaceVpcEndpointAwsService.TRANSFER_SERVER = new InterfaceVpcEndpointAwsService('transfer.server');
InterfaceVpcEndpointAwsService.TRANSLATE = new InterfaceVpcEndpointAwsService('translate');
InterfaceVpcEndpointAwsService.STORAGE_GATEWAY = new InterfaceVpcEndpointAwsService('storagegateway');
InterfaceVpcEndpointAwsService.REKOGNITION = new InterfaceVpcEndpointAwsService('rekognition');
InterfaceVpcEndpointAwsService.REKOGNITION_FIPS = new InterfaceVpcEndpointAwsService('rekognition-fips');
InterfaceVpcEndpointAwsService.STEP_FUNCTIONS = new InterfaceVpcEndpointAwsService('states');
InterfaceVpcEndpointAwsService.STEP_FUNCTIONS_SYNC = new InterfaceVpcEndpointAwsService('sync-states');
InterfaceVpcEndpointAwsService.TRANSCRIBE = new InterfaceVpcEndpointAwsService('transcribe');
InterfaceVpcEndpointAwsService.TRANSCRIBE_STREAMING = new InterfaceVpcEndpointAwsService('transcribestreaming');
InterfaceVpcEndpointAwsService.WORKSPACES = new InterfaceVpcEndpointAwsService('workspaces');
InterfaceVpcEndpointAwsService.XRAY = new InterfaceVpcEndpointAwsService('xray');
InterfaceVpcEndpointAwsService.SECURITYHUB = new InterfaceVpcEndpointAwsService('securityhub');
InterfaceVpcEndpointAwsService.EMAIL_SMTP = new InterfaceVpcEndpointAwsService('email-smtp');
exports.InterfaceVpcEndpointAwsService = InterfaceVpcEndpointAwsService;
/**
 * A interface VPC endpoint.
 * @resource AWS::EC2::VPCEndpoint
 */
class InterfaceVpcEndpoint extends VpcEndpoint {
    /**
     * Imports an existing interface VPC endpoint.
     */
    static fromInterfaceVpcEndpointAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InterfaceVpcEndpointAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromInterfaceVpcEndpointAttributes);
            }
            throw error;
        }
        const securityGroups = attrs.securityGroupId
            ? [security_group_1.SecurityGroup.fromSecurityGroupId(scope, 'SecurityGroup', attrs.securityGroupId)]
            : attrs.securityGroups;
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcEndpointId = attrs.vpcEndpointId;
                this.connections = new connections_1.Connections({
                    defaultPort: port_1.Port.tcp(attrs.port),
                    securityGroups,
                });
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InterfaceVpcEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InterfaceVpcEndpoint);
            }
            throw error;
        }
        const securityGroups = props.securityGroups || [new security_group_1.SecurityGroup(this, 'SecurityGroup', {
                vpc: props.vpc,
            })];
        this.securityGroupId = securityGroups[0].securityGroupId;
        this.connections = new connections_1.Connections({
            defaultPort: port_1.Port.tcp(props.service.port),
            securityGroups,
        });
        if (props.open !== false) {
            this.connections.allowDefaultPortFrom(peer_1.Peer.ipv4(props.vpc.vpcCidrBlock));
        }
        // Determine which subnets to place the endpoint in
        const subnetIds = this.endpointSubnets(props);
        const endpoint = new ec2_generated_1.CfnVPCEndpoint(this, 'Resource', {
            privateDnsEnabled: props.privateDnsEnabled ?? props.service.privateDnsDefault ?? true,
            policyDocument: core_1.Lazy.any({ produce: () => this.policyDocument }),
            securityGroupIds: securityGroups.map(s => s.securityGroupId),
            serviceName: props.service.name,
            vpcEndpointType: VpcEndpointType.INTERFACE,
            subnetIds,
            vpcId: props.vpc.vpcId,
        });
        this.vpcEndpointId = endpoint.ref;
        this.vpcEndpointCreationTimestamp = endpoint.attrCreationTimestamp;
        this.vpcEndpointDnsEntries = endpoint.attrDnsEntries;
        this.vpcEndpointNetworkInterfaceIds = endpoint.attrNetworkInterfaceIds;
    }
    /**
     * Determine which subnets to place the endpoint in. This is in its own function
     * because there's a lot of code.
     */
    endpointSubnets(props) {
        const lookupSupportedAzs = props.lookupSupportedAzs ?? false;
        const subnetSelection = props.vpc.selectSubnets({ ...props.subnets, onePerAz: true });
        const subnets = subnetSelection.subnets;
        // Sanity check the subnet count
        if (!subnetSelection.isPendingLookup && subnetSelection.subnets.length == 0) {
            throw new Error('Cannot create a VPC Endpoint with no subnets');
        }
        // If we aren't going to lookup supported AZs we'll exit early, returning the subnetIds from the provided subnet selection
        if (!lookupSupportedAzs) {
            return subnetSelection.subnetIds;
        }
        // Some service names, such as AWS service name references, use Tokens to automatically fill in the region
        // If it is an InterfaceVpcEndpointAwsService, then the reference will be resolvable since it only references the region
        const isAwsService = core_1.Token.isUnresolved(props.service.name) && props.service instanceof InterfaceVpcEndpointAwsService;
        // Determine what service name gets pass to the context provider
        // If it is an AWS service it will have a REGION token
        const lookupServiceName = isAwsService ? core_1.Stack.of(this).resolve(props.service.name) : props.service.name;
        // Check that the lookup will work
        this.validateCanLookupSupportedAzs(subnets, lookupServiceName);
        // Do the actual lookup for AZs
        const availableAZs = this.availableAvailabilityZones(lookupServiceName);
        const filteredSubnets = subnets.filter(s => availableAZs.includes(s.availabilityZone));
        // Throw an error if the lookup filtered out all subnets
        // VpcEndpoints must be created with at least one AZ
        if (filteredSubnets.length == 0) {
            throw new Error(`lookupSupportedAzs returned ${availableAZs} but subnets have AZs ${subnets.map(s => s.availabilityZone)}`);
        }
        return filteredSubnets.map(s => s.subnetId);
    }
    /**
     * Sanity checking when looking up AZs for an endpoint service, to make sure it won't fail
     */
    validateCanLookupSupportedAzs(subnets, serviceName) {
        // Having any of these be true will cause the AZ lookup to fail at synthesis time
        const agnosticAcct = core_1.Token.isUnresolved(this.env.account);
        const agnosticRegion = core_1.Token.isUnresolved(this.env.region);
        const agnosticService = core_1.Token.isUnresolved(serviceName);
        // Having subnets with Token AZs can cause the endpoint to be created with no subnets, failing at deployment time
        const agnosticSubnets = subnets.some(s => core_1.Token.isUnresolved(s.availabilityZone));
        const agnosticSubnetList = core_1.Token.isUnresolved(subnets.map(s => s.availabilityZone));
        // Context provider cannot make an AWS call without an account/region
        if (agnosticAcct || agnosticRegion) {
            throw new Error('Cannot look up VPC endpoint availability zones if account/region are not specified');
        }
        // The AWS call will fail if there is a Token in the service name
        if (agnosticService) {
            throw new Error(`Cannot lookup AZs for a service name with a Token: ${serviceName}`);
        }
        // The AWS call return strings for AZs, like us-east-1a, us-east-1b, etc
        // If the subnet AZs are Tokens, a string comparison between the subnet AZs and the AZs from the AWS call
        // will not match
        if (agnosticSubnets || agnosticSubnetList) {
            const agnostic = subnets.filter(s => core_1.Token.isUnresolved(s.availabilityZone));
            throw new Error(`lookupSupportedAzs cannot filter on subnets with Token AZs: ${agnostic}`);
        }
    }
    availableAvailabilityZones(serviceName) {
        // Here we check what AZs the endpoint service is available in
        // If for whatever reason we can't retrieve the AZs, and no context is set,
        // we will fall back to all AZs
        const availableAZs = core_1.ContextProvider.getValue(this, {
            provider: cxschema.ContextProvider.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER,
            dummyValue: this.stack.availabilityZones,
            props: { serviceName },
        }).value;
        if (!Array.isArray(availableAZs)) {
            throw new Error(`Discovered AZs for endpoint service ${serviceName} must be an array`);
        }
        return availableAZs;
    }
}
_f = JSII_RTTI_SYMBOL_1;
InterfaceVpcEndpoint[_f] = { fqn: "aws-cdk-lib.aws_ec2.InterfaceVpcEndpoint", version: "2.74.0" };
exports.InterfaceVpcEndpoint = InterfaceVpcEndpoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidnBjLWVuZHBvaW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidnBjLWVuZHBvaW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHFDQUFxQztBQUNyQyx3REFBd0Q7QUFDeEQscUNBQTJGO0FBRTNGLCtDQUEwRDtBQUMxRCxtREFBaUQ7QUFDakQsaUNBQThCO0FBQzlCLGlDQUE4QjtBQUM5QixxREFBaUU7QUFDakUsaUNBQW1EO0FBY25ELE1BQXNCLFdBQVksU0FBUSxlQUFRO0lBS2hEOzs7Ozs7OztPQVFHO0lBQ0ksV0FBVyxDQUFDLFNBQThCOzs7Ozs7Ozs7O1FBQy9DLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxFQUFFO1lBQzNCLE1BQU0sSUFBSSxLQUFLLENBQUMsb0NBQW9DLENBQUMsQ0FBQztTQUN2RDtRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxFQUFFO1lBQ3hCLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxHQUFHLENBQUMsY0FBYyxFQUFFLENBQUM7U0FDaEQ7UUFFRCxJQUFJLENBQUMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQztLQUM5Qzs7OztBQXhCbUIsa0NBQVc7QUFpQ2pDOztHQUVHO0FBQ0gsSUFBWSxlQWlCWDtBQWpCRCxXQUFZLGVBQWU7SUFDekI7Ozs7OztPQU1HO0lBQ0gsMENBQXVCLENBQUE7SUFFdkI7Ozs7O09BS0c7SUFDSCxzQ0FBbUIsQ0FBQTtBQUNyQixDQUFDLEVBakJXLGVBQWUsR0FBZix1QkFBZSxLQUFmLHVCQUFlLFFBaUIxQjtBQVlEOztHQUVHO0FBQ0gsTUFBYSw0QkFBNEI7SUFTdkMsWUFBWSxJQUFZLEVBQUUsTUFBZTtRQUN2QyxJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsTUFBTSxJQUFJLGVBQWUsSUFBSSxVQUFHLENBQUMsTUFBTSxJQUFJLElBQUksRUFBRSxDQUFDO0tBQ2xFOzs7O0FBVnNCLHFDQUFRLEdBQUcsSUFBSSw0QkFBNEIsQ0FBQyxVQUFVLENBQUMsQ0FBQztBQUN4RCwrQkFBRSxHQUFHLElBQUksNEJBQTRCLENBQUMsSUFBSSxDQUFDLENBQUM7QUFGeEQsb0VBQTRCO0FBeUR6Qzs7O0dBR0c7QUFDSCxNQUFhLGtCQUFtQixTQUFRLFdBQVc7SUFFMUMsTUFBTSxDQUFDLHdCQUF3QixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLG9CQUE0QjtRQUMvRixNQUFNLE1BQU8sU0FBUSxXQUFXO1lBQWhDOztnQkFDUyxrQkFBYSxHQUFHLG9CQUFvQixDQUFDO1lBQzlDLENBQUM7U0FBQTtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQzlCO0lBdUJELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBOEI7UUFDdEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQWhDUixrQkFBa0I7Ozs7UUFrQzNCLE1BQU0sT0FBTyxHQUFjLEtBQUssQ0FBQyxPQUFPO1lBQ3RDLENBQUMsQ0FBQyxJQUFBLGNBQU8sRUFBQyxLQUFLLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ3JFLENBQUMsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDNUYsTUFBTSxhQUFhLEdBQUcsSUFBQSx1QkFBZ0IsRUFBQyxPQUFPLENBQUMsQ0FBQztRQUVoRCxJQUFJLGFBQWEsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQzlCLE1BQU0sSUFBSSxLQUFLLENBQUMseUVBQXlFLENBQUMsQ0FBQztTQUM1RjtRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksOEJBQWMsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BELGNBQWMsRUFBRSxXQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUNoRSxhQUFhO1lBQ2IsV0FBVyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSTtZQUMvQixlQUFlLEVBQUUsZUFBZSxDQUFDLE9BQU87WUFDeEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsS0FBSztTQUN2QixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7UUFDbEMsSUFBSSxDQUFDLDRCQUE0QixHQUFHLFFBQVEsQ0FBQyxxQkFBcUIsQ0FBQztRQUNuRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsUUFBUSxDQUFDLGNBQWMsQ0FBQztRQUNyRCxJQUFJLENBQUMsOEJBQThCLEdBQUcsUUFBUSxDQUFDLHVCQUF1QixDQUFDO0tBQ3hFOzs7O0FBdkRVLGdEQUFrQjtBQThFL0I7O0dBRUc7QUFDSCxNQUFhLDJCQUEyQjtJQWlCdEMsWUFBWSxJQUFZLEVBQUUsSUFBYTtRQUx2Qzs7V0FFRztRQUNhLHNCQUFpQixHQUFhLEtBQUssQ0FBQztRQUdsRCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUNqQixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksSUFBSSxHQUFHLENBQUM7S0FDekI7Ozs7QUFwQlUsa0VBQTJCO0FBdUJ4Qzs7R0FFRztBQUNILE1BQWEsOEJBQThCO0lBa096QyxZQUFZLElBQVksRUFBRSxNQUFlLEVBQUUsSUFBYTtRQUx4RDs7V0FFRztRQUNhLHNCQUFpQixHQUFhLElBQUksQ0FBQztRQUdqRCxNQUFNLE1BQU0sR0FBRyxXQUFJLENBQUMsY0FBYyxDQUFDO1lBQ2pDLE9BQU8sRUFBRSxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUMsWUFBSyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTTtTQUNyRCxDQUFDLENBQUM7UUFDSCxNQUFNLHFCQUFxQixHQUFHLFdBQUksQ0FBQyxjQUFjLENBQUM7WUFDaEQsT0FBTyxFQUFFLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0JBQ25CLE1BQU0sVUFBVSxHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQztnQkFDbEQsT0FBTyxJQUFJLENBQUMsd0JBQXdCLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1lBQ3pELENBQUM7U0FDRixDQUFDLENBQUM7UUFDSCxNQUFNLHFCQUFxQixHQUFHLFdBQUksQ0FBQyxjQUFjLENBQUM7WUFDaEQsT0FBTyxFQUFFLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0JBQ25CLE1BQU0sVUFBVSxHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQztnQkFDbEQsT0FBTyxJQUFJLENBQUMsd0JBQXdCLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1lBQ3pELENBQUM7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsTUFBTSxJQUFJLHFCQUFxQixJQUFJLE1BQU0sSUFBSSxJQUFJLEdBQUcscUJBQXFCLEVBQUUsQ0FBQztRQUMzRixJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQztRQUN0QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksSUFBSSxHQUFHLENBQUM7S0FDekI7SUFFRDs7Ozs7O09BTUc7SUFDSyx3QkFBd0IsQ0FBQyxJQUFZLEVBQUUsTUFBYztRQUMzRCxNQUFNLCtCQUErQixHQUFtQztZQUN0RSxZQUFZLEVBQUUsQ0FBQyx5QkFBeUIsRUFBRSxRQUFRLEVBQUUsYUFBYSxFQUFFLGNBQWMsRUFBRSxXQUFXO2dCQUM1RixnQkFBZ0IsRUFBRSw0QkFBNEIsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsU0FBUyxFQUFFLFNBQVM7Z0JBQ3JHLGtCQUFrQixFQUFFLG1CQUFtQixFQUFFLHdCQUF3QixFQUFFLGFBQWEsRUFBRSxjQUFjO2dCQUNoRyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxpQkFBaUIsRUFBRSxRQUFRLEVBQUUsaUJBQWlCLEVBQUUsWUFBWTtnQkFDbkcsS0FBSyxFQUFFLFVBQVUsRUFBRSxlQUFlLEVBQUUsSUFBSSxFQUFFLGVBQWUsRUFBRSxnQ0FBZ0M7Z0JBQzNGLG1CQUFtQixFQUFFLGdCQUFnQixFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxZQUFZLEVBQUUsWUFBWTtnQkFDaEcscUJBQXFCLEVBQUUsVUFBVSxFQUFFLE1BQU0sQ0FBQztZQUM1QyxnQkFBZ0IsRUFBRSxDQUFDLHlCQUF5QixFQUFFLFFBQVEsRUFBRSxhQUFhLEVBQUUsY0FBYyxFQUFFLFdBQVc7Z0JBQ2hHLGdCQUFnQixFQUFFLDRCQUE0QixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRSxTQUFTLEVBQUUsU0FBUztnQkFDckcsa0JBQWtCLEVBQUUsbUJBQW1CLEVBQUUsd0JBQXdCLEVBQUUsYUFBYSxFQUFFLGNBQWM7Z0JBQ2hHLGlCQUFpQixFQUFFLFFBQVEsRUFBRSxpQkFBaUIsRUFBRSxZQUFZLEVBQUUsS0FBSyxFQUFFLFVBQVUsRUFBRSxlQUFlLEVBQUUsSUFBSTtnQkFDdEcsZUFBZSxFQUFFLGdDQUFnQyxFQUFFLG1CQUFtQixFQUFFLGdCQUFnQixFQUFFLEtBQUssRUFBRSxLQUFLO2dCQUN0RyxRQUFRLEVBQUUsS0FBSyxFQUFFLFlBQVksRUFBRSxZQUFZLEVBQUUscUJBQXFCLEVBQUUsVUFBVSxFQUFFLFlBQVksRUFBRSxNQUFNLENBQUM7U0FDeEcsQ0FBQztRQUNGLElBQUksK0JBQStCLENBQUMsTUFBTSxDQUFDLEVBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFO1lBQzNELE9BQU8sa0JBQWtCLENBQUM7U0FDM0I7YUFBTTtZQUNMLE9BQU8sZUFBZSxDQUFDO1NBQ3hCO0tBQ0Y7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSyx3QkFBd0IsQ0FBQyxJQUFZLEVBQUUsTUFBYztRQUMzRCxNQUFNLCtCQUErQixHQUFtQztZQUN0RSxZQUFZLEVBQUUsQ0FBQyxZQUFZLENBQUM7WUFDNUIsZ0JBQWdCLEVBQUUsQ0FBQyxZQUFZLENBQUM7U0FDakMsQ0FBQztRQUNGLE9BQU8sK0JBQStCLENBQUMsTUFBTSxDQUFDLEVBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztLQUM3RTs7OztBQXJTc0IsK0NBQWdCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxRQUFRLEVBQUUsZUFBZSxDQUFDLEFBQWhFLENBQWlFO0FBQ2pGLGlEQUFrQixHQUFHLElBQUksOEJBQThCLENBQUMsVUFBVSxFQUFFLGVBQWUsQ0FBQyxBQUFsRSxDQUFtRTtBQUNyRiw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsZ0JBQWdCLEVBQUUsU0FBUyxDQUFDLEFBQWxFLENBQW1FO0FBQ2pGLDhDQUFlLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxpQkFBaUIsQ0FBQyxBQUF4RCxDQUF5RDtBQUN4RSxpREFBa0IsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFNBQVMsQ0FBQyxBQUFoRCxDQUFpRDtBQUNuRSx1Q0FBUSxHQUFHLElBQUksOEJBQThCLENBQUMsMEJBQTBCLENBQUMsQUFBakUsQ0FBa0U7QUFDMUUseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFdBQVcsQ0FBQyxBQUFsRCxDQUFtRDtBQUM3RCxrREFBbUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLG9CQUFvQixDQUFDLEFBQTNELENBQTREO0FBQy9FLDREQUE2QixHQUFHLElBQUksOEJBQThCLENBQUMsS0FBSyxDQUFDLEFBQTVDLENBQTZDO0FBQzFFLDRDQUFhLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxlQUFlLENBQUMsQUFBdEQsQ0FBdUQ7QUFDcEUsa0RBQW1CLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxxQkFBcUIsQ0FBQyxBQUE1RCxDQUE2RDtBQUNoRixxQ0FBTSxHQUFHLElBQUksOEJBQThCLENBQUMsUUFBUSxDQUFDLEFBQS9DLENBQWdEO0FBQ3RELDRDQUFhLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxjQUFjLENBQUMsQUFBckQsQ0FBc0Q7QUFDbkUsc0RBQXVCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyx5QkFBeUIsQ0FBQyxBQUFoRSxDQUFpRTtBQUN4RiwwQ0FBVyxHQUFHLElBQUksOEJBQThCLENBQUMsYUFBYSxDQUFDLEFBQXBELENBQXFEO0FBQ2hFLGdEQUFpQixHQUFHLElBQUksOEJBQThCLENBQUMsbUJBQW1CLENBQUMsQUFBMUQsQ0FBMkQ7QUFDNUUscUNBQU0sR0FBRyxJQUFJLDhCQUE4QixDQUFDLFFBQVEsQ0FBQyxBQUEvQyxDQUFnRDtBQUN0RCw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsZ0JBQWdCLENBQUMsQUFBdkQsQ0FBd0Q7QUFDdEUsb0NBQUssR0FBRyxJQUFJLDhCQUE4QixDQUFDLE9BQU8sQ0FBQyxBQUE5QyxDQUErQztBQUNwRCxnREFBaUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGtCQUFrQixDQUFDLEFBQXpELENBQTBEO0FBQzNFLHFDQUFNLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxRQUFRLENBQUMsQUFBL0MsQ0FBZ0Q7QUFDdEQsNERBQTZCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxTQUFTLENBQUMsQUFBaEQsQ0FBaUQ7QUFDOUUsZ0RBQWlCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxpQkFBaUIsQ0FBQyxBQUF4RCxDQUF5RDtBQUMxRSxxREFBc0IsR0FBRyxJQUFJLDhCQUE4QixDQUFDLHNCQUFzQixDQUFDLEFBQTdELENBQThEO0FBQ3BGLDhDQUFlLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxnQkFBZ0IsQ0FBQyxBQUF2RCxDQUF3RDtBQUN2RSw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsZ0JBQWdCLENBQUMsQUFBdkQsQ0FBd0Q7QUFDdEUsdUNBQVEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQUM1RCx5Q0FBVSxHQUFHLElBQUksOEJBQThCLENBQUMsWUFBWSxDQUFDLEFBQW5ELENBQW9EO0FBQzlELG1EQUFvQixHQUFHLElBQUksOEJBQThCLENBQUMsV0FBVyxDQUFDLEFBQWxELENBQW1EO0FBQ3ZFLDZEQUE4QixHQUFHLElBQUksOEJBQThCLENBQUMscUJBQXFCLENBQUMsQUFBNUQsQ0FBNkQ7QUFDM0Ysb0RBQXFCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxZQUFZLENBQUMsQUFBbkQsQ0FBb0Q7QUFDekUsNkNBQWMsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUMzRCx1REFBd0IsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGVBQWUsQ0FBQyxBQUF0RCxDQUF1RDtBQUMvRSxvREFBcUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQUN6RSwrQ0FBZ0IsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGtCQUFrQixDQUFDLEFBQXpELENBQTBEO0FBQzFFLHdEQUF5QixHQUFHLElBQUksOEJBQThCLENBQUMsMkJBQTJCLENBQUMsQUFBbEUsQ0FBbUU7QUFDNUYsd0NBQVMsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFdBQVcsQ0FBQyxBQUFsRCxDQUFtRDtBQUM1RCw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsZ0JBQWdCLENBQUMsQUFBdkQsQ0FBd0Q7QUFDdEUseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQUM5RCw4Q0FBZSxHQUFHLElBQUksOEJBQThCLENBQUMsaUJBQWlCLENBQUMsQUFBeEQsQ0FBeUQ7QUFDeEUseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQUM5RCx5REFBMEIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLDRCQUE0QixDQUFDLEFBQW5FLENBQW9FO0FBQzlGLGdEQUFpQixHQUFHLElBQUksOEJBQThCLENBQUMsbUJBQW1CLENBQUMsQUFBMUQsQ0FBMkQ7QUFDNUUsZ0RBQWlCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxtQkFBbUIsQ0FBQyxBQUExRCxDQUEyRDtBQUM1RSwyQ0FBWSxHQUFHLElBQUksOEJBQThCLENBQUMsY0FBYyxDQUFDLEFBQXJELENBQXNEO0FBQ2xFLG1EQUFvQixHQUFHLElBQUksOEJBQThCLENBQUMsMEJBQTBCLENBQUMsQUFBakUsQ0FBa0U7QUFDdEYseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQUM5RCxpREFBa0IsR0FBRyxJQUFJLDhCQUE4QixDQUFDLG1CQUFtQixDQUFDLEFBQTFELENBQTJEO0FBQzdFLHFDQUFNLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxRQUFRLENBQUMsQUFBL0MsQ0FBZ0Q7QUFDdEQsdURBQXdCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxrQkFBa0IsQ0FBQyxBQUF6RCxDQUEwRDtBQUNsRiw0Q0FBYSxHQUFHLElBQUksOEJBQThCLENBQUMsT0FBTyxDQUFDLEFBQTlDLENBQStDO0FBQzVELHdEQUF5QixHQUFHLElBQUksOEJBQThCLENBQUMsbUJBQW1CLENBQUMsQUFBMUQsQ0FBMkQ7QUFDcEYsOENBQWUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFNBQVMsQ0FBQyxBQUFoRCxDQUFpRDtBQUNoRSw4Q0FBZSxHQUFHLElBQUksOEJBQThCLENBQUMsU0FBUyxDQUFDLEFBQWhELENBQWlEO0FBQ2hFLDZDQUFjLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxRQUFRLENBQUMsQUFBL0MsQ0FBZ0Q7QUFDOUQsNENBQWEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGNBQWMsQ0FBQyxBQUFyRCxDQUFzRDtBQUNuRSx5REFBMEIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUN2RSw4REFBK0IsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFVBQVUsQ0FBQyxBQUFqRCxDQUFrRDtBQUNqRix1Q0FBUSxHQUFHLElBQUksOEJBQThCLENBQUMsVUFBVSxDQUFDLEFBQWpELENBQWtEO0FBQzFELDBDQUFXLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxhQUFhLENBQUMsQUFBcEQsQ0FBcUQ7QUFDaEUseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUN2RCxrQ0FBRyxHQUFHLElBQUksOEJBQThCLENBQUMsS0FBSyxDQUFDLEFBQTVDLENBQTZDO0FBQ2hELDJDQUFZLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxhQUFhLENBQUMsQUFBcEQsQ0FBcUQ7QUFDakUsNENBQWEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGNBQWMsQ0FBQyxBQUFyRCxDQUFzRDtBQUNuRSxrQ0FBRyxHQUFHLElBQUksOEJBQThCLENBQUMsU0FBUyxDQUFDLEFBQWhELENBQWlEO0FBQ3BELHlDQUFVLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxTQUFTLENBQUMsQUFBaEQsQ0FBaUQ7QUFDM0Qsa0NBQUcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUNoRCx3Q0FBUyxHQUFHLElBQUksOEJBQThCLENBQUMsV0FBVyxDQUFDLEFBQWxELENBQW1EO0FBQzVELDRDQUFhLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxlQUFlLENBQUMsQUFBdEQsQ0FBdUQ7QUFDcEUsa0NBQUcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUNoRCxnREFBaUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGtCQUFrQixDQUFDLEFBQXpELENBQTBEO0FBQzNFLHVEQUF3QixHQUFHLElBQUksOEJBQThCLENBQUMseUJBQXlCLENBQUMsQUFBaEUsQ0FBaUU7QUFDekYsd0RBQXlCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxLQUFLLENBQUMsQUFBNUMsQ0FBNkM7QUFDdEUsaURBQWtCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxtQkFBbUIsQ0FBQyxBQUExRCxDQUEyRDtBQUM3RSxzREFBdUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLHdCQUF3QixDQUFDLEFBQS9ELENBQWdFO0FBQ3ZGLHdEQUF5QixHQUFHLElBQUksOEJBQThCLENBQUMsMkJBQTJCLENBQUMsQUFBbEUsQ0FBbUU7QUFDNUYscURBQXNCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxzQkFBc0IsQ0FBQyxBQUE3RCxDQUE4RDtBQUNwRiwwQ0FBVyxHQUFHLElBQUksOEJBQThCLENBQUMsYUFBYSxDQUFDLEFBQXBELENBQXFEO0FBQ2hFLCtDQUFnQixHQUFHLElBQUksOEJBQThCLENBQUMsa0JBQWtCLENBQUMsQUFBekQsQ0FBMEQ7QUFDMUUsa0NBQUcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGtCQUFrQixDQUFDLEFBQXpELENBQTBEO0FBQzdELHNDQUFPLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxnQkFBZ0IsQ0FBQyxBQUF2RCxDQUF3RDtBQUMvRCw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsZ0JBQWdCLENBQUMsQUFBdkQsQ0FBd0Q7QUFDdEUsZ0RBQWlCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxRQUFRLENBQUMsQUFBL0MsQ0FBZ0Q7QUFDakUsMENBQVcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFFBQVEsQ0FBQyxBQUEvQyxDQUFnRDtBQUMzRCx5Q0FBVSxHQUFHLElBQUksOEJBQThCLENBQUMsYUFBYSxDQUFDLEFBQXBELENBQXFEO0FBQy9ELHdEQUF5QixHQUFHLElBQUksOEJBQThCLENBQUMsS0FBSyxDQUFDLEFBQTVDLENBQTZDO0FBQ3RFLHVDQUFRLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxVQUFVLENBQUMsQUFBakQsQ0FBa0Q7QUFDMUQsMkNBQVksR0FBRyxJQUFJLDhCQUE4QixDQUFDLGNBQWMsQ0FBQyxBQUFyRCxDQUFzRDtBQUNsRSx1Q0FBUSxHQUFHLElBQUksOEJBQThCLENBQUMsVUFBVSxDQUFDLEFBQWpELENBQWtEO0FBQzFELDZDQUFjLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxlQUFlLENBQUMsQUFBdEQsQ0FBdUQ7QUFDckUsNENBQWEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGVBQWUsQ0FBQyxBQUF0RCxDQUF1RDtBQUNwRSxrREFBbUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLG9CQUFvQixDQUFDLEFBQTNELENBQTREO0FBQy9FLDZDQUFjLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxlQUFlLENBQUMsQUFBdEQsQ0FBdUQ7QUFDckUsa0NBQUcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUNoRCx1Q0FBUSxHQUFHLElBQUksOEJBQThCLENBQUMsVUFBVSxDQUFDLEFBQWpELENBQWtEO0FBQzFELDZDQUFjLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxnQkFBZ0IsQ0FBQyxBQUF2RCxDQUF3RDtBQUN0RSxrREFBbUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLHFCQUFxQixDQUFDLEFBQTVELENBQTZEO0FBQ2hGLG1DQUFJLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxNQUFNLENBQUMsQUFBN0MsQ0FBOEM7QUFDbEQsNENBQWEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFVBQVUsQ0FBQyxBQUFqRCxDQUFrRDtBQUMvRCxzQ0FBTyxHQUFHLElBQUksOEJBQThCLENBQUMsU0FBUyxDQUFDLEFBQWhELENBQWlEO0FBQ3hELGdEQUFpQixHQUFHLElBQUksOEJBQThCLENBQUMsbUJBQW1CLENBQUMsQUFBMUQsQ0FBMkQ7QUFDNUUsNENBQWEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGVBQWUsQ0FBQyxBQUF0RCxDQUF1RDtBQUNwRSx5Q0FBVSxHQUFHLElBQUksOEJBQThCLENBQUMsWUFBWSxDQUFDLEFBQW5ELENBQW9EO0FBQzlELGtEQUFtQixHQUFHLElBQUksOEJBQThCLENBQUMsZUFBZSxDQUFDLEFBQXRELENBQXVEO0FBQzFFLGlEQUFrQixHQUFHLElBQUksOEJBQThCLENBQUMsZUFBZSxDQUFDLEFBQXRELENBQXVEO0FBQ3pFLHdDQUFTLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxZQUFZLENBQUMsQUFBbkQsQ0FBb0Q7QUFDN0QsdUNBQVEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFVBQVUsQ0FBQyxBQUFqRCxDQUFrRDtBQUMxRCxzREFBdUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLG1CQUFtQixDQUFDLEFBQTFELENBQTJEO0FBQ2xGLG1EQUFvQixHQUFHLElBQUksOEJBQThCLENBQUMsaUJBQWlCLENBQUMsQUFBeEQsQ0FBeUQ7QUFDN0UsK0NBQWdCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxjQUFjLENBQUMsQUFBckQsQ0FBc0Q7QUFDdEUsOENBQWUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGFBQWEsQ0FBQyxBQUFwRCxDQUFxRDtBQUNwRSw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsWUFBWSxDQUFDLEFBQW5ELENBQW9EO0FBQ2xFLDZDQUFjLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxlQUFlLENBQUMsQUFBdEQsQ0FBdUQ7QUFDckUsK0NBQWdCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxpQkFBaUIsQ0FBQyxBQUF4RCxDQUF5RDtBQUN6RSxnREFBaUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGtCQUFrQixDQUFDLEFBQXpELENBQTBEO0FBQzNFLGdEQUFpQixHQUFHLElBQUksOEJBQThCLENBQUMsa0JBQWtCLENBQUMsQUFBekQsQ0FBMEQ7QUFDM0UsaURBQWtCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxtQkFBbUIsQ0FBQyxBQUExRCxDQUEyRDtBQUM3RSxxQ0FBTSxHQUFHLElBQUksOEJBQThCLENBQUMsUUFBUSxDQUFDLEFBQS9DLENBQWdEO0FBQ3RELHdDQUFTLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxXQUFXLEVBQUUsRUFBRSxFQUFFLElBQUksQ0FBQyxBQUE1RCxDQUE2RDtBQUN0RSw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsZ0JBQWdCLEVBQUUsRUFBRSxFQUFFLElBQUksQ0FBQyxBQUFqRSxDQUFrRTtBQUNoRiw4Q0FBZSxHQUFHLElBQUksOEJBQThCLENBQUMsaUJBQWlCLENBQUMsQUFBeEQsQ0FBeUQ7QUFDeEUsK0NBQWdCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxrQkFBa0IsQ0FBQyxBQUF6RCxDQUEwRDtBQUMxRSxrQ0FBRyxHQUFHLElBQUksOEJBQThCLENBQUMsS0FBSyxDQUFDLEFBQTVDLENBQTZDO0FBQ2hELHVDQUFRLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxVQUFVLENBQUMsQUFBakQsQ0FBa0Q7QUFDMUQsNkNBQWMsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGVBQWUsQ0FBQyxBQUF0RCxDQUF1RDtBQUNyRSw4Q0FBZSxHQUFHLElBQUksOEJBQThCLENBQUMsTUFBTSxDQUFDLEFBQTdDLENBQThDO0FBQzdELHlDQUFVLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxZQUFZLENBQUMsQUFBbkQsQ0FBb0Q7QUFDOUQscUNBQU0sR0FBRyxJQUFJLDhCQUE4QixDQUFDLFFBQVEsQ0FBQyxBQUEvQyxDQUFnRDtBQUN0RCx5Q0FBVSxHQUFHLElBQUksOEJBQThCLENBQUMsZUFBZSxDQUFDLEFBQXRELENBQXVEO0FBQ2pFLDBDQUFXLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxnQkFBZ0IsQ0FBQyxBQUF2RCxDQUF3RDtBQUNuRSw4Q0FBZSxHQUFHLElBQUksOEJBQThCLENBQUMsaUJBQWlCLENBQUMsQUFBeEQsQ0FBeUQ7QUFDeEUsbURBQW9CLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxzQkFBc0IsQ0FBQyxBQUE3RCxDQUE4RDtBQUNsRixnREFBaUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGtCQUFrQixDQUFDLEFBQXpELENBQTBEO0FBQzNFLDhDQUFlLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxnQkFBZ0IsQ0FBQyxBQUF2RCxDQUF3RDtBQUN2RSw2Q0FBYyxHQUFHLElBQUksOEJBQThCLENBQUMsZUFBZSxDQUFDLEFBQXRELENBQXVEO0FBQ3JFLG9DQUFLLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxRQUFRLENBQUMsQUFBL0MsQ0FBZ0Q7QUFDckQsc0RBQXVCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxJQUFJLENBQUMsQUFBM0MsQ0FBNEM7QUFDbkUseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUN2RCxvREFBcUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGdCQUFnQixDQUFDLEFBQXZELENBQXdEO0FBQzdFLDBDQUFXLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxhQUFhLENBQUMsQUFBcEQsQ0FBcUQ7QUFDaEUsMENBQVcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGFBQWEsQ0FBQyxBQUFwRCxDQUFxRDtBQUNoRSwwQ0FBVyxHQUFHLElBQUksOEJBQThCLENBQUMsYUFBYSxDQUFDLEFBQXBELENBQXFEO0FBQ2hFLHdDQUFTLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxXQUFXLENBQUMsQUFBbEQsQ0FBbUQ7QUFDNUQsNkNBQWMsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGVBQWUsQ0FBQyxBQUF0RCxDQUF1RDtBQUNyRSx3REFBeUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLDJCQUEyQixDQUFDLEFBQWxFLENBQW1FO0FBQzVGLDJEQUE0QixHQUFHLElBQUksOEJBQThCLENBQUMsaUJBQWlCLENBQUMsQUFBeEQsQ0FBeUQ7QUFDckYsb0RBQXFCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyx1QkFBdUIsQ0FBQyxBQUE5RCxDQUErRDtBQUNwRiw0Q0FBYSxHQUFHLElBQUksOEJBQThCLENBQUMsUUFBUSxDQUFDLEFBQS9DLENBQWdEO0FBQzdELDhDQUFlLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxpQkFBaUIsQ0FBQyxBQUF4RCxDQUF5RDtBQUN4RSxvREFBcUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLHVCQUF1QixDQUFDLEFBQTlELENBQStEO0FBQ3BGLDRDQUFhLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxlQUFlLENBQUMsQUFBdEQsQ0FBdUQ7QUFDcEUseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQUM5RCw4Q0FBZSxHQUFHLElBQUksOEJBQThCLENBQUMsaUJBQWlCLENBQUMsQUFBeEQsQ0FBeUQ7QUFDeEUsdUNBQVEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFVBQVUsQ0FBQyxBQUFqRCxDQUFrRDtBQUMxRCx1Q0FBUSxHQUFHLElBQUksOEJBQThCLENBQUMsdUJBQXVCLENBQUMsQUFBOUQsQ0FBK0Q7QUFDdkUsb0NBQUssR0FBRyxJQUFJLDhCQUE4QixDQUFDLE9BQU8sQ0FBQyxBQUE5QyxDQUErQztBQUNwRCx5Q0FBVSxHQUFHLElBQUksOEJBQThCLENBQUMsa0JBQWtCLENBQUMsQUFBekQsQ0FBMEQ7QUFDcEUscUNBQU0sR0FBRyxJQUFJLDhCQUE4QixDQUFDLFFBQVEsQ0FBQyxBQUEvQyxDQUFnRDtBQUN0RCxtQ0FBSSxHQUFHLElBQUksOEJBQThCLENBQUMsY0FBYyxDQUFDLEFBQXJELENBQXNEO0FBQzFELGtDQUFHLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxLQUFLLENBQUMsQUFBNUMsQ0FBNkM7QUFDaEQsdUNBQVEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFVBQVUsQ0FBQyxBQUFqRCxDQUFrRDtBQUMxRCx3Q0FBUyxHQUFHLElBQUksOEJBQThCLENBQUMsV0FBVyxDQUFDLEFBQWxELENBQW1EO0FBQzVELHVDQUFRLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxVQUFVLENBQUMsQUFBakQsQ0FBa0Q7QUFDMUQsNENBQWEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGVBQWUsQ0FBQyxBQUF0RCxDQUF1RDtBQUNwRSw0Q0FBYSxHQUFHLElBQUksOEJBQThCLENBQUMsZUFBZSxDQUFDLEFBQXRELENBQXVEO0FBQ3BFLGlDQUFFLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxJQUFJLENBQUMsQUFBM0MsQ0FBNEM7QUFDOUMsNERBQTZCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyx1QkFBdUIsRUFBRSxlQUFlLENBQUMsQUFBL0UsQ0FBZ0Y7QUFDN0csMENBQVcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGFBQWEsQ0FBQyxBQUFwRCxDQUFxRDtBQUNoRSw0Q0FBYSxHQUFHLElBQUksOEJBQThCLENBQUMsZUFBZSxDQUFDLEFBQXRELENBQXVEO0FBQ3BFLDZEQUE4QixHQUFHLElBQUksOEJBQThCLENBQUMsZ0NBQWdDLENBQUMsQUFBdkUsQ0FBd0U7QUFDdEcsZ0RBQWlCLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxtQkFBbUIsQ0FBQyxBQUExRCxDQUEyRDtBQUM1RSxnREFBaUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLG1CQUFtQixDQUFDLEFBQTFELENBQTJEO0FBQzVFLHFEQUFzQixHQUFHLElBQUksOEJBQThCLENBQUMsd0JBQXdCLENBQUMsQUFBL0QsQ0FBZ0U7QUFDdEYsOENBQWUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGdCQUFnQixDQUFDLEFBQXZELENBQXdEO0FBQ3ZFLDhDQUFlLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxnQkFBZ0IsQ0FBQyxBQUF2RCxDQUF3RDtBQUN2RSwwREFBMkIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLDRCQUE0QixDQUFDLEFBQW5FLENBQW9FO0FBQy9GLHVEQUF3QixHQUFHLElBQUksOEJBQThCLENBQUMsS0FBSyxDQUFDLEFBQTVDLENBQTZDO0FBQ3JFLDREQUE2QixHQUFHLElBQUksOEJBQThCLENBQUMsVUFBVSxDQUFDLEFBQWpELENBQWtEO0FBQy9FLG9FQUFxQyxHQUFHLElBQUksOEJBQThCLENBQUMsY0FBYyxDQUFDLEFBQXJELENBQXNEO0FBQzNGLGtDQUFHLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxZQUFZLENBQUMsQUFBbkQsQ0FBb0Q7QUFDdkQsa0NBQUcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUNoRCxrQ0FBRyxHQUFHLElBQUksOEJBQThCLENBQUMsS0FBSyxDQUFDLEFBQTVDLENBQTZDO0FBQ2hELGtDQUFHLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxLQUFLLENBQUMsQUFBNUMsQ0FBNkM7QUFDaEQsMkNBQVksR0FBRyxJQUFJLDhCQUE4QixDQUFDLGFBQWEsQ0FBQyxBQUFwRCxDQUFxRDtBQUNqRSwyQ0FBWSxHQUFHLElBQUksOEJBQThCLENBQUMsY0FBYyxDQUFDLEFBQXJELENBQXNEO0FBQ2xFLDRDQUFhLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxlQUFlLENBQUMsQUFBdEQsQ0FBdUQ7QUFDcEUsa0NBQUcsR0FBRyxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxBQUE1QyxDQUE2QztBQUNoRCxxREFBc0IsR0FBRyxJQUFJLDhCQUE4QixDQUFDLHdCQUF3QixDQUFDLEFBQS9ELENBQWdFO0FBQ3RGLHVDQUFRLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxVQUFVLENBQUMsQUFBakQsQ0FBa0Q7QUFDMUQsNENBQWEsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGVBQWUsQ0FBQyxBQUF0RCxDQUF1RDtBQUNwRSx1Q0FBUSxHQUFHLElBQUksOEJBQThCLENBQUMsVUFBVSxDQUFDLEFBQWpELENBQWtEO0FBQzFELDhDQUFlLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxpQkFBaUIsQ0FBQyxBQUF4RCxDQUF5RDtBQUN4RSx3Q0FBUyxHQUFHLElBQUksOEJBQThCLENBQUMsV0FBVyxDQUFDLEFBQWxELENBQW1EO0FBQzVELDhDQUFlLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxnQkFBZ0IsQ0FBQyxBQUF2RCxDQUF3RDtBQUN2RSwwQ0FBVyxHQUFHLElBQUksOEJBQThCLENBQUMsYUFBYSxDQUFDLEFBQXBELENBQXFEO0FBQ2hFLCtDQUFnQixHQUFHLElBQUksOEJBQThCLENBQUMsa0JBQWtCLENBQUMsQUFBekQsQ0FBMEQ7QUFDMUUsNkNBQWMsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFFBQVEsQ0FBQyxBQUEvQyxDQUFnRDtBQUM5RCxrREFBbUIsR0FBRyxJQUFJLDhCQUE4QixDQUFDLGFBQWEsQ0FBQyxBQUFwRCxDQUFxRDtBQUN4RSx5Q0FBVSxHQUFHLElBQUksOEJBQThCLENBQUMsWUFBWSxDQUFDLEFBQW5ELENBQW9EO0FBQzlELG1EQUFvQixHQUFHLElBQUksOEJBQThCLENBQUMscUJBQXFCLENBQUMsQUFBNUQsQ0FBNkQ7QUFDakYseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQUM5RCxtQ0FBSSxHQUFHLElBQUksOEJBQThCLENBQUMsTUFBTSxDQUFDLEFBQTdDLENBQThDO0FBQ2xELDBDQUFXLEdBQUcsSUFBSSw4QkFBOEIsQ0FBQyxhQUFhLENBQUMsQUFBcEQsQ0FBcUQ7QUFDaEUseUNBQVUsR0FBRyxJQUFJLDhCQUE4QixDQUFDLFlBQVksQ0FBQyxBQUFuRCxDQUFvRDtBQTVNMUUsd0VBQThCO0FBK1czQzs7O0dBR0c7QUFDSCxNQUFhLG9CQUFxQixTQUFRLFdBQVc7SUFDbkQ7O09BRUc7SUFDSSxNQUFNLENBQUMsa0NBQWtDLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBcUM7Ozs7Ozs7Ozs7UUFDbEgsTUFBTSxjQUFjLEdBQUcsS0FBSyxDQUFDLGVBQWU7WUFDMUMsQ0FBQyxDQUFDLENBQUMsOEJBQWEsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlLENBQUMsQ0FBQztZQUNwRixDQUFDLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUV6QixNQUFNLE1BQU8sU0FBUSxlQUFRO1lBQTdCOztnQkFDa0Isa0JBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO2dCQUNwQyxnQkFBVyxHQUFHLElBQUkseUJBQVcsQ0FBQztvQkFDNUMsV0FBVyxFQUFFLFdBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQztvQkFDakMsY0FBYztpQkFDZixDQUFDLENBQUM7WUFDTCxDQUFDO1NBQUE7UUFFRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5QjtJQWtERCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWdDO1FBQ3hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0FyRVIsb0JBQW9COzs7O1FBdUU3QixNQUFNLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxJQUFJLENBQUMsSUFBSSw4QkFBYSxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7Z0JBQ3ZGLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRzthQUNmLENBQUMsQ0FBQyxDQUFDO1FBRUosSUFBSSxDQUFDLGVBQWUsR0FBRyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDO1FBQ3pELElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSx5QkFBVyxDQUFDO1lBQ2pDLFdBQVcsRUFBRSxXQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDO1lBQ3pDLGNBQWM7U0FDZixDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxJQUFJLEtBQUssS0FBSyxFQUFFO1lBQ3hCLElBQUksQ0FBQyxXQUFXLENBQUMsb0JBQW9CLENBQUMsV0FBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7U0FDMUU7UUFFRCxtREFBbUQ7UUFDbkQsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUU5QyxNQUFNLFFBQVEsR0FBRyxJQUFJLDhCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNwRCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsSUFBSSxJQUFJO1lBQ3JGLGNBQWMsRUFBRSxXQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUNoRSxnQkFBZ0IsRUFBRSxjQUFjLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQztZQUM1RCxXQUFXLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJO1lBQy9CLGVBQWUsRUFBRSxlQUFlLENBQUMsU0FBUztZQUMxQyxTQUFTO1lBQ1QsS0FBSyxFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsS0FBSztTQUN2QixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7UUFDbEMsSUFBSSxDQUFDLDRCQUE0QixHQUFHLFFBQVEsQ0FBQyxxQkFBcUIsQ0FBQztRQUNuRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsUUFBUSxDQUFDLGNBQWMsQ0FBQztRQUNyRCxJQUFJLENBQUMsOEJBQThCLEdBQUcsUUFBUSxDQUFDLHVCQUF1QixDQUFDO0tBQ3hFO0lBRUQ7OztPQUdHO0lBQ0ssZUFBZSxDQUFDLEtBQWdDO1FBQ3RELE1BQU0sa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixJQUFJLEtBQUssQ0FBQztRQUM3RCxNQUFNLGVBQWUsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxFQUFFLEdBQUcsS0FBSyxDQUFDLE9BQU8sRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztRQUN0RixNQUFNLE9BQU8sR0FBRyxlQUFlLENBQUMsT0FBTyxDQUFDO1FBRXhDLGdDQUFnQztRQUNoQyxJQUFJLENBQUMsZUFBZSxDQUFDLGVBQWUsSUFBSSxlQUFlLENBQUMsT0FBTyxDQUFDLE1BQU0sSUFBSSxDQUFDLEVBQUU7WUFDM0UsTUFBTSxJQUFJLEtBQUssQ0FBQyw4Q0FBOEMsQ0FBQyxDQUFDO1NBQ2pFO1FBRUQsMEhBQTBIO1FBQzFILElBQUksQ0FBQyxrQkFBa0IsRUFBRTtZQUN2QixPQUFPLGVBQWUsQ0FBQyxTQUFTLENBQUM7U0FDbEM7UUFFRCwwR0FBMEc7UUFDMUcsd0hBQXdIO1FBQ3hILE1BQU0sWUFBWSxHQUFHLFlBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxLQUFLLENBQUMsT0FBTyxZQUFZLDhCQUE4QixDQUFDO1FBRXZILGdFQUFnRTtRQUNoRSxzREFBc0Q7UUFDdEQsTUFBTSxpQkFBaUIsR0FBRyxZQUFZLENBQUMsQ0FBQyxDQUFDLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDO1FBRXpHLGtDQUFrQztRQUNsQyxJQUFJLENBQUMsNkJBQTZCLENBQUMsT0FBTyxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFFL0QsK0JBQStCO1FBQy9CLE1BQU0sWUFBWSxHQUFHLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ3hFLE1BQU0sZUFBZSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7UUFFdkYsd0RBQXdEO1FBQ3hELG9EQUFvRDtRQUNwRCxJQUFJLGVBQWUsQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUFFO1lBQy9CLE1BQU0sSUFBSSxLQUFLLENBQUMsK0JBQStCLFlBQVkseUJBQXlCLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsZ0JBQWdCLENBQUMsRUFBRSxDQUFDLENBQUM7U0FDN0g7UUFDRCxPQUFPLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUM7S0FDN0M7SUFFRDs7T0FFRztJQUNLLDZCQUE2QixDQUFDLE9BQWtCLEVBQUUsV0FBbUI7UUFFM0UsaUZBQWlGO1FBQ2pGLE1BQU0sWUFBWSxHQUFHLFlBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUMxRCxNQUFNLGNBQWMsR0FBRyxZQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDM0QsTUFBTSxlQUFlLEdBQUcsWUFBSyxDQUFDLFlBQVksQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUV4RCxpSEFBaUg7UUFDakgsTUFBTSxlQUFlLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztRQUNsRixNQUFNLGtCQUFrQixHQUFHLFlBQUssQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7UUFFcEYscUVBQXFFO1FBQ3JFLElBQUksWUFBWSxJQUFJLGNBQWMsRUFBRTtZQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9GQUFvRixDQUFDLENBQUM7U0FDdkc7UUFFRCxpRUFBaUU7UUFDakUsSUFBSSxlQUFlLEVBQUU7WUFDbkIsTUFBTSxJQUFJLEtBQUssQ0FBQyxzREFBc0QsV0FBVyxFQUFFLENBQUMsQ0FBQztTQUN0RjtRQUVELHdFQUF3RTtRQUN4RSx5R0FBeUc7UUFDekcsaUJBQWlCO1FBQ2pCLElBQUksZUFBZSxJQUFJLGtCQUFrQixFQUFFO1lBQ3pDLE1BQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxZQUFLLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7WUFDN0UsTUFBTSxJQUFJLEtBQUssQ0FBQywrREFBK0QsUUFBUSxFQUFFLENBQUMsQ0FBQztTQUM1RjtLQUNGO0lBRU8sMEJBQTBCLENBQUMsV0FBbUI7UUFDcEQsOERBQThEO1FBQzlELDJFQUEyRTtRQUMzRSwrQkFBK0I7UUFDL0IsTUFBTSxZQUFZLEdBQUcsc0JBQWUsQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFO1lBQ2xELFFBQVEsRUFBRSxRQUFRLENBQUMsZUFBZSxDQUFDLDJDQUEyQztZQUM5RSxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUI7WUFDeEMsS0FBSyxFQUFFLEVBQUUsV0FBVyxFQUFFO1NBQ3ZCLENBQUMsQ0FBQyxLQUFLLENBQUM7UUFDVCxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsRUFBRTtZQUNoQyxNQUFNLElBQUksS0FBSyxDQUFDLHVDQUF1QyxXQUFXLG1CQUFtQixDQUFDLENBQUM7U0FDeEY7UUFDRCxPQUFPLFlBQVksQ0FBQztLQUNyQjs7OztBQWhNVSxvREFBb0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnLi4vLi4vYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBjeHNjaGVtYSBmcm9tICcuLi8uLi9jbG91ZC1hc3NlbWJseS1zY2hlbWEnO1xuaW1wb3J0IHsgQXdzLCBDb250ZXh0UHJvdmlkZXIsIElSZXNvdXJjZSwgTGF6eSwgUmVzb3VyY2UsIFN0YWNrLCBUb2tlbiB9IGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDb25uZWN0aW9ucywgSUNvbm5lY3RhYmxlIH0gZnJvbSAnLi9jb25uZWN0aW9ucyc7XG5pbXBvcnQgeyBDZm5WUENFbmRwb2ludCB9IGZyb20gJy4vZWMyLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBQZWVyIH0gZnJvbSAnLi9wZWVyJztcbmltcG9ydCB7IFBvcnQgfSBmcm9tICcuL3BvcnQnO1xuaW1wb3J0IHsgSVNlY3VyaXR5R3JvdXAsIFNlY3VyaXR5R3JvdXAgfSBmcm9tICcuL3NlY3VyaXR5LWdyb3VwJztcbmltcG9ydCB7IGFsbFJvdXRlVGFibGVJZHMsIGZsYXR0ZW4gfSBmcm9tICcuL3V0aWwnO1xuaW1wb3J0IHsgSVN1Ym5ldCwgSVZwYywgU3VibmV0U2VsZWN0aW9uIH0gZnJvbSAnLi92cGMnO1xuXG4vKipcbiAqIEEgVlBDIGVuZHBvaW50LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElWcGNFbmRwb2ludCBleHRlbmRzIElSZXNvdXJjZSB7XG4gIC8qKlxuICAgKiBUaGUgVlBDIGVuZHBvaW50IGlkZW50aWZpZXIuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHZwY0VuZHBvaW50SWQ6IHN0cmluZztcbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIFZwY0VuZHBvaW50IGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJVnBjRW5kcG9pbnQge1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgdnBjRW5kcG9pbnRJZDogc3RyaW5nO1xuXG4gIHByb3RlY3RlZCBwb2xpY3lEb2N1bWVudD86IGlhbS5Qb2xpY3lEb2N1bWVudDtcblxuICAvKipcbiAgICogQWRkcyBhIHN0YXRlbWVudCB0byB0aGUgcG9saWN5IGRvY3VtZW50IG9mIHRoZSBWUEMgZW5kcG9pbnQuIFRoZSBzdGF0ZW1lbnRcbiAgICogbXVzdCBoYXZlIGEgUHJpbmNpcGFsLlxuICAgKlxuICAgKiBOb3QgYWxsIGludGVyZmFjZSBWUEMgZW5kcG9pbnRzIHN1cHBvcnQgcG9saWN5LiBGb3IgbW9yZSBpbmZvcm1hdGlvblxuICAgKiBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3ZwYy9sYXRlc3QvdXNlcmd1aWRlL3ZwY2UtaW50ZXJmYWNlLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHN0YXRlbWVudCB0aGUgSUFNIHN0YXRlbWVudCB0byBhZGRcbiAgICovXG4gIHB1YmxpYyBhZGRUb1BvbGljeShzdGF0ZW1lbnQ6IGlhbS5Qb2xpY3lTdGF0ZW1lbnQpIHtcbiAgICBpZiAoIXN0YXRlbWVudC5oYXNQcmluY2lwYWwpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU3RhdGVtZW50IG11c3QgaGF2ZSBhIGBQcmluY2lwYWxgLicpO1xuICAgIH1cblxuICAgIGlmICghdGhpcy5wb2xpY3lEb2N1bWVudCkge1xuICAgICAgdGhpcy5wb2xpY3lEb2N1bWVudCA9IG5ldyBpYW0uUG9saWN5RG9jdW1lbnQoKTtcbiAgICB9XG5cbiAgICB0aGlzLnBvbGljeURvY3VtZW50LmFkZFN0YXRlbWVudHMoc3RhdGVtZW50KTtcbiAgfVxufVxuXG4vKipcbiAqIEEgZ2F0ZXdheSBWUEMgZW5kcG9pbnQuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUdhdGV3YXlWcGNFbmRwb2ludCBleHRlbmRzIElWcGNFbmRwb2ludCB7XG59XG5cbi8qKlxuICogVGhlIHR5cGUgb2YgVlBDIGVuZHBvaW50LlxuICovXG5leHBvcnQgZW51bSBWcGNFbmRwb2ludFR5cGUge1xuICAvKipcbiAgICogSW50ZXJmYWNlXG4gICAqXG4gICAqIEFuIGludGVyZmFjZSBlbmRwb2ludCBpcyBhbiBlbGFzdGljIG5ldHdvcmsgaW50ZXJmYWNlIHdpdGggYSBwcml2YXRlIElQXG4gICAqIGFkZHJlc3MgdGhhdCBzZXJ2ZXMgYXMgYW4gZW50cnkgcG9pbnQgZm9yIHRyYWZmaWMgZGVzdGluZWQgdG8gYSBzdXBwb3J0ZWRcbiAgICogc2VydmljZS5cbiAgICovXG4gIElOVEVSRkFDRSA9ICdJbnRlcmZhY2UnLFxuXG4gIC8qKlxuICAgKiBHYXRld2F5XG4gICAqXG4gICAqIEEgZ2F0ZXdheSBlbmRwb2ludCBpcyBhIGdhdGV3YXkgdGhhdCBpcyBhIHRhcmdldCBmb3IgYSBzcGVjaWZpZWQgcm91dGUgaW5cbiAgICogeW91ciByb3V0ZSB0YWJsZSwgdXNlZCBmb3IgdHJhZmZpYyBkZXN0aW5lZCB0byBhIHN1cHBvcnRlZCBBV1Mgc2VydmljZS5cbiAgICovXG4gIEdBVEVXQVkgPSAnR2F0ZXdheSdcbn1cblxuLyoqXG4gKiBBIHNlcnZpY2UgZm9yIGEgZ2F0ZXdheSBWUEMgZW5kcG9pbnQuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUdhdGV3YXlWcGNFbmRwb2ludFNlcnZpY2Uge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG59XG5cbi8qKlxuICogQW4gQVdTIHNlcnZpY2UgZm9yIGEgZ2F0ZXdheSBWUEMgZW5kcG9pbnQuXG4gKi9cbmV4cG9ydCBjbGFzcyBHYXRld2F5VnBjRW5kcG9pbnRBd3NTZXJ2aWNlIGltcGxlbWVudHMgSUdhdGV3YXlWcGNFbmRwb2ludFNlcnZpY2Uge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERZTkFNT0RCID0gbmV3IEdhdGV3YXlWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2R5bmFtb2RiJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUzMgPSBuZXcgR2F0ZXdheVZwY0VuZHBvaW50QXdzU2VydmljZSgnczMnKTtcblxuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIHNlcnZpY2UuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKG5hbWU6IHN0cmluZywgcHJlZml4Pzogc3RyaW5nKSB7XG4gICAgdGhpcy5uYW1lID0gYCR7cHJlZml4IHx8ICdjb20uYW1hem9uYXdzJ30uJHtBd3MuUkVHSU9OfS4ke25hbWV9YDtcbiAgfVxufVxuXG4vKipcbiAqIE9wdGlvbnMgdG8gYWRkIGEgZ2F0ZXdheSBlbmRwb2ludCB0byBhIFZQQy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBHYXRld2F5VnBjRW5kcG9pbnRPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBzZXJ2aWNlIHRvIHVzZSBmb3IgdGhpcyBnYXRld2F5IFZQQyBlbmRwb2ludC5cbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2U6IElHYXRld2F5VnBjRW5kcG9pbnRTZXJ2aWNlO1xuXG4gIC8qKlxuICAgKiBXaGVyZSB0byBhZGQgZW5kcG9pbnQgcm91dGluZy5cbiAgICpcbiAgICogQnkgZGVmYXVsdCwgdGhpcyBlbmRwb2ludCB3aWxsIGJlIHJvdXRhYmxlIGZyb20gYWxsIHN1Ym5ldHMgaW4gdGhlIFZQQy5cbiAgICogU3BlY2lmeSBhIGxpc3Qgb2Ygc3VibmV0IHNlbGVjdGlvbiBvYmplY3RzIGhlcmUgdG8gYmUgbW9yZSBzcGVjaWZpYy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBBbGwgc3VibmV0cyBpbiB0aGUgVlBDXG4gICAqIEBleGFtcGxlXG4gICAqXG4gICAqIGRlY2xhcmUgY29uc3QgdnBjOiBlYzIuVnBjO1xuICAgKlxuICAgKiB2cGMuYWRkR2F0ZXdheUVuZHBvaW50KCdEeW5hbW9EYkVuZHBvaW50Jywge1xuICAgKiAgIHNlcnZpY2U6IGVjMi5HYXRld2F5VnBjRW5kcG9pbnRBd3NTZXJ2aWNlLkRZTkFNT0RCLFxuICAgKiAgIC8vIEFkZCBvbmx5IHRvIElTT0xBVEVEIHN1Ym5ldHNcbiAgICogICBzdWJuZXRzOiBbXG4gICAqICAgICB7IHN1Ym5ldFR5cGU6IGVjMi5TdWJuZXRUeXBlLlBSSVZBVEVfSVNPTEFURUQgfVxuICAgKiAgIF1cbiAgICogfSk7XG4gICAqXG4gICAqXG4gICAqL1xuICByZWFkb25seSBzdWJuZXRzPzogU3VibmV0U2VsZWN0aW9uW11cbn1cblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBmb3IgYSBHYXRld2F5VnBjRW5kcG9pbnQuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgR2F0ZXdheVZwY0VuZHBvaW50UHJvcHMgZXh0ZW5kcyBHYXRld2F5VnBjRW5kcG9pbnRPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBWUEMgbmV0d29yayBpbiB3aGljaCB0aGUgZ2F0ZXdheSBlbmRwb2ludCB3aWxsIGJlIHVzZWQuXG4gICAqL1xuICByZWFkb25seSB2cGM6IElWcGNcbn1cblxuLyoqXG4gKiBBIGdhdGV3YXkgVlBDIGVuZHBvaW50LlxuICogQHJlc291cmNlIEFXUzo6RUMyOjpWUENFbmRwb2ludFxuICovXG5leHBvcnQgY2xhc3MgR2F0ZXdheVZwY0VuZHBvaW50IGV4dGVuZHMgVnBjRW5kcG9pbnQgaW1wbGVtZW50cyBJR2F0ZXdheVZwY0VuZHBvaW50IHtcblxuICBwdWJsaWMgc3RhdGljIGZyb21HYXRld2F5VnBjRW5kcG9pbnRJZChzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBnYXRld2F5VnBjRW5kcG9pbnRJZDogc3RyaW5nKTogSUdhdGV3YXlWcGNFbmRwb2ludCB7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgVnBjRW5kcG9pbnQge1xuICAgICAgcHVibGljIHZwY0VuZHBvaW50SWQgPSBnYXRld2F5VnBjRW5kcG9pbnRJZDtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBnYXRld2F5IFZQQyBlbmRwb2ludCBpZGVudGlmaWVyLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZwY0VuZHBvaW50SWQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGRhdGUgYW5kIHRpbWUgdGhlIGdhdGV3YXkgVlBDIGVuZHBvaW50IHdhcyBjcmVhdGVkLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjRW5kcG9pbnRDcmVhdGlvblRpbWVzdGFtcDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjRW5kcG9pbnROZXR3b3JrSW50ZXJmYWNlSWRzOiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZwY0VuZHBvaW50RG5zRW50cmllczogc3RyaW5nW107XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEdhdGV3YXlWcGNFbmRwb2ludFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHN1Ym5ldHM6IElTdWJuZXRbXSA9IHByb3BzLnN1Ym5ldHNcbiAgICAgID8gZmxhdHRlbihwcm9wcy5zdWJuZXRzLm1hcChzID0+IHByb3BzLnZwYy5zZWxlY3RTdWJuZXRzKHMpLnN1Ym5ldHMpKVxuICAgICAgOiBbLi4ucHJvcHMudnBjLnByaXZhdGVTdWJuZXRzLCAuLi5wcm9wcy52cGMucHVibGljU3VibmV0cywgLi4ucHJvcHMudnBjLmlzb2xhdGVkU3VibmV0c107XG4gICAgY29uc3Qgcm91dGVUYWJsZUlkcyA9IGFsbFJvdXRlVGFibGVJZHMoc3VibmV0cyk7XG5cbiAgICBpZiAocm91dGVUYWJsZUlkcy5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQ2FuXFwndCBhZGQgYSBnYXRld2F5IGVuZHBvaW50IHRvIFZQQzsgcm91dGUgdGFibGUgSURzIGFyZSBub3QgYXZhaWxhYmxlJyk7XG4gICAgfVxuXG4gICAgY29uc3QgZW5kcG9pbnQgPSBuZXcgQ2ZuVlBDRW5kcG9pbnQodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgcG9saWN5RG9jdW1lbnQ6IExhenkuYW55KHsgcHJvZHVjZTogKCkgPT4gdGhpcy5wb2xpY3lEb2N1bWVudCB9KSxcbiAgICAgIHJvdXRlVGFibGVJZHMsXG4gICAgICBzZXJ2aWNlTmFtZTogcHJvcHMuc2VydmljZS5uYW1lLFxuICAgICAgdnBjRW5kcG9pbnRUeXBlOiBWcGNFbmRwb2ludFR5cGUuR0FURVdBWSxcbiAgICAgIHZwY0lkOiBwcm9wcy52cGMudnBjSWQsXG4gICAgfSk7XG5cbiAgICB0aGlzLnZwY0VuZHBvaW50SWQgPSBlbmRwb2ludC5yZWY7XG4gICAgdGhpcy52cGNFbmRwb2ludENyZWF0aW9uVGltZXN0YW1wID0gZW5kcG9pbnQuYXR0ckNyZWF0aW9uVGltZXN0YW1wO1xuICAgIHRoaXMudnBjRW5kcG9pbnREbnNFbnRyaWVzID0gZW5kcG9pbnQuYXR0ckRuc0VudHJpZXM7XG4gICAgdGhpcy52cGNFbmRwb2ludE5ldHdvcmtJbnRlcmZhY2VJZHMgPSBlbmRwb2ludC5hdHRyTmV0d29ya0ludGVyZmFjZUlkcztcbiAgfVxufVxuXG4vKipcbiAqIEEgc2VydmljZSBmb3IgYW4gaW50ZXJmYWNlIFZQQyBlbmRwb2ludC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJSW50ZXJmYWNlVnBjRW5kcG9pbnRTZXJ2aWNlIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBzZXJ2aWNlLlxuICAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcG9ydCBvZiB0aGUgc2VydmljZS5cbiAgICovXG4gIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcblxuICAvKipcbiAgICogV2hldGhlciBQcml2YXRlIEROUyBpcyBzdXBwb3J0ZWQgYnkgZGVmYXVsdC5cbiAgICovXG4gIHJlYWRvbmx5IHByaXZhdGVEbnNEZWZhdWx0PzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBBIGN1c3RvbS1ob3N0ZWQgc2VydmljZSBmb3IgYW4gaW50ZXJmYWNlIFZQQyBlbmRwb2ludC5cbiAqL1xuZXhwb3J0IGNsYXNzIEludGVyZmFjZVZwY0VuZHBvaW50U2VydmljZSBpbXBsZW1lbnRzIElJbnRlcmZhY2VWcGNFbmRwb2ludFNlcnZpY2Uge1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgc2VydmljZS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwb3J0IG9mIHRoZSBzZXJ2aWNlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcblxuICAvKipcbiAgICogV2hldGhlciBQcml2YXRlIEROUyBpcyBzdXBwb3J0ZWQgYnkgZGVmYXVsdC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBwcml2YXRlRG5zRGVmYXVsdD86IGJvb2xlYW4gPSBmYWxzZTtcblxuICBjb25zdHJ1Y3RvcihuYW1lOiBzdHJpbmcsIHBvcnQ/OiBudW1iZXIpIHtcbiAgICB0aGlzLm5hbWUgPSBuYW1lO1xuICAgIHRoaXMucG9ydCA9IHBvcnQgfHwgNDQzO1xuICB9XG59XG5cbi8qKlxuICogQW4gQVdTIHNlcnZpY2UgZm9yIGFuIGludGVyZmFjZSBWUEMgZW5kcG9pbnQuXG4gKi9cbmV4cG9ydCBjbGFzcyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UgaW1wbGVtZW50cyBJSW50ZXJmYWNlVnBjRW5kcG9pbnRTZXJ2aWNlIHtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTQUdFTUFLRVJfU1RVRElPID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc3R1ZGlvJywgJ2F3cy5zYWdlbWFrZXInKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTQUdFTUFLRVJfTk9URUJPT0sgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdub3RlYm9vaycsICdhd3Muc2FnZW1ha2VyJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgS0VORFJBX1JBTktJTkcgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdrZW5kcmEtcmFua2luZycsICdhd3MuYXBpJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUNDRVNTX0FOQUxZWkVSID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYWNjZXNzLWFuYWx5emVyJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUNDT1VOVF9NQU5BR0VNRU5UID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYWNjb3VudCcpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFQUF9NRVNIID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYXBwbWVzaC1lbnZveS1tYW5hZ2VtZW50Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQVBQX1JVTk5FUiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2FwcHJ1bm5lcicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFQUF9SVU5ORVJfUkVRVUVTVFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhcHBydW5uZXIucmVxdWVzdHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBUFBMSUNBVElPTl9NSUdSQVRJT05fU0VSVklDRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ21nbicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFQUFNUUkVBTV9BUEkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhcHBzdHJlYW0uYXBpJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQVBQU1RSRUFNX1NUUkVBTUlORyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2FwcHN0cmVhbS5zdHJlYW1pbmcnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBVEhFTkEgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhdGhlbmEnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBVURJVF9NQU5BR0VSID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYXVkaXRtYW5hZ2VyJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQVBQTElDQVRJT05fQVVUT1NDQUxJTkcgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhcHBsaWNhdGlvbi1hdXRvc2NhbGluZycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFVVE9TQ0FMSU5HID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYXV0b3NjYWxpbmcnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBVVRPU0NBTElOR19QTEFOUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2F1dG9zY2FsaW5nLXBsYW5zJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQkFDS1VQID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYmFja3VwJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQkFDS1VQX0dBVEVXQVkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdiYWNrdXAtZ2F0ZXdheScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEJBVENIID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYmF0Y2gnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBCSUxMSU5HX0NPTkRVQ1RPUiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2JpbGxpbmdjb25kdWN0b3InKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBCUkFLRVQgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdicmFrZXQnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQUklWQVRFX0NFUlRJRklDQVRFX0FVVEhPUklUWSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2FjbS1wY2EnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRF9DT05UUk9MX0FQSSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Nsb3VkY29udHJvbGFwaScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEX0NPTlRST0xfQVBJX0ZJUFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjbG91ZGNvbnRyb2xhcGktZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEX0RJUkVDVE9SWSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Nsb3VkZGlyZWN0b3J5Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURGT1JNQVRJT04gPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjbG91ZGZvcm1hdGlvbicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VESFNNID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnY2xvdWRoc212MicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEVFJBSUwgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjbG91ZHRyYWlsJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURXQVRDSF9FVklERU5UTFkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdldmlkZW50bHknKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFdBVENIX0VWSURFTlRMWV9EQVRBUExBTkUgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdldmlkZW50bHktZGF0YXBsYW5lJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURXQVRDSF9NT05JVE9SSU5HID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnbW9uaXRvcmluZycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEV0FUQ0hfUlVNID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncnVtJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURXQVRDSF9SVU1fREFUQVBMQU5FID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncnVtLWRhdGFwbGFuZScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEV0FUQ0hfU1lOVEhFVElDUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3N5bnRoZXRpY3MnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT0RFQVJUSUZBQ1RfQVBJID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnY29kZWFydGlmYWN0LmFwaScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPREVBUlRJRkFDVF9SRVBPU0lUT1JJRVMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb2RlYXJ0aWZhY3QucmVwb3NpdG9yaWVzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09ERUJVSUxEID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnY29kZWJ1aWxkJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09ERUJVSUxEX0ZJUFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb2RlYnVpbGQtZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPREVDT01NSVQgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb2RlY29tbWl0Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09ERUNPTU1JVF9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnY29kZWNvbW1pdC1maXBzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09ERURFUExPWSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2NvZGVkZXBsb3knKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT0RFREVQTE9ZX0NPTU1BTkRTX1NFQ1VSRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2NvZGVkZXBsb3ktY29tbWFuZHMtc2VjdXJlJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09ERUdVUlVfUFJPRklMRVIgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb2RlZ3VydS1wcm9maWxlcicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPREVHVVJVX1JFVklFV0VSID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnY29kZWd1cnUtcmV2aWV3ZXInKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT0RFUElQRUxJTkUgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb2RlcGlwZWxpbmUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT0RFU1RBUl9DT05ORUNUSU9OUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2NvZGVzdGFyLWNvbm5lY3Rpb25zLmFwaScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPTVBSRUhFTkQgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb21wcmVoZW5kJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09NUFJFSEVORF9NRURJQ0FMID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnY29tcHJlaGVuZG1lZGljYWwnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT05GSUcgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb25maWcnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT05ORUNUX0FQUF9JTlRFR1JBVElPTlMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhcHAtaW50ZWdyYXRpb25zJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09OTkVDVF9DQVNFUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Nhc2VzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09OTkVDVF9DT05ORUNUX0NBTVBBSUdOUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Nvbm5lY3QtY2FtcGFpZ25zJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09OTkVDVF9QUk9GSUxFID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncHJvZmlsZScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPTk5FQ1RfVk9JQ0VJRCA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3ZvaWNlaWQnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT05ORUNUX1dJU0RPTSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3dpc2RvbScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERBVEFfRVhDSEFOR0UgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdkYXRhZXhjaGFuZ2UnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBEQVRBQkFTRV9NSUdSQVRJT05fU0VSVklDRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2RtcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERBVEFCQVNFX01JR1JBVElPTl9TRVJWSUNFX0ZJUFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdkbXMtZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERBVEFTWU5DID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZGF0YXN5bmMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBERVZPUFNfR1VSVSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Rldm9wcy1ndXJ1Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUJTX0RJUkVDVCA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2VicycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2VjMicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9NRVNTQUdFUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2VjMm1lc3NhZ2VzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSU1BR0VfQlVJTERFUiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2ltYWdlYnVpbGRlcicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDUiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Vjci5hcGknKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQ1JfRE9DS0VSID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZWNyLmRrcicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2VjcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDU19BR0VOVCA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Vjcy1hZ2VudCcpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDU19URUxFTUVUUlkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdlY3MtdGVsZW1ldHJ5Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUtTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZWtzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ19CRUFOU1RBTEsgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdlbGFzdGljYmVhbnN0YWxrJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ19CRUFOU1RBTEtfSEVBTFRIID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZWxhc3RpY2JlYW5zdGFsay1oZWFsdGgnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEFTVElDX0RJU0FTVEVSX1JFQ09WRVJZID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZHJzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ19GSUxFU1lTVEVNID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZWxhc3RpY2ZpbGVzeXN0ZW0nKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEFTVElDX0ZJTEVTWVNURU1fRklQUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2VsYXN0aWNmaWxlc3lzdGVtLWZpcHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEFTVElDX0lORkVSRU5DRV9SVU5USU1FID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZWxhc3RpYy1pbmZlcmVuY2UucnVudGltZScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVMQVNUSUNfTE9BRF9CQUxBTkNJTkcgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdlbGFzdGljbG9hZGJhbGFuY2luZycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVMQVNUSUNBQ0hFID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZWxhc3RpY2FjaGUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEFTVElDQUNIRV9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZWxhc3RpY2FjaGUtZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVNUiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2VsYXN0aWNtYXByZWR1Y2UnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTVJfRUtTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZW1yLWNvbnRhaW5lcnMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTVJfU0VSVkVSTEVTUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Vtci1zZXJ2ZXJsZXNzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURXQVRDSF9FVkVOVFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdldmVudHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBFVkVOVEJSSURHRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2V2ZW50cycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFQSUdBVEVXQVkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdleGVjdXRlLWFwaScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZBVUxUX0lOSkVDVElPTl9TSU1VTEFUT1IgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdmaXMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBGSU5TUEFDRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2ZpbnNwYWNlJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRklOU1BBQ0VfQVBJID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZmluc3BhY2UtYXBpJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRk9SRUNBU1QgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdmb3JlY2FzdCcpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZPUkVDQVNUX1FVRVJZID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZm9yZWNhc3RxdWVyeScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZPUkVDQVNUX0ZJUFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdmb3JlY2FzdC1maXBzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRk9SRUNBU1RfUVVFUllfRklQUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2ZvcmVjYXN0cXVlcnktZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZSQVVEX0RFVEVDVE9SID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZnJhdWRkZXRlY3RvcicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZTWCA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2ZzeCcpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZTWF9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZnN4LWZpcHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT0RFQ09NTUlUX0dJVCA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2dpdC1jb2RlY29tbWl0Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09ERUNPTU1JVF9HSVRfRklQUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2dpdC1jb2RlY29tbWl0LWZpcHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBHTFVFID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZ2x1ZScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdMVUVfREFUQUJSRVcgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdkYXRhYnJldycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdSQUZBTkEgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdncmFmYW5hJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1JBRkFOQV9XT1JLU1BBQ0UgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdncmFmYW5hLXdvcmtzcGFjZScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdST1VORFNUQVRJT04gPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdncm91bmRzdGF0aW9uJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSEVBTFRITEFLRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2hlYWx0aGxha2UnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJQU1fSURFTlRJVFlfQ0VOVEVSID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnaWRlbnRpdHlzdG9yZScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9ST0xFU19BTllXSEVSRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3JvbGVzYW55d2hlcmUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJTlNQRUNUT1IgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdpbnNwZWN0b3IyJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSU9UX0NPUkUgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdpb3QuZGF0YScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElPVF9DT1JFX0RFVklDRV9BRFZJU09SID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZGV2aWNlYWR2aXNvci5pb3QnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJT1RfQ09SRV9GT1JfTE9SQVdBTiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2lvdHdpcmVsZXNzLmFwaScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElPVF9MT1JBV0FOX0NVUFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdsb3Jhd2FuLmN1cHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJT1RfTE9SQVdBTl9MTlMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdsb3Jhd2FuLmxucycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElPVF9HUkVFTkdSQVNTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZ3JlZW5ncmFzcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElPVF9ST0JPUlVOTkVSID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnaW90cm9ib3J1bm5lcicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElPVF9TSVRFV0lTRV9BUEkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdpb3RzaXRld2lzZS5hcGknKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJT1RfU0lURVdJU0VfREFUQSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2lvdHNpdGV3aXNlLmRhdGEnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJT1RfVFdJTk1BS0VSX0FQSSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2lvdHR3aW5tYWtlci5hcGknKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJT1RfVFdJTk1BS0VSX0RBVEEgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdpb3R0d2lubWFrZXIuZGF0YScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEtFTkRSQSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2tlbmRyYScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEtFWVNQQUNFUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Nhc3NhbmRyYScsICcnLCA5MTQyKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBLRVlTUEFDRVNfRklQUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2Nhc3NhbmRyYS1maXBzJywgJycsIDkxNDIpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEtJTkVTSVNfU1RSRUFNUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2tpbmVzaXMtc3RyZWFtcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEtJTkVTSVNfRklSRUhPU0UgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdraW5lc2lzLWZpcmVob3NlJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgS01TID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgna21zJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgS01TX0ZJUFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdrbXMtZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExBS0VfRk9STUFUSU9OID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnbGFrZWZvcm1hdGlvbicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEV0FUQ0hfTE9HUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2xvZ3MnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFdBVENIID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnbW9uaXRvcmluZycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExBTUJEQSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2xhbWJkYScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExFWF9NT0RFTFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdtb2RlbHMtdjItbGV4Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTEVYX1JVTlRJTUUgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdydW50aW1lLXYyLWxleCcpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExJQ0VOU0VfTUFOQUdFUiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2xpY2Vuc2UtbWFuYWdlcicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExJQ0VOU0VfTUFOQUdFUl9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnbGljZW5zZS1tYW5hZ2VyLWZpcHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMT09LT1VUX0VRVUlQTUVOVCA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2xvb2tvdXRlcXVpcG1lbnQnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMT09LT1VUX01FVFJJQ1MgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdsb29rb3V0bWV0cmljcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IExPT0tPVVRfVklTSU9OID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnbG9va291dHZpc2lvbicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1BQ0lFID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnbWFjaWUyJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTUFJTkZSQU1FX01PREVSTklaQVRJT04gPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdtMicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBST01FVEhFVVMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhcHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQUk9NRVRIRVVTX1dPUktTUEFDRVMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhcHMtd29ya3NwYWNlcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFJUkZMT1dfQVBJID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYWlyZmxvdy5hcGknKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBSVJGTE9XX0VOViA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ2FpcmZsb3cuZW52Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUlSRkxPV19PUFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhaXJmbG93Lm9wcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1FTU9SWV9EQiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ21lbW9yeS1kYicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1FTU9SWV9EQl9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnbWVtb3J5ZGItZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1JR1JBVElPTkhVQl9PUkNIRVNUUkFUT1IgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdtaWdyYXRpb25odWItb3JjaGVzdHJhdG9yJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTUlHUkFUSU9OSFVCX1JFRkFDVE9SX1NQQUNFUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3JlZmFjdG9yLXNwYWNlcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1JR1JBVElPTkhVQl9TVFJBVEVHWSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ21pZ3JhdGlvbmh1Yi1zdHJhdGVneScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE5JTUJMRV9TVFVESU8gPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCduaW1ibGUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPTUlDU19BTkFMWVRJQ1MgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdhbmFseXRpY3Mtb21pY3MnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPTUlDU19DT05UUk9MX1NUT1JBR0UgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb250cm9sLXN0b3JhZ2Utb21pY3MnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPTUlDU19TVE9SQUdFID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc3RvcmFnZS1vbWljcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE9NSUNTX1RBR1MgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCd0YWdzLW9taWNzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT01JQ1NfV09SS0ZMT1dTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnd29ya2Zsb3dzLW9taWNzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUEFOT1JBTUEgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdwYW5vcmFtYScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBJTlBPSU5UID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncGlucG9pbnQtc21zLXZvaWNlLXYyJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUE9MTFkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdwb2xseScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBSSVZBVEVfNUcgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdwcml2YXRlLW5ldHdvcmtzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUFJPVE9OID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncHJvdG9uJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUUxEQiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3FsZGIuc2Vzc2lvbicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJEUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3JkcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJEU19EQVRBID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncmRzLWRhdGEnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBST0JPTUFLRVIgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdyb2JvbWFrZXInKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRURTSElGVCA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3JlZHNoaWZ0Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkVEU0hJRlRfRklQUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3JlZHNoaWZ0LWZpcHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRURTSElGVF9EQVRBID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncmVkc2hpZnQtZGF0YScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFMzID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnczMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTM19NVUxUSV9SRUdJT05fQUNDRVNTX1BPSU5UUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3MzLWdsb2JhbC5hY2Nlc3Nwb2ludCcsICdjb20uYW1hem9uYXdzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUzNfT1VUUE9TVFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdzMy1vdXRwb3N0cycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNBR0VNQUtFUl9BUEkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdzYWdlbWFrZXIuYXBpJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0FHRU1BS0VSX0ZFQVRVUkVTVE9SRV9SVU5USU1FID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc2FnZW1ha2VyLmZlYXR1cmVzdG9yZS1ydW50aW1lJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0FHRU1BS0VSX01FVFJJQ1MgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdzYWdlbWFrZXIubWV0cmljcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNBR0VNQUtFUl9SVU5USU1FID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc2FnZW1ha2VyLnJ1bnRpbWUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTQUdFTUFLRVJfUlVOVElNRV9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc2FnZW1ha2VyLnJ1bnRpbWUtZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFQ1JFVFNfTUFOQUdFUiA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3NlY3JldHNtYW5hZ2VyJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VSVklDRV9DQVRBTE9HID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc2VydmljZWNhdGFsb2cnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTRVJWSUNFX0NBVEFMT0dfQVBQUkVHSVNUUlkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdzZXJ2aWNlY2F0YWxvZy1hcHByZWdpc3RyeScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFUlZFUl9NSUdSQVRJT05fU0VSVklDRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3NtcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFUlZFUl9NSUdSQVRJT05fU0VSVklDRV9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc21zLWZpcHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTRVJWRVJfTUlHUkFUSU9OX1NFUlZJQ0VfQVdTQ09OTkVDVE9SID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnYXdzY29ubmVjdG9yJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnZW1haWwtc210cCcpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNOUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3NucycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNRUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3NxcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNTTSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3NzbScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNTTV9NRVNTQUdFUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3NzbW1lc3NhZ2VzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1NNX0NPTlRBQ1RTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc3NtLWNvbnRhY3RzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1NNX0lOQ0lERU5UUyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3NzbS1pbmNpZGVudHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTVFMgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdzdHMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTTk9XX0RFVklDRV9NQU5BR0VNRU5UID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc25vdy1kZXZpY2UtbWFuYWdlbWVudCcpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFRFWFRSQUNUID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgndGV4dHJhY3QnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBURVhUUkFDVF9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgndGV4dHJhY3QtZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFRSQU5TRkVSID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgndHJhbnNmZXInKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBUUkFOU0ZFUl9TRVJWRVIgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCd0cmFuc2Zlci5zZXJ2ZXInKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBUUkFOU0xBVEUgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCd0cmFuc2xhdGUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTVE9SQUdFX0dBVEVXQVkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdzdG9yYWdlZ2F0ZXdheScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFS09HTklUSU9OID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncmVrb2duaXRpb24nKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRUtPR05JVElPTl9GSVBTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgncmVrb2duaXRpb24tZmlwcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNURVBfRlVOQ1RJT05TID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnc3RhdGVzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1RFUF9GVU5DVElPTlNfU1lOQyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3N5bmMtc3RhdGVzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVFJBTlNDUklCRSA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3RyYW5zY3JpYmUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBUUkFOU0NSSUJFX1NUUkVBTUlORyA9IG5ldyBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UoJ3RyYW5zY3JpYmVzdHJlYW1pbmcnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBXT1JLU1BBQ0VTID0gbmV3IEludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZSgnd29ya3NwYWNlcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFhSQVkgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCd4cmF5Jyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VDVVJJVFlIVUIgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdzZWN1cml0eWh1YicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVNQUlMX1NNVFAgPSBuZXcgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdlbWFpbC1zbXRwJyk7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBzZXJ2aWNlLiBlLmcuIGNvbS5hbWF6b25hd3MudXMtZWFzdC0xLmVjc1xuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHNob3J0IG5hbWUgb2YgdGhlIHNlcnZpY2UuIGUuZy4gZWNzXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgc2hvcnROYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwb3J0IG9mIHRoZSBzZXJ2aWNlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcblxuICAvKipcbiAgICogV2hldGhlciBQcml2YXRlIEROUyBpcyBzdXBwb3J0ZWQgYnkgZGVmYXVsdC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBwcml2YXRlRG5zRGVmYXVsdD86IGJvb2xlYW4gPSB0cnVlO1xuXG4gIGNvbnN0cnVjdG9yKG5hbWU6IHN0cmluZywgcHJlZml4Pzogc3RyaW5nLCBwb3J0PzogbnVtYmVyKSB7XG4gICAgY29uc3QgcmVnaW9uID0gTGF6eS51bmNhY2hlZFN0cmluZyh7XG4gICAgICBwcm9kdWNlOiAoY29udGV4dCkgPT4gU3RhY2sub2YoY29udGV4dC5zY29wZSkucmVnaW9uLFxuICAgIH0pO1xuICAgIGNvbnN0IGRlZmF1bHRFbmRwb2ludFByZWZpeCA9IExhenkudW5jYWNoZWRTdHJpbmcoe1xuICAgICAgcHJvZHVjZTogKGNvbnRleHQpID0+IHtcbiAgICAgICAgY29uc3QgcmVnaW9uTmFtZSA9IFN0YWNrLm9mKGNvbnRleHQuc2NvcGUpLnJlZ2lvbjtcbiAgICAgICAgcmV0dXJuIHRoaXMuZ2V0RGVmYXVsdEVuZHBvaW50UHJlZml4KG5hbWUsIHJlZ2lvbk5hbWUpO1xuICAgICAgfSxcbiAgICB9KTtcbiAgICBjb25zdCBkZWZhdWx0RW5kcG9pbnRTdWZmaXggPSBMYXp5LnVuY2FjaGVkU3RyaW5nKHtcbiAgICAgIHByb2R1Y2U6IChjb250ZXh0KSA9PiB7XG4gICAgICAgIGNvbnN0IHJlZ2lvbk5hbWUgPSBTdGFjay5vZihjb250ZXh0LnNjb3BlKS5yZWdpb247XG4gICAgICAgIHJldHVybiB0aGlzLmdldERlZmF1bHRFbmRwb2ludFN1ZmZpeChuYW1lLCByZWdpb25OYW1lKTtcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLm5hbWUgPSBgJHtwcmVmaXggfHwgZGVmYXVsdEVuZHBvaW50UHJlZml4fS4ke3JlZ2lvbn0uJHtuYW1lfSR7ZGVmYXVsdEVuZHBvaW50U3VmZml4fWA7XG4gICAgdGhpcy5zaG9ydE5hbWUgPSBuYW1lO1xuICAgIHRoaXMucG9ydCA9IHBvcnQgfHwgNDQzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldCB0aGUgZW5kcG9pbnQgcHJlZml4IGZvciB0aGUgc2VydmljZSBpbiB0aGUgc3BlY2lmaWVkIHJlZ2lvblxuICAgKiBiZWNhdXNlIHRoZSBwcmVmaXggZm9yIHNvbWUgb2YgdGhlIHNlcnZpY2VzIGluIGNuLW5vcnRoLTEgYW5kIGNuLW5vcnRod2VzdC0xIGFyZSBkaWZmZXJlbnRcbiAgICpcbiAgICogRm9yIGZ1dHVyZSBtYWludGVuYW5jZe+8jCB0aGUgdnBjIGVuZHBvaW50IHNlcnZpY2VzIGNvdWxkIGJlIGZldGNoZWQgdXNpbmcgQVdTIENMSSBDb21tbWFuZDpcbiAgICogYXdzIGVjMiBkZXNjcmliZS12cGMtZW5kcG9pbnQtc2VydmljZXNcbiAgICovXG4gIHByaXZhdGUgZ2V0RGVmYXVsdEVuZHBvaW50UHJlZml4KG5hbWU6IHN0cmluZywgcmVnaW9uOiBzdHJpbmcpIHtcbiAgICBjb25zdCBWUENfRU5EUE9JTlRfU0VSVklDRV9FWENFUFRJT05TOiB7IFtyZWdpb246IHN0cmluZ106IHN0cmluZ1tdIH0gPSB7XG4gICAgICAnY24tbm9ydGgtMSc6IFsnYXBwbGljYXRpb24tYXV0b3NjYWxpbmcnLCAnYXRoZW5hJywgJ2F1dG9zY2FsaW5nJywgJ2F3c2Nvbm5lY3RvcicsICdjYXNzYW5kcmEnLFxuICAgICAgICAnY2xvdWRmb3JtYXRpb24nLCAnY29kZWRlcGxveS1jb21tYW5kcy1zZWN1cmUnLCAnZGF0YWJyZXcnLCAnZG1zJywgJ2VicycsICdlYzInLCAnZWNyLmFwaScsICdlY3IuZGtyJyxcbiAgICAgICAgJ2VsYXN0aWNiZWFuc3RhbGsnLCAnZWxhc3RpY2ZpbGVzeXN0ZW0nLCAnZWxhc3RpY2ZpbGVzeXN0ZW0tZmlwcycsICdleGVjdXRlLWFwaScsICdpbWFnZWJ1aWxkZXInLFxuICAgICAgICAnaW90c2l0ZXdpc2UuYXBpJywgJ2lvdHNpdGV3aXNlLmRhdGEnLCAna2luZXNpcy1zdHJlYW1zJywgJ2xhbWJkYScsICdsaWNlbnNlLW1hbmFnZXInLCAnbW9uaXRvcmluZycsXG4gICAgICAgICdyZHMnLCAncmVkc2hpZnQnLCAncmVkc2hpZnQtZGF0YScsICdzMycsICdzYWdlbWFrZXIuYXBpJywgJ3NhZ2VtYWtlci5mZWF0dXJlc3RvcmUtcnVudGltZScsXG4gICAgICAgICdzYWdlbWFrZXIucnVudGltZScsICdzZXJ2aWNlY2F0YWxvZycsICdzbXMnLCAnc3FzJywgJ3N0YXRlcycsICdzdHMnLCAnc3ludGhldGljcycsICd0cmFuc2NyaWJlJyxcbiAgICAgICAgJ3RyYW5zY3JpYmVzdHJlYW1pbmcnLCAndHJhbnNmZXInLCAneHJheSddLFxuICAgICAgJ2NuLW5vcnRod2VzdC0xJzogWydhcHBsaWNhdGlvbi1hdXRvc2NhbGluZycsICdhdGhlbmEnLCAnYXV0b3NjYWxpbmcnLCAnYXdzY29ubmVjdG9yJywgJ2Nhc3NhbmRyYScsXG4gICAgICAgICdjbG91ZGZvcm1hdGlvbicsICdjb2RlZGVwbG95LWNvbW1hbmRzLXNlY3VyZScsICdkYXRhYnJldycsICdkbXMnLCAnZWJzJywgJ2VjMicsICdlY3IuYXBpJywgJ2Vjci5ka3InLFxuICAgICAgICAnZWxhc3RpY2JlYW5zdGFsaycsICdlbGFzdGljZmlsZXN5c3RlbScsICdlbGFzdGljZmlsZXN5c3RlbS1maXBzJywgJ2V4ZWN1dGUtYXBpJywgJ2ltYWdlYnVpbGRlcicsXG4gICAgICAgICdraW5lc2lzLXN0cmVhbXMnLCAnbGFtYmRhJywgJ2xpY2Vuc2UtbWFuYWdlcicsICdtb25pdG9yaW5nJywgJ3JkcycsICdyZWRzaGlmdCcsICdyZWRzaGlmdC1kYXRhJywgJ3MzJyxcbiAgICAgICAgJ3NhZ2VtYWtlci5hcGknLCAnc2FnZW1ha2VyLmZlYXR1cmVzdG9yZS1ydW50aW1lJywgJ3NhZ2VtYWtlci5ydW50aW1lJywgJ3NlcnZpY2VjYXRhbG9nJywgJ3NtcycsICdzcXMnLFxuICAgICAgICAnc3RhdGVzJywgJ3N0cycsICdzeW50aGV0aWNzJywgJ3RyYW5zY3JpYmUnLCAndHJhbnNjcmliZXN0cmVhbWluZycsICd0cmFuc2ZlcicsICd3b3Jrc3BhY2VzJywgJ3hyYXknXSxcbiAgICB9O1xuICAgIGlmIChWUENfRU5EUE9JTlRfU0VSVklDRV9FWENFUFRJT05TW3JlZ2lvbl0/LmluY2x1ZGVzKG5hbWUpKSB7XG4gICAgICByZXR1cm4gJ2NuLmNvbS5hbWF6b25hd3MnO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gJ2NvbS5hbWF6b25hd3MnO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBHZXQgdGhlIGVuZHBvaW50IHN1ZmZpeCBmb3IgdGhlIHNlcnZpY2UgaW4gdGhlIHNwZWNpZmllZCByZWdpb24uXG4gICAqIEluIGNuLW5vcnRoLTEgYW5kIGNuLW5vcnRod2VzdC0xLCB0aGUgdnBjIGVuZHBvaW50IG9mIHRyYW5zY3JpYmUgaXM6XG4gICAqICAgY24uY29tLmFtYXpvbmF3cy5jbi1ub3J0aC0xLnRyYW5zY3JpYmUuY25cbiAgICogICBjbi5jb20uYW1hem9uYXdzLmNuLW5vcnRod2VzdC0xLnRyYW5zY3JpYmUuY25cbiAgICogc28gc3VmZml4ICcuY24nIHNob3VsZCBiZSByZXR1cm4gaW4gdGhlc2Ugc2NlbmFyaW9zLlxuICAgKlxuICAgKiBGb3IgZnV0dXJlIG1haW50ZW5hbmNl77yMIHRoZSB2cGMgZW5kcG9pbnQgc2VydmljZXMgY291bGQgYmUgZmV0Y2hlZCB1c2luZyBBV1MgQ0xJIENvbW1tYW5kOlxuICAgKiBhd3MgZWMyIGRlc2NyaWJlLXZwYy1lbmRwb2ludC1zZXJ2aWNlc1xuICAgKi9cbiAgcHJpdmF0ZSBnZXREZWZhdWx0RW5kcG9pbnRTdWZmaXgobmFtZTogc3RyaW5nLCByZWdpb246IHN0cmluZykge1xuICAgIGNvbnN0IFZQQ19FTkRQT0lOVF9TRVJWSUNFX0VYQ0VQVElPTlM6IHsgW3JlZ2lvbjogc3RyaW5nXTogc3RyaW5nW10gfSA9IHtcbiAgICAgICdjbi1ub3J0aC0xJzogWyd0cmFuc2NyaWJlJ10sXG4gICAgICAnY24tbm9ydGh3ZXN0LTEnOiBbJ3RyYW5zY3JpYmUnXSxcbiAgICB9O1xuICAgIHJldHVybiBWUENfRU5EUE9JTlRfU0VSVklDRV9FWENFUFRJT05TW3JlZ2lvbl0/LmluY2x1ZGVzKG5hbWUpID8gJy5jbicgOiAnJztcbiAgfVxufVxuXG4vKipcbiAqIE9wdGlvbnMgdG8gYWRkIGFuIGludGVyZmFjZSBlbmRwb2ludCB0byBhIFZQQy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbnRlcmZhY2VWcGNFbmRwb2ludE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIHNlcnZpY2UgdG8gdXNlIGZvciB0aGlzIGludGVyZmFjZSBWUEMgZW5kcG9pbnQuXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlOiBJSW50ZXJmYWNlVnBjRW5kcG9pbnRTZXJ2aWNlO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIGFzc29jaWF0ZSBhIHByaXZhdGUgaG9zdGVkIHpvbmUgd2l0aCB0aGUgc3BlY2lmaWVkIFZQQy4gVGhpc1xuICAgKiBhbGxvd3MgeW91IHRvIG1ha2UgcmVxdWVzdHMgdG8gdGhlIHNlcnZpY2UgdXNpbmcgaXRzIGRlZmF1bHQgRE5TIGhvc3RuYW1lLlxuICAgKlxuICAgKiBAZGVmYXVsdCBzZXQgYnkgdGhlIGluc3RhbmNlIG9mIElJbnRlcmZhY2VWcGNFbmRwb2ludFNlcnZpY2UsIG9yIHRydWUgaWZcbiAgICogbm90IGRlZmluZWQgYnkgdGhlIGluc3RhbmNlIG9mIElJbnRlcmZhY2VWcGNFbmRwb2ludFNlcnZpY2VcbiAgICovXG4gIHJlYWRvbmx5IHByaXZhdGVEbnNFbmFibGVkPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIHN1Ym5ldHMgaW4gd2hpY2ggdG8gY3JlYXRlIGFuIGVuZHBvaW50IG5ldHdvcmsgaW50ZXJmYWNlLiBBdCBtb3N0IG9uZVxuICAgKiBwZXIgYXZhaWxhYmlsaXR5IHpvbmUuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gcHJpdmF0ZSBzdWJuZXRzXG4gICAqL1xuICByZWFkb25seSBzdWJuZXRzPzogU3VibmV0U2VsZWN0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgc2VjdXJpdHkgZ3JvdXBzIHRvIGFzc29jaWF0ZSB3aXRoIHRoaXMgaW50ZXJmYWNlIFZQQyBlbmRwb2ludC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBhIG5ldyBzZWN1cml0eSBncm91cCBpcyBjcmVhdGVkXG4gICAqL1xuICByZWFkb25seSBzZWN1cml0eUdyb3Vwcz86IElTZWN1cml0eUdyb3VwW107XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gYXV0b21hdGljYWxseSBhbGxvdyBWUEMgdHJhZmZpYyB0byB0aGUgZW5kcG9pbnRcbiAgICpcbiAgICogSWYgZW5hYmxlZCwgYWxsIHRyYWZmaWMgdG8gdGhlIGVuZHBvaW50IGZyb20gd2l0aGluIHRoZSBWUEMgd2lsbCBiZVxuICAgKiBhdXRvbWF0aWNhbGx5IGFsbG93ZWQuIFRoaXMgaXMgZG9uZSBiYXNlZCBvbiB0aGUgVlBDJ3MgQ0lEUiByYW5nZS5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgb3Blbj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIExpbWl0IHRvIG9ubHkgdGhvc2UgYXZhaWxhYmlsaXR5IHpvbmVzIHdoZXJlIHRoZSBlbmRwb2ludCBzZXJ2aWNlIGNhbiBiZSBjcmVhdGVkXG4gICAqXG4gICAqIFNldHRpbmcgdGhpcyB0byAndHJ1ZScgcmVxdWlyZXMgYSBsb29rdXAgdG8gYmUgcGVyZm9ybWVkIGF0IHN5bnRoZXNpcyB0aW1lLiBBY2NvdW50XG4gICAqIGFuZCByZWdpb24gbXVzdCBiZSBzZXQgb24gdGhlIGNvbnRhaW5pbmcgc3RhY2sgZm9yIHRoaXMgdG8gd29yay5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGxvb2t1cFN1cHBvcnRlZEF6cz86IGJvb2xlYW47XG59XG5cbi8qKlxuICogQ29uc3RydWN0aW9uIHByb3BlcnRpZXMgZm9yIGFuIEludGVyZmFjZVZwY0VuZHBvaW50LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEludGVyZmFjZVZwY0VuZHBvaW50UHJvcHMgZXh0ZW5kcyBJbnRlcmZhY2VWcGNFbmRwb2ludE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIFZQQyBuZXR3b3JrIGluIHdoaWNoIHRoZSBpbnRlcmZhY2UgZW5kcG9pbnQgd2lsbCBiZSB1c2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgdnBjOiBJVnBjXG59XG5cbi8qKlxuICogQW4gaW50ZXJmYWNlIFZQQyBlbmRwb2ludC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJSW50ZXJmYWNlVnBjRW5kcG9pbnQgZXh0ZW5kcyBJVnBjRW5kcG9pbnQsIElDb25uZWN0YWJsZSB7XG59XG5cbi8qKlxuICogQSBpbnRlcmZhY2UgVlBDIGVuZHBvaW50LlxuICogQHJlc291cmNlIEFXUzo6RUMyOjpWUENFbmRwb2ludFxuICovXG5leHBvcnQgY2xhc3MgSW50ZXJmYWNlVnBjRW5kcG9pbnQgZXh0ZW5kcyBWcGNFbmRwb2ludCBpbXBsZW1lbnRzIElJbnRlcmZhY2VWcGNFbmRwb2ludCB7XG4gIC8qKlxuICAgKiBJbXBvcnRzIGFuIGV4aXN0aW5nIGludGVyZmFjZSBWUEMgZW5kcG9pbnQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21JbnRlcmZhY2VWcGNFbmRwb2ludEF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IEludGVyZmFjZVZwY0VuZHBvaW50QXR0cmlidXRlcyk6IElJbnRlcmZhY2VWcGNFbmRwb2ludCB7XG4gICAgY29uc3Qgc2VjdXJpdHlHcm91cHMgPSBhdHRycy5zZWN1cml0eUdyb3VwSWRcbiAgICAgID8gW1NlY3VyaXR5R3JvdXAuZnJvbVNlY3VyaXR5R3JvdXBJZChzY29wZSwgJ1NlY3VyaXR5R3JvdXAnLCBhdHRycy5zZWN1cml0eUdyb3VwSWQpXVxuICAgICAgOiBhdHRycy5zZWN1cml0eUdyb3VwcztcblxuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUludGVyZmFjZVZwY0VuZHBvaW50IHtcbiAgICAgIHB1YmxpYyByZWFkb25seSB2cGNFbmRwb2ludElkID0gYXR0cnMudnBjRW5kcG9pbnRJZDtcbiAgICAgIHB1YmxpYyByZWFkb25seSBjb25uZWN0aW9ucyA9IG5ldyBDb25uZWN0aW9ucyh7XG4gICAgICAgIGRlZmF1bHRQb3J0OiBQb3J0LnRjcChhdHRycy5wb3J0KSxcbiAgICAgICAgc2VjdXJpdHlHcm91cHMsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBpbnRlcmZhY2UgVlBDIGVuZHBvaW50IGlkZW50aWZpZXIuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjRW5kcG9pbnRJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgZGF0ZSBhbmQgdGltZSB0aGUgaW50ZXJmYWNlIFZQQyBlbmRwb2ludCB3YXMgY3JlYXRlZC5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZwY0VuZHBvaW50Q3JlYXRpb25UaW1lc3RhbXA6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEROUyBlbnRyaWVzIGZvciB0aGUgaW50ZXJmYWNlIFZQQyBlbmRwb2ludC5cbiAgICogRWFjaCBlbnRyeSBpcyBhIGNvbWJpbmF0aW9uIG9mIHRoZSBob3N0ZWQgem9uZSBJRCBhbmQgdGhlIEROUyBuYW1lLlxuICAgKiBUaGUgZW50cmllcyBhcmUgb3JkZXJlZCBhcyBmb2xsb3dzOiByZWdpb25hbCBwdWJsaWMgRE5TLCB6b25hbCBwdWJsaWMgRE5TLCBwcml2YXRlIEROUywgYW5kIHdpbGRjYXJkIEROUy5cbiAgICogVGhpcyBvcmRlciBpcyBub3QgZW5mb3JjZWQgZm9yIEFXUyBNYXJrZXRwbGFjZSBzZXJ2aWNlcy5cbiAgICpcbiAgICogVGhlIGZvbGxvd2luZyBpcyBhbiBleGFtcGxlLiBJbiB0aGUgZmlyc3QgZW50cnksIHRoZSBob3N0ZWQgem9uZSBJRCBpcyBaMUhVQjIzVVVMUVhWXG4gICAqIGFuZCB0aGUgRE5TIG5hbWUgaXMgdnBjZS0wMWFiYzIzNDU2ZGU3OGY5Zy0xMmFiY2NkMy5lYzIudXMtZWFzdC0xLnZwY2UuYW1hem9uYXdzLmNvbS5cbiAgICpcbiAgICogW1wiWjFIVUIyM1VVTFFYVjp2cGNlLTAxYWJjMjM0NTZkZTc4ZjlnLTEyYWJjY2QzLmVjMi51cy1lYXN0LTEudnBjZS5hbWF6b25hd3MuY29tXCIsXG4gICAqIFwiWjFIVUIyM1VVTFFYVjp2cGNlLTAxYWJjMjM0NTZkZTc4ZjlnLTEyYWJjY2QzLXVzLWVhc3QtMWEuZWMyLnVzLWVhc3QtMS52cGNlLmFtYXpvbmF3cy5jb21cIixcbiAgICogXCJaMUMxMjM0NFZZRElUQjA6ZWMyLnVzLWVhc3QtMS5hbWF6b25hd3MuY29tXCJdXG4gICAqXG4gICAqIElmIHlvdSB1cGRhdGUgdGhlIFByaXZhdGVEbnNFbmFibGVkIG9yIFN1Ym5ldElkcyBwcm9wZXJ0aWVzLCB0aGUgRE5TIGVudHJpZXMgaW4gdGhlIGxpc3Qgd2lsbCBjaGFuZ2UuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB2cGNFbmRwb2ludERuc0VudHJpZXM6IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBPbmUgb3IgbW9yZSBuZXR3b3JrIGludGVyZmFjZXMgZm9yIHRoZSBpbnRlcmZhY2UgVlBDIGVuZHBvaW50LlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjRW5kcG9pbnROZXR3b3JrSW50ZXJmYWNlSWRzOiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIGZpcnN0IHNlY3VyaXR5IGdyb3VwIGFzc29jaWF0ZWQgd2l0aCB0aGlzIGludGVyZmFjZVxuICAgKiBWUEMgZW5kcG9pbnQuXG4gICAqXG4gICAqIEBkZXByZWNhdGVkIHVzZSB0aGUgYGNvbm5lY3Rpb25zYCBvYmplY3RcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzZWN1cml0eUdyb3VwSWQ6IHN0cmluZztcblxuICAvKipcbiAgICogQWNjZXNzIHRvIG5ldHdvcmsgY29ubmVjdGlvbnMuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY29ubmVjdGlvbnM6IENvbm5lY3Rpb25zO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBJbnRlcmZhY2VWcGNFbmRwb2ludFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHNlY3VyaXR5R3JvdXBzID0gcHJvcHMuc2VjdXJpdHlHcm91cHMgfHwgW25ldyBTZWN1cml0eUdyb3VwKHRoaXMsICdTZWN1cml0eUdyb3VwJywge1xuICAgICAgdnBjOiBwcm9wcy52cGMsXG4gICAgfSldO1xuXG4gICAgdGhpcy5zZWN1cml0eUdyb3VwSWQgPSBzZWN1cml0eUdyb3Vwc1swXS5zZWN1cml0eUdyb3VwSWQ7XG4gICAgdGhpcy5jb25uZWN0aW9ucyA9IG5ldyBDb25uZWN0aW9ucyh7XG4gICAgICBkZWZhdWx0UG9ydDogUG9ydC50Y3AocHJvcHMuc2VydmljZS5wb3J0KSxcbiAgICAgIHNlY3VyaXR5R3JvdXBzLFxuICAgIH0pO1xuXG4gICAgaWYgKHByb3BzLm9wZW4gIT09IGZhbHNlKSB7XG4gICAgICB0aGlzLmNvbm5lY3Rpb25zLmFsbG93RGVmYXVsdFBvcnRGcm9tKFBlZXIuaXB2NChwcm9wcy52cGMudnBjQ2lkckJsb2NrKSk7XG4gICAgfVxuXG4gICAgLy8gRGV0ZXJtaW5lIHdoaWNoIHN1Ym5ldHMgdG8gcGxhY2UgdGhlIGVuZHBvaW50IGluXG4gICAgY29uc3Qgc3VibmV0SWRzID0gdGhpcy5lbmRwb2ludFN1Ym5ldHMocHJvcHMpO1xuXG4gICAgY29uc3QgZW5kcG9pbnQgPSBuZXcgQ2ZuVlBDRW5kcG9pbnQodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgcHJpdmF0ZURuc0VuYWJsZWQ6IHByb3BzLnByaXZhdGVEbnNFbmFibGVkID8/IHByb3BzLnNlcnZpY2UucHJpdmF0ZURuc0RlZmF1bHQgPz8gdHJ1ZSxcbiAgICAgIHBvbGljeURvY3VtZW50OiBMYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMucG9saWN5RG9jdW1lbnQgfSksXG4gICAgICBzZWN1cml0eUdyb3VwSWRzOiBzZWN1cml0eUdyb3Vwcy5tYXAocyA9PiBzLnNlY3VyaXR5R3JvdXBJZCksXG4gICAgICBzZXJ2aWNlTmFtZTogcHJvcHMuc2VydmljZS5uYW1lLFxuICAgICAgdnBjRW5kcG9pbnRUeXBlOiBWcGNFbmRwb2ludFR5cGUuSU5URVJGQUNFLFxuICAgICAgc3VibmV0SWRzLFxuICAgICAgdnBjSWQ6IHByb3BzLnZwYy52cGNJZCxcbiAgICB9KTtcblxuICAgIHRoaXMudnBjRW5kcG9pbnRJZCA9IGVuZHBvaW50LnJlZjtcbiAgICB0aGlzLnZwY0VuZHBvaW50Q3JlYXRpb25UaW1lc3RhbXAgPSBlbmRwb2ludC5hdHRyQ3JlYXRpb25UaW1lc3RhbXA7XG4gICAgdGhpcy52cGNFbmRwb2ludERuc0VudHJpZXMgPSBlbmRwb2ludC5hdHRyRG5zRW50cmllcztcbiAgICB0aGlzLnZwY0VuZHBvaW50TmV0d29ya0ludGVyZmFjZUlkcyA9IGVuZHBvaW50LmF0dHJOZXR3b3JrSW50ZXJmYWNlSWRzO1xuICB9XG5cbiAgLyoqXG4gICAqIERldGVybWluZSB3aGljaCBzdWJuZXRzIHRvIHBsYWNlIHRoZSBlbmRwb2ludCBpbi4gVGhpcyBpcyBpbiBpdHMgb3duIGZ1bmN0aW9uXG4gICAqIGJlY2F1c2UgdGhlcmUncyBhIGxvdCBvZiBjb2RlLlxuICAgKi9cbiAgcHJpdmF0ZSBlbmRwb2ludFN1Ym5ldHMocHJvcHM6IEludGVyZmFjZVZwY0VuZHBvaW50UHJvcHMpIHtcbiAgICBjb25zdCBsb29rdXBTdXBwb3J0ZWRBenMgPSBwcm9wcy5sb29rdXBTdXBwb3J0ZWRBenMgPz8gZmFsc2U7XG4gICAgY29uc3Qgc3VibmV0U2VsZWN0aW9uID0gcHJvcHMudnBjLnNlbGVjdFN1Ym5ldHMoeyAuLi5wcm9wcy5zdWJuZXRzLCBvbmVQZXJBejogdHJ1ZSB9KTtcbiAgICBjb25zdCBzdWJuZXRzID0gc3VibmV0U2VsZWN0aW9uLnN1Ym5ldHM7XG5cbiAgICAvLyBTYW5pdHkgY2hlY2sgdGhlIHN1Ym5ldCBjb3VudFxuICAgIGlmICghc3VibmV0U2VsZWN0aW9uLmlzUGVuZGluZ0xvb2t1cCAmJiBzdWJuZXRTZWxlY3Rpb24uc3VibmV0cy5sZW5ndGggPT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdDYW5ub3QgY3JlYXRlIGEgVlBDIEVuZHBvaW50IHdpdGggbm8gc3VibmV0cycpO1xuICAgIH1cblxuICAgIC8vIElmIHdlIGFyZW4ndCBnb2luZyB0byBsb29rdXAgc3VwcG9ydGVkIEFacyB3ZSdsbCBleGl0IGVhcmx5LCByZXR1cm5pbmcgdGhlIHN1Ym5ldElkcyBmcm9tIHRoZSBwcm92aWRlZCBzdWJuZXQgc2VsZWN0aW9uXG4gICAgaWYgKCFsb29rdXBTdXBwb3J0ZWRBenMpIHtcbiAgICAgIHJldHVybiBzdWJuZXRTZWxlY3Rpb24uc3VibmV0SWRzO1xuICAgIH1cblxuICAgIC8vIFNvbWUgc2VydmljZSBuYW1lcywgc3VjaCBhcyBBV1Mgc2VydmljZSBuYW1lIHJlZmVyZW5jZXMsIHVzZSBUb2tlbnMgdG8gYXV0b21hdGljYWxseSBmaWxsIGluIHRoZSByZWdpb25cbiAgICAvLyBJZiBpdCBpcyBhbiBJbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2UsIHRoZW4gdGhlIHJlZmVyZW5jZSB3aWxsIGJlIHJlc29sdmFibGUgc2luY2UgaXQgb25seSByZWZlcmVuY2VzIHRoZSByZWdpb25cbiAgICBjb25zdCBpc0F3c1NlcnZpY2UgPSBUb2tlbi5pc1VucmVzb2x2ZWQocHJvcHMuc2VydmljZS5uYW1lKSAmJiBwcm9wcy5zZXJ2aWNlIGluc3RhbmNlb2YgSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlO1xuXG4gICAgLy8gRGV0ZXJtaW5lIHdoYXQgc2VydmljZSBuYW1lIGdldHMgcGFzcyB0byB0aGUgY29udGV4dCBwcm92aWRlclxuICAgIC8vIElmIGl0IGlzIGFuIEFXUyBzZXJ2aWNlIGl0IHdpbGwgaGF2ZSBhIFJFR0lPTiB0b2tlblxuICAgIGNvbnN0IGxvb2t1cFNlcnZpY2VOYW1lID0gaXNBd3NTZXJ2aWNlID8gU3RhY2sub2YodGhpcykucmVzb2x2ZShwcm9wcy5zZXJ2aWNlLm5hbWUpIDogcHJvcHMuc2VydmljZS5uYW1lO1xuXG4gICAgLy8gQ2hlY2sgdGhhdCB0aGUgbG9va3VwIHdpbGwgd29ya1xuICAgIHRoaXMudmFsaWRhdGVDYW5Mb29rdXBTdXBwb3J0ZWRBenMoc3VibmV0cywgbG9va3VwU2VydmljZU5hbWUpO1xuXG4gICAgLy8gRG8gdGhlIGFjdHVhbCBsb29rdXAgZm9yIEFac1xuICAgIGNvbnN0IGF2YWlsYWJsZUFacyA9IHRoaXMuYXZhaWxhYmxlQXZhaWxhYmlsaXR5Wm9uZXMobG9va3VwU2VydmljZU5hbWUpO1xuICAgIGNvbnN0IGZpbHRlcmVkU3VibmV0cyA9IHN1Ym5ldHMuZmlsdGVyKHMgPT4gYXZhaWxhYmxlQVpzLmluY2x1ZGVzKHMuYXZhaWxhYmlsaXR5Wm9uZSkpO1xuXG4gICAgLy8gVGhyb3cgYW4gZXJyb3IgaWYgdGhlIGxvb2t1cCBmaWx0ZXJlZCBvdXQgYWxsIHN1Ym5ldHNcbiAgICAvLyBWcGNFbmRwb2ludHMgbXVzdCBiZSBjcmVhdGVkIHdpdGggYXQgbGVhc3Qgb25lIEFaXG4gICAgaWYgKGZpbHRlcmVkU3VibmV0cy5sZW5ndGggPT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBsb29rdXBTdXBwb3J0ZWRBenMgcmV0dXJuZWQgJHthdmFpbGFibGVBWnN9IGJ1dCBzdWJuZXRzIGhhdmUgQVpzICR7c3VibmV0cy5tYXAocyA9PiBzLmF2YWlsYWJpbGl0eVpvbmUpfWApO1xuICAgIH1cbiAgICByZXR1cm4gZmlsdGVyZWRTdWJuZXRzLm1hcChzID0+IHMuc3VibmV0SWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFNhbml0eSBjaGVja2luZyB3aGVuIGxvb2tpbmcgdXAgQVpzIGZvciBhbiBlbmRwb2ludCBzZXJ2aWNlLCB0byBtYWtlIHN1cmUgaXQgd29uJ3QgZmFpbFxuICAgKi9cbiAgcHJpdmF0ZSB2YWxpZGF0ZUNhbkxvb2t1cFN1cHBvcnRlZEF6cyhzdWJuZXRzOiBJU3VibmV0W10sIHNlcnZpY2VOYW1lOiBzdHJpbmcpIHtcblxuICAgIC8vIEhhdmluZyBhbnkgb2YgdGhlc2UgYmUgdHJ1ZSB3aWxsIGNhdXNlIHRoZSBBWiBsb29rdXAgdG8gZmFpbCBhdCBzeW50aGVzaXMgdGltZVxuICAgIGNvbnN0IGFnbm9zdGljQWNjdCA9IFRva2VuLmlzVW5yZXNvbHZlZCh0aGlzLmVudi5hY2NvdW50KTtcbiAgICBjb25zdCBhZ25vc3RpY1JlZ2lvbiA9IFRva2VuLmlzVW5yZXNvbHZlZCh0aGlzLmVudi5yZWdpb24pO1xuICAgIGNvbnN0IGFnbm9zdGljU2VydmljZSA9IFRva2VuLmlzVW5yZXNvbHZlZChzZXJ2aWNlTmFtZSk7XG5cbiAgICAvLyBIYXZpbmcgc3VibmV0cyB3aXRoIFRva2VuIEFacyBjYW4gY2F1c2UgdGhlIGVuZHBvaW50IHRvIGJlIGNyZWF0ZWQgd2l0aCBubyBzdWJuZXRzLCBmYWlsaW5nIGF0IGRlcGxveW1lbnQgdGltZVxuICAgIGNvbnN0IGFnbm9zdGljU3VibmV0cyA9IHN1Ym5ldHMuc29tZShzID0+IFRva2VuLmlzVW5yZXNvbHZlZChzLmF2YWlsYWJpbGl0eVpvbmUpKTtcbiAgICBjb25zdCBhZ25vc3RpY1N1Ym5ldExpc3QgPSBUb2tlbi5pc1VucmVzb2x2ZWQoc3VibmV0cy5tYXAocyA9PiBzLmF2YWlsYWJpbGl0eVpvbmUpKTtcblxuICAgIC8vIENvbnRleHQgcHJvdmlkZXIgY2Fubm90IG1ha2UgYW4gQVdTIGNhbGwgd2l0aG91dCBhbiBhY2NvdW50L3JlZ2lvblxuICAgIGlmIChhZ25vc3RpY0FjY3QgfHwgYWdub3N0aWNSZWdpb24pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGxvb2sgdXAgVlBDIGVuZHBvaW50IGF2YWlsYWJpbGl0eSB6b25lcyBpZiBhY2NvdW50L3JlZ2lvbiBhcmUgbm90IHNwZWNpZmllZCcpO1xuICAgIH1cblxuICAgIC8vIFRoZSBBV1MgY2FsbCB3aWxsIGZhaWwgaWYgdGhlcmUgaXMgYSBUb2tlbiBpbiB0aGUgc2VydmljZSBuYW1lXG4gICAgaWYgKGFnbm9zdGljU2VydmljZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBDYW5ub3QgbG9va3VwIEFacyBmb3IgYSBzZXJ2aWNlIG5hbWUgd2l0aCBhIFRva2VuOiAke3NlcnZpY2VOYW1lfWApO1xuICAgIH1cblxuICAgIC8vIFRoZSBBV1MgY2FsbCByZXR1cm4gc3RyaW5ncyBmb3IgQVpzLCBsaWtlIHVzLWVhc3QtMWEsIHVzLWVhc3QtMWIsIGV0Y1xuICAgIC8vIElmIHRoZSBzdWJuZXQgQVpzIGFyZSBUb2tlbnMsIGEgc3RyaW5nIGNvbXBhcmlzb24gYmV0d2VlbiB0aGUgc3VibmV0IEFacyBhbmQgdGhlIEFacyBmcm9tIHRoZSBBV1MgY2FsbFxuICAgIC8vIHdpbGwgbm90IG1hdGNoXG4gICAgaWYgKGFnbm9zdGljU3VibmV0cyB8fCBhZ25vc3RpY1N1Ym5ldExpc3QpIHtcbiAgICAgIGNvbnN0IGFnbm9zdGljID0gc3VibmV0cy5maWx0ZXIocyA9PiBUb2tlbi5pc1VucmVzb2x2ZWQocy5hdmFpbGFiaWxpdHlab25lKSk7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYGxvb2t1cFN1cHBvcnRlZEF6cyBjYW5ub3QgZmlsdGVyIG9uIHN1Ym5ldHMgd2l0aCBUb2tlbiBBWnM6ICR7YWdub3N0aWN9YCk7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBhdmFpbGFibGVBdmFpbGFiaWxpdHlab25lcyhzZXJ2aWNlTmFtZTogc3RyaW5nKTogc3RyaW5nW10ge1xuICAgIC8vIEhlcmUgd2UgY2hlY2sgd2hhdCBBWnMgdGhlIGVuZHBvaW50IHNlcnZpY2UgaXMgYXZhaWxhYmxlIGluXG4gICAgLy8gSWYgZm9yIHdoYXRldmVyIHJlYXNvbiB3ZSBjYW4ndCByZXRyaWV2ZSB0aGUgQVpzLCBhbmQgbm8gY29udGV4dCBpcyBzZXQsXG4gICAgLy8gd2Ugd2lsbCBmYWxsIGJhY2sgdG8gYWxsIEFac1xuICAgIGNvbnN0IGF2YWlsYWJsZUFacyA9IENvbnRleHRQcm92aWRlci5nZXRWYWx1ZSh0aGlzLCB7XG4gICAgICBwcm92aWRlcjogY3hzY2hlbWEuQ29udGV4dFByb3ZpZGVyLkVORFBPSU5UX1NFUlZJQ0VfQVZBSUxBQklMSVRZX1pPTkVfUFJPVklERVIsXG4gICAgICBkdW1teVZhbHVlOiB0aGlzLnN0YWNrLmF2YWlsYWJpbGl0eVpvbmVzLFxuICAgICAgcHJvcHM6IHsgc2VydmljZU5hbWUgfSxcbiAgICB9KS52YWx1ZTtcbiAgICBpZiAoIUFycmF5LmlzQXJyYXkoYXZhaWxhYmxlQVpzKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBEaXNjb3ZlcmVkIEFacyBmb3IgZW5kcG9pbnQgc2VydmljZSAke3NlcnZpY2VOYW1lfSBtdXN0IGJlIGFuIGFycmF5YCk7XG4gICAgfVxuICAgIHJldHVybiBhdmFpbGFibGVBWnM7XG4gIH1cbn1cblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBmb3IgYW4gSW1wb3J0ZWRJbnRlcmZhY2VWcGNFbmRwb2ludC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbnRlcmZhY2VWcGNFbmRwb2ludEF0dHJpYnV0ZXMge1xuICAvKipcbiAgICogVGhlIGludGVyZmFjZSBWUEMgZW5kcG9pbnQgaWRlbnRpZmllci5cbiAgICovXG4gIHJlYWRvbmx5IHZwY0VuZHBvaW50SWQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGlkZW50aWZpZXIgb2YgdGhlIHNlY3VyaXR5IGdyb3VwIGFzc29jaWF0ZWQgd2l0aCB0aGUgaW50ZXJmYWNlIFZQQyBlbmRwb2ludC5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWQgdXNlIGBzZWN1cml0eUdyb3Vwc2AgaW5zdGVhZFxuICAgKi9cbiAgcmVhZG9ubHkgc2VjdXJpdHlHcm91cElkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgc2VjdXJpdHkgZ3JvdXBzIGFzc29jaWF0ZWQgd2l0aCB0aGUgaW50ZXJmYWNlIFZQQyBlbmRwb2ludC5cbiAgICpcbiAgICogSWYgeW91IHdpc2ggdG8gbWFuYWdlIHRoZSBuZXR3b3JrIGNvbm5lY3Rpb25zIGFzc29jaWF0ZWQgd2l0aCB0aGlzIGVuZHBvaW50LFxuICAgKiB5b3Ugd2lsbCBuZWVkIHRvIHNwZWNpZnkgaXRzIHNlY3VyaXR5IGdyb3Vwcy5cbiAgICovXG4gIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBzPzogSVNlY3VyaXR5R3JvdXBbXTtcblxuICAvKipcbiAgICogVGhlIHBvcnQgb2YgdGhlIHNlcnZpY2Ugb2YgdGhlIGludGVyZmFjZSBWUEMgZW5kcG9pbnQuXG4gICAqL1xuICByZWFkb25seSBwb3J0OiBudW1iZXI7XG59XG4iXX0=