"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledFargateTask = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("../../../aws-ecs");
const aws_events_targets_1 = require("../../../aws-events-targets");
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 */
class ScheduledFargateTask extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_patterns_ScheduledFargateTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScheduledFargateTask);
            }
            throw error;
        }
        if (props.scheduledFargateTaskDefinitionOptions && props.scheduledFargateTaskImageOptions) {
            throw new Error('You must specify either a scheduledFargateTaskDefinitionOptions or scheduledFargateTaskOptions, not both.');
        }
        else if (props.scheduledFargateTaskDefinitionOptions) {
            this.taskDefinition = props.scheduledFargateTaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledFargateTaskImageOptions) {
            const taskImageOptions = props.scheduledFargateTaskImageOptions;
            this.taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'ScheduledTaskDef', {
                memoryLimitMiB: taskImageOptions.memoryLimitMiB || 512,
                cpu: taskImageOptions.cpu || 256,
            });
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: taskImageOptions.logDriver ?? this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify one of: taskDefinition or image');
        }
        // Use the EcsTask as the target of the EventRule
        this.task = new aws_events_targets_1.EcsTask({
            cluster: this.cluster,
            taskDefinition: this.taskDefinition,
            taskCount: this.desiredTaskCount,
            subnetSelection: this.subnetSelection,
            platformVersion: props.platformVersion,
            securityGroups: props.securityGroups,
        });
        this.addTaskAsTarget(this.task);
    }
}
_a = JSII_RTTI_SYMBOL_1;
ScheduledFargateTask[_a] = { fqn: "aws-cdk-lib.aws_ecs_patterns.ScheduledFargateTask", version: "2.74.0" };
exports.ScheduledFargateTask = ScheduledFargateTask;
//# sourceMappingURL=data:application/json;base64,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