"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BottleRocketImage = exports.BottlerocketEcsVariant = exports.EcsOptimizedImage = exports.EcsOptimizedAmi = exports.WindowsOptimizedVersion = exports.AmiHardwareType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const ssm = require("../../aws-ssm");
/**
 * The ECS-optimized AMI variant to use. For more information, see
 * [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
 */
var AmiHardwareType;
(function (AmiHardwareType) {
    /**
     * Use the standard Amazon ECS-optimized AMI.
     */
    AmiHardwareType["STANDARD"] = "Standard";
    /**
     * Use the Amazon ECS GPU-optimized AMI.
     */
    AmiHardwareType["GPU"] = "GPU";
    /**
     * Use the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI.
     */
    AmiHardwareType["ARM"] = "ARM64";
})(AmiHardwareType = exports.AmiHardwareType || (exports.AmiHardwareType = {}));
/**
 * ECS-optimized Windows version list
 */
var WindowsOptimizedVersion;
(function (WindowsOptimizedVersion) {
    WindowsOptimizedVersion["SERVER_2019"] = "2019";
    WindowsOptimizedVersion["SERVER_2016"] = "2016";
})(WindowsOptimizedVersion = exports.WindowsOptimizedVersion || (exports.WindowsOptimizedVersion = {}));
const BR_IMAGE_SYMBOL = Symbol.for('@aws-cdk/aws-ecs/lib/amis.BottleRocketImage');
/*
 * TODO:v2.0.0 remove EcsOptimizedAmi
 */
/**
 * Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM
 *
 * @deprecated see `EcsOptimizedImage#amazonLinux`, `EcsOptimizedImage#amazonLinux` and `EcsOptimizedImage#windows`
 */
class EcsOptimizedAmi {
    /**
     * Constructs a new instance of the EcsOptimizedAmi class.
     */
    constructor(props) {
        this.hwType = (props && props.hardwareType) || AmiHardwareType.STANDARD;
        if (props && props.generation) { // generation defined in the props object
            if (props.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX && this.hwType !== AmiHardwareType.STANDARD) {
                throw new Error('Amazon Linux does not support special hardware type. Use Amazon Linux 2 instead');
            }
            else if (props.windowsVersion) {
                throw new Error('"windowsVersion" and Linux image "generation" cannot be both set');
            }
            else {
                this.generation = props.generation;
            }
        }
        else if (props && props.windowsVersion) {
            if (this.hwType !== AmiHardwareType.STANDARD) {
                throw new Error('Windows Server does not support special hardware type');
            }
            else {
                this.windowsVersion = props.windowsVersion;
            }
        }
        else { // generation not defined in props object
            // always default to Amazon Linux v2 regardless of HW
            this.generation = ec2.AmazonLinuxGeneration.AMAZON_LINUX_2;
        }
        // set the SSM parameter name
        this.amiParameterName = '/aws/service/ecs/optimized-ami/'
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX ? 'amazon-linux/' : '')
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX_2 ? 'amazon-linux-2/' : '')
            + (this.windowsVersion ? `windows_server/${this.windowsVersion}/english/full/` : '')
            + (this.hwType === AmiHardwareType.GPU ? 'gpu/' : '')
            + (this.hwType === AmiHardwareType.ARM ? 'arm64/' : '')
            + 'recommended/image_id';
        this.cachedInContext = props?.cachedInContext ?? false;
    }
    /**
     * Return the correct image
     */
    getImage(scope) {
        const ami = lookupImage(scope, this.cachedInContext, this.amiParameterName);
        const osType = this.windowsVersion ? ec2.OperatingSystemType.WINDOWS : ec2.OperatingSystemType.LINUX;
        return {
            imageId: ami,
            osType,
            userData: ec2.UserData.forOperatingSystem(osType),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
EcsOptimizedAmi[_a] = { fqn: "aws-cdk-lib.aws_ecs.EcsOptimizedAmi", version: "2.74.0" };
exports.EcsOptimizedAmi = EcsOptimizedAmi;
/**
 * Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM
 */
class EcsOptimizedImage {
    /**
     * Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM
     *
     * @param hardwareType ECS-optimized AMI variant to use
     */
    static amazonLinux2(hardwareType = AmiHardwareType.STANDARD, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AmiHardwareType(hardwareType);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_EcsOptimizedImageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.amazonLinux2);
            }
            throw error;
        }
        return new EcsOptimizedImage({
            generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
            hardwareType,
            cachedInContext: options.cachedInContext,
        });
    }
    /**
     * Construct an Amazon Linux AMI image from the latest ECS Optimized AMI published in SSM
     */
    static amazonLinux(options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_EcsOptimizedImageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.amazonLinux);
            }
            throw error;
        }
        return new EcsOptimizedImage({
            generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX,
            cachedInContext: options.cachedInContext,
        });
    }
    /**
     * Construct a Windows image from the latest ECS Optimized AMI published in SSM
     *
     * @param windowsVersion Windows Version to use
     */
    static windows(windowsVersion, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_WindowsOptimizedVersion(windowsVersion);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_EcsOptimizedImageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.windows);
            }
            throw error;
        }
        return new EcsOptimizedImage({
            windowsVersion,
            cachedInContext: options.cachedInContext,
        });
    }
    /**
     * Constructs a new instance of the EcsOptimizedAmi class.
     */
    constructor(props) {
        this.hwType = props && props.hardwareType;
        if (props.windowsVersion) {
            this.windowsVersion = props.windowsVersion;
        }
        else if (props.generation) {
            this.generation = props.generation;
        }
        else {
            throw new Error('This error should never be thrown');
        }
        // set the SSM parameter name
        this.amiParameterName = '/aws/service/ecs/optimized-ami/'
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX ? 'amazon-linux/' : '')
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX_2 ? 'amazon-linux-2/' : '')
            + (this.windowsVersion ? `windows_server/${this.windowsVersion}/english/full/` : '')
            + (this.hwType === AmiHardwareType.GPU ? 'gpu/' : '')
            + (this.hwType === AmiHardwareType.ARM ? 'arm64/' : '')
            + 'recommended/image_id';
        this.cachedInContext = props?.cachedInContext ?? false;
    }
    /**
     * Return the correct image
     */
    getImage(scope) {
        const ami = lookupImage(scope, this.cachedInContext, this.amiParameterName);
        const osType = this.windowsVersion ? ec2.OperatingSystemType.WINDOWS : ec2.OperatingSystemType.LINUX;
        return {
            imageId: ami,
            osType,
            userData: ec2.UserData.forOperatingSystem(osType),
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
EcsOptimizedImage[_b] = { fqn: "aws-cdk-lib.aws_ecs.EcsOptimizedImage", version: "2.74.0" };
exports.EcsOptimizedImage = EcsOptimizedImage;
/**
 * Amazon ECS variant
 */
var BottlerocketEcsVariant;
(function (BottlerocketEcsVariant) {
    /**
     * aws-ecs-1 variant
     */
    BottlerocketEcsVariant["AWS_ECS_1"] = "aws-ecs-1";
})(BottlerocketEcsVariant = exports.BottlerocketEcsVariant || (exports.BottlerocketEcsVariant = {}));
/**
 * Construct an Bottlerocket image from the latest AMI published in SSM
 */
class BottleRocketImage {
    /**
     * Return whether the given object is a BottleRocketImage
     */
    static isBottleRocketImage(x) {
        return x !== null && typeof x === 'object' && BR_IMAGE_SYMBOL in x;
    }
    /**
     * Constructs a new instance of the BottleRocketImage class.
     */
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_BottleRocketImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BottleRocketImage);
            }
            throw error;
        }
        this.variant = props.variant ?? BottlerocketEcsVariant.AWS_ECS_1;
        this.architecture = props.architecture ?? ec2.InstanceArchitecture.X86_64;
        // set the SSM parameter name
        this.amiParameterName = `/aws/service/bottlerocket/${this.variant}/${this.architecture}/latest/image_id`;
        this.cachedInContext = props.cachedInContext ?? false;
    }
    /**
     * Return the correct image
     */
    getImage(scope) {
        const ami = lookupImage(scope, this.cachedInContext, this.amiParameterName);
        return {
            imageId: ami,
            osType: ec2.OperatingSystemType.LINUX,
            userData: ec2.UserData.custom(''),
        };
    }
}
_c = JSII_RTTI_SYMBOL_1;
BottleRocketImage[_c] = { fqn: "aws-cdk-lib.aws_ecs.BottleRocketImage", version: "2.74.0" };
exports.BottleRocketImage = BottleRocketImage;
Object.defineProperty(BottleRocketImage.prototype, BR_IMAGE_SYMBOL, {
    value: true,
    enumerable: false,
    writable: false,
});
function lookupImage(scope, cachedInContext, parameterName) {
    return cachedInContext
        ? ssm.StringParameter.valueFromLookup(scope, parameterName)
        : ssm.StringParameter.valueForTypedStringParameterV2(scope, parameterName, ssm.ParameterValueType.AWS_EC2_IMAGE_ID);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW1pcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFtaXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEscUNBQXFDO0FBQ3JDLHFDQUFxQztBQU1yQzs7O0dBR0c7QUFDSCxJQUFZLGVBZ0JYO0FBaEJELFdBQVksZUFBZTtJQUV6Qjs7T0FFRztJQUNILHdDQUFxQixDQUFBO0lBRXJCOztPQUVHO0lBQ0gsOEJBQVcsQ0FBQTtJQUVYOztPQUVHO0lBQ0gsZ0NBQWEsQ0FBQTtBQUNmLENBQUMsRUFoQlcsZUFBZSxHQUFmLHVCQUFlLEtBQWYsdUJBQWUsUUFnQjFCO0FBR0Q7O0dBRUc7QUFDSCxJQUFZLHVCQUdYO0FBSEQsV0FBWSx1QkFBdUI7SUFDakMsK0NBQW9CLENBQUE7SUFDcEIsK0NBQW9CLENBQUE7QUFDdEIsQ0FBQyxFQUhXLHVCQUF1QixHQUF2QiwrQkFBdUIsS0FBdkIsK0JBQXVCLFFBR2xDO0FBRUQsTUFBTSxlQUFlLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FDaEMsNkNBQTZDLENBQzlDLENBQUM7QUF3REY7O0dBRUc7QUFDSDs7OztHQUlHO0FBQ0gsTUFBYSxlQUFlO0lBUTFCOztPQUVHO0lBQ0gsWUFBWSxLQUE0QjtRQUN0QyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsS0FBSyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxlQUFlLENBQUMsUUFBUSxDQUFDO1FBQ3hFLElBQUksS0FBSyxJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUUsRUFBRSx5Q0FBeUM7WUFDeEUsSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxlQUFlLENBQUMsUUFBUSxFQUFFO2dCQUMzRyxNQUFNLElBQUksS0FBSyxDQUFDLGlGQUFpRixDQUFDLENBQUM7YUFDcEc7aUJBQU0sSUFBSSxLQUFLLENBQUMsY0FBYyxFQUFFO2dCQUMvQixNQUFNLElBQUksS0FBSyxDQUFDLGtFQUFrRSxDQUFDLENBQUM7YUFDckY7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO2FBQ3BDO1NBQ0Y7YUFBTSxJQUFJLEtBQUssSUFBSSxLQUFLLENBQUMsY0FBYyxFQUFFO1lBQ3hDLElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxlQUFlLENBQUMsUUFBUSxFQUFFO2dCQUM1QyxNQUFNLElBQUksS0FBSyxDQUFDLHVEQUF1RCxDQUFDLENBQUM7YUFDMUU7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO2FBQzVDO1NBQ0Y7YUFBTSxFQUFFLHlDQUF5QztZQUNoRCxxREFBcUQ7WUFDckQsSUFBSSxDQUFDLFVBQVUsR0FBRyxHQUFHLENBQUMscUJBQXFCLENBQUMsY0FBYyxDQUFDO1NBQzVEO1FBRUQsNkJBQTZCO1FBQzdCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxpQ0FBaUM7Y0FDckQsQ0FBQyxJQUFJLENBQUMsVUFBVSxLQUFLLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO2NBQ25GLENBQUMsSUFBSSxDQUFDLFVBQVUsS0FBSyxHQUFHLENBQUMscUJBQXFCLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO2NBQ3ZGLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsa0JBQWtCLElBQUksQ0FBQyxjQUFjLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7Y0FDbEYsQ0FBQyxJQUFJLENBQUMsTUFBTSxLQUFLLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO2NBQ25ELENBQUMsSUFBSSxDQUFDLE1BQU0sS0FBSyxlQUFlLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztjQUNyRCxzQkFBc0IsQ0FBQztRQUUzQixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssRUFBRSxlQUFlLElBQUksS0FBSyxDQUFDO0tBQ3hEO0lBRUQ7O09BRUc7SUFDSSxRQUFRLENBQUMsS0FBZ0I7UUFDOUIsTUFBTSxHQUFHLEdBQUcsV0FBVyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsZUFBZSxFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBRTVFLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLENBQUM7UUFDckcsT0FBTztZQUNMLE9BQU8sRUFBRSxHQUFHO1lBQ1osTUFBTTtZQUNOLFFBQVEsRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQztTQUNsRCxDQUFDO0tBQ0g7Ozs7QUF4RFUsMENBQWU7QUFxRjVCOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUFDNUI7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxZQUFZLENBQUMsWUFBWSxHQUFHLGVBQWUsQ0FBQyxRQUFRLEVBQUUsVUFBb0MsRUFBRTs7Ozs7Ozs7Ozs7UUFDeEcsT0FBTyxJQUFJLGlCQUFpQixDQUFDO1lBQzNCLFVBQVUsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsY0FBYztZQUNwRCxZQUFZO1lBQ1osZUFBZSxFQUFFLE9BQU8sQ0FBQyxlQUFlO1NBQ3pDLENBQUMsQ0FBQztLQUNKO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsV0FBVyxDQUFDLFVBQW9DLEVBQUU7Ozs7Ozs7Ozs7UUFDOUQsT0FBTyxJQUFJLGlCQUFpQixDQUFDO1lBQzNCLFVBQVUsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsWUFBWTtZQUNsRCxlQUFlLEVBQUUsT0FBTyxDQUFDLGVBQWU7U0FDekMsQ0FBQyxDQUFDO0tBQ0o7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLE9BQU8sQ0FBQyxjQUF1QyxFQUFFLFVBQW9DLEVBQUU7Ozs7Ozs7Ozs7O1FBQ25HLE9BQU8sSUFBSSxpQkFBaUIsQ0FBQztZQUMzQixjQUFjO1lBQ2QsZUFBZSxFQUFFLE9BQU8sQ0FBQyxlQUFlO1NBQ3pDLENBQUMsQ0FBQztLQUNKO0lBU0Q7O09BRUc7SUFDSCxZQUFvQixLQUEyQjtRQUM3QyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDO1FBRTFDLElBQUksS0FBSyxDQUFDLGNBQWMsRUFBRTtZQUN4QixJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7U0FDNUM7YUFBTSxJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUU7WUFDM0IsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1NBQ3BDO2FBQU07WUFDTCxNQUFNLElBQUksS0FBSyxDQUFDLG1DQUFtQyxDQUFDLENBQUM7U0FDdEQ7UUFFRCw2QkFBNkI7UUFDN0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGlDQUFpQztjQUNyRCxDQUFDLElBQUksQ0FBQyxVQUFVLEtBQUssR0FBRyxDQUFDLHFCQUFxQixDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7Y0FDbkYsQ0FBQyxJQUFJLENBQUMsVUFBVSxLQUFLLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7Y0FDdkYsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxrQkFBa0IsSUFBSSxDQUFDLGNBQWMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztjQUNsRixDQUFDLElBQUksQ0FBQyxNQUFNLEtBQUssZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7Y0FDbkQsQ0FBQyxJQUFJLENBQUMsTUFBTSxLQUFLLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO2NBQ3JELHNCQUFzQixDQUFDO1FBRTNCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxFQUFFLGVBQWUsSUFBSSxLQUFLLENBQUM7S0FDeEQ7SUFFRDs7T0FFRztJQUNJLFFBQVEsQ0FBQyxLQUFnQjtRQUM5QixNQUFNLEdBQUcsR0FBRyxXQUFXLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFFNUUsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQztRQUNyRyxPQUFPO1lBQ0wsT0FBTyxFQUFFLEdBQUc7WUFDWixNQUFNO1lBQ04sUUFBUSxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDO1NBQ2xELENBQUM7S0FDSDs7OztBQWpGVSw4Q0FBaUI7QUFvRjlCOztHQUVHO0FBQ0gsSUFBWSxzQkFNWDtBQU5ELFdBQVksc0JBQXNCO0lBQ2hDOztPQUVHO0lBQ0gsaURBQXVCLENBQUE7QUFFekIsQ0FBQyxFQU5XLHNCQUFzQixHQUF0Qiw4QkFBc0IsS0FBdEIsOEJBQXNCLFFBTWpDO0FBMkNEOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUFDNUI7O09BRUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsQ0FBTTtRQUN0QyxPQUFPLENBQUMsS0FBSyxJQUFJLElBQUksT0FBTyxDQUFDLEtBQUssUUFBUSxJQUFJLGVBQWUsSUFBSSxDQUFDLENBQUM7S0FDcEU7SUFlRDs7T0FFRztJQUNILFlBQW1CLFFBQWdDLEVBQUU7Ozs7OzsrQ0F4QjFDLGlCQUFpQjs7OztRQXlCMUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxJQUFJLHNCQUFzQixDQUFDLFNBQVMsQ0FBQztRQUNqRSxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLElBQUksR0FBRyxDQUFDLG9CQUFvQixDQUFDLE1BQU0sQ0FBQztRQUUxRSw2QkFBNkI7UUFDN0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLDZCQUE2QixJQUFJLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxZQUFZLGtCQUFrQixDQUFDO1FBRXpHLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsSUFBSSxLQUFLLENBQUM7S0FDdkQ7SUFFRDs7T0FFRztJQUNJLFFBQVEsQ0FBQyxLQUFnQjtRQUM5QixNQUFNLEdBQUcsR0FBRyxXQUFXLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFFNUUsT0FBTztZQUNMLE9BQU8sRUFBRSxHQUFHO1lBQ1osTUFBTSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLO1lBQ3JDLFFBQVEsRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUM7U0FDbEMsQ0FBQztLQUNIOzs7O0FBN0NVLDhDQUFpQjtBQWdEOUIsTUFBTSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsZUFBZSxFQUFFO0lBQ2xFLEtBQUssRUFBRSxJQUFJO0lBQ1gsVUFBVSxFQUFFLEtBQUs7SUFDakIsUUFBUSxFQUFFLEtBQUs7Q0FDaEIsQ0FBQyxDQUFDO0FBRUgsU0FBUyxXQUFXLENBQUMsS0FBZ0IsRUFBRSxlQUFvQyxFQUFFLGFBQXFCO0lBQ2hHLE9BQU8sZUFBZTtRQUNwQixDQUFDLENBQUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLGFBQWEsQ0FBQztRQUMzRCxDQUFDLENBQUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyw4QkFBOEIsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0FBQ3hILENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlYzIgZnJvbSAnLi4vLi4vYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBzc20gZnJvbSAnLi4vLi4vYXdzLXNzbSc7XG5cbi8vIHYyIC0ga2VlcCB0aGlzIGltcG9ydCBhcyBhIHNlcGFyYXRlIHNlY3Rpb24gdG8gcmVkdWNlIG1lcmdlIGNvbmZsaWN0IHdoZW4gZm9yd2FyZCBtZXJnaW5nIHdpdGggdGhlIHYyIGJyYW5jaC5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZVxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogVGhlIEVDUy1vcHRpbWl6ZWQgQU1JIHZhcmlhbnQgdG8gdXNlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlXG4gKiBbQW1hem9uIEVDUy1vcHRpbWl6ZWQgQU1Jc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvbkVDUy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZWNzLW9wdGltaXplZF9BTUkuaHRtbCkuXG4gKi9cbmV4cG9ydCBlbnVtIEFtaUhhcmR3YXJlVHlwZSB7XG5cbiAgLyoqXG4gICAqIFVzZSB0aGUgc3RhbmRhcmQgQW1hem9uIEVDUy1vcHRpbWl6ZWQgQU1JLlxuICAgKi9cbiAgU1RBTkRBUkQgPSAnU3RhbmRhcmQnLFxuXG4gIC8qKlxuICAgKiBVc2UgdGhlIEFtYXpvbiBFQ1MgR1BVLW9wdGltaXplZCBBTUkuXG4gICAqL1xuICBHUFUgPSAnR1BVJyxcblxuICAvKipcbiAgICogVXNlIHRoZSBBbWF6b24gRUNTLW9wdGltaXplZCBBbWF6b24gTGludXggMiAoYXJtNjQpIEFNSS5cbiAgICovXG4gIEFSTSA9ICdBUk02NCcsXG59XG5cblxuLyoqXG4gKiBFQ1Mtb3B0aW1pemVkIFdpbmRvd3MgdmVyc2lvbiBsaXN0XG4gKi9cbmV4cG9ydCBlbnVtIFdpbmRvd3NPcHRpbWl6ZWRWZXJzaW9uIHtcbiAgU0VSVkVSXzIwMTkgPSAnMjAxOScsXG4gIFNFUlZFUl8yMDE2ID0gJzIwMTYnLFxufVxuXG5jb25zdCBCUl9JTUFHRV9TWU1CT0wgPSBTeW1ib2wuZm9yKFxuICAnQGF3cy1jZGsvYXdzLWVjcy9saWIvYW1pcy5Cb3R0bGVSb2NrZXRJbWFnZScsXG4pO1xuXG4vKlxuICogVE9ETzp2Mi4wLjBcbiAqICAqIHJlbW92ZSBgZXhwb3J0YCBrZXl3b3JkXG4gKiAgKiByZW1vdmUgQGRlcHJlY2F0ZWRcbiAqL1xuLyoqXG4gKiBUaGUgcHJvcGVydGllcyB0aGF0IGRlZmluZSB3aGljaCBFQ1Mtb3B0aW1pemVkIEFNSSBpcyB1c2VkLlxuICpcbiAqIEBkZXByZWNhdGVkIHNlZSBgRWNzT3B0aW1pemVkSW1hZ2VgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRWNzT3B0aW1pemVkQW1pUHJvcHMge1xuICAvKipcbiAgICogVGhlIEFtYXpvbiBMaW51eCBnZW5lcmF0aW9uIHRvIHVzZS5cbiAgICpcbiAgICogQGRlZmF1bHQgQW1hem9uTGludXhHZW5lcmF0aW9uLkFtYXpvbkxpbnV4MlxuICAgKi9cbiAgcmVhZG9ubHkgZ2VuZXJhdGlvbj86IGVjMi5BbWF6b25MaW51eEdlbmVyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBXaW5kb3dzIFNlcnZlciB2ZXJzaW9uIHRvIHVzZS5cbiAgICpcbiAgICogQGRlZmF1bHQgbm9uZSwgdXNlcyBMaW51eCBnZW5lcmF0aW9uXG4gICAqL1xuICByZWFkb25seSB3aW5kb3dzVmVyc2lvbj86IFdpbmRvd3NPcHRpbWl6ZWRWZXJzaW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgRUNTLW9wdGltaXplZCBBTUkgdmFyaWFudCB0byB1c2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IEFtaUhhcmR3YXJlVHlwZS5TdGFuZGFyZFxuICAgKi9cbiAgcmVhZG9ubHkgaGFyZHdhcmVUeXBlPzogQW1pSGFyZHdhcmVUeXBlO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRoZSBBTUkgSUQgaXMgY2FjaGVkIHRvIGJlIHN0YWJsZSBiZXR3ZWVuIGRlcGxveW1lbnRzXG4gICAqXG4gICAqIEJ5IGRlZmF1bHQsIHRoZSBuZXdlc3QgaW1hZ2UgaXMgdXNlZCBvbiBlYWNoIGRlcGxveW1lbnQuIFRoaXMgd2lsbCBjYXVzZVxuICAgKiBpbnN0YW5jZXMgdG8gYmUgcmVwbGFjZWQgd2hlbmV2ZXIgYSBuZXcgdmVyc2lvbiBpcyByZWxlYXNlZCwgYW5kIG1heSBjYXVzZVxuICAgKiBkb3dudGltZSBpZiB0aGVyZSBhcmVuJ3QgZW5vdWdoIHJ1bm5pbmcgaW5zdGFuY2VzIGluIHRoZSBBdXRvU2NhbGluZ0dyb3VwXG4gICAqIHRvIHJlc2NoZWR1bGUgdGhlIHRhc2tzIG9uLlxuICAgKlxuICAgKiBJZiBzZXQgdG8gdHJ1ZSwgdGhlIEFNSSBJRCB3aWxsIGJlIGNhY2hlZCBpbiBgY2RrLmNvbnRleHQuanNvbmAgYW5kIHRoZVxuICAgKiBzYW1lIHZhbHVlIHdpbGwgYmUgdXNlZCBvbiBmdXR1cmUgcnVucy4gWW91ciBpbnN0YW5jZXMgd2lsbCBub3QgYmUgcmVwbGFjZWRcbiAgICogYnV0IHlvdXIgQU1JIHZlcnNpb24gd2lsbCBncm93IG9sZCBvdmVyIHRpbWUuIFRvIHJlZnJlc2ggdGhlIEFNSSBsb29rdXAsXG4gICAqIHlvdSB3aWxsIGhhdmUgdG8gZXZpY3QgdGhlIHZhbHVlIGZyb20gdGhlIGNhY2hlIHVzaW5nIHRoZSBgY2RrIGNvbnRleHRgXG4gICAqIGNvbW1hbmQuIFNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2RrL2xhdGVzdC9ndWlkZS9jb250ZXh0Lmh0bWwgZm9yXG4gICAqIG1vcmUgaW5mb3JtYXRpb24uXG4gICAqXG4gICAqIENhbiBub3QgYmUgc2V0IHRvIGB0cnVlYCBpbiBlbnZpcm9ubWVudC1hZ25vc3RpYyBzdGFja3MuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBjYWNoZWRJbkNvbnRleHQ/OiBib29sZWFuO1xufVxuXG4vKlxuICogVE9ETzp2Mi4wLjAgcmVtb3ZlIEVjc09wdGltaXplZEFtaVxuICovXG4vKipcbiAqIENvbnN0cnVjdCBhIExpbnV4IG9yIFdpbmRvd3MgbWFjaGluZSBpbWFnZSBmcm9tIHRoZSBsYXRlc3QgRUNTIE9wdGltaXplZCBBTUkgcHVibGlzaGVkIGluIFNTTVxuICpcbiAqIEBkZXByZWNhdGVkIHNlZSBgRWNzT3B0aW1pemVkSW1hZ2UjYW1hem9uTGludXhgLCBgRWNzT3B0aW1pemVkSW1hZ2UjYW1hem9uTGludXhgIGFuZCBgRWNzT3B0aW1pemVkSW1hZ2Ujd2luZG93c2BcbiAqL1xuZXhwb3J0IGNsYXNzIEVjc09wdGltaXplZEFtaSBpbXBsZW1lbnRzIGVjMi5JTWFjaGluZUltYWdlIHtcbiAgcHJpdmF0ZSByZWFkb25seSBnZW5lcmF0aW9uPzogZWMyLkFtYXpvbkxpbnV4R2VuZXJhdGlvbjtcbiAgcHJpdmF0ZSByZWFkb25seSB3aW5kb3dzVmVyc2lvbj86IFdpbmRvd3NPcHRpbWl6ZWRWZXJzaW9uO1xuICBwcml2YXRlIHJlYWRvbmx5IGh3VHlwZTogQW1pSGFyZHdhcmVUeXBlO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgYW1pUGFyYW1ldGVyTmFtZTogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IGNhY2hlZEluQ29udGV4dDogYm9vbGVhbjtcblxuICAvKipcbiAgICogQ29uc3RydWN0cyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgRWNzT3B0aW1pemVkQW1pIGNsYXNzLlxuICAgKi9cbiAgY29uc3RydWN0b3IocHJvcHM/OiBFY3NPcHRpbWl6ZWRBbWlQcm9wcykge1xuICAgIHRoaXMuaHdUeXBlID0gKHByb3BzICYmIHByb3BzLmhhcmR3YXJlVHlwZSkgfHwgQW1pSGFyZHdhcmVUeXBlLlNUQU5EQVJEO1xuICAgIGlmIChwcm9wcyAmJiBwcm9wcy5nZW5lcmF0aW9uKSB7IC8vIGdlbmVyYXRpb24gZGVmaW5lZCBpbiB0aGUgcHJvcHMgb2JqZWN0XG4gICAgICBpZiAocHJvcHMuZ2VuZXJhdGlvbiA9PT0gZWMyLkFtYXpvbkxpbnV4R2VuZXJhdGlvbi5BTUFaT05fTElOVVggJiYgdGhpcy5od1R5cGUgIT09IEFtaUhhcmR3YXJlVHlwZS5TVEFOREFSRCkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0FtYXpvbiBMaW51eCBkb2VzIG5vdCBzdXBwb3J0IHNwZWNpYWwgaGFyZHdhcmUgdHlwZS4gVXNlIEFtYXpvbiBMaW51eCAyIGluc3RlYWQnKTtcbiAgICAgIH0gZWxzZSBpZiAocHJvcHMud2luZG93c1ZlcnNpb24pIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdcIndpbmRvd3NWZXJzaW9uXCIgYW5kIExpbnV4IGltYWdlIFwiZ2VuZXJhdGlvblwiIGNhbm5vdCBiZSBib3RoIHNldCcpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5nZW5lcmF0aW9uID0gcHJvcHMuZ2VuZXJhdGlvbjtcbiAgICAgIH1cbiAgICB9IGVsc2UgaWYgKHByb3BzICYmIHByb3BzLndpbmRvd3NWZXJzaW9uKSB7XG4gICAgICBpZiAodGhpcy5od1R5cGUgIT09IEFtaUhhcmR3YXJlVHlwZS5TVEFOREFSRCkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1dpbmRvd3MgU2VydmVyIGRvZXMgbm90IHN1cHBvcnQgc3BlY2lhbCBoYXJkd2FyZSB0eXBlJyk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLndpbmRvd3NWZXJzaW9uID0gcHJvcHMud2luZG93c1ZlcnNpb247XG4gICAgICB9XG4gICAgfSBlbHNlIHsgLy8gZ2VuZXJhdGlvbiBub3QgZGVmaW5lZCBpbiBwcm9wcyBvYmplY3RcbiAgICAgIC8vIGFsd2F5cyBkZWZhdWx0IHRvIEFtYXpvbiBMaW51eCB2MiByZWdhcmRsZXNzIG9mIEhXXG4gICAgICB0aGlzLmdlbmVyYXRpb24gPSBlYzIuQW1hem9uTGludXhHZW5lcmF0aW9uLkFNQVpPTl9MSU5VWF8yO1xuICAgIH1cblxuICAgIC8vIHNldCB0aGUgU1NNIHBhcmFtZXRlciBuYW1lXG4gICAgdGhpcy5hbWlQYXJhbWV0ZXJOYW1lID0gJy9hd3Mvc2VydmljZS9lY3Mvb3B0aW1pemVkLWFtaS8nXG4gICAgICArICh0aGlzLmdlbmVyYXRpb24gPT09IGVjMi5BbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYID8gJ2FtYXpvbi1saW51eC8nIDogJycpXG4gICAgICArICh0aGlzLmdlbmVyYXRpb24gPT09IGVjMi5BbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYXzIgPyAnYW1hem9uLWxpbnV4LTIvJyA6ICcnKVxuICAgICAgKyAodGhpcy53aW5kb3dzVmVyc2lvbiA/IGB3aW5kb3dzX3NlcnZlci8ke3RoaXMud2luZG93c1ZlcnNpb259L2VuZ2xpc2gvZnVsbC9gIDogJycpXG4gICAgICArICh0aGlzLmh3VHlwZSA9PT0gQW1pSGFyZHdhcmVUeXBlLkdQVSA/ICdncHUvJyA6ICcnKVxuICAgICAgKyAodGhpcy5od1R5cGUgPT09IEFtaUhhcmR3YXJlVHlwZS5BUk0gPyAnYXJtNjQvJyA6ICcnKVxuICAgICAgKyAncmVjb21tZW5kZWQvaW1hZ2VfaWQnO1xuXG4gICAgdGhpcy5jYWNoZWRJbkNvbnRleHQgPSBwcm9wcz8uY2FjaGVkSW5Db250ZXh0ID8/IGZhbHNlO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybiB0aGUgY29ycmVjdCBpbWFnZVxuICAgKi9cbiAgcHVibGljIGdldEltYWdlKHNjb3BlOiBDb25zdHJ1Y3QpOiBlYzIuTWFjaGluZUltYWdlQ29uZmlnIHtcbiAgICBjb25zdCBhbWkgPSBsb29rdXBJbWFnZShzY29wZSwgdGhpcy5jYWNoZWRJbkNvbnRleHQsIHRoaXMuYW1pUGFyYW1ldGVyTmFtZSk7XG5cbiAgICBjb25zdCBvc1R5cGUgPSB0aGlzLndpbmRvd3NWZXJzaW9uID8gZWMyLk9wZXJhdGluZ1N5c3RlbVR5cGUuV0lORE9XUyA6IGVjMi5PcGVyYXRpbmdTeXN0ZW1UeXBlLkxJTlVYO1xuICAgIHJldHVybiB7XG4gICAgICBpbWFnZUlkOiBhbWksXG4gICAgICBvc1R5cGUsXG4gICAgICB1c2VyRGF0YTogZWMyLlVzZXJEYXRhLmZvck9wZXJhdGluZ1N5c3RlbShvc1R5cGUpLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBBZGRpdGlvbmFsIGNvbmZpZ3VyYXRpb24gcHJvcGVydGllcyBmb3IgRWNzT3B0aW1pemVkSW1hZ2UgZmFjdG9yeSBmdW5jdGlvbnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFY3NPcHRpbWl6ZWRJbWFnZU9wdGlvbnMge1xuICAvKipcbiAgICogV2hldGhlciB0aGUgQU1JIElEIGlzIGNhY2hlZCB0byBiZSBzdGFibGUgYmV0d2VlbiBkZXBsb3ltZW50c1xuICAgKlxuICAgKiBCeSBkZWZhdWx0LCB0aGUgbmV3ZXN0IGltYWdlIGlzIHVzZWQgb24gZWFjaCBkZXBsb3ltZW50LiBUaGlzIHdpbGwgY2F1c2VcbiAgICogaW5zdGFuY2VzIHRvIGJlIHJlcGxhY2VkIHdoZW5ldmVyIGEgbmV3IHZlcnNpb24gaXMgcmVsZWFzZWQsIGFuZCBtYXkgY2F1c2VcbiAgICogZG93bnRpbWUgaWYgdGhlcmUgYXJlbid0IGVub3VnaCBydW5uaW5nIGluc3RhbmNlcyBpbiB0aGUgQXV0b1NjYWxpbmdHcm91cFxuICAgKiB0byByZXNjaGVkdWxlIHRoZSB0YXNrcyBvbi5cbiAgICpcbiAgICogSWYgc2V0IHRvIHRydWUsIHRoZSBBTUkgSUQgd2lsbCBiZSBjYWNoZWQgaW4gYGNkay5jb250ZXh0Lmpzb25gIGFuZCB0aGVcbiAgICogc2FtZSB2YWx1ZSB3aWxsIGJlIHVzZWQgb24gZnV0dXJlIHJ1bnMuIFlvdXIgaW5zdGFuY2VzIHdpbGwgbm90IGJlIHJlcGxhY2VkXG4gICAqIGJ1dCB5b3VyIEFNSSB2ZXJzaW9uIHdpbGwgZ3JvdyBvbGQgb3ZlciB0aW1lLiBUbyByZWZyZXNoIHRoZSBBTUkgbG9va3VwLFxuICAgKiB5b3Ugd2lsbCBoYXZlIHRvIGV2aWN0IHRoZSB2YWx1ZSBmcm9tIHRoZSBjYWNoZSB1c2luZyB0aGUgYGNkayBjb250ZXh0YFxuICAgKiBjb21tYW5kLiBTZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9sYXRlc3QvZ3VpZGUvY29udGV4dC5odG1sIGZvclxuICAgKiBtb3JlIGluZm9ybWF0aW9uLlxuICAgKlxuICAgKiBDYW4gbm90IGJlIHNldCB0byBgdHJ1ZWAgaW4gZW52aXJvbm1lbnQtYWdub3N0aWMgc3RhY2tzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgY2FjaGVkSW5Db250ZXh0PzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBDb25zdHJ1Y3QgYSBMaW51eCBvciBXaW5kb3dzIG1hY2hpbmUgaW1hZ2UgZnJvbSB0aGUgbGF0ZXN0IEVDUyBPcHRpbWl6ZWQgQU1JIHB1Ymxpc2hlZCBpbiBTU01cbiAqL1xuZXhwb3J0IGNsYXNzIEVjc09wdGltaXplZEltYWdlIGltcGxlbWVudHMgZWMyLklNYWNoaW5lSW1hZ2Uge1xuICAvKipcbiAgICogQ29uc3RydWN0IGFuIEFtYXpvbiBMaW51eCAyIGltYWdlIGZyb20gdGhlIGxhdGVzdCBFQ1MgT3B0aW1pemVkIEFNSSBwdWJsaXNoZWQgaW4gU1NNXG4gICAqXG4gICAqIEBwYXJhbSBoYXJkd2FyZVR5cGUgRUNTLW9wdGltaXplZCBBTUkgdmFyaWFudCB0byB1c2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgYW1hem9uTGludXgyKGhhcmR3YXJlVHlwZSA9IEFtaUhhcmR3YXJlVHlwZS5TVEFOREFSRCwgb3B0aW9uczogRWNzT3B0aW1pemVkSW1hZ2VPcHRpb25zID0ge30pOiBFY3NPcHRpbWl6ZWRJbWFnZSB7XG4gICAgcmV0dXJuIG5ldyBFY3NPcHRpbWl6ZWRJbWFnZSh7XG4gICAgICBnZW5lcmF0aW9uOiBlYzIuQW1hem9uTGludXhHZW5lcmF0aW9uLkFNQVpPTl9MSU5VWF8yLFxuICAgICAgaGFyZHdhcmVUeXBlLFxuICAgICAgY2FjaGVkSW5Db250ZXh0OiBvcHRpb25zLmNhY2hlZEluQ29udGV4dCxcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3QgYW4gQW1hem9uIExpbnV4IEFNSSBpbWFnZSBmcm9tIHRoZSBsYXRlc3QgRUNTIE9wdGltaXplZCBBTUkgcHVibGlzaGVkIGluIFNTTVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBhbWF6b25MaW51eChvcHRpb25zOiBFY3NPcHRpbWl6ZWRJbWFnZU9wdGlvbnMgPSB7fSk6IEVjc09wdGltaXplZEltYWdlIHtcbiAgICByZXR1cm4gbmV3IEVjc09wdGltaXplZEltYWdlKHtcbiAgICAgIGdlbmVyYXRpb246IGVjMi5BbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYLFxuICAgICAgY2FjaGVkSW5Db250ZXh0OiBvcHRpb25zLmNhY2hlZEluQ29udGV4dCxcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3QgYSBXaW5kb3dzIGltYWdlIGZyb20gdGhlIGxhdGVzdCBFQ1MgT3B0aW1pemVkIEFNSSBwdWJsaXNoZWQgaW4gU1NNXG4gICAqXG4gICAqIEBwYXJhbSB3aW5kb3dzVmVyc2lvbiBXaW5kb3dzIFZlcnNpb24gdG8gdXNlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHdpbmRvd3Mod2luZG93c1ZlcnNpb246IFdpbmRvd3NPcHRpbWl6ZWRWZXJzaW9uLCBvcHRpb25zOiBFY3NPcHRpbWl6ZWRJbWFnZU9wdGlvbnMgPSB7fSk6IEVjc09wdGltaXplZEltYWdlIHtcbiAgICByZXR1cm4gbmV3IEVjc09wdGltaXplZEltYWdlKHtcbiAgICAgIHdpbmRvd3NWZXJzaW9uLFxuICAgICAgY2FjaGVkSW5Db250ZXh0OiBvcHRpb25zLmNhY2hlZEluQ29udGV4dCxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgcmVhZG9ubHkgZ2VuZXJhdGlvbj86IGVjMi5BbWF6b25MaW51eEdlbmVyYXRpb247XG4gIHByaXZhdGUgcmVhZG9ubHkgd2luZG93c1ZlcnNpb24/OiBXaW5kb3dzT3B0aW1pemVkVmVyc2lvbjtcbiAgcHJpdmF0ZSByZWFkb25seSBod1R5cGU/OiBBbWlIYXJkd2FyZVR5cGU7XG5cbiAgcHJpdmF0ZSByZWFkb25seSBhbWlQYXJhbWV0ZXJOYW1lOiBzdHJpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkgY2FjaGVkSW5Db250ZXh0OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBFY3NPcHRpbWl6ZWRBbWkgY2xhc3MuXG4gICAqL1xuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByb3BzOiBFY3NPcHRpbWl6ZWRBbWlQcm9wcykge1xuICAgIHRoaXMuaHdUeXBlID0gcHJvcHMgJiYgcHJvcHMuaGFyZHdhcmVUeXBlO1xuXG4gICAgaWYgKHByb3BzLndpbmRvd3NWZXJzaW9uKSB7XG4gICAgICB0aGlzLndpbmRvd3NWZXJzaW9uID0gcHJvcHMud2luZG93c1ZlcnNpb247XG4gICAgfSBlbHNlIGlmIChwcm9wcy5nZW5lcmF0aW9uKSB7XG4gICAgICB0aGlzLmdlbmVyYXRpb24gPSBwcm9wcy5nZW5lcmF0aW9uO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1RoaXMgZXJyb3Igc2hvdWxkIG5ldmVyIGJlIHRocm93bicpO1xuICAgIH1cblxuICAgIC8vIHNldCB0aGUgU1NNIHBhcmFtZXRlciBuYW1lXG4gICAgdGhpcy5hbWlQYXJhbWV0ZXJOYW1lID0gJy9hd3Mvc2VydmljZS9lY3Mvb3B0aW1pemVkLWFtaS8nXG4gICAgICArICh0aGlzLmdlbmVyYXRpb24gPT09IGVjMi5BbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYID8gJ2FtYXpvbi1saW51eC8nIDogJycpXG4gICAgICArICh0aGlzLmdlbmVyYXRpb24gPT09IGVjMi5BbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYXzIgPyAnYW1hem9uLWxpbnV4LTIvJyA6ICcnKVxuICAgICAgKyAodGhpcy53aW5kb3dzVmVyc2lvbiA/IGB3aW5kb3dzX3NlcnZlci8ke3RoaXMud2luZG93c1ZlcnNpb259L2VuZ2xpc2gvZnVsbC9gIDogJycpXG4gICAgICArICh0aGlzLmh3VHlwZSA9PT0gQW1pSGFyZHdhcmVUeXBlLkdQVSA/ICdncHUvJyA6ICcnKVxuICAgICAgKyAodGhpcy5od1R5cGUgPT09IEFtaUhhcmR3YXJlVHlwZS5BUk0gPyAnYXJtNjQvJyA6ICcnKVxuICAgICAgKyAncmVjb21tZW5kZWQvaW1hZ2VfaWQnO1xuXG4gICAgdGhpcy5jYWNoZWRJbkNvbnRleHQgPSBwcm9wcz8uY2FjaGVkSW5Db250ZXh0ID8/IGZhbHNlO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybiB0aGUgY29ycmVjdCBpbWFnZVxuICAgKi9cbiAgcHVibGljIGdldEltYWdlKHNjb3BlOiBDb25zdHJ1Y3QpOiBlYzIuTWFjaGluZUltYWdlQ29uZmlnIHtcbiAgICBjb25zdCBhbWkgPSBsb29rdXBJbWFnZShzY29wZSwgdGhpcy5jYWNoZWRJbkNvbnRleHQsIHRoaXMuYW1pUGFyYW1ldGVyTmFtZSk7XG5cbiAgICBjb25zdCBvc1R5cGUgPSB0aGlzLndpbmRvd3NWZXJzaW9uID8gZWMyLk9wZXJhdGluZ1N5c3RlbVR5cGUuV0lORE9XUyA6IGVjMi5PcGVyYXRpbmdTeXN0ZW1UeXBlLkxJTlVYO1xuICAgIHJldHVybiB7XG4gICAgICBpbWFnZUlkOiBhbWksXG4gICAgICBvc1R5cGUsXG4gICAgICB1c2VyRGF0YTogZWMyLlVzZXJEYXRhLmZvck9wZXJhdGluZ1N5c3RlbShvc1R5cGUpLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBBbWF6b24gRUNTIHZhcmlhbnRcbiAqL1xuZXhwb3J0IGVudW0gQm90dGxlcm9ja2V0RWNzVmFyaWFudCB7XG4gIC8qKlxuICAgKiBhd3MtZWNzLTEgdmFyaWFudFxuICAgKi9cbiAgQVdTX0VDU18xID0gJ2F3cy1lY3MtMSdcblxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIEJvdHRsZVJvY2tldEltYWdlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQm90dGxlUm9ja2V0SW1hZ2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgQW1hem9uIEVDUyB2YXJpYW50IHRvIHVzZS5cbiAgICogT25seSBgYXdzLWVjcy0xYCBpcyBjdXJyZW50bHkgYXZhaWxhYmxlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQm90dGxlcm9ja2V0RWNzVmFyaWFudC5BV1NfRUNTXzFcbiAgICovXG4gIHJlYWRvbmx5IHZhcmlhbnQ/OiBCb3R0bGVyb2NrZXRFY3NWYXJpYW50O1xuXG4gIC8qKlxuICAgKiBUaGUgQ1BVIGFyY2hpdGVjdHVyZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHg4Nl82NFxuICAgKi9cbiAgcmVhZG9ubHkgYXJjaGl0ZWN0dXJlPzogZWMyLkluc3RhbmNlQXJjaGl0ZWN0dXJlO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRoZSBBTUkgSUQgaXMgY2FjaGVkIHRvIGJlIHN0YWJsZSBiZXR3ZWVuIGRlcGxveW1lbnRzXG4gICAqXG4gICAqIEJ5IGRlZmF1bHQsIHRoZSBuZXdlc3QgaW1hZ2UgaXMgdXNlZCBvbiBlYWNoIGRlcGxveW1lbnQuIFRoaXMgd2lsbCBjYXVzZVxuICAgKiBpbnN0YW5jZXMgdG8gYmUgcmVwbGFjZWQgd2hlbmV2ZXIgYSBuZXcgdmVyc2lvbiBpcyByZWxlYXNlZCwgYW5kIG1heSBjYXVzZVxuICAgKiBkb3dudGltZSBpZiB0aGVyZSBhcmVuJ3QgZW5vdWdoIHJ1bm5pbmcgaW5zdGFuY2VzIGluIHRoZSBBdXRvU2NhbGluZ0dyb3VwXG4gICAqIHRvIHJlc2NoZWR1bGUgdGhlIHRhc2tzIG9uLlxuICAgKlxuICAgKiBJZiBzZXQgdG8gdHJ1ZSwgdGhlIEFNSSBJRCB3aWxsIGJlIGNhY2hlZCBpbiBgY2RrLmNvbnRleHQuanNvbmAgYW5kIHRoZVxuICAgKiBzYW1lIHZhbHVlIHdpbGwgYmUgdXNlZCBvbiBmdXR1cmUgcnVucy4gWW91ciBpbnN0YW5jZXMgd2lsbCBub3QgYmUgcmVwbGFjZWRcbiAgICogYnV0IHlvdXIgQU1JIHZlcnNpb24gd2lsbCBncm93IG9sZCBvdmVyIHRpbWUuIFRvIHJlZnJlc2ggdGhlIEFNSSBsb29rdXAsXG4gICAqIHlvdSB3aWxsIGhhdmUgdG8gZXZpY3QgdGhlIHZhbHVlIGZyb20gdGhlIGNhY2hlIHVzaW5nIHRoZSBgY2RrIGNvbnRleHRgXG4gICAqIGNvbW1hbmQuIFNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2RrL2xhdGVzdC9ndWlkZS9jb250ZXh0Lmh0bWwgZm9yXG4gICAqIG1vcmUgaW5mb3JtYXRpb24uXG4gICAqXG4gICAqIENhbiBub3QgYmUgc2V0IHRvIGB0cnVlYCBpbiBlbnZpcm9ubWVudC1hZ25vc3RpYyBzdGFja3MuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBjYWNoZWRJbkNvbnRleHQ/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIENvbnN0cnVjdCBhbiBCb3R0bGVyb2NrZXQgaW1hZ2UgZnJvbSB0aGUgbGF0ZXN0IEFNSSBwdWJsaXNoZWQgaW4gU1NNXG4gKi9cbmV4cG9ydCBjbGFzcyBCb3R0bGVSb2NrZXRJbWFnZSBpbXBsZW1lbnRzIGVjMi5JTWFjaGluZUltYWdlIHtcbiAgLyoqXG4gICAqIFJldHVybiB3aGV0aGVyIHRoZSBnaXZlbiBvYmplY3QgaXMgYSBCb3R0bGVSb2NrZXRJbWFnZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBpc0JvdHRsZVJvY2tldEltYWdlKHg6IGFueSk6IHggaXMgQm90dGxlUm9ja2V0SW1hZ2Uge1xuICAgIHJldHVybiB4ICE9PSBudWxsICYmIHR5cGVvZiB4ID09PSAnb2JqZWN0JyAmJiBCUl9JTUFHRV9TWU1CT0wgaW4geDtcbiAgfVxuXG4gIHByaXZhdGUgcmVhZG9ubHkgYW1pUGFyYW1ldGVyTmFtZTogc3RyaW5nO1xuICAvKipcbiAgICogQW1hem9uIEVDUyB2YXJpYW50IGZvciBCb3R0bGVyb2NrZXQgQU1JXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IHZhcmlhbnQ6IHN0cmluZztcblxuICAvKipcbiAgICogSW5zdGFuY2UgYXJjaGl0ZWN0dXJlXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IGFyY2hpdGVjdHVyZTogZWMyLkluc3RhbmNlQXJjaGl0ZWN0dXJlO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgY2FjaGVkSW5Db250ZXh0OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBCb3R0bGVSb2NrZXRJbWFnZSBjbGFzcy5cbiAgICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcihwcm9wczogQm90dGxlUm9ja2V0SW1hZ2VQcm9wcyA9IHt9KSB7XG4gICAgdGhpcy52YXJpYW50ID0gcHJvcHMudmFyaWFudCA/PyBCb3R0bGVyb2NrZXRFY3NWYXJpYW50LkFXU19FQ1NfMTtcbiAgICB0aGlzLmFyY2hpdGVjdHVyZSA9IHByb3BzLmFyY2hpdGVjdHVyZSA/PyBlYzIuSW5zdGFuY2VBcmNoaXRlY3R1cmUuWDg2XzY0O1xuXG4gICAgLy8gc2V0IHRoZSBTU00gcGFyYW1ldGVyIG5hbWVcbiAgICB0aGlzLmFtaVBhcmFtZXRlck5hbWUgPSBgL2F3cy9zZXJ2aWNlL2JvdHRsZXJvY2tldC8ke3RoaXMudmFyaWFudH0vJHt0aGlzLmFyY2hpdGVjdHVyZX0vbGF0ZXN0L2ltYWdlX2lkYDtcblxuICAgIHRoaXMuY2FjaGVkSW5Db250ZXh0ID0gcHJvcHMuY2FjaGVkSW5Db250ZXh0ID8/IGZhbHNlO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybiB0aGUgY29ycmVjdCBpbWFnZVxuICAgKi9cbiAgcHVibGljIGdldEltYWdlKHNjb3BlOiBDb25zdHJ1Y3QpOiBlYzIuTWFjaGluZUltYWdlQ29uZmlnIHtcbiAgICBjb25zdCBhbWkgPSBsb29rdXBJbWFnZShzY29wZSwgdGhpcy5jYWNoZWRJbkNvbnRleHQsIHRoaXMuYW1pUGFyYW1ldGVyTmFtZSk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgaW1hZ2VJZDogYW1pLFxuICAgICAgb3NUeXBlOiBlYzIuT3BlcmF0aW5nU3lzdGVtVHlwZS5MSU5VWCxcbiAgICAgIHVzZXJEYXRhOiBlYzIuVXNlckRhdGEuY3VzdG9tKCcnKSxcbiAgICB9O1xuICB9XG59XG5cbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShCb3R0bGVSb2NrZXRJbWFnZS5wcm90b3R5cGUsIEJSX0lNQUdFX1NZTUJPTCwge1xuICB2YWx1ZTogdHJ1ZSxcbiAgZW51bWVyYWJsZTogZmFsc2UsXG4gIHdyaXRhYmxlOiBmYWxzZSxcbn0pO1xuXG5mdW5jdGlvbiBsb29rdXBJbWFnZShzY29wZTogQ29uc3RydWN0LCBjYWNoZWRJbkNvbnRleHQ6IGJvb2xlYW4gfCB1bmRlZmluZWQsIHBhcmFtZXRlck5hbWU6IHN0cmluZykge1xuICByZXR1cm4gY2FjaGVkSW5Db250ZXh0XG4gICAgPyBzc20uU3RyaW5nUGFyYW1ldGVyLnZhbHVlRnJvbUxvb2t1cChzY29wZSwgcGFyYW1ldGVyTmFtZSlcbiAgICA6IHNzbS5TdHJpbmdQYXJhbWV0ZXIudmFsdWVGb3JUeXBlZFN0cmluZ1BhcmFtZXRlclYyKHNjb3BlLCBwYXJhbWV0ZXJOYW1lLCBzc20uUGFyYW1ldGVyVmFsdWVUeXBlLkFXU19FQzJfSU1BR0VfSUQpO1xufVxuIl19