"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractServiceNameFromArn = exports.fromServiceAttributes = void 0;
const core_1 = require("../../../core");
const cx_api_1 = require("../../../cx-api");
function fromServiceAttributes(scope, id, attrs) {
    if ((attrs.serviceArn && attrs.serviceName) || (!attrs.serviceArn && !attrs.serviceName)) {
        throw new Error('You can only specify either serviceArn or serviceName.');
    }
    const newArnFormat = core_1.FeatureFlags.of(scope).isEnabled(cx_api_1.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME);
    const stack = core_1.Stack.of(scope);
    let name;
    let arn;
    if (attrs.serviceName) {
        name = attrs.serviceName;
        const resourceName = newArnFormat ? `${attrs.cluster.clusterName}/${attrs.serviceName}` : attrs.serviceName;
        arn = stack.formatArn({
            partition: stack.partition,
            service: 'ecs',
            region: stack.region,
            account: stack.account,
            resource: 'service',
            resourceName,
        });
    }
    else {
        arn = attrs.serviceArn;
        name = extractServiceNameFromArn(scope, arn);
    }
    class Import extends core_1.Resource {
        constructor() {
            super(...arguments);
            this.serviceArn = arn;
            this.serviceName = name;
            this.cluster = attrs.cluster;
        }
    }
    return new Import(scope, id, {
        environmentFromArn: arn,
    });
}
exports.fromServiceAttributes = fromServiceAttributes;
function extractServiceNameFromArn(scope, arn) {
    const newArnFormat = core_1.FeatureFlags.of(scope).isEnabled(cx_api_1.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME);
    const stack = core_1.Stack.of(scope);
    if (core_1.Token.isUnresolved(arn)) {
        if (newArnFormat) {
            const components = core_1.Fn.split(':', arn);
            const lastComponents = core_1.Fn.split('/', core_1.Fn.select(5, components));
            return core_1.Fn.select(2, lastComponents);
        }
        else {
            return stack.splitArn(arn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        }
    }
    else {
        const resourceName = stack.splitArn(arn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        const resourceNameSplit = resourceName.split('/');
        return resourceNameSplit.length === 1 ? resourceName : resourceNameSplit[1];
    }
}
exports.extractServiceNameFromArn = extractServiceNameFromArn;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnJvbS1zZXJ2aWNlLWF0dHJpYnV0ZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmcm9tLXNlcnZpY2UtYXR0cmlidXRlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBb0Y7QUFDcEYsNENBQXVFO0FBNkJ2RSxTQUFnQixxQkFBcUIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QjtJQUMxRixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDLEtBQUssQ0FBQyxVQUFVLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLEVBQUU7UUFDeEYsTUFBTSxJQUFJLEtBQUssQ0FBQyx3REFBd0QsQ0FBQyxDQUFDO0tBQzNFO0lBRUQsTUFBTSxZQUFZLEdBQUcsbUJBQVksQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsU0FBUyxDQUFDLDZDQUFvQyxDQUFDLENBQUM7SUFFNUYsTUFBTSxLQUFLLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM5QixJQUFJLElBQVksQ0FBQztJQUNqQixJQUFJLEdBQVcsQ0FBQztJQUNoQixJQUFJLEtBQUssQ0FBQyxXQUFXLEVBQUU7UUFDckIsSUFBSSxHQUFHLEtBQUssQ0FBQyxXQUFxQixDQUFDO1FBQ25DLE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVcsSUFBSSxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxXQUFxQixDQUFDO1FBQ3RILEdBQUcsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1lBQ3BCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixPQUFPLEVBQUUsS0FBSztZQUNkLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsUUFBUSxFQUFFLFNBQVM7WUFDbkIsWUFBWTtTQUNiLENBQUMsQ0FBQztLQUNKO1NBQU07UUFDTCxHQUFHLEdBQUcsS0FBSyxDQUFDLFVBQW9CLENBQUM7UUFDakMsSUFBSSxHQUFHLHlCQUF5QixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FBQztLQUM5QztJQUNELE1BQU0sTUFBTyxTQUFRLGVBQVE7UUFBN0I7O1lBQ2tCLGVBQVUsR0FBRyxHQUFHLENBQUM7WUFDakIsZ0JBQVcsR0FBRyxJQUFJLENBQUM7WUFDbkIsWUFBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDMUMsQ0FBQztLQUFBO0lBQ0QsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1FBQzNCLGtCQUFrQixFQUFFLEdBQUc7S0FDeEIsQ0FBQyxDQUFDO0FBQ0wsQ0FBQztBQWpDRCxzREFpQ0M7QUFFRCxTQUFnQix5QkFBeUIsQ0FBQyxLQUFnQixFQUFFLEdBQVc7SUFDckUsTUFBTSxZQUFZLEdBQUcsbUJBQVksQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsU0FBUyxDQUFDLDZDQUFvQyxDQUFDLENBQUM7SUFDNUYsTUFBTSxLQUFLLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUU5QixJQUFJLFlBQUssQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLEVBQUU7UUFDM0IsSUFBSSxZQUFZLEVBQUU7WUFDaEIsTUFBTSxVQUFVLEdBQUcsU0FBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7WUFDdEMsTUFBTSxjQUFjLEdBQUcsU0FBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsU0FBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsVUFBVSxDQUFDLENBQUMsQ0FBQztZQUMvRCxPQUFPLFNBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLGNBQWMsQ0FBQyxDQUFDO1NBQ3JDO2FBQU07WUFDTCxPQUFPLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLGdCQUFTLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxZQUFzQixDQUFDO1NBQ2xGO0tBQ0Y7U0FBTTtRQUNMLE1BQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLGdCQUFTLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxZQUFzQixDQUFDO1FBQy9GLE1BQU0saUJBQWlCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNsRCxPQUFPLGlCQUFpQixDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDN0U7QUFDSCxDQUFDO0FBakJELDhEQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFybkZvcm1hdCwgRmVhdHVyZUZsYWdzLCBGbiwgUmVzb3VyY2UsIFN0YWNrLCBUb2tlbiB9IGZyb20gJy4uLy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgRUNTX0FSTl9GT1JNQVRfSU5DTFVERVNfQ0xVU1RFUl9OQU1FIH0gZnJvbSAnLi4vLi4vLi4vY3gtYXBpJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUJhc2VTZXJ2aWNlIH0gZnJvbSAnLi4vYmFzZS9iYXNlLXNlcnZpY2UnO1xuaW1wb3J0IHsgSUNsdXN0ZXIgfSBmcm9tICcuLi9jbHVzdGVyJztcblxuLyoqXG4gKiBUaGUgcHJvcGVydGllcyB0byBpbXBvcnQgZnJvbSB0aGUgc2VydmljZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZXJ2aWNlQXR0cmlidXRlcyB7XG4gIC8qKlxuICAgKiBUaGUgY2x1c3RlciB0aGF0IGhvc3RzIHRoZSBzZXJ2aWNlLlxuICAgKi9cbiAgcmVhZG9ubHkgY2x1c3RlcjogSUNsdXN0ZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBzZXJ2aWNlIEFSTi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBlaXRoZXIgdGhpcywgb3IgYHNlcnZpY2VOYW1lYCwgaXMgcmVxdWlyZWRcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VBcm4/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBzZXJ2aWNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGVpdGhlciB0aGlzLCBvciBgc2VydmljZUFybmAsIGlzIHJlcXVpcmVkXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlTmFtZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGZyb21TZXJ2aWNlQXR0cmlidXRlcyhzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBhdHRyczogU2VydmljZUF0dHJpYnV0ZXMpOiBJQmFzZVNlcnZpY2Uge1xuICBpZiAoKGF0dHJzLnNlcnZpY2VBcm4gJiYgYXR0cnMuc2VydmljZU5hbWUpIHx8ICghYXR0cnMuc2VydmljZUFybiAmJiAhYXR0cnMuc2VydmljZU5hbWUpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdZb3UgY2FuIG9ubHkgc3BlY2lmeSBlaXRoZXIgc2VydmljZUFybiBvciBzZXJ2aWNlTmFtZS4nKTtcbiAgfVxuXG4gIGNvbnN0IG5ld0FybkZvcm1hdCA9IEZlYXR1cmVGbGFncy5vZihzY29wZSkuaXNFbmFibGVkKEVDU19BUk5fRk9STUFUX0lOQ0xVREVTX0NMVVNURVJfTkFNRSk7XG5cbiAgY29uc3Qgc3RhY2sgPSBTdGFjay5vZihzY29wZSk7XG4gIGxldCBuYW1lOiBzdHJpbmc7XG4gIGxldCBhcm46IHN0cmluZztcbiAgaWYgKGF0dHJzLnNlcnZpY2VOYW1lKSB7XG4gICAgbmFtZSA9IGF0dHJzLnNlcnZpY2VOYW1lIGFzIHN0cmluZztcbiAgICBjb25zdCByZXNvdXJjZU5hbWUgPSBuZXdBcm5Gb3JtYXQgPyBgJHthdHRycy5jbHVzdGVyLmNsdXN0ZXJOYW1lfS8ke2F0dHJzLnNlcnZpY2VOYW1lfWAgOiBhdHRycy5zZXJ2aWNlTmFtZSBhcyBzdHJpbmc7XG4gICAgYXJuID0gc3RhY2suZm9ybWF0QXJuKHtcbiAgICAgIHBhcnRpdGlvbjogc3RhY2sucGFydGl0aW9uLFxuICAgICAgc2VydmljZTogJ2VjcycsXG4gICAgICByZWdpb246IHN0YWNrLnJlZ2lvbixcbiAgICAgIGFjY291bnQ6IHN0YWNrLmFjY291bnQsXG4gICAgICByZXNvdXJjZTogJ3NlcnZpY2UnLFxuICAgICAgcmVzb3VyY2VOYW1lLFxuICAgIH0pO1xuICB9IGVsc2Uge1xuICAgIGFybiA9IGF0dHJzLnNlcnZpY2VBcm4gYXMgc3RyaW5nO1xuICAgIG5hbWUgPSBleHRyYWN0U2VydmljZU5hbWVGcm9tQXJuKHNjb3BlLCBhcm4pO1xuICB9XG4gIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUJhc2VTZXJ2aWNlIHtcbiAgICBwdWJsaWMgcmVhZG9ubHkgc2VydmljZUFybiA9IGFybjtcbiAgICBwdWJsaWMgcmVhZG9ubHkgc2VydmljZU5hbWUgPSBuYW1lO1xuICAgIHB1YmxpYyByZWFkb25seSBjbHVzdGVyID0gYXR0cnMuY2x1c3RlcjtcbiAgfVxuICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQsIHtcbiAgICBlbnZpcm9ubWVudEZyb21Bcm46IGFybixcbiAgfSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBleHRyYWN0U2VydmljZU5hbWVGcm9tQXJuKHNjb3BlOiBDb25zdHJ1Y3QsIGFybjogc3RyaW5nKTogc3RyaW5nIHtcbiAgY29uc3QgbmV3QXJuRm9ybWF0ID0gRmVhdHVyZUZsYWdzLm9mKHNjb3BlKS5pc0VuYWJsZWQoRUNTX0FSTl9GT1JNQVRfSU5DTFVERVNfQ0xVU1RFUl9OQU1FKTtcbiAgY29uc3Qgc3RhY2sgPSBTdGFjay5vZihzY29wZSk7XG5cbiAgaWYgKFRva2VuLmlzVW5yZXNvbHZlZChhcm4pKSB7XG4gICAgaWYgKG5ld0FybkZvcm1hdCkge1xuICAgICAgY29uc3QgY29tcG9uZW50cyA9IEZuLnNwbGl0KCc6JywgYXJuKTtcbiAgICAgIGNvbnN0IGxhc3RDb21wb25lbnRzID0gRm4uc3BsaXQoJy8nLCBGbi5zZWxlY3QoNSwgY29tcG9uZW50cykpO1xuICAgICAgcmV0dXJuIEZuLnNlbGVjdCgyLCBsYXN0Q29tcG9uZW50cyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBzdGFjay5zcGxpdEFybihhcm4sIEFybkZvcm1hdC5TTEFTSF9SRVNPVVJDRV9OQU1FKS5yZXNvdXJjZU5hbWUgYXMgc3RyaW5nO1xuICAgIH1cbiAgfSBlbHNlIHtcbiAgICBjb25zdCByZXNvdXJjZU5hbWUgPSBzdGFjay5zcGxpdEFybihhcm4sIEFybkZvcm1hdC5TTEFTSF9SRVNPVVJDRV9OQU1FKS5yZXNvdXJjZU5hbWUgYXMgc3RyaW5nO1xuICAgIGNvbnN0IHJlc291cmNlTmFtZVNwbGl0ID0gcmVzb3VyY2VOYW1lLnNwbGl0KCcvJyk7XG4gICAgcmV0dXJuIHJlc291cmNlTmFtZVNwbGl0Lmxlbmd0aCA9PT0gMSA/IHJlc291cmNlTmFtZSA6IHJlc291cmNlTmFtZVNwbGl0WzFdO1xuICB9XG59XG4iXX0=