"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecr_assets_1 = require("../../aws-ecr-assets");
/**
 * Constructs for types of container images
 */
class ContainerImage {
    /**
     * Reference an image on DockerHub or another online registry
     */
    static fromRegistry(name, props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_RepositoryImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRegistry);
            }
            throw error;
        }
        return new repository_1.RepositoryImage(name, props);
    }
    /**
     * Reference an image in an ECR repository
     */
    static fromEcrRepository(repository, tag = 'latest') {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecr_IRepository(repository);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrRepository);
            }
            throw error;
        }
        return new ecr_1.EcrImage(repository, tag);
    }
    /**
     * Reference an image that's constructed directly from sources on disk.
     *
     * If you already have a `DockerImageAsset` instance, you can use the
     * `ContainerImage.fromDockerImageAsset` method instead.
     *
     * @param directory The directory containing the Dockerfile
     */
    static fromAsset(directory, props = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AssetImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new asset_image_1.AssetImage(directory, props);
    }
    /**
     * Use an existing `DockerImageAsset` for this container image.
     *
     * @param asset The `DockerImageAsset` to use for this container definition.
     */
    static fromDockerImageAsset(asset) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecr_assets_DockerImageAsset(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDockerImageAsset);
            }
            throw error;
        }
        return {
            bind(_scope, containerDefinition) {
                asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
                return {
                    imageName: asset.imageUri,
                };
            },
        };
    }
    /**
     * Use an existing tarball for this container image.
     *
     * Use this method if the container image has already been created by another process (e.g. jib)
     * and you want to add it as a container image asset.
     *
     * @param tarballFile Absolute path to the tarball. You can use language-specific idioms (such as `__dirname` in Node.js)
     *                    to create an absolute path based on the current script running directory.
     */
    static fromTarball(tarballFile) {
        return {
            bind(scope, containerDefinition) {
                const asset = new aws_ecr_assets_1.TarballImageAsset(scope, 'Tarball', { tarballFile });
                asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
                return {
                    imageName: asset.imageUri,
                };
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ContainerImage[_a] = { fqn: "aws-cdk-lib.aws_ecs.ContainerImage", version: "2.74.0" };
exports.ContainerImage = ContainerImage;
const asset_image_1 = require("./images/asset-image");
const ecr_1 = require("./images/ecr");
const repository_1 = require("./images/repository");
//# sourceMappingURL=data:application/json;base64,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