"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentFileType = exports.S3EnvironmentFile = exports.AssetEnvironmentFile = exports.EnvironmentFile = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_assets_1 = require("../../aws-s3-assets");
/**
 * Constructs for types of environment files
 */
class EnvironmentFile {
    /**
     * Loads the environment file from a local disk path.
     *
     * @param path Local disk path
     * @param options
     */
    static fromAsset(path, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_assets_AssetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetEnvironmentFile(path, options);
    }
    /**
     * Loads the environment file from an S3 bucket.
     *
     * @returns `S3EnvironmentFile` associated with the specified S3 object.
     * @param bucket The S3 bucket
     * @param key The object key
     * @param objectVersion Optional S3 object version
     */
    static fromBucket(bucket, key, objectVersion) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromBucket);
            }
            throw error;
        }
        return new S3EnvironmentFile(bucket, key, objectVersion);
    }
}
_a = JSII_RTTI_SYMBOL_1;
EnvironmentFile[_a] = { fqn: "aws-cdk-lib.aws_ecs.EnvironmentFile", version: "2.74.0" };
exports.EnvironmentFile = EnvironmentFile;
/**
 * Environment file from a local directory.
 */
class AssetEnvironmentFile extends EnvironmentFile {
    /**
     * @param path The path to the asset file or directory.
     * @param options
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_assets_AssetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetEnvironmentFile);
            }
            throw error;
        }
    }
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new aws_s3_assets_1.Asset(scope, 'EnvironmentFile', {
                path: this.path,
                ...this.options,
            });
        }
        if (!this.asset.isFile) {
            throw new Error(`Asset must be a single file (${this.path})`);
        }
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
AssetEnvironmentFile[_b] = { fqn: "aws-cdk-lib.aws_ecs.AssetEnvironmentFile", version: "2.74.0" };
exports.AssetEnvironmentFile = AssetEnvironmentFile;
/**
 * Environment file from S3.
 */
class S3EnvironmentFile extends EnvironmentFile {
    constructor(bucket, key, objectVersion) {
        super();
        this.key = key;
        this.objectVersion = objectVersion;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3EnvironmentFile);
            }
            throw error;
        }
        if (!bucket.bucketName) {
            throw new Error('bucketName is undefined for the provided bucket');
        }
        this.bucketName = bucket.bucketName;
    }
    bind(_scope) {
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.bucketName,
                objectKey: this.key,
                objectVersion: this.objectVersion,
            },
        };
    }
}
_c = JSII_RTTI_SYMBOL_1;
S3EnvironmentFile[_c] = { fqn: "aws-cdk-lib.aws_ecs.S3EnvironmentFile", version: "2.74.0" };
exports.S3EnvironmentFile = S3EnvironmentFile;
/**
 * Type of environment file to be included in the container definition
 */
var EnvironmentFileType;
(function (EnvironmentFileType) {
    /**
     * Environment file hosted on S3, referenced by object ARN
     */
    EnvironmentFileType["S3"] = "s3";
})(EnvironmentFileType = exports.EnvironmentFileType || (exports.EnvironmentFileType = {}));
//# sourceMappingURL=data:application/json;base64,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