"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateTaskDefinition = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const _imported_task_definition_1 = require("../base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on a Fargate cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class FargateTaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromFargateTaskDefinitionArn(scope, id, fargateTaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, { taskDefinitionArn: fargateTaskDefinitionArn });
    }
    /**
     * Import an existing Fargate task definition from its attributes
     */
    static fromFargateTaskDefinitionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_FargateTaskDefinitionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromFargateTaskDefinitionAttributes);
            }
            throw error;
        }
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.FARGATE,
            networkMode: attrs.networkMode,
            taskRole: attrs.taskRole,
        });
    }
    /**
     * Constructs a new instance of the FargateTaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            cpu: props.cpu !== undefined ? core_1.Tokenization.stringifyNumber(props.cpu) : '256',
            memoryMiB: props.memoryLimitMiB !== undefined ? core_1.Tokenization.stringifyNumber(props.memoryLimitMiB) : '512',
            compatibility: task_definition_1.Compatibility.FARGATE,
            networkMode: task_definition_1.NetworkMode.AWS_VPC,
        });
        /**
         * The Docker networking mode to use for the containers in the task. Fargate tasks require the awsvpc network mode.
         */
        this.networkMode = task_definition_1.NetworkMode.AWS_VPC;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_FargateTaskDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FargateTaskDefinition);
            }
            throw error;
        }
        // eslint-disable-next-line max-len
        if (props.ephemeralStorageGiB && !core_1.Token.isUnresolved(props.ephemeralStorageGiB) && (props.ephemeralStorageGiB < 21 || props.ephemeralStorageGiB > 200)) {
            throw new Error('Ephemeral storage size must be between 21GiB and 200GiB');
        }
        this.ephemeralStorageGiB = props.ephemeralStorageGiB;
    }
}
_a = JSII_RTTI_SYMBOL_1;
FargateTaskDefinition[_a] = { fqn: "aws-cdk-lib.aws_ecs.FargateTaskDefinition", version: "2.74.0" };
exports.FargateTaskDefinition = FargateTaskDefinition;
//# sourceMappingURL=data:application/json;base64,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