"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetImage = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecr_assets_1 = require("../../../aws-ecr-assets");
const container_image_1 = require("../container-image");
/**
 * An image that will be built from a local directory with a Dockerfile
 */
class AssetImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the AssetImage class.
     *
     * @param directory The directory containing the Dockerfile
     */
    constructor(directory, props = {}) {
        super();
        this.directory = directory;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AssetImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetImage);
            }
            throw error;
        }
    }
    bind(scope, containerDefinition) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDefinition(containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const asset = new aws_ecr_assets_1.DockerImageAsset(scope, 'AssetImage', {
            directory: this.directory,
            ...this.props,
        });
        asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: asset.imageUri,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
AssetImage[_a] = { fqn: "aws-cdk-lib.aws_ecs.AssetImage", version: "2.74.0" };
exports.AssetImage = AssetImage;
//# sourceMappingURL=data:application/json;base64,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