"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryImage = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const container_image_1 = require("../container-image");
/**
 * Regex pattern to check if it is an ECR image URL.
 *
 */
const ECR_IMAGE_REGEX = /(^[a-zA-Z0-9][a-zA-Z0-9-_]*).dkr.ecr.([a-zA-Z0-9][a-zA-Z0-9-_]*).amazonaws.com(.cn)?\/.*/;
/**
 * An image hosted in a public or private repository. For images hosted in Amazon ECR, see
 * [EcrImage](https://docs.aws.amazon.com/AmazonECR/latest/userguide/images.html).
 */
class RepositoryImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the RepositoryImage class.
     */
    constructor(imageName, props = {}) {
        super();
        this.imageName = imageName;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_RepositoryImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RepositoryImage);
            }
            throw error;
        }
    }
    bind(scope, containerDefinition) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDefinition(containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // name could be a Token - in that case, skip validation altogether
        if (!core_1.Token.isUnresolved(this.imageName) && ECR_IMAGE_REGEX.test(this.imageName)) {
            core_1.Annotations.of(scope).addWarning("Proper policies need to be attached before pulling from ECR repository, or use 'fromEcrRepository'.");
        }
        if (this.props.credentials) {
            this.props.credentials.grantRead(containerDefinition.taskDefinition.obtainExecutionRole());
        }
        return {
            imageName: this.imageName,
            repositoryCredentials: this.props.credentials && {
                credentialsParameter: this.props.credentials.secretArn,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
RepositoryImage[_a] = { fqn: "aws-cdk-lib.aws_ecs.RepositoryImage", version: "2.74.0" };
exports.RepositoryImage = RepositoryImage;
//# sourceMappingURL=data:application/json;base64,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