"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFileLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to json-file Logs.
 */
class JsonFileLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_JsonFileLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, JsonFileLogDriver);
            }
            throw error;
        }
        // Validation
        if (props.maxFile && props.maxFile < 0) {
            throw new Error('`maxFile` must be a positive integer.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            logDriver: 'json-file',
            options: (0, utils_1.stringifyOptions)({
                'max-size': this.props.maxSize,
                'max-file': this.props.maxFile,
                'compress': this.props.compress,
                'labels': (0, utils_1.joinWithCommas)(this.props.labels),
                'env': (0, utils_1.joinWithCommas)(this.props.env),
                'env-regex': this.props.envRegex,
            }),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
JsonFileLogDriver[_a] = { fqn: "aws-cdk-lib.aws_ecs.JsonFileLogDriver", version: "2.74.0" };
exports.JsonFileLogDriver = JsonFileLogDriver;
//# sourceMappingURL=data:application/json;base64,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