"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_log_driver_1 = require("./aws-log-driver");
/**
 * The base class for log drivers.
 */
class LogDriver {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AwsLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsLogs);
            }
            throw error;
        }
        return new aws_log_driver_1.AwsLogDriver(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
LogDriver[_a] = { fqn: "aws-cdk-lib.aws_ecs.LogDriver", version: "2.74.0" };
exports.LogDriver = LogDriver;
//# sourceMappingURL=data:application/json;base64,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