"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDrivers = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_log_driver_1 = require("./aws-log-driver");
const firelens_log_driver_1 = require("./firelens-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * The base class for log drivers.
 */
class LogDrivers {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AwsLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsLogs);
            }
            throw error;
        }
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     */
    static fluentd(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_FluentdLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fluentd);
            }
            throw error;
        }
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     */
    static gelf(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_GelfLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.gelf);
            }
            throw error;
        }
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     */
    static journald(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_JournaldLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.journald);
            }
            throw error;
        }
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     */
    static jsonFile(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_JsonFileLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.jsonFile);
            }
            throw error;
        }
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     */
    static splunk(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_SplunkLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.splunk);
            }
            throw error;
        }
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     */
    static syslog(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_SyslogLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.syslog);
            }
            throw error;
        }
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to firelens log router.
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     */
    static firelens(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_FireLensLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.firelens);
            }
            throw error;
        }
        return new firelens_log_driver_1.FireLensLogDriver(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
LogDrivers[_a] = { fqn: "aws-cdk-lib.aws_ecs.LogDrivers", version: "2.74.0" };
exports.LogDrivers = LogDrivers;
//# sourceMappingURL=data:application/json;base64,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