"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyslogLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to syslog Logs.
 */
class SyslogLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SyslogLogDriver class.
     *
     * @param props the syslog log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_SyslogLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SyslogLogDriver);
            }
            throw error;
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            logDriver: 'syslog',
            options: (0, utils_1.stringifyOptions)({
                'syslog-address': this.props.address,
                'syslog-facility': this.props.facility,
                'syslog-tls-ca-cert': this.props.tlsCaCert,
                'syslog-tls-cert': this.props.tlsCert,
                'syslog-tls-key': this.props.tlsKey,
                'syslog-tls-skip-verify': this.props.tlsSkipVerify,
                'syslog-format': this.props.format,
                ...(0, utils_1.renderCommonLogDriverOptions)(this.props),
            }),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SyslogLogDriver[_a] = { fqn: "aws-cdk-lib.aws_ecs.SyslogLogDriver", version: "2.74.0" };
exports.SyslogLogDriver = SyslogLogDriver;
//# sourceMappingURL=data:application/json;base64,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