"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppMeshProxyConfiguration = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const proxy_configuration_1 = require("./proxy-configuration");
/**
 * The class for App Mesh proxy configurations.
 *
 * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version
 * 1.26.0-1 of the ecs-init package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized
 * AMI version 20190301 or later, then they contain the required versions of the container agent and ecs-init.
 * For more information, see [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
 *
 * For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later.
 */
class AppMeshProxyConfiguration extends proxy_configuration_1.ProxyConfiguration {
    /**
     * Constructs a new instance of the AppMeshProxyConfiguration class.
     */
    constructor(props) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AppMeshProxyConfigurationConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AppMeshProxyConfiguration);
            }
            throw error;
        }
        if (props.properties) {
            if (!props.properties.ignoredUID && !props.properties.ignoredGID) {
                throw new Error('At least one of ignoredUID or ignoredGID should be specified.');
            }
        }
    }
    /**
     * Called when the proxy configuration is configured on a task definition.
     */
    bind(_scope, _taskDefinition) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_TaskDefinition(_taskDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const configProps = this.props.properties;
        const configType = 'APPMESH';
        return {
            containerName: this.props.containerName,
            proxyConfigurationProperties: renderProperties(configProps),
            type: configType,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
AppMeshProxyConfiguration[_a] = { fqn: "aws-cdk-lib.aws_ecs.AppMeshProxyConfiguration", version: "2.74.0" };
exports.AppMeshProxyConfiguration = AppMeshProxyConfiguration;
function renderProperties(props) {
    const ret = new Array();
    for (const [k, v] of Object.entries(props)) {
        const key = String(k);
        const value = String(v);
        if (value !== 'undefined' && value !== '') {
            const capitalizedKey = key.charAt(0).toUpperCase() + key.slice(1);
            ret.push({ ['name']: capitalizedKey, ['value']: value });
        }
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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